/* REXX2PM: bind resource to REXX_PM.EXE */

Parse Arg FileName ExeName

if FileName = '' then
  do
    Say 'Usage: REXX2PM <sourcefile> [<exefile>]'
    Return 1
  end

if Stream(FileName, 'C', 'Query Exist') == '' then
  do
    Say 'File "'FileName'" does not exist!'
    Return 1
  end

if ExeName = '' then
  do
    Parse Value FileSpec('name', FileName) With Fname '.' Fext
    ExeName = FileSpec('drive', FileName)||FileSpec('path', FileName)||Fname||'.exe'
  end

Parse Source operatingSystem commandType sourceFileName
REXX_PM = FileSpec('drive', sourceFileName) || FileSpec('path', sourceFileName) || 'REXX_PM.EXE'
if Stream(REXX_PM, 'C', 'Query Exist') == '' then
  do
    Say 'File "'REXX_PM'" is required, but does not exist!'
    Return 1
  end

'@copy' REXX_PM ExeName
'@echo RESOURCE 17746 1' FileName ' > %tmp%\rexx2pm.rc'
'@rc.exe -n -x2 %tmp%\rexx2pm.rc' ExeName
'@del %tmp%\rexx2pm.rc %tmp%\rexx2pm.res'
Return 0
