/* RxSwitchQuery (RxIsRul.DLL) Test: Wait for OS/2 App to Start *
 *                                                              *
 * (C) Mads Orbesen Troest & SIRIUS Cybernetics 1998            */

PARSE ARG App /* Get App on CommandLine */
IF App = "" THEN EXIT /* Exit if no App Specified */

/* Load External RxSwitchQuery Routines: */

CALL RxFuncAdd "RxSwitchQueryVer", "RxIsRun", "RxSwitchQueryVer"
CALL RxFuncAdd "RxSwitchQueryApp", "RxIsRun", "RxSwitchQueryApp"
CALL RxFuncAdd "RxSwitchQueryWaitAppInList", "RxIsRun", "RxSwitchQueryWaitAppInList"
CALL RxFuncAdd "RxSwitchQueryWaitAppNotInList", "RxIsRun", "RxSwitchQueryWaitAppNotInList"

/* Do some Initial ChitChat: */

appStr = RxSwitchQueryVer() /* Retrieve Version Information */

SAY ""
SAY "RxSwitchQuery Test: Wait for OS/2 App to Start, utilising:"
SAY WORD( appStr, 1) WORD( appStr, 2 ) WORD( appStr, 3 )
SAY ""
SAY " INFO  : Waiting for '"App"' to Start..."
RC = RxSwitchQueryWaitAppInList( App,,'NOCASE', 5000 ) /* Only poll every 5 seconds */
IF RC = "OK" THEN SAY " INFO  : OK!"
ELSE SAY " PANIC : Aborted!"
