/* Kill the VREXX.EXE thread if a VREXX program failed to call VExit() */
/* By Chris Angelico. All rights reserved. */

/* Load REXXUtil */
SIGNAL ON SYNTAX NAME NOREXXUTIL
IF RXFUNCQUERY("SYSLOADFUNCS")\=0 THEN DO
	CALL RXFUNCADD "SYSLOADFUNCS","REXXUTIL","SYSLOADFUNCS"
	CALL SYSLOADFUNCS
END
IF RXFUNCQUERY("SYSLOADFUNCS")=0 THEN SIGNAL TRYLOADING
NOREXXUTIL:
SAY "Can't load REXXUTIL.DLL - exiting."
EXIT

/* Load RxExtras, used to kill the process later on */
TRYLOADING:
SIGNAL ON SYNTAX NAME NOTLOADED
IF RXFUNCQUERY("RXEXTRA")\=0 THEN DO
	CALL RXFUNCADD "RXEXTRA","RXEXTRAS","RxExtra"
	CALL RXEXTRA "LOAD"
END
IF RXFUNCQUERY("RXEXTRA")=0 THEN SIGNAL GO
NOTLOADED:
SAY "Oh dear, I couldn't load the RXEXTRAS functions."
SAY "Have you installed the package?"
PULL INSTALLED
IF LEFT(INSTALLED,1)="Y" THEN DO
	SAY "Could you please tell me where you put it?"
	SAY "Or type SEARCH and I'll do a search."
	PULL DIR
	IF DIR="" THEN EXIT
	IF DIR="SEARCH" THEN DO
		DRIVES=SYSDRIVEMAP("C:","LOCAL") /* List local drives */
		SAY "Press Escape to cancel after searching the current drive."
		TOT=0
		FOUND.=""
		DO I=1 TO WORDS(DRIVES)
			IF SYSDRIVEINFO(WORD(DRIVES,I))="" THEN ITERATE /* If unavailable, skip */
			SAY "Searching drive "WORD(DRIVES,I)"..."
			CALL SYSFILESEARCH WORD(DRIVES,I)"\RXEXTRAS.DLL","STEM",FOS /* Search, please, REXXUtil! */
			IF STEM.0>0 THEN DO
				SAY "Found!"
				DO J=1 TO STEM.0; Z=TOT+J; SAY Z") "STEM.J; FOUND.Z=STEM.J; END
				TOT=TOT+STEM.0
			END
		END
		SAY "Total found: "TOT
		SAY "Select number of the one to use:"
		PULL N
		DIR=FOUND.N
		IF DIR="" THEN EXIT
	END
	CUR=VALUE("BEGINLIBPATH",,"OS2ENVIRONMENT")
	OLD=CUR
	IF (CUR\="")&(RIGHT(CUR,1)\=";") THEN CUR=CUR";"
	CALL VALUE "BEGINLIBPATH",CUR||DIR,"OS2ENVIRONMENT"
	SIGNAL TRYLOADING
END
ELSE DO
	SAY "OK, fine, but I can't run without RxExtras!"
	SAY "Go fetch one to pacify me, or just leave VRexx running."
	EXIT
END
GO:
IF OLD\="OLD" THEN CALL VALUE "BEGINLIBPATH",OLD,"OS2ENVIRONMENT"
/*
If you use this, but VREXX still won't start, you can take one of these choices:
	1) The drastic, "just fix it" approach.
		Shut down the computer and reboot. This will fix most problems.
		If this doesn't fix the problem, re-install VRexx.
		Next try checking what other programs you're using and hunt for conflicts.
		If the problem _still_ isn't fixed, re-install OS/2. But I don't think you'll need this!
	2) Chat with me (Chris Angelico, accessible at talldad@pobox.com.au), and I'll see what I can do. No guarantees.
	3) Try to find the author of VRexx. I can't help you with that - I haven't seen any VRexx newer than the one on the OS/2 2.11 Unleashed CD-ROM.
*/

/* Find the text 'VREXX' in the PSTAT process info and put lines containing it into the REXX queue */
"@PSTAT /C|FIND ""VREXX""|RXQUEUE"

IF QUEUED()=0 THEN DO
	/* If no process found, forget it. */
	SAY "No VREXX process found. I don't think there's a problem..."
	EXIT
END

/* Display all the processes with VREXX in their titles */
/* No more than 1 expected, but more supported. */
I=0
STEM.=""
DO WHILE QUEUED()>0
	PULL PID . . FILE .
	I=I+1
	STEM.I=PID
	STEM.PID=PID
	SAY I") "LEFT("PID: "X2D(PID)" ("PID"x)",20)"File: "FILE
END
SAY "Enter number of process to kill, or 0 to cancel:"
PULL ID
IF STEM.ID="" THEN EXIT
RESLT=RXKILLPROCESS(X2D(STEM.ID)) /* Bang! There goes the process... */
IF RESLT="Killed" THEN SAY "Killed successfully."
ELSE SAY "Not killed - returned "RESLT"."
