/* VisPro/REXX */

_VPAppHandle = VpInit()
if _VPAppHandle='' then exit
_VPAppReturn = 0

/* Open first form */
Parse arg topic
_VPMainWindow = VpOpenForm('', 256, topic)
if _VPMainWindow='' then do
   call VpMessageBox 0,'VisPro/REXX','Unable to open Main form.  Verify that there is a Main form, that it has an id of 256, and that the form has controls within it.'
   signal _VPAppExit
end

do until ( _VPEventCall=='')
   _VPEventCall = VpGetMsg(_VPAppHandle)
   Interpret _VpEventCall
end
/* Terminate application */
_VPAppExit:
call VpQuit _VPAppHandle
return _VPAppReturn


/* ##256_1002.0 */
256_1002.0: /* Event Clicked/selected - List Box  1002 */
Arg window self

/* Tk can only be chosen when Tcl is chosen */
/* Get selection state of item 1002 List Box */
value=VpIsSelected(window,1002,indexTcl)
IF \ value
THEN
    /* Tcl wasn't selected */
    DO
    /* Is Tk selected? */
    wasSel=VpIsSelected(window,1002,indexTk)
    IF wasSel
    THEN
        DO
        /* Select item 1002 List Box */
        CALL VpSelect window,1002,indexTk,0
        response=VpMessageBox(window,'Tk deselected', 'Tk can only be used if Tcl is also installed, so it has been deselected.')
        END
    END

/* Tk Examples can only be chosen when Tk is chosen */
/* Get selection state of item 1002 List Box */
value=VpIsSelected(window,1002,indexTk)
IF \ value
THEN
    /* Tk wasn't selected */
    DO
    /* Is examples selected? */
    wasSel=VpIsSelected(window,1002,indexDemos)
    IF wasSel
    THEN
        DO
        /* Select item 1002 List Box */
        CALL VpSelect window,1002,indexDemos,0
        response=VpMessageBox(window,'Tk Examples deselected', 'Tk Examples can only be used if Tk is also installed, so it has been deselected.')
        END
    END

ITEMS.Tcl = VpIsSelected(window,1002,indexTcl)
tkWasSelected = 0
IF ITEMS.Tk
THEN
    DO
    tkWasSelected = 1
    END
ITEMS.Tk = VpIsSelected(window,1002,indexTk)
ITEMS.Demos = VpIsSelected(window,1002,indexDemos)
ITEMS.Inf = VpIsSelected(window,1002,indexInf)
ITEMS.Headers = VpIsSelected(window,1002,indexHeaders)

IF tkWasSelected
THEN
    DO
    IF \ ITEMS.Tk
    THEN
        /* turned off */
        DO
        /* Check the item *.tcl start tclsh, *.tk start wish1013 Radio Button */
        CALL VpSelect window,1013,1
        /* Set item value *.tcl start tclsh, *.tk start wish1013 Radio Button */
        CALL VpSetItemValue window,1013,'*.tcl start ~tclsh'
        /* Enable item Command Line version of tclsh1014 Radio Button */
        CALL VpItem window,1014,'ENABLE'
        /* Enable item PM version of tclsh1015 Radio Button */
        CALL VpItem window,1015,'ENABLE'
        /* Disable item All *.tcl scripts start wish (Scriptics standard)1010 Radio Button */
        CALL VpItem window,1010,'DISABLE'
        END
    END
ELSE
    DO
    IF ITEMS.Tk
    THEN
        /* turned on */
        DO
        /* Enable item All *.tcl scripts start wish (Scriptics standard)1010 Radio Button */
        CALL VpItem window,1010,'ENABLE'
        /* Set item value *.tcl start tclsh, *.tk start wish1013 Radio Button */
        CALL VpSetItemValue window,1013,'*.tcl start ~tclsh, *.tk start wish'
        IF ASSOCSTD = 1
        THEN
            DO
            /* Check the item All *.tcl scripts start wish (Scriptics standard)1010 Radio Button */
            CALL VpSelect window,1010,1
            /* Disable item Command Line version of tclsh1014 Radio Button */
            CALL VpItem window,1014,'DISABLE'
            /* Disable item PM version of tclsh1015 Radio Button */
            CALL VpItem window,1015,'DISABLE'
            END
        END
    END

IF  ITEMS.Tcl
THEN
    DO
    /* Ensable item Create associations with scripts1040 Check Box */
    CALL VpItem window,1040,'ENABLE'
    ASSOC = 1
    /* Enable item Provide necessary settings in profile1020 Check Box */
    CALL VpItem window,1020,'ENABLE'
    PROFSETTINGS = 1
    /* Enable item Provide necessary settings in CONFIG.SYS1030 Check Box */
    CALL VpItem window,1030,'ENABLE'
    CONFSETTINGS = 1
    /* Enable item ~Override TCL_LIBRARY, TK_LIBRARY, TCLLIBPATH1004 Check Box */
    CALL VpItem window,1004,'ENABLE'
    /* Get button state All *.tcl scripts start wish (Scriptics standard)1010 Radio Button */
    IF VpIsSelected(window,1010)
    THEN
        DO
        /* Enable item All *.tcl scripts start wish (Scriptics standard)1010 Radio Button */
        CALL VpItem window,1010,'ENABLE'
        END
    ELSE
        DO
        /* Enable item *.tcl start tclsh, *.tk start wish1013 Radio Button */
        CALL VpItem window,1013,'ENABLE'
        /* Enable item Command Line version of tclsh1014 Radio Button */
        CALL VpItem window,1014,'ENABLE'
        /* Enable item PM version of tclsh1015 Radio Button */
        CALL VpItem window,1015,'ENABLE'
        END
    END
ELSE
    DO
    /* Disable item Create associations with scripts1040 Check Box */
    CALL VpItem window,1040,'DISABLE'
    ASSOC = 0
    /* Disable item Provide necessary settings in profile1020 Check Box */
    CALL VpItem window,1020,'DISABLE'
    PROFSETTINGS = 0
    /* Disable item Provide necessary settings in CONFIG.SYS1030 Check Box */
    CALL VpItem window,1030,'DISABLE'
    CONFSETTINGS = 0
    /* Disable item ~Override TCL_LIBRARY, TK_LIBRARY, TCLLIBPATH1004 Check Box */
    CALL VpItem window,1004,'DISABLE'
    /* Disable item All *.tcl scripts start wish (Scriptics standard)1010 Radio Button */
    CALL VpItem window,1010,'DISABLE'
    /* Disable item *.tcl start tclsh, *.tk start wish1013 Radio Button */
    CALL VpItem window,1013,'DISABLE'
    /* Disable item Command Line version of tclsh1014 Radio Button */
    CALL VpItem window,1014,'DISABLE'
    /* Disable item PM version of tclsh1015 Radio Button */
    CALL VpItem window,1015,'DISABLE'
    END
        

return

/* ##256_1003.0 */
256_1003.0: 
/* Disable item ~Start!1003 Push Button */
CALL VpItem window,1003,'DISABLE'
/* Disable item C:\Tcl8051001 Entry Field */
CALL VpItem window,1001,'DISABLE'
/* Disable item 1002 Multi-Line Entry Field */
CALL VpItem window,1002,'DISABLE'
/* Disable item Items1000 Push Button */
CALL VpItem window,1000,'DISABLE'
/* Disable item Exit1005 Push Button */
CALL VpItem window,1005,'DISABLE'

/* use forward slashes for Tcl directories, so translate dest */
tclDest = TRANSLATE(dest, '/', '\')

files = allFiles
msg = 'Unzipping: '
IF ITEMS.Tcl
THEN
    DO
    msg = msg 'Tcl'
    files = files tclFiles
    /* See if Tk should go too */
    IF ITEMS.Tk
    THEN
        DO
            /* Yes, Tk should go too */
            files = files tkFiles
            msg = msg', Tk'
        END
    END
IF \ (msg = 'Unzipping: ')
THEN
    DO
    msg = msg','
    END
IF ITEMS.Demos
THEN
    DO
    msg = msg 'Examples'
    END
IF \ (msg = 'Unzipping: ')
THEN
    DO
    msg = msg','
    END
IF ITEMS.Inf
THEN
    DO
    msg = msg 'Reference'
    files = files infFiles
    END
IF \ (msg = 'Unzipping: ')
THEN
    DO
    msg = msg','
    END
IF ITEMS.Headers
THEN
    DO
    msg = msg 'Headers & Libraries'
    files = files headerFiles
    END

IF \ ITEMS.Demos
THEN
    DO
    files = files '-x' demosFiles
    END

/*
IF files = allFiles
THEN
    DO
    response = VpMessageBox(window,'Useless','Nothing has been selected to install...')
    /* Change progress indicator */
    CALL VpSetItemValue window,1018,''
    CALL cleanup
    RETURN
    END
*/

/* dest = 'h:\temp' */
/* see if the destination exists */
curdir = directory()
newdir = directory(dest)
IF \ (newdir = dest)
THEN
    DO
        /* It doesn't exist yet, confirm (unzip will create it) */
        question = 'The destination directory' dest "doesn't exist yet."
        question = question 'Choose OK to go ahead and create it,'
        question = question 'or CANCEL to abort installing there.'
        response = VpMessageBox(window,'Confirm',question,'OKCNCL')
        IF response = 'CANCEL'
        THEN
            DO
            /* Change progress indicator */
            CALL VpSetItemValue window,1018,''
            CALL cleanup
            RETURN
            END
    END
CALL directory(curdir)    

/* Set item value Text1018 Text */
CALL VpSetItemValue window,1018,msg

/*
CALL VpWindow window,'ENABLESTDIO'
say 'unzip -o -C tcl'verShort'.zip' files '-d' dest
*/
unzip '-o' '-C' 'tcl'verShort'.zip' files '-d' dest

IF RC != 0
THEN
    DO
    /* Error box */
    response=VpMessageBox(window,'Installation Failed','Unzipping the distribution was',
                          'unsuccessful. Do you have UNZIP.EXE installed?')
    /* Set item value Text1018 Text */
    CALL VpSetItemValue window,1018,"Failed..."
    CALL cleanup
    RETURN
    END

/* Associations */
IF ASSOC & VpIsSelected(window,1040)
THEN DO
    CALL VpSetItemValue window,1018,'Making associations in OS2.INI'
    CALL SysIni 'USER', 'PMWP_ASSOC_FILTER', '*.TCL', D2C(0)
    CALL SysIni 'USER', 'PMWP_ASSOC_FILTER', '*.TK', D2C(0)
    CALL SysIni 'USER', 'PMWP_ASSOC_TYPE', 'Tcl 'verFull' script', D2C(0)
    /* Get button state *.tcl start tclsh, *.tk start wish1013 Radio Button */
    IF VpIsSelected(window,1013)
    THEN DO
        IF ITEMS.Tk
        THEN DO
            CALL SysIni 'USER', 'PMWP_ASSOC_TYPE', 'Tk 'verFull' script', D2C(0)
        END
    END
END

/* OS2.INI Settings */
IF PROFSETTINGS & VpIsSelected(window,1020)
THEN
    DO
    /* OS2.INI */
    CALL VpSetItemValue window,1018,'Making settings in OS2.INI'
    CALL SysIni 'USER', 'Tcl'verFull, 'InstallDir', tclDest
    CALL SysIni 'USER', 'Tcl'verFull, 'PkgPath', tclDest'/lib'D2C(0)
    END

/* Config.Sys Settings */
IF CONFSETTINGS & VpIsSelected(window,1030)
THEN
    DO
    CALL VpSetItemValue window,1018,'Making settings in' bootdrive'\CONFIG.SYS'
    orgcsname = bootdrive'\config.sys'
    orgcs = STREAM(orgcsname, 'c', 'open read')
    IF orgcs \= 'READY:'
    THEN
        DO
        /* Error box */
        response=VpMessageBox(window,'Settings failed','Couldn''t open',
                              bootdrive'\config.sys for reading')
        CALL rest
        RETURN
    END

    newcsname =  bootdrive'\config.new'
    newcs = STREAM(newcsname, 'c', 'open write')
    IF newcs \= 'READY:'
    THEN
        DO
        /* Error box */
        response=VpMessageBox(window,'Settings failed','Couldn''t open',
                              bootdrive'\config.new for writing')
        CALL STREAM bootdrive'\config.sys', 'c', 'close'
        CALL rest
        RETURN
    END

    /* Truncate file if it already exists */
    CALL LINEOUT newcsname,,1

    add_tcl_library = ITEMS.Tcl
    tcl_library = tclDest'/lib/tcl8.0'
    add_tk_library = ITEMS.Tk
    tk_library = tclDest'/lib/tk8.0'
    add_tcllibpath = ITEMS.Tcl
    tcllibpath = tclDest'/bin'
    DO WHILE STREAM(orgcsname, 's') = 'READY'
        curline = LINEIN(orgcsname)
        /* MODIFY curline */
        PARSE UPPER VAR curline word1 rest
        IF word1 = 'SET'
        THEN
            DO
                /* SET var=, where var can be PATH, TCL_LIBRARY, TK_LIBRARY, TCLLIBPATH */
                PARSE VALUE rest WITH envvar '=' path
                SELECT
                    WHEN envvar = 'PATH' THEN
                        DO
                        /* is this path already in PATH ? */
                        IF (POS(';'dest'\bin', path)) = 0 & (POS(dest'\bin;', path) = 0)
                        THEN
                            DO
                            /* make sure there's no ; on the end when we add it */
                            curline = 'SET PATH='STRIP(path,'T',';')';'dest'\bin;'
                            END
                        END
                    WHEN envvar = 'TCL_LIBRARY' THEN
                        DO
                        IF add_tcl_library & VpIsSelected(window,1004)
                        THEN
                            DO
                            curline = 'SET TCL_LIBRARY='tcl_library
                            END
                        add_tcl_library = 0
                        END
                    WHEN envvar = 'TK_LIBRARY' THEN
                        DO
                        IF add_tk_library & VpIsSelected(window,1004)
                        THEN
                            DO
                            curline = 'SET TK_LIBRARY='tk_library
                            END
                        add_tk_library = 0
                        END
                    WHEN envvar = 'TCLLIBPATH' THEN
                        DO
                        IF add_tcllibpath & VpIsSelected(window,1004)
                        THEN
                            DO
                            curline = 'SET TCLLIBPATH='tcllibpath
                            END
                        add_tcllibpath = 0
                        END
                    OTHERWISE NOP
                END
            END
        ELSE
            DO
                /* Can be the LIBPATH= line */                
                PARSE VALUE curline WITH envvar '=' path
                IF envvar = 'LIBPATH'
                THEN
                    DO
                    /* is this path already in LIBPATH ? */
                    IF (POS(';'dest'\bin', path)) = 0 & (POS(dest'\bin;', path) = 0)
                    THEN
                        DO
                        /* make sure there's no ; on the end when we add it */
                        curline = 'LIBPATH='STRIP(path,'T',';')';'dest'\bin;'
                        END
                    END
            END
        /* END MODIFY curline */
        CALL LINEOUT newcsname, curline
        END
    IF add_tcl_library
    THEN
        DO
        curline = 'SET TCL_LIBRARY='tcl_library
        CALL LINEOUT newcsname, curline
        END
    IF add_tk_library
    THEN
        DO        
        curline = 'SET TCL_LIBRARY='tk_library
        CALL LINEOUT newcsname, curline
        END
    IF add_tcllibpath
    THEN
        DO
        curline = 'SET TCLLIBPATH='tcllibpath
        CALL LINEOUT newcsname, curline
        END
    CALL STREAM orgcsname, 'c', 'close'
    CALL STREAM newcsname, 'c', 'close'
    DEL bootdrive'\config.'verShort
    RENAME orgcsname 'config.'verShort
    RENAME newcsname 'config.sys'
    END

rest:

/* Folder */
/* Get button state Create ~folder on desktop1008 Check Box */
IF VpIsSelected(window,1008)
THEN
DO
    IF SysCreateObject('WPFolder', 'Tcl/Tk 'verFull, '<WP_DESKTOP>', 'OBJECTID=<TCLTK'verShort'>',update)
    THEN
    DO
    CALL SysCreateObject 'WPProgram', 'README', '<TCLTK'verShort'>', 'EXENAME=E.EXE;PARAMETERS=README;STARTUPDIR='DEST';OBJECTID=<README>;',replace
    /* SysCreateObject won't let parameters 'stick' all the time, SysSetObjectData will */
    CALL SysSetObjectData '<README>', 'EXENAME=E.EXE;PARAMETERS=README;STARTUPDIR='DEST';OBJECTID=<README>;'
    IF ITEMS.Tcl
    THEN
        DO
            /* tclsh80.exe */
            CALL SysCreateObject 'WPProgram', 'Tcl Shell 'verFull'^(CLI version)', '<TCLTK'verShort'>', 'EXENAME='DEST'\BIN\TCLSH'ver'.EXE;PROGTYPE=WINDOWABLEVIO;STARTUPDIR='DEST'\BIN;OBJECTID=<TCLSH'verShort'>;',replace
            CALL SysSetObjectData '<TCLSH'verShort'>', 'EXENAME='DEST'\BIN\TCLSH'ver'.EXE;PROGTYPE=WINDOWABLEVIO;STARTUPDIR='DEST'\BIN;'
            /* tclshpm80.exe */
            CALL SysCreateObject 'WPProgram', 'Tcl Shell 'verFull'^(PM version)', '<TCLTK'verShort'>', 'EXENAME='DEST'\BIN\TCLPM'ver'.EXE;STARTUPDIR='DEST'\BIN;OBJECTID=<TCLPM'verShort'>;',replace
            CALL SysSetObjectData '<TCLSHPM'verShort'>', 'EXENAME='DEST'\BIN\TCLPM'ver'.EXE;STARTUPDIR='DEST'\BIN;'
            /* Get button state *.tcl start tclsh, *.tk start wish1013 Radio Button */
            IF VpIsSelected(window,1013)
            THEN
                DO
                /* Get button state Command Line version of tclsh1014 Radio Button */
                IF VpIsSelected(window,1014)
                THEN
                    DO
                    CALL SysSetObjectData '<TCLSH'verShort'>', 'ASSOCFILTER=*.TCL;ASSOCTYPE=Tcl 'verFull' script;'
                    END
                ELSE
                    DO
                    CALL SysSetObjectData '<TCLPM'verShort'>', 'ASSOCFILTER=*.TCL;ASSOCTYPE=Tcl 'verFull' script;'
                    END
                END
                        END
    IF ITEMS.Tk
    THEN
        DO
            /* wish80.exe */
            CALL SysCreateObject 'WPProgram', 'Wish 'verFull, '<TCLTK'verShort'>', 'EXENAME='DEST'\BIN\WISH'ver'.EXE;STARTUPDIR='DEST'\BIN;OBJECTID=<WISH'verShort'>;', replace
            CALL SysSetObjectData '<WISH'verShort'>', 'EXENAME='DEST'\BIN\WISH'ver'.EXE;STARTUPDIR='DEST'\BIN;'
            /* Get button state *.tcl start tclsh, *.tk start wish1013 Radio Button */
            IF VpIsSelected(window,1013)
            THEN
                DO
                CALL SysSetObjectData '<WISH'verShort'>', 'ASSOCFILTER=*.TK;ASSOCTYPE=Tk 'verFull' script;'
                END
            ELSE
                DO
                CALL SysSetObjectData '<WISH'verShort'>', 'ASSOCFILTER=*.TCL,*.TK;ASSOCTYPE=Tcl 'verFull' script;'
                END
            /* Widget Tour */
            CALL SysCreateObject 'WPProgram', 'Widget Tour', '<TCLTK'verShort'>', 'EXENAME='DEST'\BIN\WISH'ver'.EXE;PARAMETERS='DEST'\LIB\TK'verDot'\DEMOS\WIDGET;STARTUPDIR='DEST'\BIN;OBJECTID=<TOUR'verShort'>;',replace
            CALL SysSetObjectData '<TOUR'verShort'>', 'EXENAME='DEST'\BIN\WISH'ver'.EXE;PARAMETERS='DEST'\LIB\TK'verDot'\DEMOS\WIDGET;STARTUPDIR='DEST'\BIN;OBJECTID=<TOUR'verShort'>;'
        END
    IF ITEMS.Inf
    THEN
        DO
            CALL SysCreateObject 'WPProgram', 'Tcl/Tk 'verFull'^Reference', '<TCLTK'verShort'>', 'EXENAME=VIEW.EXE;PARAMETERS=TCL'verShort'.INF;STARTUPDIR='DEST'\DOC;OBJECTID=<TCL'verShort'REF>;',replace
            CALL SysSetObjectData '<TCL'verShort'REF>', 'EXENAME=VIEW.EXE;PARAMETERS=;STARTUPDIR='DEST'\DOC;OBJECTID=<TCL'verShort'REF>;'
        END
        IF ITEMS.Headers
        THEN
            DO
            END
        END
    ELSE
    response=VpMessageBox(window,'Error','Couldn''t create folder')
END

/* Change progress indicator */
CALL VpSetItemValue window,1018,'Done...'


cleanup:

/* Enable item C:\Tcl8051001 Entry Field */
CALL VpItem window,1001,'ENABLE'
/* Enable item 1002 Multi-Line Entry Field */
CALL VpItem window,1002,'ENABLE'
/* Enable item Items1000 Push Button */
CALL VpItem window,1000,'ENABLE'
/* Enable item ~Start!1003 Push Button */
CALL VpItem window,1003,'ENABLE'
/* Enable item Exit1005 Push Button */
CALL VpItem window,1005,'ENABLE'
RETURN

/* ##256_1005.0 */
256_1005.0: /* Event Clicked/selected - Exit  1005 */
Arg window self

exit
return

/* ##256_1010.0 */
256_1010.0: /* Event Clicked/selected - All *.tcl scripts start wish (Sc  1010 */
Arg window self

/* Uncheck the item *.tcl start tclsh, *.tk start wish1013 Radio Button */
CALL VpSelect window,1013,0
/* Disable item Command Line version of tclsh1014 Radio Button */
CALL VpItem window,1014,'DISABLE'
/* Disable item PM version of tclsh1015 Radio Button */
CALL VpItem window,1015,'DISABLE'

ASSOCSTD = 1
return

/* ##256_1013.0 */
256_1013.0: /* Event Clicked/selected - *.tcl start tclsh, *.tk start wi  1013 */
Arg window self

/* Uncheck the item All *.tcl scripts start wish (Scriptics standard)1010 Radio Button */
CALL VpSelect window,1010,0
/* Enable item Command Line version of tclsh1014 Radio Button */
CALL VpItem window,1014,'ENABLE'
/* Enable item PM version of tclsh1015 Radio Button */
CALL VpItem window,1015,'ENABLE'

ASSOCSTD = 0
return

/* ##256_1020.0 */
256_1020.0: /* Event Clicked/selected - Provide necessary settings  1007 */
Arg window self

return

/* ##256_1030.0 */
256_1030.0: /* Event Clicked/selected - Provide necessary settings in CO  1030 */
Arg window self

/* Get button state Provide necessary settings in CONFIG.SYS1030 Check Box */
configFlag = VpIsSelected(window,1030)
/* configFlag true -> just selected */
IF configFlag
THEN
    DO
    /* Enable item Override TCL_LIBRARY, TK_LIBRARY, TCLLIBPATH1004 Check Box */
    CALL VpItem window,1004,'ENABLE'
    END
ELSE
    DO
    /* Disable item Override TCL_LIBRARY, TK_LIBRARY, TCLLIBPATH1004 Check Box */
    CALL VpItem window,1004,'DISABLE'
    END
return

/* ##256_1040.0 */
256_1040.0: /* Event Clicked/selected - Create associations with scripts  1040 */
Arg window self

/* Get button state Create associations with scripts1040 Check Box */
assocflag = VpIsSelected(window,1040)
/* assocflag is true when the button was _just_ selected => enable */
IF assocflag
THEN
    DO
    /* Enable item All *.tcl scripts start wish (Scriptics standard)1010 Radio Button */
    CALL VpItem window,1010,'ENABLE'
    /* Enable item *.tcl start tclsh, *.tk start wish1013 Radio Button */
    CALL VpItem window,1013,'ENABLE'
    /* Get button state *.tcl start tclsh, *.tk start wish1013 Radio Button */
    extflag = VpIsSelected(window,1013)
    IF extflag
    THEN
        DO
        /* Enable item Command Line version of tclsh1014 Radio Button */
        CALL VpItem window,1014,'ENABLE'
        /* Enable item PM version of tclsh1015 Radio Button */
        CALL VpItem window,1015,'ENABLE'
        END
    END
ELSE
    DO
    /* Disable item All *.tcl scripts start wish (Scriptics standard)1010 Radio Button */
    CALL VpItem window,1010,'DISABLE'
    /* Disable item *.tcl start tclsh, *.tk start wish1013 Radio Button */
    CALL VpItem window,1013,'DISABLE'
    /* Disable item Command Line version of tclsh1014 Radio Button */
    CALL VpItem window,1014,'DISABLE'
    /* Disable item PM version of tclsh1015 Radio Button */
    CALL VpItem window,1015,'DISABLE'
    END


return

/* ##256_Form.1 */
256_Form.1: /* Event OPND - Form INSTALLATIE!!TCL8.0.5\Main */
Arg window 

/* Load RexxUtil utility functions */
IF RxFuncQuery('SysLoadFuncs')
THEN
    DO
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    CALL SysLoadFuncs
    END

/* Disable STDIO window */
CALL VpWindow window,'DISABLESTDIO'

/* Set choices to default */
ver = 80
verDot = 8.0
verFull = 8.0.5
verShort = 805
bootDrive = SysBootDrive()
DEST = bootDrive'\Tcl'verShort

/* Destination */
/* Set item value 1001 Entry Field */
CALL VpSetItemValue window,1001,DEST

/* Items to install */
/* Add items to end Tcl!!Tk1002 Multi-Line Entry Field */
allFiles = README
indexTcl = VpAddItem(window, 1002, 'END', "Tcl Run-Time Files")
tclFiles = 'bin/tclsh'ver'.exe' 'bin/tclpm'ver'.exe' 'bin/tcltst'ver'.exe'
tclFiles = tclFiles 'bin/tcl'ver'.dll' 'bin/tclreg'ver'.dll'
tclFiles = tclFiles 'lib/tcl'verDot'/'
tclFiles = tclFiles'*'
indexTk = VpAddItem(window, 1002, 'END', "Tk Run-Time Files")
tkFiles = 'bin/wish'ver'.exe' 'bin/tktest'ver'.exe' 'bin/tk'ver'.dll'
tkFiles = tkFiles 'lib/tk'verDot'/'
tkFiles = tkFiles'*'
indexDemos = VpAddItem(window, 1002, 'END', "Example Tk Scripts")
demosFiles = 'lib/tk'verDot'/demos/*'
indexInf = VpAddItem(window, 1002, 'END', "Online Reference")
infFiles = 'doc/tcl'verShort'.inf'
indexHeaders = VpAddItem(window, 1002, 'END', "Header files and import libraries")
headerFiles = 'include/'
headerFiles = headerFiles'*' 'lib/tcl'ver'.lib' 'lib/tk'ver'.lib'
headerFiles = headerFiles 'bin/man2tcl.exe' 'doc/man2ipf.tcl' 'doc/man2ipf2.tcl'
/* Select all items Tcl!!Tk1002 Multi-Line Entry Field */
CALL VpSelect window,1002,'ALL',1
/*
ITEMS = "Tcl Tk Inf Headers"
*/
ITEMS.Tcl = 1
ITEMS.Tk = 1
ITEMS.Demos = 1
ITEMS.Inf = 1
ITEMS.Headers = 1
ASSOCSTD = 1


/* Set options to default state */

/* Create folder */
/* Check the item  Create Tcl/Tk folder1008 Check Box */
CALL VpSelect window,1008,1

/* Profile Settings */
/* Check the item  Provide necessary settings1020 Check Box */
CALL VpSelect window,1020,1

/* CONFIG.SYS Settings */
/* Check the item  Provide necessary settings in CONFIG.SYS1030 Check Box */
CALL VpSelect window,1030,1
/* Check the item  Override TCL_LIBRARY, TK_LIBRARY, TCLLIBPATH1004 Check Box */
CALL VpSelect window,1004,1

/* Associations */
/* Check the item  Create associations with scripts1040 Check Box */
CALL VpSelect window,1040,1
/* Check the item  All *.tcl scripts start wish (Scriptics standard)1010 Radio Button */
CALL VpSelect window,1010,1
/*
 * If "*.tcl starts Tclsh" is chosen, make CLI default
 * Check the item  Command Line version of tclsh1014 Radio Button
 */
CALL VpSelect window,1014,1

/* Progress */
/* Set item value Text1018 Text */
CALL VpSetItemValue window,1018,''

return
