/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.addressbook;

import java.util.ResourceBundle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.examples.addressbook.FindListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SearchDialog {
    private static ResourceBundle resAddressBook = ResourceBundle.getBundle("examples_addressbook");
    Shell shell;
    Text searchText;
    Combo searchArea;
    Label searchAreaLabel;
    Button matchCase;
    Button matchWord;
    Button findButton;
    Button down;
    FindListener findHandler;

    public SearchDialog(Shell parent) {
        this.shell = new Shell(parent, 2144);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.shell.setLayout((Layout)layout);
        this.shell.setText(resAddressBook.getString("Search_dialog_title"));
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                e.doit = false;
                SearchDialog.this.shell.setVisible(false);
            }
        });
        Label label = new Label((Composite)this.shell, 16384);
        label.setText(resAddressBook.getString("Dialog_find_what"));
        this.searchText = new Text((Composite)this.shell, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 200;
        this.searchText.setLayoutData((Object)gridData);
        this.searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean enableFind = SearchDialog.this.searchText.getCharCount() != 0;
                SearchDialog.this.findButton.setEnabled(enableFind);
            }
        });
        this.searchAreaLabel = new Label((Composite)this.shell, 16384);
        this.searchArea = new Combo((Composite)this.shell, 12);
        gridData = new GridData(768);
        gridData.widthHint = 200;
        this.searchArea.setLayoutData((Object)gridData);
        this.matchCase = new Button((Composite)this.shell, 32);
        this.matchCase.setText(resAddressBook.getString("Dialog_match_case"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.matchCase.setLayoutData((Object)gridData);
        this.matchWord = new Button((Composite)this.shell, 32);
        this.matchWord.setText(resAddressBook.getString("Dialog_match_word"));
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        this.matchWord.setLayoutData((Object)gridData);
        Group direction = new Group((Composite)this.shell, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        direction.setLayoutData((Object)gridData);
        direction.setLayout((Layout)new FillLayout());
        direction.setText(resAddressBook.getString("Dialog_direction"));
        Button up = new Button((Composite)direction, 16);
        up.setText(resAddressBook.getString("Dialog_dir_up"));
        up.setSelection(false);
        this.down = new Button((Composite)direction, 16);
        this.down.setText(resAddressBook.getString("Dialog_dir_down"));
        this.down.setSelection(true);
        Composite composite = new Composite((Composite)this.shell, 0);
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        composite.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        this.findButton = new Button(composite, 8);
        this.findButton.setText(resAddressBook.getString("Dialog_find"));
        this.findButton.setLayoutData((Object)new GridData(128));
        this.findButton.setEnabled(false);
        this.findButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!SearchDialog.this.findHandler.find()) {
                    MessageBox box = new MessageBox(SearchDialog.this.shell, 32802);
                    box.setText(SearchDialog.this.shell.getText());
                    box.setMessage(String.valueOf(resAddressBook.getString("Cannot_find")) + "\"" + SearchDialog.this.searchText.getText() + "\"");
                    box.open();
                }
            }
        });
        Button cancelButton = new Button(composite, 8);
        cancelButton.setText(resAddressBook.getString("Cancel"));
        cancelButton.setLayoutData((Object)new GridData(32));
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchDialog.this.shell.setVisible(false);
            }
        });
        this.shell.pack();
    }

    public String getSearchAreaLabel(String label) {
        return this.searchAreaLabel.getText();
    }

    public String[] getsearchAreaNames() {
        return this.searchArea.getItems();
    }

    public boolean getMatchCase() {
        return this.matchCase.getSelection();
    }

    public boolean getMatchWord() {
        return this.matchWord.getSelection();
    }

    public String getSearchString() {
        return this.searchText.getText();
    }

    public boolean getSearchDown() {
        return this.down.getSelection();
    }

    public int getSelectedSearchArea() {
        return this.searchArea.getSelectionIndex();
    }

    public void open() {
        if (this.shell.isVisible()) {
            this.shell.setFocus();
        } else {
            this.shell.open();
        }
        this.searchText.setFocus();
    }

    public void setSearchAreaNames(String[] names) {
        int i = 0;
        while (i < names.length) {
            this.searchArea.add(names[i]);
            ++i;
        }
        this.searchArea.select(0);
    }

    public void setSearchAreaLabel(String label) {
        this.searchAreaLabel.setText(label);
    }

    public void setMatchCase(boolean match) {
        this.matchCase.setSelection(match);
    }

    public void setMatchWord(boolean match) {
        this.matchWord.setSelection(match);
    }

    public void setSearchDown(boolean searchDown) {
        this.down.setSelection(searchDown);
    }

    public void setSearchString(String searchString) {
        this.searchText.setText(searchString);
    }

    public void setSelectedSearchArea(int index) {
        this.searchArea.select(index);
    }

    public void addFindListener(FindListener listener) {
        this.findHandler = listener;
    }

    public void removeFindListener(FindListener listener) {
        this.findHandler = null;
    }
}

