/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;

abstract class Tab {
    Button borderButton;
    Button enabledButton;
    Button visibleButton;
    Button preferredButton;
    Button tooSmallButton;
    Button smallButton;
    Button largeButton;
    Button fillButton;
    Composite tabFolderPage;
    Group exampleGroup;
    Group controlGroup;
    Group displayGroup;
    Group sizeGroup;
    Group styleGroup;
    Group colorGroup;
    final ControlExample instance;
    static final int TOO_SMALL_SIZE = 10;
    static final int SMALL_SIZE = 50;
    static final int LARGE_SIZE = 100;
    Button backgroundButton;
    Button foregroundButton;
    Button fontButton;
    Color backgroundColor;
    Color foregroundColor;
    Font font;

    Tab(ControlExample instance) {
        this.instance = instance;
    }

    void createControlGroup() {
        this.controlGroup = new Group(this.tabFolderPage, 0);
        GridLayout gridLayout = new GridLayout();
        this.controlGroup.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        this.controlGroup.setLayoutData((Object)new GridData(272));
        this.controlGroup.setText(ControlExample.getResourceString("Parameters"));
        this.createStyleGroup();
        this.createDisplayGroup();
        this.createSizeGroup();
        this.createColorGroup();
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if ((event.widget.getStyle() & 0x10) != 0 && !((Button)event.widget).getSelection()) {
                    return;
                }
                Tab.this.recreateExampleWidgets();
            }
        };
        Control[] children = this.styleGroup.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Button) {
                Button button = (Button)children[i];
                button.addSelectionListener((SelectionListener)selectionListener);
            }
            ++i;
        }
    }

    void createControlWidgets() {
    }

    void createColorGroup() {
        this.colorGroup = new Group((Composite)this.controlGroup, 0);
        this.colorGroup.setLayout((Layout)new GridLayout(2, false));
        this.colorGroup.setLayoutData((Object)new GridData(272));
        this.colorGroup.setText(ControlExample.getResourceString("Colors"));
        new Label((Composite)this.colorGroup, 0).setText(ControlExample.getResourceString("Foreground_Color"));
        this.foregroundButton = new Button((Composite)this.colorGroup, 8);
        new Label((Composite)this.colorGroup, 0).setText(ControlExample.getResourceString("Background_Color"));
        this.backgroundButton = new Button((Composite)this.colorGroup, 8);
        this.fontButton = new Button((Composite)this.colorGroup, 8);
        this.fontButton.setText(ControlExample.getResourceString("Font"));
        Shell shell = this.backgroundButton.getShell();
        final ColorDialog backgroundDialog = new ColorDialog(shell);
        final ColorDialog foregroundDialog = new ColorDialog(shell);
        final FontDialog fontDialog = new FontDialog(shell);
        int imageSize = 12;
        Display display = shell.getDisplay();
        final Image backgroundImage = new Image((Device)display, imageSize, imageSize);
        final Image foregroundImage = new Image((Device)display, imageSize, imageSize);
        this.backgroundButton.setImage(backgroundImage);
        this.backgroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RGB rgb = backgroundDialog.open();
                if (rgb == null) {
                    return;
                }
                Color oldColor = Tab.this.backgroundColor;
                Tab.this.backgroundColor = new Color((Device)Tab.this.backgroundButton.getDisplay(), rgb);
                Tab.this.setExampleWidgetBackground();
                if (oldColor != null) {
                    oldColor.dispose();
                }
            }
        });
        this.foregroundButton.setImage(foregroundImage);
        this.foregroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RGB rgb = foregroundDialog.open();
                if (rgb == null) {
                    return;
                }
                Color oldColor = Tab.this.foregroundColor;
                Tab.this.foregroundColor = new Color((Device)Tab.this.foregroundButton.getDisplay(), rgb);
                Tab.this.setExampleWidgetForeground();
                if (oldColor != null) {
                    oldColor.dispose();
                }
            }
        });
        this.fontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FontData fontData = fontDialog.open();
                if (fontData == null) {
                    return;
                }
                Font oldFont = Tab.this.font;
                Tab.this.font = new Font((Device)Tab.this.fontButton.getDisplay(), fontData);
                Tab.this.setExampleWidgetFont();
                Tab.this.setExampleWidgetSize();
                if (oldFont != null) {
                    oldFont.dispose();
                }
            }
        });
        this.backgroundButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (backgroundImage != null) {
                    backgroundImage.dispose();
                }
                if (foregroundImage != null) {
                    foregroundImage.dispose();
                }
                if (Tab.this.backgroundColor != null) {
                    Tab.this.backgroundColor.dispose();
                }
                if (Tab.this.foregroundColor != null) {
                    Tab.this.foregroundColor.dispose();
                }
                if (Tab.this.font != null) {
                    Tab.this.font.dispose();
                }
                Tab.this.backgroundColor = null;
                Tab.this.foregroundColor = null;
                Tab.this.font = null;
            }
        });
    }

    void createDisplayGroup() {
        this.displayGroup = new Group((Composite)this.controlGroup, 0);
        this.displayGroup.setLayout((Layout)new GridLayout());
        this.displayGroup.setLayoutData((Object)new GridData(272));
        this.displayGroup.setText(ControlExample.getResourceString("State"));
        this.enabledButton = new Button((Composite)this.displayGroup, 32);
        this.enabledButton.setText(ControlExample.getResourceString("Enabled"));
        this.visibleButton = new Button((Composite)this.displayGroup, 32);
        this.visibleButton.setText(ControlExample.getResourceString("Visible"));
        this.enabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Tab.this.setExampleWidgetEnabled();
            }
        });
        this.visibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Tab.this.setExampleWidgetVisibility();
            }
        });
        this.enabledButton.setSelection(true);
        this.visibleButton.setSelection(true);
    }

    void createExampleGroup() {
        this.exampleGroup = new Group(this.tabFolderPage, 0);
        GridLayout gridLayout = new GridLayout();
        this.exampleGroup.setLayout((Layout)gridLayout);
        this.exampleGroup.setLayoutData((Object)new GridData(1808));
    }

    void createExampleWidgets() {
    }

    void createSizeGroup() {
        this.sizeGroup = new Group((Composite)this.controlGroup, 0);
        this.sizeGroup.setLayout((Layout)new GridLayout());
        this.sizeGroup.setLayoutData((Object)new GridData(272));
        this.sizeGroup.setText(ControlExample.getResourceString("Size"));
        this.preferredButton = new Button((Composite)this.sizeGroup, 16);
        this.preferredButton.setText(ControlExample.getResourceString("Preferred"));
        this.tooSmallButton = new Button((Composite)this.sizeGroup, 16);
        this.tooSmallButton.setText("10 X 10");
        this.smallButton = new Button((Composite)this.sizeGroup, 16);
        this.smallButton.setText("50 X 50");
        this.largeButton = new Button((Composite)this.sizeGroup, 16);
        this.largeButton.setText("100 X 100");
        this.fillButton = new Button((Composite)this.sizeGroup, 16);
        this.fillButton.setText(ControlExample.getResourceString("Fill"));
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!((Button)event.widget).getSelection()) {
                    return;
                }
                Tab.this.setExampleWidgetSize();
            }
        };
        this.preferredButton.addSelectionListener((SelectionListener)selectionListener);
        this.tooSmallButton.addSelectionListener((SelectionListener)selectionListener);
        this.smallButton.addSelectionListener((SelectionListener)selectionListener);
        this.largeButton.addSelectionListener((SelectionListener)selectionListener);
        this.fillButton.addSelectionListener((SelectionListener)selectionListener);
        this.preferredButton.setSelection(true);
    }

    void createStyleGroup() {
        this.styleGroup = new Group((Composite)this.controlGroup, 0);
        this.styleGroup.setLayout((Layout)new GridLayout());
        this.styleGroup.setLayoutData((Object)new GridData(272));
        this.styleGroup.setText(ControlExample.getResourceString("Styles"));
    }

    Composite createTabFolderPage(TabFolder tabFolder) {
        this.tabFolderPage = new Composite((Composite)tabFolder, 0);
        GridLayout gridLayout = new GridLayout();
        this.tabFolderPage.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 2;
        this.createExampleGroup();
        this.createControlGroup();
        this.createExampleWidgets();
        this.createControlWidgets();
        this.setExampleWidgetState();
        return this.tabFolderPage;
    }

    void disposeExampleWidgets() {
        Control[] controls = this.getExampleWidgets();
        int i = 0;
        while (i < controls.length) {
            controls[i].dispose();
            ++i;
        }
    }

    void drawImage(Image image, Color color) {
        GC gc = new GC((Drawable)image);
        gc.setBackground(color);
        Rectangle bounds = image.getBounds();
        gc.fillRectangle(0, 0, bounds.width, bounds.height);
        gc.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
        gc.dispose();
    }

    Control[] getExampleWidgets() {
        return new Control[0];
    }

    String getTabText() {
        return "";
    }

    void recreateExampleWidgets() {
        this.disposeExampleWidgets();
        this.createExampleWidgets();
        this.setExampleWidgetState();
    }

    void setExampleWidgetBackground() {
        if (this.backgroundButton == null) {
            return;
        }
        Control[] controls = this.getExampleWidgets();
        Color color = this.backgroundColor;
        if (color == null) {
            color = controls[0].getBackground();
        }
        Image image = this.backgroundButton.getImage();
        this.drawImage(image, color);
        this.backgroundButton.setImage(image);
        if (this.backgroundColor == null) {
            return;
        }
        int i = 0;
        while (i < controls.length) {
            Control control = controls[i];
            control.setBackground(this.backgroundColor);
            ++i;
        }
    }

    void setExampleWidgetEnabled() {
        Control[] controls = this.getExampleWidgets();
        int i = 0;
        while (i < controls.length) {
            controls[i].setEnabled(this.enabledButton.getSelection());
            ++i;
        }
    }

    void setExampleWidgetFont() {
        if (this.font == null) {
            return;
        }
        Control[] controls = this.getExampleWidgets();
        int i = 0;
        while (i < controls.length) {
            Control control = controls[i];
            control.setFont(this.font);
            ++i;
        }
    }

    void setExampleWidgetForeground() {
        if (this.foregroundButton == null) {
            return;
        }
        Control[] controls = this.getExampleWidgets();
        Color color = this.foregroundColor;
        if (color == null) {
            color = controls[0].getForeground();
        }
        Image image = this.foregroundButton.getImage();
        this.drawImage(image, color);
        this.foregroundButton.setImage(image);
        if (this.foregroundColor == null) {
            return;
        }
        int i = 0;
        while (i < controls.length) {
            Control control = controls[i];
            control.setForeground(this.foregroundColor);
            ++i;
        }
    }

    void setExampleWidgetSize() {
        int size = -1;
        if (this.preferredButton == null) {
            return;
        }
        if (this.preferredButton.getSelection()) {
            size = -1;
        }
        if (this.tooSmallButton.getSelection()) {
            size = 10;
        }
        if (this.smallButton.getSelection()) {
            size = 50;
        }
        if (this.largeButton.getSelection()) {
            size = 100;
        }
        Control[] controls = this.getExampleWidgets();
        int i = 0;
        while (i < controls.length) {
            GridData gridData;
            if (this.fillButton.getSelection()) {
                gridData = new GridData(1808);
            } else {
                gridData = new GridData();
                gridData.widthHint = size;
                gridData.heightHint = size;
            }
            controls[i].setLayoutData((Object)gridData);
            ++i;
        }
        int seenCount = 0;
        Composite[] seen = new Composite[4];
        int i2 = 0;
        while (i2 < controls.length) {
            Control control = controls[i2];
            while (control != this.exampleGroup) {
                Composite parent = control.getParent();
                int index = 0;
                while (index < seenCount) {
                    if (seen[index] == parent) break;
                    ++index;
                }
                if (index == seenCount) {
                    parent.layout();
                }
                if (seenCount == seen.length) {
                    Composite[] newSeen = new Composite[seen.length + 4];
                    System.arraycopy(seen, 0, newSeen, 0, seen.length);
                    seen = newSeen;
                }
                seen[seenCount++] = parent;
                control = control.getParent();
            }
            ++i2;
        }
    }

    void setExampleWidgetState() {
        this.setExampleWidgetEnabled();
        this.setExampleWidgetVisibility();
        this.setExampleWidgetBackground();
        this.setExampleWidgetForeground();
        this.setExampleWidgetFont();
        this.setExampleWidgetSize();
    }

    void setExampleWidgetVisibility() {
        Control[] controls = this.getExampleWidgets();
        int i = 0;
        while (i < controls.length) {
            controls[i].setVisible(this.visibleButton.getSelection());
            ++i;
        }
    }
}

