/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.pm.FATTRS;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.PSZ;

public abstract class Device
implements Drawable {
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    public int hPalette = 0;
    int[] colorRefCount;
    boolean disposed;
    public boolean has32bitDepth;
    String[] fontFamilies = null;
    FATTRS[][] fontAttrs = null;
    int defFontFamilyID = -1;
    int defFontAttrsID = -1;
    int defFontHeight;
    long fontCacheStamp;
    FATTRS sysFont = null;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;

    static Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device(DeviceData data) {
        if (data != null) {
            this.debug = data.debug;
            this.tracking = data.tracking;
        }
        this.create(data);
        this.init();
        if (this.tracking) {
            this.errors = new Error[128];
            this.objects = new Object[128];
        }
        GCData hpsData = new GCData();
        int hps = this.internal_new_GC(hpsData);
        int[] formatCount = new int[1];
        OS.DevQueryCaps(hpsData.hdc, 23, 1, formatCount);
        int[] formats = new int[formatCount[0] * 2];
        OS.GpiQueryDeviceBitmapFormats(hps, formats.length, formats);
        this.internal_dispose_GC(hps, hpsData);
        int i = 0;
        while (i < formats.length) {
            if (formats[i] == 1 && formats[i + 1] == 32) {
                this.has32bitDepth = true;
                break;
            }
            i += 2;
        }
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    boolean checkFontCache() {
        int[] cFonts;
        boolean changed;
        boolean bl = changed = (OS.GpiQueryFontAction(0, 1) & 1) == 1;
        if (!changed && this.defFontFamilyID != -1) {
            return true;
        }
        this.fontFamilies = new String[8];
        this.fontAttrs = new FATTRS[8][];
        this.defFontFamilyID = -1;
        this.defFontAttrsID = -1;
        PSZ app = new PSZ("PM_SystemFonts");
        PSZ key = new PSZ("WindowText");
        int[] keyLen = new int[1];
        OS.PrfQueryProfileSize(-1, app, key, keyLen);
        byte[] buf = new byte[keyLen[0]];
        OS.PrfQueryProfileString(-1, app, key, null, buf, keyLen[0]);
        this.sysFont = this.decomposeFontNameSize(new PSZ(buf).toString());
        GCData hpsData = new GCData();
        int hps = this.internal_new_GC(hpsData);
        cFonts = new int[]{OS.GpiQueryFonts(hps, 1, null, cFonts, 0, null)};
        byte[] fm = new byte[cFonts[0] * 228];
        OS.GpiQueryFonts(hps, 1, null, cFonts, 228, fm);
        int[] info = new int[3];
        OS.DevQueryCaps(hpsData.hdc, 36, 3, info);
        int xRes = info[1];
        int yRes = info[2];
        this.defFontHeight = Compatibility.round(info[0] * 72, yRes);
        this.internal_dispose_GC(hps, hpsData);
        this.fontCacheStamp = System.currentTimeMillis();
        byte[] defFm = new byte[228];
        byte[] curFm = new byte[228];
        int sysFontHeight = this.sysFont.height;
        if (sysFontHeight == 0) {
            sysFontHeight = this.defFontHeight;
        }
        FATTRS sfa = null;
        int off = 0;
        int i = 0;
        while (i < cFonts[0]) {
            block21: {
                int k;
                int j;
                FATTRS fa;
                block23: {
                    FATTRS[] fAttrs;
                    block22: {
                        int lMatch;
                        block20: {
                            lMatch = fm[off + 204] & 0xFF | (fm[off + 205] & 0xFF) << 8 | (fm[off + 206] & 0xFF) << 16 | (fm[off + 207] & 0xFF) << 24;
                            if (lMatch != 0) break block20;
                            System.arraycopy(fm, off, defFm, 0, 228);
                            break block21;
                        }
                        short fsDefn = (short)(fm[off + 146] & 0xFF | (fm[off + 147] & 0xFF) << 8);
                        short fsCaps = (short)(fm[off + 150] & 0xFF | (fm[off + 151] & 0xFF) << 8);
                        short sXDeviceRes = (short)(fm[off + 126] & 0xFF | (fm[off + 127] & 0xFF) << 8);
                        short sYDeviceRes = (short)(fm[off + 128] & 0xFF | (fm[off + 129] & 0xFF) << 8);
                        if ((fsDefn & 1) == 0 && (sXDeviceRes != xRes || sYDeviceRes != yRes)) break block21;
                        fa = new FATTRS();
                        j = 0;
                        while (j < 32 && fm[off + j] != 0) {
                            ++j;
                        }
                        fa.fm_szFamilyname = new String(fm, off, j);
                        System.arraycopy(fm, off + 32, fa.szFacename, 0, 32);
                        fa.lMatch = lMatch;
                        fa.idRegistry = (short)(fm[off + 64] & 0xFF | (fm[off + 65] & 0xFF) << 8);
                        fa.usCodePage = (short)(fm[off + 66] & 0xFF | (fm[off + 67] & 0xFF) << 8);
                        fa.lMaxBaselineExt = fm[off + 112] & 0xFF | (fm[off + 113] & 0xFF) << 8 | (fm[off + 114] & 0xFF) << 16 | (fm[off + 115] & 0xFF) << 24;
                        fa.lAveCharWidth = fm[off + 100] & 0xFF | (fm[off + 101] & 0xFF) << 8 | (fm[off + 102] & 0xFF) << 16 | (fm[off + 103] & 0xFF) << 24;
                        fa.fsType = (short)(fm[off + 144] & 0xFF | (fm[off + 145] & 0xFF) << 8);
                        if ((fsDefn & 1) == 1) {
                            fa.fsFontUse = (short)(fa.fsFontUse | 4);
                        }
                        if ((fsCaps & 1) == 1) {
                            fa.fsFontUse = (short)(fa.fsFontUse | 2);
                        }
                        fa.fm_usWeightClass = (short)(fm[off + 122] & 0xFF | (fm[off + 123] & 0xFF) << 8);
                        fa.fm_fsSelection = (short)(fm[off + 148] & 0xFF | (fm[off + 149] & 0xFF) << 8);
                        fa.height = (short)(fm[off + 138] & 0xFF | (fm[off + 139] & 0xFF) << 8) / 10;
                        j = 0;
                        while (j < this.fontFamilies.length) {
                            if (this.fontFamilies[j] == null || this.fontFamilies[j].equals(fa.fm_szFamilyname)) break;
                            ++j;
                        }
                        if (j == this.fontFamilies.length) {
                            String[] newFontFamilies = new String[j + 8];
                            System.arraycopy(this.fontFamilies, 0, newFontFamilies, 0, j);
                            this.fontFamilies = newFontFamilies;
                            FATTRS[][] newFontAttrs = new FATTRS[j + 8][];
                            System.arraycopy(this.fontAttrs, 0, newFontAttrs, 0, j);
                            this.fontAttrs = newFontAttrs;
                        }
                        if (this.fontFamilies[j] == null) {
                            this.fontFamilies[j] = fa.fm_szFamilyname;
                            this.fontAttrs[j] = new FATTRS[4];
                        }
                        fAttrs = this.fontAttrs[j];
                        k = 0;
                        while (k < fAttrs.length) {
                            if (fAttrs[k] == null || (fAttrs[k].fsFontUse & 4) == (fa.fsFontUse & 4) && ((fa.fsFontUse & 4) != 0 || fAttrs[k].height == fa.height) && Arrays.equals(fAttrs[k].szFacename, fa.szFacename)) break;
                            ++k;
                        }
                        if (k != fAttrs.length) break block22;
                        fAttrs = new FATTRS[k + 4];
                        System.arraycopy(this.fontAttrs[j], 0, fAttrs, 0, k);
                        this.fontAttrs[j] = fAttrs;
                        break block23;
                    }
                    if (fAttrs[k] != null) break block21;
                }
                fAttrs[k] = fa;
                if (this.defFontFamilyID == -1) {
                    System.arraycopy(fm, off, curFm, 0, 228);
                    curFm[204] = 0;
                    curFm[205] = 0;
                    curFm[206] = 0;
                    curFm[207] = 0;
                    if (Arrays.equals(curFm, defFm)) {
                        this.defFontFamilyID = j;
                        this.defFontAttrsID = k;
                    }
                }
                if ((fa.fsFontUse & 4) == 0) {
                    if ((sfa == null || (sfa.fsFontUse & 4) != 0) && sysFontHeight == fa.height && Arrays.equals(this.sysFont.szFacename, fa.szFacename)) {
                        sfa = fa;
                    }
                } else if (sfa == null && Arrays.equals(this.sysFont.szFacename, fa.szFacename)) {
                    sfa = fa;
                }
            }
            ++i;
            off += 228;
        }
        if (sfa == null) {
            sfa = this.fontAttrs[this.defFontFamilyID][this.defFontAttrsID];
            System.arraycopy(sfa.szFacename, 0, this.sysFont.szFacename, 0, 32);
            this.sysFont.height = sfa.height;
            this.sysFont.fsSelection = 0;
        }
        this.sysFont.fsFontUse = sfa.fsFontUse;
        this.sysFont.lMatch = sfa.lMatch;
        this.sysFont.fm_szFamilyname = sfa.fm_szFamilyname;
        this.sysFont.fm_fsSelection = sfa.fm_fsSelection;
        this.sysFont.fm_usWeightClass = sfa.fm_usWeightClass;
        return false;
    }

    protected String composeFontNameSize(FATTRS fa) {
        String composed = fa.height + "." + new PSZ(fa.szFacename).toString();
        String simStyle = "";
        if ((fa.fsSelection & 0x20) != 0) {
            simStyle = simStyle + " Bold";
        }
        if ((fa.fsSelection & 1) != 0) {
            simStyle = simStyle + " Italic";
        }
        if ((fa.fsSelection & 2) != 0) {
            simStyle = simStyle + " Underscore";
        }
        if ((fa.fsSelection & 0x10) != 0) {
            simStyle = simStyle + " Strikeout";
        }
        if ((fa.fsSelection & 8) != 0) {
            simStyle = simStyle + " Outline";
        }
        if (simStyle.length() > 0) {
            composed = composed + "." + simStyle.substring(1);
        }
        return composed;
    }

    protected void create(DeviceData data) {
    }

    FATTRS decomposeFontNameSize(String fontNameSize) {
        String simStyle;
        String faceName;
        int pnt2;
        int pnt = fontNameSize.indexOf(46);
        int height = 0;
        if (pnt > 0) {
            try {
                height = Integer.parseInt(fontNameSize.substring(0, pnt));
            }
            catch (NumberFormatException x) {
                // empty catch block
            }
        }
        if ((pnt2 = fontNameSize.indexOf(46, ++pnt)) > 0) {
            faceName = fontNameSize.substring(pnt, pnt2);
            simStyle = fontNameSize.substring(pnt2) + ".";
        } else {
            faceName = fontNameSize.substring(pnt);
            simStyle = ".";
        }
        simStyle = simStyle.toUpperCase();
        FATTRS decomposed = new FATTRS();
        int len = faceName.length();
        if (len >= 32) {
            len = 31;
        }
        System.arraycopy(faceName.getBytes(), 0, decomposed.szFacename, 0, len);
        decomposed.szFacename[len] = 0;
        if (simStyle.indexOf(".BOLD.") >= 0) {
            decomposed.fsSelection = (short)(decomposed.fsSelection | 0x20);
        }
        if (simStyle.indexOf(".ITALIC.") >= 0) {
            decomposed.fsSelection = (short)(decomposed.fsSelection | 1);
        }
        if (simStyle.indexOf(".UNDERSCORE.") >= 0) {
            decomposed.fsSelection = (short)(decomposed.fsSelection | 2);
        }
        if (simStyle.indexOf(".UNDERLINED.") >= 0) {
            decomposed.fsSelection = (short)(decomposed.fsSelection | 2);
        }
        if (simStyle.indexOf(".STRIKEOUT.") >= 0) {
            decomposed.fsSelection = (short)(decomposed.fsSelection | 0x10);
        }
        if (simStyle.indexOf(".OUTLINE.") >= 0) {
            decomposed.fsSelection = (short)(decomposed.fsSelection | 8);
        }
        decomposed.height = height;
        return decomposed;
    }

    protected void destroy() {
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.checkDevice();
        this.release();
        this.destroy();
        this.disposed = true;
        if (this.tracking) {
            this.objects = null;
            this.errors = null;
        }
    }

    void dispose_Object(Object object) {
        int i = 0;
        while (i < this.objects.length) {
            if (this.objects[i] == object) {
                this.objects[i] = null;
                this.errors[i] = null;
                return;
            }
            ++i;
        }
    }

    public Rectangle getBounds() {
        this.checkDevice();
        GCData data = new GCData();
        int hps = this.internal_new_GC(data);
        int[] caps = new int[2];
        OS.DevQueryCaps(data.hdc, 4, caps.length, caps);
        this.internal_dispose_GC(hps, data);
        return new Rectangle(0, 0, caps[0], caps[1]);
    }

    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData data = new DeviceData();
        data.debug = this.debug;
        data.tracking = this.tracking;
        int count = 0;
        int length = 0;
        if (this.tracking) {
            length = this.objects.length;
        }
        int i = 0;
        while (i < length) {
            if (this.objects[i] != null) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        data.objects = new Object[count];
        data.errors = new Error[count];
        int i2 = 0;
        while (i2 < length) {
            if (this.objects[i2] != null) {
                data.objects[index] = this.objects[i2];
                data.errors[index] = this.errors[i2];
                ++index;
            }
            ++i2;
        }
        return data;
    }

    public Rectangle getClientArea() {
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        GCData hpsData = new GCData();
        int hps = this.internal_new_GC(hpsData);
        int[] colorInfo = new int[2];
        OS.DevQueryCaps(hpsData.hdc, 15, 2, colorInfo);
        this.internal_dispose_GC(hps, hpsData);
        return colorInfo[0] * colorInfo[1];
    }

    public Point getDPI() {
        this.checkDevice();
        GCData hpsData = new GCData();
        int hps = this.internal_new_GC(hpsData);
        int[] dpiInfo = new int[2];
        OS.DevQueryCaps(hpsData.hdc, 37, 2, dpiInfo);
        this.internal_dispose_GC(hps, hpsData);
        return new Point(dpiInfo[0], dpiInfo[1]);
    }

    public FontData[] getFontList(String faceName, boolean scalable) {
        this.checkDevice();
        this.checkFontCache();
        ArrayList<FontData> list = new ArrayList<FontData>();
        int i = 0;
        while (i < this.fontAttrs.length) {
            if (this.fontAttrs[i] == null) break;
            if (faceName == null || this.fontFamilies[i].equals(faceName)) {
                int j = 0;
                while (j < this.fontAttrs[i].length) {
                    FATTRS fa = this.fontAttrs[i][j];
                    if (fa == null) break;
                    if ((fa.fsFontUse & 4) != 0 == scalable) {
                        list.add(FontData.pm_new(fa));
                    }
                    ++j;
                }
                if (faceName != null) break;
            }
            ++i;
        }
        FontData[] fontList = new FontData[list.size()];
        return list.toArray(fontList);
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        int pixel = 0;
        switch (id) {
            case 1: {
                pixel = this.hPalette != 0 ? 15 : 0xFFFFFF;
                break;
            }
            case 2: {
                pixel = this.hPalette != 0 ? 0 : 0;
                break;
            }
            case 3: {
                pixel = this.hPalette != 0 ? 9 : 0xFF0000;
                break;
            }
            case 4: {
                pixel = this.hPalette != 0 ? 1 : 0x800000;
                break;
            }
            case 5: {
                pixel = this.hPalette != 0 ? 10 : 65280;
                break;
            }
            case 6: {
                pixel = this.hPalette != 0 ? 2 : 32768;
                break;
            }
            case 7: {
                pixel = this.hPalette != 0 ? 11 : 0xFFFF00;
                break;
            }
            case 8: {
                pixel = this.hPalette != 0 ? 3 : 0x808000;
                break;
            }
            case 9: {
                pixel = this.hPalette != 0 ? 12 : 255;
                break;
            }
            case 10: {
                pixel = this.hPalette != 0 ? 4 : 128;
                break;
            }
            case 11: {
                pixel = this.hPalette != 0 ? 13 : 0xFF00FF;
                break;
            }
            case 12: {
                pixel = this.hPalette != 0 ? 5 : 0x800080;
                break;
            }
            case 13: {
                pixel = this.hPalette != 0 ? 14 : 65535;
                break;
            }
            case 14: {
                pixel = this.hPalette != 0 ? 6 : 32896;
                break;
            }
            case 15: {
                pixel = this.hPalette != 0 ? 7 : 0xC0C0C0;
                break;
            }
            case 16: {
                pixel = this.hPalette != 0 ? 8 : 0x808080;
            }
        }
        return Color.pm_new(this, pixel);
    }

    public Font getSystemFont() {
        this.checkDevice();
        return Font.pm_new(this, this.systemFont());
    }

    public boolean getWarnings() {
        this.checkDevice();
        return false;
    }

    protected void init() {
        GCData data = new GCData();
        int hps = this.internal_new_GC(data);
        int[] addcaps = new int[1];
        int[] colors = new int[1];
        OS.DevQueryCaps(data.hdc, 32, 1, addcaps);
        OS.DevQueryCaps(data.hdc, 14, 1, colors);
        this.internal_dispose_GC(hps, data);
        if ((addcaps[0] & 0x100) == 0 || colors[0] != 256) {
            return;
        }
        RGB[] rgbs = new RGB[]{new RGB(0, 0, 0), new RGB(128, 0, 0), new RGB(0, 128, 0), new RGB(128, 128, 0), new RGB(0, 0, 128), new RGB(128, 0, 128), new RGB(0, 128, 128), new RGB(192, 192, 192), new RGB(128, 128, 128), new RGB(255, 0, 0), new RGB(0, 255, 0), new RGB(255, 255, 0), new RGB(0, 0, 255), new RGB(255, 0, 255), new RGB(0, 255, 255), new RGB(255, 255, 255)};
        int[] logPalette = new int[256];
        this.colorRefCount = new int[256];
        int i = 0;
        while (i < rgbs.length) {
            this.colorRefCount[i] = 1;
            logPalette[i] = rgbs[i].red << 16 | rgbs[i].green << 8 | rgbs[i].blue;
            ++i;
        }
        this.hPalette = OS.GpiCreatePalette(0, 0, 2, 256, logPalette);
    }

    public abstract int internal_new_GC(GCData var1);

    public abstract void internal_dispose_GC(int var1, GCData var2);

    public boolean isDisposed() {
        return this.disposed;
    }

    void new_Object(Object object) {
        int i = 0;
        while (i < this.objects.length) {
            if (this.objects[i] == null) {
                this.objects[i] = object;
                this.errors[i] = new Error();
                return;
            }
            ++i;
        }
        Object[] newObjects = new Object[this.objects.length + 128];
        System.arraycopy(this.objects, 0, newObjects, 0, this.objects.length);
        newObjects[this.objects.length] = object;
        this.objects = newObjects;
        Error[] newErrors = new Error[this.errors.length + 128];
        System.arraycopy(this.errors, 0, newErrors, 0, this.errors.length);
        newErrors[this.errors.length] = new Error();
        this.errors = newErrors;
    }

    long matchFont(FATTRS handle, boolean firstTime) {
        FATTRS fa;
        if (this.checkFontCache() && !firstTime) {
            return this.fontCacheStamp;
        }
        int familyID = -1;
        int i = 0;
        while (i < this.fontFamilies.length && this.fontFamilies[i] != null) {
            if (this.fontFamilies[i].equals(handle.fm_szFamilyname)) {
                familyID = i;
                break;
            }
            ++i;
        }
        if (familyID == -1) {
            familyID = this.defFontFamilyID;
        }
        int attrsID = -1;
        int maxCost = 0;
        int maxHeightCost = 0;
        FATTRS[] fAttrs = this.fontAttrs[familyID];
        int i2 = 0;
        while (i2 < fAttrs.length && fAttrs[i2] != null) {
            boolean vector;
            int cost = 0;
            fa = fAttrs[i2];
            boolean bl = vector = (fa.fsFontUse & 4) != 0;
            if (!(handle.fm_usWeightClass <= 5 && fa.fm_usWeightClass > 5 || (handle.fm_fsSelection & 1) == 0 && (fa.fm_fsSelection & 1) != 0)) {
                cost += vector ? 200 : 201;
                int weight = handle.fm_usWeightClass;
                if (weight == fa.fm_usWeightClass) {
                    cost += 100;
                } else {
                    weight = weight <= 5 ? ((weight -= fa.fm_usWeightClass) > 0 ? (weight << 1) - 1 : -weight << 1) : ((weight -= fa.fm_usWeightClass) < 0 ? (-weight << 1) - 1 : (weight <<= 1));
                    cost += 100 - weight;
                }
                cost += (handle.fm_fsSelection & 1) == (fa.fm_fsSelection & 1) ? 71 : 70;
                cost += Arrays.equals(handle.szFacename, fa.szFacename) ? 51 : 50;
                int hCost = handle.height;
                if (hCost == 0) {
                    hCost = this.defFontHeight;
                }
                if (vector || hCost == fa.height) {
                    hCost = Integer.MAX_VALUE;
                } else {
                    hCost = (hCost -= fa.height) > 0 ? (hCost << 1) - 1 : -hCost << 1;
                    hCost = Integer.MAX_VALUE - hCost;
                }
                if (cost > maxCost || cost == maxCost && hCost > maxHeightCost) {
                    maxCost = cost;
                    maxHeightCost = hCost;
                    attrsID = i2;
                }
            }
            ++i2;
        }
        fa = attrsID >= 0 ? this.fontAttrs[familyID][attrsID] : this.fontAttrs[this.defFontFamilyID][this.defFontAttrsID];
        System.arraycopy(fa.szFacename, 0, handle.szFacename, 0, 32);
        if (handle.fm_usWeightClass > 5 && fa.fm_usWeightClass <= 5) {
            handle.fsSelection = (short)(handle.fsSelection | 0x20);
        }
        if ((handle.fm_fsSelection & 1) != 0 && (fa.fm_fsSelection & 1) == 0) {
            handle.fsSelection = (short)(handle.fsSelection | 1);
        }
        handle.fsFontUse = fa.fsFontUse;
        handle.lMatch = fa.lMatch;
        return this.fontCacheStamp;
    }

    protected FATTRS matchFont(String fontNameSize) {
        if (fontNameSize == null) {
            return this.fontAttrs[this.defFontFamilyID][this.defFontAttrsID];
        }
        this.checkFontCache();
        FATTRS handle = this.decomposeFontNameSize(fontNameSize);
        FATTRS ffa = null;
        int height = handle.height;
        if (height == 0) {
            height = this.defFontHeight;
        }
        int i = 0;
        while (i < this.fontAttrs.length && this.fontAttrs[i] != null) {
            int j = 0;
            while (j < this.fontAttrs[i].length && this.fontAttrs[i][j] != null) {
                boolean cost = false;
                FATTRS fa = this.fontAttrs[i][j];
                if ((fa.fsFontUse & 4) == 0) {
                    if (height == fa.height && Arrays.equals(handle.szFacename, fa.szFacename)) {
                        ffa = fa;
                        break;
                    }
                } else if (ffa == null && Arrays.equals(handle.szFacename, fa.szFacename)) {
                    ffa = fa;
                }
                ++j;
            }
            ++i;
        }
        if (ffa == null) {
            ffa = this.fontAttrs[this.defFontFamilyID][this.defFontAttrsID];
            System.arraycopy(ffa.szFacename, 0, handle.szFacename, 0, 32);
            handle.height = ffa.height;
            handle.fsSelection = 0;
        }
        handle.fsFontUse = ffa.fsFontUse;
        handle.lMatch = ffa.lMatch;
        handle.fm_szFamilyname = ffa.fm_szFamilyname;
        handle.fm_fsSelection = ffa.fm_fsSelection;
        handle.fm_usWeightClass = ffa.fm_usWeightClass;
        return handle;
    }

    protected void release() {
        if (this.hPalette != 0) {
            OS.GpiDeletePalette(this.hPalette);
        }
        this.hPalette = 0;
        this.colorRefCount = null;
    }

    public void setWarnings(boolean warnings) {
        this.checkDevice();
    }

    protected FATTRS systemFont() {
        this.checkFontCache();
        return this.sysFont;
    }

    static {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

