/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.pm.BITMAPINFOHEADER2;
import org.eclipse.swt.internal.pm.FATTRS;
import org.eclipse.swt.internal.pm.FONTMETRICS;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.POINTERINFO;
import org.eclipse.swt.internal.pm.RECTL;
import org.eclipse.swt.internal.pm.RGNRECT;

public final class GC {
    public int handle;
    Drawable drawable;
    GCData data;
    final int[] matrix = new int[]{65536, 0, 0, 0, 65536, 0, 0, 0, 1};
    FATTRS hFont;
    FONTMETRICS hFontMetrics;
    static final char Mnemonic = '&';

    GC() {
    }

    public GC(Drawable drawable) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData data = new GCData();
        data.doInit = true;
        int hps = drawable.internal_new_GC(data);
        Device device = data.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        data.device = device;
        this.init(drawable, data, hps);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void copyArea(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rect = image.getBounds();
        int bmpPS = image.new_compatible_GC(null, this.data.hdc, rect.width, rect.height);
        OS.GpiSetBitmap(bmpPS, image.handle);
        if (this.matrix[4] == -65536) {
            y = this.matrix[7] + 1 - (y + rect.height);
        }
        OS.GpiBitBlt(bmpPS, this.handle, 4, new int[]{0, 0, rect.width, rect.height, x, y, x + rect.width, y + rect.height}, 204, 2);
        image.dispose_compatible_GC(bmpPS, null);
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY) {
        int hwnd;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.matrix[4] == -65536) {
            int h = this.matrix[7] + 1;
            srcY = h - (srcY + height);
            destY = h - (destY + height);
        }
        if ((hwnd = this.data.hwnd) == 0) {
            OS.GpiBitBlt(this.handle, this.handle, 4, new int[]{destX, destY, destX + width, destY + height, srcX, srcY, srcX + width, srcY + height}, 204, 2);
        } else {
            RECTL rclClip = null;
            int[] pHrgn = new int[1];
            OS.GpiSetClipRegion(this.handle, 0, pHrgn);
            int hrgn = pHrgn[0];
            if (hrgn != 0 && hrgn != -1) {
                rclClip = new RECTL();
                OS.GpiQueryRegionBox(this.handle, hrgn, rclClip);
                OS.GpiSetClipRegion(this.handle, hrgn, pHrgn);
            }
            RECTL rclScroll = new RECTL();
            rclScroll.xLeft = srcX;
            rclScroll.yBottom = srcY;
            rclScroll.xRight = srcX + width;
            rclScroll.yTop = srcY + height;
            int rc = OS.WinScrollWindow(hwnd, destX - srcX, destY - srcY, rclScroll, rclClip, 0, null, 2);
        }
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        Image image = this.data.image;
        if (image != null) {
            if (image.device.hPalette == 0) {
                image.refreshBitmap();
            }
            OS.GpiSetBitmap(this.handle, 0);
            image.memGC = null;
        }
        this.setClipping((Rectangle)null);
        Device device = this.data.device;
        this.drawable.internal_dispose_GC(this.handle, this.data);
        this.drawable = null;
        this.handle = 0;
        this.data.image = null;
        this.data.rcl = null;
        if (device.tracking) {
            device.dispose_Object(this);
        }
        this.data.device = null;
        this.data = null;
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int endAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (endAngle < 0) {
            startAngle += endAngle;
            endAngle = -endAngle;
        }
        if (width == 0 || height == 0 || endAngle == 0) {
            SWT.error(5);
        }
        boolean geomLine = OS.GpiQueryLineWidthGeom(this.handle) != 1;
        int saved = -1;
        int axr = width / 2;
        int ayr = height / 2;
        int[] arcparams = new int[]{axr, -ayr, 0, 0};
        OS.GpiSetArcParams(this.handle, arcparams);
        int xc = x + axr;
        int yc = y + ayr;
        int[] pnt = new int[]{xc, yc};
        int[] pnt2 = new int[2];
        int extX = width % 2;
        int extY = height % 2;
        if (extX != 0 || extY != 0) {
            int i = 0;
            while (i < 4) {
                int sa = i * 90;
                int ea = sa + 90;
                if (sa < startAngle) {
                    sa = startAngle;
                }
                if (ea > startAngle + endAngle) {
                    ea = startAngle + endAngle;
                }
                if (ea > sa) {
                    ea -= sa;
                    switch (i) {
                        case 0: {
                            pnt[0] = xc + extX;
                            pnt[1] = yc;
                            break;
                        }
                        case 1: {
                            pnt[0] = xc;
                            pnt[1] = yc;
                            break;
                        }
                        case 2: {
                            pnt[0] = xc;
                            pnt[1] = yc + extY;
                            break;
                        }
                        case 3: {
                            pnt[0] = xc + extX;
                            pnt[1] = yc + extY;
                        }
                    }
                    if (sa == startAngle) {
                        int oldMix = OS.GpiQueryMix(this.handle);
                        OS.GpiSetMix(this.handle, 5);
                        OS.GpiPartialArc(this.handle, pnt, 65536, sa << 16, 0);
                        OS.GpiSetMix(this.handle, oldMix);
                        OS.GpiQueryCurrentPosition(this.handle, pnt2);
                        OS.GpiMove(this.handle, pnt2);
                    }
                    if (geomLine) {
                        saved = this.beginGeomLine();
                    }
                    OS.GpiPartialArc(this.handle, pnt, 65536, sa << 16, ea << 16);
                    if (geomLine) {
                        this.endGeomLine(saved);
                    }
                }
                ++i;
            }
        } else {
            int oldMix = OS.GpiQueryMix(this.handle);
            OS.GpiSetMix(this.handle, 5);
            OS.GpiPartialArc(this.handle, pnt, 65536, startAngle << 16, 0);
            OS.GpiSetMix(this.handle, oldMix);
            OS.GpiQueryCurrentPosition(this.handle, pnt2);
            OS.GpiMove(this.handle, pnt2);
            if (geomLine) {
                saved = this.beginGeomLine();
            }
            OS.GpiPartialArc(this.handle, pnt, 65536, startAngle << 16, endAngle << 16);
            if (geomLine) {
                this.endGeomLine(saved);
            }
        }
    }

    public void drawFocus(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0 || height < 0) {
            return;
        }
        int[] pnt = new int[]{x, y};
        int oldType = OS.GpiQueryLineType(this.handle);
        int oldMix = OS.GpiQueryMix(this.handle);
        int oldColor = OS.GpiQueryColor(this.handle);
        Color fg = Color.pm_new(this.data.device, oldColor);
        Color bg = Color.pm_new(this.data.device, OS.GpiQueryBackColor(this.handle));
        int newColor = fg.rgb ^ bg.rgb;
        int hPal = this.data.device.hPalette;
        if (hPal != 0) {
            newColor = OS.GpiQueryNearestPaletteIndex(hPal, newColor);
        }
        OS.GpiSetLineType(this.handle, 9);
        OS.GpiSetMix(this.handle, 4);
        OS.GpiSetColor(this.handle, newColor);
        OS.GpiMove(this.handle, pnt);
        pnt[0] = pnt[0] + (width - 1);
        pnt[1] = pnt[1] + (height - 1);
        OS.GpiBox(this.handle, 2, pnt, 0, 0);
        OS.GpiSetLineType(this.handle, oldType);
        OS.GpiSetMix(this.handle, oldMix);
        OS.GpiSetColor(this.handle, oldColor);
    }

    public void drawImage(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, x, y, -1, -1, true);
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (srcWidth == 0 || srcHeight == 0 || destWidth == 0 || destHeight == 0) {
            return;
        }
        if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false);
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        switch (srcImage.type) {
            case 0: {
                this.drawBitmap(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple);
                break;
            }
            case 1: {
                this.drawIcon(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple);
                break;
            }
            default: {
                SWT.error(42);
            }
        }
    }

    void drawIcon(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        int hBitmap;
        int hbmColor = srcImage.handle;
        int hbmPointer = srcImage.maskHandle;
        if (hbmPointer == 0) {
            POINTERINFO srcInfo = new POINTERINFO();
            OS.WinQueryPointerInfo(srcImage.handle, srcInfo);
            hbmColor = srcInfo.hbmColor;
            hbmPointer = srcInfo.hbmPointer;
        }
        if ((hBitmap = hbmColor) == 0) {
            hBitmap = hbmPointer;
        }
        BITMAPINFOHEADER2 bm = new BITMAPINFOHEADER2();
        OS.GpiQueryBitmapInfoHeader(hBitmap, bm);
        int iconWidth = bm.cx;
        int iconHeight = bm.cy;
        if (hBitmap == hbmPointer) {
            iconHeight /= 2;
        }
        if (srcX + srcWidth > iconWidth || srcY + srcHeight > iconHeight) {
            SWT.error(5);
        }
        if (simple) {
            srcWidth = destWidth = iconWidth;
            srcHeight = destHeight = iconHeight;
        }
        srcY = iconHeight - (srcY + srcHeight);
        if (this.matrix[4] == -65536) {
            destY = this.matrix[7] + 1 - (destY + destHeight);
        }
        if (simple && srcImage.maskHandle == 0) {
            OS.WinDrawPointer(this.handle, destX, destY, srcImage.handle, 0);
            return;
        }
        int oldColor = OS.GpiQueryColor(this.handle);
        int oldBackColor = OS.GpiQueryBackColor(this.handle);
        OS.GpiSetDefaultViewMatrix(this.handle, 0, null, 0);
        int newColor = 0xFFFFFF;
        int newBackColor = 0;
        int hPalette = this.data.device.hPalette;
        if (hPalette != 0) {
            newColor = 15;
        }
        OS.GpiSetColor(this.handle, newColor);
        OS.GpiSetBackColor(this.handle, newBackColor);
        OS.GpiWCBitBlt(this.handle, hbmPointer, 4, new int[]{destX, destY, destX + destWidth - 1, destY + destHeight - 1, srcX, srcY + iconHeight, srcX + srcWidth, srcY + iconHeight + srcHeight}, 136, 2);
        OS.GpiWCBitBlt(this.handle, hbmColor, 4, new int[]{destX, destY, destX + destWidth - 1, destY + destHeight - 1, srcX, srcY, srcX + srcWidth, srcY + srcHeight}, 102, 2);
        OS.GpiWCBitBlt(this.handle, hbmPointer, 4, new int[]{destX, destY, destX + destWidth - 1, destY + destHeight - 1, srcX, srcY, srcX + srcWidth, srcY + srcHeight}, 102, 2);
        OS.GpiSetDefaultViewMatrix(this.handle, 9, this.matrix, 0);
        OS.GpiSetBackColor(this.handle, oldBackColor);
        OS.GpiSetColor(this.handle, oldColor);
    }

    void drawBitmap(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        BITMAPINFOHEADER2 bm = new BITMAPINFOHEADER2();
        OS.GpiQueryBitmapInfoHeader(srcImage.handle, bm);
        int imgWidth = bm.cx;
        int imgHeight = bm.cy;
        if (simple) {
            srcWidth = destWidth = imgWidth;
            srcHeight = destHeight = imgHeight;
        } else {
            if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
                SWT.error(5);
            }
            simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
        }
        boolean mustRestore = false;
        GC memGC = srcImage.memGC;
        if (memGC != null && !memGC.isDisposed()) {
            mustRestore = true;
            if (srcImage.device.hPalette == 0) {
                srcImage.refreshBitmap();
            }
            OS.GpiSetBitmap(memGC.handle, 0);
        }
        if (srcImage.alpha != -1 || srcImage.alphaData != null) {
            this.drawBitmapAlpha(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, bm, imgWidth, imgHeight);
        } else if (srcImage.transparentPixel != -1) {
            this.drawBitmapTransparent(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, bm, imgWidth, imgHeight);
        } else {
            this.drawBitmap(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, bm, imgWidth, imgHeight);
        }
        if (mustRestore) {
            OS.GpiSetBitmap(memGC.handle, srcImage.handle);
        }
    }

    void drawBitmapAlpha(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, BITMAPINFOHEADER2 bm, int imgWidth, int imgHeight) {
        int alpha;
        boolean fixStretch;
        if (srcImage.alpha == 0) {
            return;
        }
        if (srcImage.alpha == 255) {
            this.drawBitmap(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, bm, imgWidth, imgHeight);
            return;
        }
        Rectangle rect = this.getClipping();
        Rectangle destRect = new Rectangle(destX, destY, destWidth, destHeight);
        if ((rect = rect.intersection(destRect)).isEmpty()) {
            return;
        }
        if (!rect.equals(destRect)) {
            simple = false;
            int sx1 = srcX + (rect.x - destX) * srcWidth / destWidth;
            int sx2 = srcX + (rect.x + rect.width - destX) * srcWidth / destWidth;
            int sy1 = srcY + (rect.y - destY) * srcHeight / destHeight;
            int sy2 = srcY + (rect.y + rect.height - destY) * srcHeight / destHeight;
            destX = rect.x;
            destY = rect.y;
            destWidth = rect.width;
            destHeight = rect.height;
            srcX = sx1;
            srcY = sy1;
            srcWidth = Math.max(1, sx2 - sx1);
            srcHeight = Math.max(1, sy2 - sy1);
        }
        int depth = this.data.device.has32bitDepth ? 32 : 24;
        int destPS = srcImage.new_compatible_GC(null, this.data.hdc, destWidth, destHeight);
        int destBitmap = srcImage.createBitmap(destWidth, destHeight, depth, 1, null, null, new int[]{destPS}, 0);
        int bmi_cbFix = 4;
        int[] bmi = new int[4];
        bmi[0] = 16;
        bmi[3] = depth << 16 | 1;
        int destBytesPerLine = (depth * destWidth + 31) / 32 * 4;
        int destSizeInBytes = destBytesPerLine * destHeight;
        OS.GpiSetDefaultViewMatrix(this.handle, 0, null, 0);
        srcY = imgHeight - (srcY + srcHeight);
        if (this.matrix[4] == -65536) {
            destY = this.matrix[7] + 1 - (destY + destHeight);
        }
        boolean bl = fixStretch = srcWidth != destWidth || srcHeight != destHeight;
        if (simple) {
            OS.GpiSetBitmap(destPS, srcImage.handle);
        } else {
            int oldColor = 0;
            int oldPattern = 0;
            int rop = 204;
            if (fixStretch) {
                oldColor = OS.GpiQueryColor(destPS);
                OS.GpiSetColor(destPS, -1);
                oldPattern = OS.GpiQueryPattern(destPS);
                OS.GpiSetPattern(destPS, 16);
                rop = 252;
            }
            OS.GpiWCBitBlt(destPS, srcImage.handle, 4, new int[]{0, 0, destWidth - 1, destHeight - 1, srcX, srcY, srcX + srcWidth, srcY + srcHeight}, rop, 2);
            if (fixStretch) {
                OS.GpiSetColor(destPS, oldColor);
                OS.GpiSetPattern(destPS, oldPattern);
            }
        }
        byte[] srcData = new byte[destSizeInBytes];
        OS.GpiQueryBitmapBits(destPS, 0, destHeight, srcData, bmi);
        OS.GpiSetBitmap(destPS, destBitmap);
        OS.GpiBitBlt(destPS, this.handle, 4, new int[]{0, 0, destWidth, destHeight, destX, destY, destX + destWidth, destY + destHeight}, 204, 2);
        byte[] destData = new byte[destSizeInBytes];
        OS.GpiQueryBitmapBits(destPS, 0, destHeight, destData, bmi);
        byte[] srcAlphaData = null;
        if (srcImage.alpha == -1) {
            srcAlphaData = new byte[destWidth * destHeight];
            ImageData.blit(1, srcImage.alphaData, 8, imgWidth, 1, srcX, imgHeight - (srcY + srcHeight), srcWidth, srcHeight, null, null, null, 255, null, 0, srcAlphaData, 8, destWidth, 1, 0, 0, destWidth, destHeight, null, null, null, false, true);
        }
        boolean hasAlphaChannel = (alpha = srcImage.alpha) == -1;
        int dpinc = destBytesPerLine - destWidth * (depth >> 3);
        int dp = 0;
        int ap = 0;
        int y = 0;
        while (y < destHeight) {
            int x = 0;
            while (x < destWidth) {
                if (hasAlphaChannel) {
                    alpha = srcAlphaData[ap] & 0xFF;
                }
                int n = dp;
                destData[n] = (byte)(destData[n] + ((srcData[dp] & 0xFF) - (destData[dp] & 0xFF)) * alpha / 255);
                int n2 = dp + 1;
                destData[n2] = (byte)(destData[n2] + ((srcData[dp + 1] & 0xFF) - (destData[dp + 1] & 0xFF)) * alpha / 255);
                int n3 = dp + 2;
                destData[n3] = (byte)(destData[n3] + ((srcData[dp + 2] & 0xFF) - (destData[dp + 2] & 0xFF)) * alpha / 255);
                dp += depth >> 3;
                ++ap;
                ++x;
            }
            dp += dpinc;
            ++y;
        }
        OS.GpiDrawBits(this.handle, destData, bmi, 4, new int[]{destX, destY, destX + destWidth - 1, destY + destHeight - 1, 0, 0, destWidth, destHeight}, 204, 2);
        OS.GpiSetDefaultViewMatrix(this.handle, 9, this.matrix, 0);
        srcImage.dispose_compatible_GC(destPS, null);
        OS.GpiDeleteBitmap(destBitmap);
    }

    void drawBitmapTransparent(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, BITMAPINFOHEADER2 bm, int imgWidth, int imgHeight) {
        Rectangle rect = this.getClipping();
        Rectangle destRect = new Rectangle(destX, destY, destWidth, destHeight);
        if ((rect = rect.intersection(destRect)).isEmpty()) {
            return;
        }
        if (!rect.equals(destRect)) {
            simple = false;
            int sx1 = srcX + (rect.x - destX) * srcWidth / destWidth;
            int sx2 = srcX + (rect.x + rect.width - destX) * srcWidth / destWidth;
            int sy1 = srcY + (rect.y - destY) * srcHeight / destHeight;
            int sy2 = srcY + (rect.y + rect.height - destY) * srcHeight / destHeight;
            destX = rect.x;
            destY = rect.y;
            destWidth = rect.width;
            destHeight = rect.height;
            srcX = sx1;
            srcY = sy1;
            srcWidth = Math.max(1, sx2 - sx1);
            srcHeight = Math.max(1, sy2 - sy1);
        }
        int transRGB = 0;
        int depth = bm.cBitCount * bm.cPlanes;
        int bmi_cbFix = 4;
        int[] bmi = null;
        int bmpPS = 0;
        if (depth <= 8) {
            int numColors = 1 << depth;
            bmi = new int[4 + numColors];
            bmi[0] = 16;
            bmi[3] = bm.cBitCount << 16 | bm.cPlanes;
            bmpPS = srcImage.new_compatible_GC(null, this.data.hdc, imgWidth, imgHeight);
            OS.GpiSetBitmap(bmpPS, srcImage.handle);
            OS.GpiQueryBitmapBits(bmpPS, 0, 0, null, bmi);
            int offset = 4 + srcImage.transparentPixel;
            transRGB = bmi[offset];
        } else {
            int pixel = srcImage.transparentPixel;
            transRGB = (pixel & 0xFF0000) >> 16 | pixel & 0xFF00 | (pixel & 0xFF) << 16;
        }
        int transColor = transRGB;
        int hPalette = this.data.device.hPalette;
        if (hPalette != 0) {
            transColor = OS.GpiQueryNearestPaletteIndex(hPalette, transRGB);
        }
        int oldBackColor = OS.GpiQueryBackColor(this.handle);
        int oldMix = OS.GpiQueryBackMix(this.handle);
        OS.GpiSetBackColor(this.handle, transColor);
        OS.GpiSetBackMix(this.handle, 18);
        srcY = imgHeight - (srcY + srcHeight);
        byte[] srcData = null;
        int rop = 204;
        boolean fixStretch = srcWidth != destWidth || srcHeight != destHeight;
        int oldColor = 0;
        int oldPattern = 0;
        if (fixStretch) {
            if (this.data.hwnd != 0) {
                if (bmi == null) {
                    int numColors = 0;
                    if (depth <= 8) {
                        numColors = 1 << depth;
                    } else if (this.data.device.has32bitDepth) {
                        bm.cBitCount = (short)32;
                        depth = 32;
                        bm.cPlanes = 1;
                    }
                    bmi = new int[4 + numColors];
                    bmi[0] = 16;
                    bmi[3] = bm.cBitCount << 16 | bm.cPlanes;
                    bmpPS = srcImage.new_compatible_GC(null, this.data.hdc, imgWidth, imgHeight);
                    OS.GpiSetBitmap(bmpPS, srcImage.handle);
                }
                int srcBytesPerLine = (depth * imgWidth + 31) / 32 * 4;
                srcData = new byte[srcBytesPerLine * srcHeight];
                OS.GpiQueryBitmapBits(bmpPS, srcY, srcHeight, srcData, bmi);
                int newBytesPerLine = (depth * destWidth + 31) / 32 * 4;
                byte[] newData = new byte[newBytesPerLine * destHeight];
                if (depth > 8) {
                    ImageData.blit(1, srcData, depth, srcBytesPerLine, 1, srcX, 0, srcWidth, srcHeight, 0, 0, 0, 255, null, 0, newData, depth, newBytesPerLine, 1, 0, 0, destWidth, destHeight, 0, 0, 0, false, false);
                } else {
                    ImageData.blit(1, srcData, depth, srcBytesPerLine, 1, srcX, 0, srcWidth, srcHeight, null, null, null, 255, null, 0, newData, depth, newBytesPerLine, 1, 0, 0, destWidth, destHeight, null, null, null, false, false);
                }
                srcData = newData;
                bmi[1] = destWidth;
                bmi[2] = destHeight;
            } else {
                oldColor = OS.GpiQueryColor(this.handle);
                OS.GpiSetColor(this.handle, -1);
                oldPattern = OS.GpiQueryPattern(this.handle);
                OS.GpiSetPattern(this.handle, 16);
                rop = 252;
            }
        }
        if (bmpPS != 0) {
            srcImage.dispose_compatible_GC(bmpPS, null);
        }
        OS.GpiSetDefaultViewMatrix(this.handle, 0, null, 0);
        if (this.matrix[4] == -65536) {
            destY = this.matrix[7] + 1 - (destY + destHeight);
        }
        if (srcData != null) {
            OS.GpiDrawBits(this.handle, srcData, bmi, 4, new int[]{destX, destY, destX + destWidth - 1, destY + destHeight - 1, 0, 0, destWidth, destHeight}, 204, 2);
        } else {
            OS.GpiWCBitBlt(this.handle, srcImage.handle, 4, new int[]{destX, destY, destX + destWidth - 1, destY + destHeight - 1, srcX, srcY, srcX + srcWidth, srcY + srcHeight}, rop, 2);
        }
        OS.GpiSetDefaultViewMatrix(this.handle, 9, this.matrix, 0);
        if (fixStretch && srcData == null) {
            OS.GpiSetColor(this.handle, oldColor);
            OS.GpiSetPattern(this.handle, oldPattern);
        }
        OS.GpiSetBackColor(this.handle, oldBackColor);
        OS.GpiSetBackMix(this.handle, oldMix);
    }

    void drawBitmap(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, BITMAPINFOHEADER2 bm, int imgWidth, int imgHeight) {
        Rectangle rect = this.getClipping();
        Rectangle destRect = new Rectangle(destX, destY, destWidth, destHeight);
        if ((rect = rect.intersection(destRect)).isEmpty()) {
            return;
        }
        if (!rect.equals(destRect)) {
            simple = false;
            int sx1 = srcX + (rect.x - destX) * srcWidth / destWidth;
            int sx2 = srcX + (rect.x + rect.width - destX) * srcWidth / destWidth;
            int sy1 = srcY + (rect.y - destY) * srcHeight / destHeight;
            int sy2 = srcY + (rect.y + rect.height - destY) * srcHeight / destHeight;
            destX = rect.x;
            destY = rect.y;
            destWidth = rect.width;
            destHeight = rect.height;
            srcX = sx1;
            srcY = sy1;
            srcWidth = Math.max(1, sx2 - sx1);
            srcHeight = Math.max(1, sy2 - sy1);
        }
        int rop = OS.GpiQueryMix(this.handle) == 4 ? 102 : 204;
        boolean fixStretch = rop == 204 && (srcWidth != destWidth || srcHeight != destHeight);
        int oldColor = 0;
        int oldPattern = 0;
        if (fixStretch) {
            oldColor = OS.GpiQueryColor(this.handle);
            OS.GpiSetColor(this.handle, -1);
            oldPattern = OS.GpiQueryPattern(this.handle);
            OS.GpiSetPattern(this.handle, 16);
            rop = 252;
        }
        OS.GpiSetDefaultViewMatrix(this.handle, 0, null, 0);
        srcY = imgHeight - (srcY + srcHeight);
        if (this.matrix[4] == -65536) {
            destY = this.matrix[7] + 1 - (destY + destHeight);
        }
        OS.GpiWCBitBlt(this.handle, srcImage.handle, 4, new int[]{destX, destY, destX + destWidth - 1, destY + destHeight - 1, srcX, srcY, srcX + srcWidth, srcY + srcHeight}, rop, 2);
        OS.GpiSetDefaultViewMatrix(this.handle, 9, this.matrix, 0);
        if (fixStretch) {
            OS.GpiSetColor(this.handle, oldColor);
            OS.GpiSetPattern(this.handle, oldPattern);
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        boolean geomLine = OS.GpiQueryLineWidthGeom(this.handle) != 1;
        int saved = -1;
        if (geomLine) {
            saved = this.beginGeomLine();
        }
        int[] pnt = new int[]{x1, y1};
        OS.GpiMove(this.handle, pnt);
        pnt[0] = x2;
        pnt[1] = y2;
        OS.GpiLine(this.handle, pnt);
        if (geomLine) {
            this.endGeomLine(saved);
        }
    }

    public void drawOval(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.drawArc(x, y, width, height, 0, 360);
    }

    public void drawPolygon(int[] pointArray) {
        int len;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if ((len = pointArray.length) < 2) {
            return;
        }
        boolean geomLine = OS.GpiQueryLineWidthGeom(this.handle) != 1;
        int saved = -1;
        if (geomLine) {
            saved = this.beginGeomLine();
        }
        int[] pnt = new int[]{pointArray[len - 2], pointArray[len - 1]};
        OS.GpiMove(this.handle, pnt);
        OS.GpiPolyLine(this.handle, len / 2, pointArray);
        if (geomLine) {
            this.endGeomLine(saved);
        }
    }

    public void drawPolyline(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        boolean geomLine = OS.GpiQueryLineWidthGeom(this.handle) != 1;
        int saved = -1;
        if (geomLine) {
            saved = this.beginGeomLine();
        }
        OS.GpiMove(this.handle, pointArray);
        OS.GpiPolyLine(this.handle, pointArray.length / 2, pointArray);
        if (geomLine) {
            this.endGeomLine(saved);
        }
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.drawRoundRectangle(x, y, width, height, 0, 0);
    }

    public void drawRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.drawRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        boolean geomLine = OS.GpiQueryLineWidthGeom(this.handle) != 1;
        int saved = -1;
        if (geomLine) {
            saved = this.beginGeomLine();
        }
        int[] pnt = new int[]{x, y};
        OS.GpiMove(this.handle, pnt);
        pnt[0] = pnt[0] + width;
        pnt[1] = pnt[1] + height;
        OS.GpiBox(this.handle, 2, pnt, arcWidth, arcHeight);
        if (geomLine) {
            this.endGeomLine(saved);
        }
    }

    public void drawString(String string, int x, int y) {
        this.drawString(string, x, y, false);
    }

    public void drawString(String string, int x, int y, boolean isTransparent) {
        int length;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if ((length = string.length()) == 0) {
            return;
        }
        byte[] text = string.getBytes();
        int[] pnts = new int[10];
        int[] pnt = new int[2];
        OS.GpiSetDefaultViewMatrix(this.handle, 0, null, 0);
        if (this.matrix[4] == -65536) {
            y = this.matrix[7] - y;
        }
        int backX = x;
        int is = 0;
        while (is < length) {
            int ie = is + 512;
            if (ie > length) {
                ie = length;
            }
            if (is != 0) {
                System.arraycopy(text, is, text, 0, ie - is);
            }
            OS.GpiQueryTextBox(this.handle, ie - is, text, 5, pnts);
            if (!isTransparent) {
                int maxX = pnts[4];
                if (maxX < pnts[8]) {
                    maxX = pnts[8];
                }
                pnt[0] = backX;
                pnt[1] = y - this.hFontMetrics.lMaxBaselineExt + 1;
                OS.GpiMove(this.handle, pnt);
                backX = x + maxX;
                pnt[0] = backX - 1;
                pnt[1] = y;
                OS.GpiBox(this.handle, 1, pnt, 0, 0);
            }
            int oldBackMix = OS.GpiQueryBackMix(this.handle);
            OS.GpiSetBackMix(this.handle, 5);
            pnt[0] = x;
            pnt[1] = y - (this.hFontMetrics.lMaxAscender - 1);
            OS.GpiCharStringAt(this.handle, pnt, ie - is, text);
            OS.GpiSetBackMix(this.handle, oldBackMix);
            x += pnts[8];
            is = ie;
        }
        OS.GpiSetDefaultViewMatrix(this.handle, 9, this.matrix, 0);
    }

    Point drawTabbedString(byte[] text, int start, int end, int x, int y, int flags, boolean simulate) {
        int[] pnts = new int[10];
        int[] pnt = new int[2];
        int height = this.hFontMetrics.lMaxBaselineExt;
        int py = y - (this.hFontMetrics.lMaxAscender - 1);
        int px = x;
        int backX = x;
        int mnemX = -1;
        byte mnemChar = 0;
        int is = start;
        while (is <= end) {
            int ie = is;
            while (!(ie >= end || (flags & 4) != 0 && text[ie] == 9 || (flags & 8) != 0 && text[ie] == 38 || ie >= is + 512)) {
                ++ie;
            }
            if (is != 0) {
                System.arraycopy(text, is, text, 0, ie - is);
            }
            if (ie > is) {
                OS.GpiQueryTextBox(this.handle, ie - is, text, 5, pnts);
                int maxX = pnts[4];
                if (maxX < pnts[8]) {
                    maxX = pnts[8];
                }
                if (!simulate) {
                    if ((flags & 1) == 0) {
                        OS.GpiSetBackMix(this.handle, 2);
                        pnt[0] = backX;
                        pnt[1] = y - height + 1;
                        OS.GpiMove(this.handle, pnt);
                        pnt[0] = px + maxX - 1;
                        pnt[1] = y;
                        OS.GpiBox(this.handle, 1, pnt, 0, 0);
                        OS.GpiSetBackMix(this.handle, 5);
                    }
                    pnt[0] = px;
                    pnt[1] = py;
                    OS.GpiCharStringAt(this.handle, pnt, ie - is, text);
                }
                backX = px + maxX;
                px += pnts[8];
            }
            if (ie < end) {
                if ((flags & 4) != 0 && text[ie] == 9) {
                    int tabWidth = this.hFontMetrics.lAveCharWidth * 8;
                    backX = px = x + ((px - x) / tabWidth + 1) * tabWidth;
                }
                if ((flags & 8) != 0 && text[ie] == 38) {
                    mnemX = px;
                    mnemChar = text[ie + 1];
                }
                if (ie == is + 256) {
                    --ie;
                }
            }
            is = ie + 1;
        }
        if (!simulate && mnemX >= 0 && mnemChar != 9) {
            OS.GpiQueryTextBox(this.handle, 1, new byte[]{mnemChar}, 5, pnts);
            int backColor = OS.GpiQueryBackColor(this.handle);
            OS.GpiSetBackColor(this.handle, OS.GpiQueryColor(this.handle));
            OS.GpiSetBackMix(this.handle, 2);
            pnt[0] = mnemX;
            pnt[1] = py - this.hFontMetrics.lUnderscorePosition - 1;
            OS.GpiMove(this.handle, pnt);
            pnt[0] = mnemX + pnts[8] - 1;
            pnt[1] = pnt[1] + (this.hFontMetrics.lUnderscoreSize - 1);
            OS.GpiBox(this.handle, 1, pnt, 0, 0);
            OS.GpiSetBackMix(this.handle, 5);
            OS.GpiSetBackColor(this.handle, backColor);
        }
        return new Point(backX - x, height);
    }

    Point drawTabbedText(String string, int x, int y, int flags, boolean simulate) {
        int length = string.length();
        byte[] text = string.getBytes();
        OS.GpiSetDefaultViewMatrix(this.handle, 0, null, 0);
        if (this.matrix[4] == -65536) {
            y = this.matrix[7] - y;
        }
        int oldBackMix = OS.GpiQueryBackMix(this.handle);
        OS.GpiSetBackMix(this.handle, 5);
        int is = 0;
        int maxWidth = 0;
        int totHeight = 0;
        if ((flags & 2) != 0) {
            while (is <= length) {
                int ie = is;
                while (ie < length && text[ie] != 10 && text[ie] != 13) {
                    ++ie;
                }
                Point pnt = this.drawTabbedString(text, is, ie, x, y, flags, simulate);
                if (simulate) {
                    totHeight += pnt.y;
                    if (pnt.x > maxWidth) {
                        maxWidth = pnt.x;
                    }
                } else {
                    y -= pnt.y;
                }
                if (ie < length - 1) {
                    if (text[ie] == 10) {
                        if (text[ie + 1] == 13) {
                            ++ie;
                        }
                    } else if (text[ie + 1] == 10) {
                        ++ie;
                    }
                }
                is = ++ie;
            }
        } else {
            Point pnt = this.drawTabbedString(text, 0, length, x, y, flags, simulate);
            maxWidth = pnt.x;
            totHeight = pnt.y;
        }
        OS.GpiSetBackMix(this.handle, oldBackMix);
        OS.GpiSetDefaultViewMatrix(this.handle, 9, this.matrix, 0);
        if (simulate) {
            return new Point(maxWidth, totHeight);
        }
        return null;
    }

    public void drawText(String string, int x, int y) {
        this.drawText(string, x, y, 6);
    }

    public void drawText(String string, int x, int y, boolean isTransparent) {
        int flags = 6;
        if (isTransparent) {
            flags |= 1;
        }
        this.drawText(string, x, y, flags);
    }

    public void drawText(String string, int x, int y, int flags) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        this.drawTabbedText(string, x, y, flags, false);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof GC && this.handle == ((GC)object).handle;
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int endAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (endAngle < 0) {
            startAngle += endAngle;
            endAngle = -endAngle;
        }
        if (width == 0 || height == 0 || endAngle == 0) {
            SWT.error(5);
        }
        int axr = --width / 2;
        int ayr = --height / 2;
        int[] arcparams = new int[]{axr, -ayr, 0, 0};
        OS.GpiSetArcParams(this.handle, arcparams);
        int xc = x + axr;
        int yc = y + ayr;
        int[] pnt = new int[]{xc, yc};
        OS.GpiBeginArea(this.handle, 0);
        int extX = width % 2;
        int extY = height % 2;
        if (extX != 0 || extY != 0) {
            int i = 0;
            while (i < 4) {
                int sa = i * 90;
                int ea = sa + 90;
                if (sa < startAngle) {
                    sa = startAngle;
                }
                if (ea > startAngle + endAngle) {
                    ea = startAngle + endAngle;
                }
                if (ea > sa) {
                    ea -= sa;
                    switch (i) {
                        case 0: {
                            pnt[0] = xc + extX;
                            pnt[1] = yc;
                            break;
                        }
                        case 1: {
                            pnt[0] = xc;
                            pnt[1] = yc;
                            break;
                        }
                        case 2: {
                            pnt[0] = xc;
                            pnt[1] = yc + extY;
                            break;
                        }
                        case 3: {
                            pnt[0] = xc + extX;
                            pnt[1] = yc + extY;
                        }
                    }
                    if (sa == startAngle) {
                        OS.GpiMove(this.handle, pnt);
                    }
                    OS.GpiPartialArc(this.handle, pnt, 65536, sa << 16, ea << 16);
                }
                ++i;
            }
        } else {
            OS.GpiMove(this.handle, pnt);
            OS.GpiPartialArc(this.handle, pnt, 65536, startAngle << 16, endAngle << 16);
        }
        OS.GpiEndArea(this.handle);
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width == 0 || height == 0) {
            return;
        }
        int fromColor = Color.pm_new((Device)this.data.device, (int)OS.GpiQueryColor((int)this.handle)).rgb;
        int toColor = Color.pm_new((Device)this.data.device, (int)OS.GpiQueryBackColor((int)this.handle)).rgb;
        boolean swapColors = false;
        if (width < 0) {
            x += width;
            width = -width;
            if (!vertical) {
                swapColors = true;
            }
        }
        if (height < 0) {
            y += height;
            height = -height;
            if (vertical) {
                swapColors = true;
            }
        }
        if (swapColors) {
            int t = fromColor;
            fromColor = toColor;
            toColor = t;
        }
        if (fromColor == toColor) {
            this.drawRoundRectangle(x, y, width, height, 0, 0);
            return;
        }
        RGB fromRGB = new RGB(fromColor >>> 16 & 0xFF, fromColor >>> 8 & 0xFF, fromColor & 0xFF);
        RGB toRGB = new RGB(toColor >>> 16 & 0xFF, toColor >>> 8 & 0xFF, toColor & 0xFF);
        int[] colorInfo = new int[2];
        OS.DevQueryCaps(this.data.hdc, 15, 2, colorInfo);
        int depth = colorInfo[0] * colorInfo[1];
        int bitResolution = depth >= 24 ? 8 : (depth >= 15 ? 5 : 0);
        ImageData.fillGradientRectangle(this, this.data.device, x, y, width, height, vertical, fromRGB, toRGB, bitResolution, bitResolution, bitResolution);
    }

    public void fillOval(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        this.fillArc(x, y, width, height, 0, 360);
    }

    public void fillPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        OS.GpiBeginArea(this.handle, 0);
        OS.GpiMove(this.handle, pointArray);
        OS.GpiPolyLine(this.handle, pointArray.length / 2, pointArray);
        OS.GpiEndArea(this.handle);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.fillRoundRectangle(x, y, width, height, 0, 0);
    }

    public void fillRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0) {
            return;
        }
        --width;
        --height;
        if (arcWidth == 0 || arcHeight == 0) {
            int[] pnt = new int[]{x, y};
            OS.GpiMove(this.handle, pnt);
            pnt[0] = pnt[0] + width;
            pnt[1] = pnt[1] + height;
            OS.GpiBox(this.handle, 1, pnt, 0, 0);
            return;
        }
        if (arcWidth < 0) {
            arcWidth = -arcWidth;
        }
        if (arcHeight < 0) {
            arcHeight = -arcHeight;
        }
        if (arcWidth > width + 1) {
            arcWidth = width + 1;
        }
        if (arcHeight > height + 1) {
            arcHeight = height + 1;
        }
        int axr = arcWidth / 2;
        int ayr = arcHeight / 2;
        int x1 = x + width;
        int y1 = y + width;
        if (axr == 0) {
            axr = 1;
        }
        if (ayr == 0) {
            ayr = 1;
        }
        int[] arcparams = new int[]{axr, -ayr, 0, 0};
        OS.GpiSetArcParams(this.handle, arcparams);
        OS.GpiBeginArea(this.handle, 0);
        int[] pnt = new int[]{x1, y + ayr};
        OS.GpiMove(this.handle, pnt);
        pnt[0] = x1 - axr;
        pnt[1] = y + ayr;
        OS.GpiPartialArc(this.handle, pnt, 65536, 0, 0x5A0000);
        pnt[0] = x + axr;
        OS.GpiPartialArc(this.handle, pnt, 65536, 0x5A0000, 0x5A0000);
        pnt[1] = y1 - ayr;
        OS.GpiPartialArc(this.handle, pnt, 65536, 0xB40000, 0x5A0000);
        pnt[0] = x1 - axr;
        OS.GpiPartialArc(this.handle, pnt, 65536, 0x10E0000, 0x5A0000);
        OS.GpiEndArea(this.handle);
    }

    public int getAdvanceWidth(char ch) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        byte[] text = new String(new char[]{ch}).getBytes();
        int[] pnts = new int[10];
        OS.GpiSetDefaultViewMatrix(this.handle, 0, null, 0);
        OS.GpiQueryTextBox(this.handle, 1, text, 5, pnts);
        OS.GpiSetDefaultViewMatrix(this.handle, 9, this.matrix, 0);
        return pnts[8];
    }

    public Color getBackground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int color = OS.GpiQueryBackColor(this.handle);
        return Color.pm_new(this.data.device, color);
    }

    public int getCharWidth(char ch) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        byte[] text = new String(new char[]{ch}).getBytes();
        int[] pnts = new int[10];
        OS.GpiSetDefaultViewMatrix(this.handle, 0, null, 0);
        OS.GpiQueryTextBox(this.handle, 1, text, 5, pnts);
        OS.GpiSetDefaultViewMatrix(this.handle, 9, this.matrix, 0);
        return pnts[4] - pnts[0];
    }

    public Rectangle getClipping() {
        RECTL rcl;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (OS.GpiQueryClipBox(this.handle, rcl = new RECTL()) == 1) {
            rcl.yTop = 0;
            rcl.yBottom = 0;
            rcl.xRight = 0;
            rcl.xLeft = 0;
        } else {
            ++rcl.xRight;
            ++rcl.yTop;
        }
        return new Rectangle(rcl.xLeft, rcl.yBottom, rcl.xRight - rcl.xLeft, rcl.yTop - rcl.yBottom);
    }

    public void getClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        int[] pHrgn = new int[1];
        OS.GpiSetClipRegion(this.handle, 0, pHrgn);
        int hrgn = pHrgn[0];
        if (hrgn != 0 && hrgn != -1) {
            if (this.matrix[4] == -65536) {
                RGNRECT rgnctl = new RGNRECT();
                rgnctl.ircStart = 1;
                rgnctl.ulDirection = 1;
                OS.GpiQueryRegionRects(this.handle, hrgn, null, rgnctl, null);
                int[] rgnRects = new int[rgnctl.crcReturned * 4];
                rgnctl.crc = rgnctl.crcReturned;
                OS.GpiQueryRegionRects(this.handle, hrgn, null, rgnctl, rgnRects);
                int height = this.matrix[7] + 1;
                int cnt = rgnRects.length / 4;
                int i = 0;
                while (i < cnt) {
                    int y = rgnRects[(i << 2) + 1];
                    rgnRects[(i << 2) + 1] = height - rgnRects[(i << 2) + 3];
                    rgnRects[(i << 2) + 3] = height - y;
                    ++i;
                }
                OS.GpiSetRegion(this.handle, region.handle, cnt, rgnRects);
            } else {
                OS.GpiCombineRegion(this.handle, region.handle, hrgn, 0, 2);
            }
            OS.GpiSetClipRegion(this.handle, hrgn, pHrgn);
            return;
        }
        RECTL rcl = new RECTL();
        int lCount = 0;
        int[] rcls = null;
        if (OS.GpiQueryClipBox(this.handle, rcl) != 1) {
            lCount = 1;
            rcls = new int[]{rcl.xLeft, rcl.yBottom, rcl.xRight + 1, rcl.yTop + 1};
        }
        OS.GpiSetRegion(this.handle, region.handle, lCount, rcls);
    }

    public Font getFont() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return Font.pm_new(this.data.device, this.hFont);
    }

    public FontMetrics getFontMetrics() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return FontMetrics.pm_new(this.hFontMetrics);
    }

    public Color getForeground() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int color = OS.GpiQueryColor(this.handle);
        return Color.pm_new(this.data.device, color);
    }

    public int getLineStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int type = OS.GpiQueryLineType(this.handle);
        switch (type) {
            case 7: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 6: {
                return 5;
            }
        }
        return 1;
    }

    public int getLineWidth() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return OS.GpiQueryLineWidthGeom(this.handle);
    }

    public boolean getXORMode() {
        int mix;
        if (this.handle == 0) {
            SWT.error(44);
        }
        return (mix = OS.GpiQueryMix(this.handle)) == 4;
    }

    void init(Drawable drawable, GCData data, int hps) {
        Image image = data.image;
        int hPalette = data.device.hPalette;
        if (data.doInit) {
            BITMAPINFOHEADER2 bm = null;
            int height = -1;
            if (image != null) {
                bm = new BITMAPINFOHEADER2();
                OS.GpiQueryBitmapInfoHeader(image.handle, bm);
                height = bm.cy;
            } else if (data.hwnd != 0) {
                RECTL rcl = new RECTL();
                OS.WinQueryWindowRect(data.hwnd, rcl);
                height = rcl.yTop;
            }
            if (height != -1) {
                this.matrix[4] = -65536;
                this.matrix[7] = height - 1;
                OS.GpiSetDefaultViewMatrix(hps, this.matrix.length, this.matrix, 0);
            }
            if (hPalette == 0) {
                OS.GpiCreateLogColorTable(hps, 0, 3, 0, 0, null);
            } else {
                OS.GpiSelectPalette(hps, hPalette);
            }
        } else {
            OS.GpiQueryDefaultViewMatrix(hps, this.matrix.length, this.matrix);
        }
        OS.GpiSetMix(hps, 2);
        OS.GpiSetBackMix(hps, 2);
        OS.GpiSetPattern(hps, 64);
        OS.GpiSetLineEnd(hps, 3);
        OS.GpiSetLineJoin(hps, 2);
        OS.GpiSetLineType(hps, 7);
        OS.GpiSetLineWidthGeom(hps, 1);
        int foreground = data.foreground;
        if (foreground == -3) {
            foreground = 0;
        }
        OS.GpiSetColor(hps, foreground);
        int background = data.background;
        if (background == -3) {
            background = 0xFFFFFF;
            if (hPalette != 0) {
                background = 15;
            }
        }
        OS.GpiSetBackColor(hps, background);
        if (image != null) {
            image.memGC = this;
            OS.GpiSetBitmap(hps, image.handle);
        } else if (data.hwnd != 0 && hPalette != 0) {
            int[] cclr = new int[1];
            OS.WinRealizePalette(data.hwnd, hps, cclr);
        }
        this.hFont = data.hFont == null ? data.device.sysFont : data.hFont;
        GC.internal_set_font(hps, data.hdc, data.device, this.hFont);
        this.hFontMetrics = new FONTMETRICS();
        OS.GpiQueryFontMetrics(hps, 228, this.hFontMetrics);
        this.drawable = drawable;
        this.data = data;
        this.handle = hps;
    }

    public int hashCode() {
        return this.handle;
    }

    public boolean isClipped() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        return OS.GpiQueryClipRegion(this.handle) > 0;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void setBackground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        int hColor = color.handle;
        int hPalette = this.data.device.hPalette;
        if (hPalette != 0 && !this.data.device.equals(color.device)) {
            SWT.error(5);
        }
        if (OS.GpiQueryBackColor(this.handle) == hColor) {
            return;
        }
        OS.GpiSetBackColor(this.handle, hColor);
    }

    public void setClipping(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.matrix[4] == -65536) {
            y = this.matrix[7] + 1 - (y + height);
        }
        int hrgn = OS.GpiCreateRegion(this.handle, 1, new int[]{x, y, x + width, y + height});
        int[] hrgnOld = new int[1];
        OS.GpiSetClipRegion(this.handle, hrgn, hrgnOld);
        if (hrgnOld[0] != 0) {
            OS.GpiDestroyRegion(this.handle, hrgnOld[0]);
        }
    }

    public void setClipping(Rectangle rect) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rect == null) {
            int[] hrgnOld = new int[1];
            OS.GpiSetClipRegion(this.handle, 0, hrgnOld);
            if (hrgnOld[0] != 0) {
                OS.GpiDestroyRegion(this.handle, hrgnOld[0]);
            }
            return;
        }
        this.setClipping(rect.x, rect.y, rect.width, rect.height);
    }

    public void setClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int hRegion = 0;
        if (region != null) {
            if (this.matrix[4] == -65536) {
                RGNRECT rgnctl = new RGNRECT();
                rgnctl.ircStart = 1;
                rgnctl.ulDirection = 1;
                OS.GpiQueryRegionRects(this.handle, region.handle, null, rgnctl, null);
                int[] rgnRects = new int[rgnctl.crcReturned * 4];
                rgnctl.crc = rgnctl.crcReturned;
                OS.GpiQueryRegionRects(this.handle, region.handle, null, rgnctl, rgnRects);
                int height = this.matrix[7] + 1;
                int cnt = rgnRects.length / 4;
                int i = 0;
                while (i < cnt) {
                    int y = rgnRects[(i << 2) + 1];
                    rgnRects[(i << 2) + 1] = height - rgnRects[(i << 2) + 3];
                    rgnRects[(i << 2) + 3] = height - y;
                    ++i;
                }
                hRegion = OS.GpiCreateRegion(this.handle, cnt, rgnRects);
            } else {
                hRegion = OS.GpiCreateRegion(this.handle, 0, null);
                OS.GpiCombineRegion(this.handle, hRegion, region.handle, 0, 2);
            }
        }
        int[] hrgnOld = new int[1];
        OS.GpiSetClipRegion(this.handle, hRegion, hrgnOld);
        if (hrgnOld[0] != 0) {
            OS.GpiDestroyRegion(this.handle, hrgnOld[0]);
        }
    }

    public static void internal_set_font(int hps, int hdc, Device device, FATTRS hFont) {
        short fsType = hFont.fsType;
        hFont.fsType = (short)(hFont.fsType & 0xFFC);
        hFont.usRecordLength = (short)56;
        OS.GpiCreateLogFont(hps, null, 1, hFont);
        hFont.fsType = fsType;
        OS.GpiSetCharSet(hps, 1);
        if ((hFont.fsFontUse & 4) != 0) {
            int height = hFont.height;
            if (height == 0) {
                height = device.defFontHeight;
            }
            int[] dpiInfo = new int[1];
            OS.DevQueryCaps(hdc, 38, 1, dpiInfo);
            int hPixels = Compatibility.round(height * dpiInfo[0], 72) << 16;
            OS.GpiSetCharBox(hps, new int[]{hPixels, hPixels});
        }
    }

    public void setFont(Font font) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        Device device = this.data.device;
        if (font == null) {
            device.checkFontCache();
            this.hFont = device.sysFont;
        } else {
            if (font.isDisposed()) {
                SWT.error(5);
            }
            this.hFont = font.internal_get_handle();
        }
        GC.internal_set_font(this.handle, this.data.hdc, this.data.device, this.hFont);
        OS.GpiQueryFontMetrics(this.handle, 228, this.hFontMetrics);
    }

    public void setForeground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        int hColor = color.handle;
        int hPalette = this.data.device.hPalette;
        if (hPalette != 0 && !this.data.device.equals(color.device)) {
            SWT.error(5);
        }
        if (OS.GpiQueryColor(this.handle) == hColor) {
            return;
        }
        OS.GpiSetColor(this.handle, hColor);
    }

    public void setLineStyle(int lineStyle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int style = -1;
        switch (lineStyle) {
            case 1: {
                style = 7;
                break;
            }
            case 2: {
                style = 5;
                break;
            }
            case 3: {
                style = 1;
                break;
            }
            case 4: {
                style = 3;
                break;
            }
            case 5: {
                style = 6;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        OS.GpiSetLineType(this.handle, style);
    }

    public void setLineWidth(int lineWidth) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        OS.GpiSetLineWidthGeom(this.handle, lineWidth);
    }

    public void setXORMode(boolean xor) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (xor) {
            OS.GpiSetMix(this.handle, 4);
            OS.GpiSetBackMix(this.handle, 4);
        } else {
            OS.GpiSetMix(this.handle, 2);
            OS.GpiSetBackMix(this.handle, 2);
        }
    }

    public Point stringExtent(String string) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return new Point(0, this.hFontMetrics.lMaxBaselineExt);
        }
        int length = string.length();
        byte[] text = string.getBytes();
        int[] pnts = new int[10];
        OS.GpiSetDefaultViewMatrix(this.handle, 0, null, 0);
        int extX = 0;
        int dx = 0;
        int is = 0;
        while (is < text.length) {
            int ie = is + 512;
            if (ie > text.length) {
                ie = text.length;
            }
            if (is != 0) {
                System.arraycopy(text, is, text, 0, ie - is);
            }
            OS.GpiQueryTextBox(this.handle, ie - is, text, 5, pnts);
            extX += pnts[8];
            dx = pnts[4];
            if (dx < pnts[8]) {
                dx = pnts[8];
            }
            dx -= pnts[8];
            is = ie;
        }
        OS.GpiSetDefaultViewMatrix(this.handle, 9, this.matrix, 0);
        return new Point(extX + dx, this.hFontMetrics.lMaxBaselineExt);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    public Point textExtent(String string, int flags) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        return this.drawTabbedText(string, 0, 0, flags, true);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }

    int beginGeomLine() {
        int pattern = OS.GpiQueryPattern(this.handle);
        OS.GpiBeginPath(this.handle, 1);
        OS.GpiSetPattern(this.handle, 16);
        return pattern;
    }

    void endGeomLine(int savedData) {
        OS.GpiEndPath(this.handle);
        OS.GpiStrokePath(this.handle, 1, 0);
        OS.GpiSetPattern(this.handle, savedData);
    }

    public static GC pm_new(Drawable drawable, GCData data) {
        GC gc = new GC();
        int hps = drawable.internal_new_GC(data);
        gc.init(drawable, data, hps);
        return gc;
    }
}

