/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.RECTL;

public final class Region {
    public int handle;
    int hps;

    public Region() {
        this.hps = OS.WinGetScreenPS(1);
        if (this.hps == 0) {
            SWT.error(2);
        }
        this.handle = OS.GpiCreateRegion(this.hps, 0, null);
        if (this.handle == 0) {
            SWT.error(2);
        }
    }

    Region(int handle) {
        this.handle = handle;
    }

    public void add(Rectangle rect) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        if (rect.width < 0 || rect.height < 0) {
            SWT.error(5);
        }
        int rectRgn = OS.GpiCreateRegion(this.hps, 1, new int[]{rect.x, rect.y, rect.x + rect.width, rect.y + rect.height});
        OS.GpiCombineRegion(this.hps, this.handle, this.handle, rectRgn, 1);
        OS.GpiDestroyRegion(this.hps, rectRgn);
    }

    public void add(Region region) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        OS.GpiCombineRegion(this.hps, this.handle, this.handle, region.handle, 1);
    }

    public boolean contains(int x, int y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.GpiPtInRegion(this.hps, this.handle, new int[]{x, y}) == 2;
    }

    public boolean contains(Point pt) {
        if (pt == null) {
            SWT.error(4);
        }
        return this.contains(pt.x, pt.y);
    }

    public void dispose() {
        if (this.handle != 0) {
            OS.GpiDestroyRegion(this.hps, this.handle);
            OS.WinReleasePS(this.hps);
        }
        this.handle = 0;
        this.hps = 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Region)) {
            return false;
        }
        Region rgn = (Region)object;
        return this.handle == rgn.handle;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        RECTL rcl = new RECTL();
        OS.GpiQueryRegionBox(this.hps, this.handle, rcl);
        return new Rectangle(rcl.xLeft, rcl.yBottom, rcl.xRight - rcl.xLeft, rcl.yTop - rcl.yBottom);
    }

    public int hashCode() {
        return this.handle;
    }

    public boolean intersects(int x, int y, int width, int height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        RECTL rcl = new RECTL();
        rcl.xLeft = x;
        rcl.yBottom = y;
        rcl.xRight = x + width;
        rcl.yTop = y + height;
        int result = OS.GpiRectInRegion(this.hps, this.handle, rcl);
        return result == 3 || result == 2;
    }

    public boolean intersects(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        return this.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public boolean isEmpty() {
        RECTL rcl;
        int result;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if ((result = OS.GpiQueryRegionBox(this.hps, this.handle, rcl = new RECTL())) == 1) {
            return true;
        }
        return rcl.xRight - rcl.xLeft <= 0 || rcl.yTop - rcl.yBottom <= 0;
    }

    public static Region pm_new(int handle) {
        return new Region(handle);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Region {*DISPOSED*}";
        }
        return "Region {" + this.handle + "}";
    }
}

