/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

public class Library {
    static int MAJOR_VERSION = 2;
    static int MINOR_VERSION = 49;
    static int REVISION = 0;

    public static int getVersion() {
        return MAJOR_VERSION * 1000 + MINOR_VERSION;
    }

    static String getPlatform() {
        String[] names = new String[]{"motif", "gtk", "win32", "pm", "photon", "carbon"};
        int i = 0;
        while (i < names.length) {
            try {
                Class.forName("org.eclipse.swt.internal." + names[i] + ".OS");
                return names[i];
            }
            catch (ClassNotFoundException classNotFoundException) {
                ++i;
            }
        }
        return "unknown";
    }

    public static int getRevision() {
        return REVISION;
    }

    public static void loadLibrary(String name) {
        String platform = Library.getPlatform();
        String version = System.getProperty("swt.version");
        if (version == null) {
            version = "" + MAJOR_VERSION;
            if (MINOR_VERSION < 10) {
                version = version + "00";
            } else if (MINOR_VERSION < 100) {
                version = version + "0";
            }
            version = version + MINOR_VERSION;
            if (platform != "pm" && REVISION > 0) {
                version = version + "r" + REVISION;
            }
        }
        try {
            String newName = platform == "pm" ? name + "p" + version : name + "-" + platform + "-" + version;
            System.loadLibrary(newName);
            return;
        }
        catch (UnsatisfiedLinkError e1) {
            try {
                String newName = name + "-" + platform;
                System.loadLibrary(newName);
                return;
            }
            catch (UnsatisfiedLinkError e2) {
                throw e1;
            }
        }
    }
}

