/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.pm.CLASSINFO;
import org.eclipse.swt.internal.pm.FONTMETRICS;
import org.eclipse.swt.internal.pm.MRESULT;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.PSZ;
import org.eclipse.swt.internal.pm.RECTL;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Combo
extends Composite {
    short textLimit = (short)32;
    static final int ComboProc;
    static final PSZ ComboClass;

    public Combo(Composite parent, int style) {
        super(parent, Combo.checkStyle(style));
    }

    public void add(String string) {
        PSZ buffer;
        int result;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((result = OS.WinSendMsg(this.handle, 353, -2, buffer = new PSZ(string))) == -2) {
            this.error(14);
        }
        if (result == -3) {
            this.error(14);
        }
    }

    public void add(String string, int index) {
        PSZ buffer;
        int result;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (index == -1) {
            this.error(6);
        }
        if ((result = OS.WinSendMsg(this.handle, 353, index, buffer = new PSZ(string))) == -2) {
            this.error(14);
        }
        if (result == -3) {
            int count = OS.WinSendMsg(this.handle, 352, 0, 0);
            if (0 <= index && index <= count) {
                this.error(14);
            } else {
                this.error(6);
            }
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int msg, int mp1, int mp2) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.WinCallWindowProc(ComboProc, this.handle, msg, mp1, mp2);
    }

    static int checkStyle(int style) {
        style &= 0xFFFFF7FF;
        style &= 0xFFFFFCFF;
        if (((style = Widget.checkBits(style, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return style & 0xFFFFFFF7;
        }
        return style;
    }

    public void clearSelection() {
        this.checkWidget();
        OS.WinSendMsg(this.handle, 322, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int hps;
        this.checkWidget();
        int count = OS.WinSendMsg(this.handle, 352, 0, 0);
        int itemHeight = this.getItemHeight();
        int width = 0;
        int height = 0;
        if ((this.style & 0x40) != 0) {
            height = count * itemHeight;
        }
        if ((hps = this.hps) == 0) {
            hps = OS.WinGetPS(this.handle);
        }
        PSZ buffer = new PSZ(65);
        int[] pnts = new int[10];
        int i = 0;
        while (i < count) {
            int length = OS.WinSendMsg(this.handle, 359, (int)((short)i), 0);
            if (length != -3) {
                int result;
                if (length + 1 > buffer.length()) {
                    buffer = new PSZ(length + 1);
                }
                if ((result = OS.WinSendMsg(this.handle, 360, OS.MPFROM2SHORT((short)i, (short)length), buffer)) != 0) {
                    OS.GpiQueryTextBox(hps, length, buffer.getBytes(), 5, pnts);
                    width = Math.max(width, pnts[4] - pnts[0]);
                }
            }
            ++i;
        }
        if (this.hps == 0) {
            OS.WinReleasePS(hps);
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int textHeight = this.getItemHeight();
        height = (this.style & 4) != 0 ? textHeight + 6 : (height += textHeight + 10);
        return new Point(width += OS.WinQuerySysValue(1, 22) + 8, height);
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFEFFF;
    }

    int defaultBackground() {
        return OS.WinQuerySysColor(this.handle, -47, 0);
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index == -1) {
            return;
        }
        int oldIndex = OS.WinSendMsg(this.handle, 357, 0, 0);
        if (oldIndex == -1) {
            return;
        }
        if (oldIndex == index) {
            OS.WinSendMsg(this.handle, 356, index, 0);
        }
        this.sendEvent(24);
    }

    public void deselectAll() {
        this.checkWidget();
        int count = OS.WinSendMsg(this.handle, 352, 0, 0);
        int index = 0;
        int i = 0;
        while (i < count) {
            index = OS.WinSendMsg(this.handle, 357, index, 0);
            OS.WinSendMsg(this.handle, 356, index, 0);
            ++i;
        }
        this.sendEvent(24);
    }

    boolean getEditable() {
        int bits = OS.WinQueryWindowULong(this.handle, -2);
        return (bits & 4) == 0;
    }

    public String getItem(int index) {
        this.checkWidget();
        int length = OS.WinSendMsg(this.handle, 359, (int)((short)index), 0);
        if (length != -3) {
            PSZ buffer = new PSZ(length + 1);
            int result = OS.WinSendMsg(this.handle, 360, OS.MPFROM2SHORT((short)index, (short)length), buffer);
            if (result != 0) {
                return buffer.toString();
            }
        }
        int count = OS.WinSendMsg(this.handle, 352, 0, 0);
        if (0 <= index && index < count) {
            this.error(8);
        } else {
            this.error(6);
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        int result = OS.WinSendMsg(this.handle, 352, 0, 0);
        if (result == -3) {
            this.error(36);
        }
        return result;
    }

    public int getItemHeight() {
        this.checkWidget();
        int hps = this.hps;
        if (hps == 0) {
            hps = OS.WinGetPS(this.handle);
        }
        FONTMETRICS fm = new FONTMETRICS();
        OS.GpiQueryFontMetrics(hps, 228, fm);
        int result = fm.lMaxBaselineExt;
        if (this.hps == 0) {
            OS.WinReleasePS(hps);
        }
        return result;
    }

    public String[] getItems() {
        this.checkWidget();
        int count = this.getItemCount();
        String[] result = new String[count];
        int i = 0;
        while (i < count) {
            result[i] = this.getItem(i);
            ++i;
        }
        return result;
    }

    String getNameText() {
        return this.getText();
    }

    public Point getSelection() {
        int pos = 0;
        pos = OS.WinSendMsg(this.handle, 321, 0, 0);
        return new Point(OS.SHORT1FROMMP(pos), OS.SHORT2FROMMP(pos));
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int index = OS.WinSendMsg(this.handle, 357, -1, 0);
        if (index == -1) {
            return -1;
        }
        return index;
    }

    public String getText() {
        this.checkWidget();
        int index = OS.WinSendMsg(this.handle, 357, -4, 0);
        int length = OS.WinSendMsg(this.handle, 359, (int)((short)index), 0);
        if (length == 0) {
            return "";
        }
        PSZ buffer = new PSZ(length);
        OS.WinSendMsg(this.handle, 360, OS.MPFROM2SHORT((short)index, (short)length), buffer);
        return buffer.toString();
    }

    String getText(int start, int stop) {
        return this.getText().substring(start, stop - 1);
    }

    public int getTextHeight() {
        this.checkWidget();
        int hps = this.hps;
        if (hps == 0) {
            hps = OS.WinGetPS(this.handle);
        }
        FONTMETRICS fm = new FONTMETRICS();
        OS.GpiQueryFontMetrics(hps, 228, fm);
        int result = fm.lMaxBaselineExt;
        if (this.hps == 0) {
            OS.WinReleasePS(hps);
        }
        return result + 6;
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    boolean hasFocus() {
        int hwndFocus = OS.WinQueryFocus(1);
        if (hwndFocus == this.handle) {
            return true;
        }
        if (hwndFocus == 0) {
            return false;
        }
        int hwndText = OS.WinWindowFromID(this.handle, 667);
        if (hwndFocus == hwndText) {
            return true;
        }
        int hwndList = OS.WinWindowFromID(this.handle, 666);
        return hwndFocus == hwndList;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.length() == 0) {
            int count = this.getItemCount();
            int i = start;
            while (i < count) {
                if (string.equals(this.getItem(i))) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        int count = OS.WinSendMsg(this.handle, 352, 0, 0);
        if (0 > start || start >= count) {
            return -1;
        }
        int index = start - 1;
        PSZ buffer = new PSZ(string);
        if ((index = OS.WinSendMsg(this.handle, 363, OS.MPFROM2SHORT((short)4, (short)index), buffer)) == -3 || index < start) {
            return -1;
        }
        return index;
    }

    public void remove(int index) {
        int leftCount;
        this.checkWidget();
        int length = OS.WinSendMsg(this.handle, 359, (int)((short)index), 0);
        if (length == -3) {
            this.error(15);
        }
        int count = OS.WinSendMsg(this.handle, 352, 0, 0);
        if (index < 0 || index > count) {
            this.error(6);
        }
        if ((leftCount = OS.WinSendMsg(this.handle, 355, (int)((short)index), 0)) == count) {
            this.error(15);
        }
        this.sendEvent(24);
        if (this.isDisposed()) {
            return;
        }
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        int count = OS.WinSendMsg(this.handle, 352, 0, 0);
        int topIndex = OS.WinSendMsg(this.handle, 365, 0, 0);
        int index = start;
        while (index <= end) {
            int result;
            PSZ buffer = null;
            if ((this.style & 0x100) != 0) {
                int length = OS.WinSendMsg(this.handle, 359, (int)((short)start), 0);
                if (length == -3) break;
                buffer = new PSZ(length + 1);
                int result2 = OS.WinSendMsg(this.handle, 360, OS.MPFROM2SHORT((short)start, (short)length), buffer);
                if (result2 <= 0) break;
            }
            if ((result = OS.WinSendMsg(this.handle, 355, (int)((short)start), 0)) <= 0) break;
            ++index;
        }
        if (end < topIndex) {
            OS.WinSendMsg(this.handle, 354, (int)((short)(topIndex -= end - start + 1)), 0);
        }
        if (index <= end) {
            if (0 <= index && index < count) {
                this.error(15);
            }
            this.error(6);
        }
    }

    public void remove(String string) {
        int index = this.indexOf(string, 0);
        if (index == -1) {
            this.error(5);
        }
        this.remove(index);
    }

    public void removeAll() {
        this.checkWidget();
        OS.WinSendMsg(this.handle, 366, 0, 0);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index == -1) {
            return;
        }
        int count = OS.WinSendMsg(this.handle, 352, 0, 0);
        if (0 <= index && index < count) {
            int selection = OS.WinSendMsg(this.handle, 357, -4, 0);
            int rc = OS.WinSendMsg(this.handle, 356, (int)((short)index), 1);
            if (rc != 0 && rc != selection) {
                this.sendEvent(24);
            }
        }
    }

    void setBounds(int x, int y, int width, int height, int flags) {
        if ((this.style & 4) != 0) {
            int textHeight = this.getTextHeight();
            super.setBounds(x, y, width, textHeight + textHeight * 5 + 2, flags);
            return;
        }
        int hps = OS.WinGetPS(this.handle);
        RECTL rcl = new RECTL();
        OS.WinQueryWindowRect(this.handle, rcl);
        OS.WinBeginPaint(this.handle, hps, rcl);
        super.setBounds(x, y, width, height, flags);
        OS.WinReleasePS(hps);
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.remove(index);
        if (this.isDisposed()) {
            return;
        }
        this.add(string, index);
    }

    public void setItems(String[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        OS.WinSendMsg(this.handle, 366, 0, 0);
        PSZ[] items2 = new PSZ[items.length];
        int i = 0;
        while (i < items.length) {
            OS.WinSendMsg(this.handle, 353, -1, new PSZ(items[i]));
            ++i;
        }
    }

    private void setSelection(int start, int end) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            OS.WinSendMsg(this.handle, 458, start, end);
        } else {
            OS.WinSendMsg(this.handle, 322, OS.MPFROM2SHORT((short)start, (short)end), 0);
        }
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            this.error(4);
        }
        this.setSelection(selection.x, selection.y);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int index = this.indexOf(string);
            if (index != -1) {
                this.select(index);
            }
            return;
        }
        PSZ buffer = new PSZ(string);
        if (OS.WinSetWindowText(this.handle, buffer)) {
            this.sendEvent(24);
        }
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        OS.WinSendMsg(this.handle, 323, limit, 0);
        this.textLimit = (short)limit;
    }

    int widgetStyle() {
        int bits = super.widgetStyle() | Integer.MIN_VALUE;
        if ((this.style & 0x40) != 0) {
            return bits | 1;
        }
        if ((this.style & 8) != 0) {
            return bits | 4;
        }
        return bits | 2;
    }

    PSZ windowClass() {
        return ComboClass;
    }

    int windowProc() {
        return ComboProc;
    }

    MRESULT WM_CHAR(int mp1, int mp2) {
        MRESULT result = super.WM_CHAR(mp1, mp2);
        if (result != null) {
            return result;
        }
        if (OS.SHORT2FROMMP(mp2) == 30 || OS.SHORT2FROMMP(mp2) == 8) {
            this.postEvent(14);
        }
        return result;
    }

    MRESULT wmControlChild(int mp1, int mp2) {
        int code = mp1 >> 16;
        switch (code) {
            case 1: {
                this.sendEvent(24);
                if (!this.isDisposed()) break;
                return MRESULT.ZERO;
            }
            case 4: {
                if (this.isDisposed()) {
                    return MRESULT.ZERO;
                }
                this.postEvent(13);
                break;
            }
            case 2: 
            case 3: {
                this.sendEvent(code == 2 ? 15 : 16);
                if (!this.isDisposed()) break;
                return MRESULT.ZERO;
            }
        }
        return super.wmControlChild(mp1, mp2);
    }

    static {
        ComboClass = PSZ.getAtom(-65534);
        CLASSINFO pclsiClassInfo = new CLASSINFO();
        OS.WinQueryClassInfo(0, ComboClass, pclsiClassInfo);
        ComboProc = pclsiClassInfo.pfnWindowProc;
    }
}

