/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.pm.FILEDLG;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.PSZ;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String[] fileNames = new String[0];
    String filterPath = "";
    String fileName = "";
    String fullPath = "";
    static final String FILTER = "*";

    public FileDialog(Shell parent) {
        this(parent, 32768);
    }

    public FileDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String open() {
        boolean save;
        int hwndOwner = 1;
        if (this.parent != null) {
            hwndOwner = this.parent.handle;
        }
        if (this.title == null) {
            this.title = "";
        }
        if (this.filterPath == null) {
            this.filterPath = "";
        }
        String strFilter = "";
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        int i = 0;
        while (i < this.filterExtensions.length) {
            String filterName = this.filterExtensions[i];
            if (i < this.filterNames.length) {
                filterName = this.filterNames[i];
            }
            strFilter = strFilter + filterName + '\u0000' + this.filterExtensions[i] + '\u0000';
            ++i;
        }
        if (this.filterExtensions.length == 0) {
            strFilter = strFilter + FILTER + '\u0000' + FILTER + '\u0000';
        }
        FILEDLG fileDlg = new FILEDLG();
        fileDlg.ulUser = 0;
        fileDlg.lReturn = 0;
        fileDlg.lSRC = 0;
        fileDlg.pfnDlgProc = 0;
        fileDlg.pszIType = null;
        fileDlg.papszITypeList = null;
        fileDlg.pszIDrive = null;
        fileDlg.papszIDriveList = null;
        fileDlg.hMod = 0;
        fileDlg.papszFQFilename = null;
        fileDlg.ulFQFCount = 0;
        fileDlg.usDlgId = 0;
        fileDlg.x = 0;
        fileDlg.y = 0;
        fileDlg.sEAType = 0;
        fileDlg.fl = 33;
        if ((this.style & 2) != 0) {
            fileDlg.fl |= 0x400;
        }
        fileDlg.pszTitle = new PSZ(this.title);
        if (this.fileName == null) {
            this.fileName = "";
        }
        if (this.fileName != null && this.fileName.length() > 0) {
            System.arraycopy(this.fileName.getBytes(), 0, fileDlg.szFullFile, 0, this.fileName.getBytes().length);
        } else {
            System.arraycopy(strFilter.getBytes(), 0, fileDlg.szFullFile, 0, strFilter.getBytes().length);
        }
        boolean bl = save = (this.style & 0x2000) != 0;
        if (save) {
            fileDlg.pszOKButton = new PSZ("Save");
            fileDlg.fl |= 0xA00;
        } else {
            fileDlg.pszOKButton = new PSZ("Open");
            fileDlg.fl |= 0x100;
        }
        boolean success = OS.WinFileDlg(1, hwndOwner, fileDlg);
        if (fileDlg.lSRC == 6) {
            fileDlg.lSRC = 0;
            System.arraycopy(new String("").getBytes(), 0, fileDlg.szFullFile, 0, 1);
            success = OS.WinFileDlg(1, hwndOwner, fileDlg);
        }
        if (fileDlg.lReturn == 65535) {
            success = false;
        }
        this.fullPath = null;
        if (success) {
            int i2;
            String[] bufferArray;
            String separator = System.getProperty("file.separator");
            if ((this.style & 2) == 0) {
                bufferArray = new String[]{new String(fileDlg.szFullFile)};
            } else {
                bufferArray = new String[fileDlg.ulFQFCount];
                i2 = 0;
                while (i2 < fileDlg.ulFQFCount) {
                    if (fileDlg.papszFQFilename[i2] != null) {
                        bufferArray[i2] = fileDlg.papszFQFilename[i2].toString();
                        System.out.println("FILE = " + bufferArray[i2]);
                    }
                    ++i2;
                }
            }
            String buffer = new String(fileDlg.szFullFile);
            this.filterPath = buffer.substring(0, buffer.lastIndexOf(separator));
            this.fileName = buffer.substring(buffer.lastIndexOf(separator), buffer.length());
            this.fileNames = new String[bufferArray.length];
            try {
                i2 = 0;
                while (i2 < bufferArray.length) {
                    this.fileNames[i2] = new String(bufferArray[i2].substring(bufferArray[i2].lastIndexOf(separator) + 1, bufferArray[i2].length()));
                    ++i2;
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                System.err.flush();
            }
            this.fullPath = this.filterPath + this.fileName;
        }
        return this.fullPath;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] extensions) {
        this.filterExtensions = extensions;
    }

    public void setFilterNames(String[] names) {
        this.filterNames = names;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }
}

