/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.pm.FONTDLG;
import org.eclipse.swt.internal.pm.OS;
import org.eclipse.swt.internal.pm.PSZ;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;

    public FontDialog(Shell parent) {
        this(parent, 32768);
    }

    public FontDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData open() {
        int hps;
        int hwndOwner = 0;
        if (this.parent != null) {
            hwndOwner = this.parent.handle;
        }
        FONTDLG fontDlg = new FONTDLG();
        fontDlg.hpsScreen = hps = OS.WinGetPS(hwndOwner);
        fontDlg.cbSize = 168;
        fontDlg.fl = 1;
        fontDlg.usFamilyBufLen = (short)32;
        byte[] szCurrentFont = new byte[32];
        if (this.fontData != null) {
            fontDlg.fl |= 0x80;
            byte[] buffer = this.fontData.getName().getBytes();
            int i = 0;
            while (i < buffer.length && i < szCurrentFont.length) {
                szCurrentFont[i] = buffer[i];
                ++i;
            }
            fontDlg.fAttrs = this.fontData.getFAttrs();
        } else {
            szCurrentFont[0] = 32;
        }
        fontDlg.pszFamilyname = new PSZ(szCurrentFont);
        fontDlg.clrFore = -1;
        fontDlg.clrBack = -2;
        fontDlg.pszTitle = new PSZ("Fonts");
        fontDlg.pszPreview = new PSZ("Eclipse/2");
        int rc = OS.WinFontDlg(1, hwndOwner, fontDlg);
        if (fontDlg.lReturn == 1) {
            fontDlg.fAttrs.height = fontDlg.fxPointSize;
            fontDlg.fAttrs.fm_szFamilyname = fontDlg.pszFamilyname.toString();
            fontDlg.fAttrs.fm_usWeightClass = fontDlg.usWeight;
            fontDlg.fAttrs.fm_fsSelection = (short)fontDlg.flType;
            this.fontData = FontData.pm_new(fontDlg.fAttrs);
            return this.fontData;
        }
        OS.WinReleasePS(hps);
        return null;
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }
}

