/* RXOWIRE.CMD */
/* Written by Lone Peak Automation */

/* Load RXEXIF.DLL */
CALL RXFuncAdd 'rxOWireLoadFuncs', 'RXOWIRE', 'rxOWireLoadFuncs'
CALL rxOWireLoadFuncs

SAY ''
SAY '--- Sample REXX Program for accessing 1-Wire data. ---'
SAY '    The RS-232 based DS9097U interface is required'
SAY '    to read temperature from a DS1820 sensor.'
SAY '    See www.maxim-ic.com for details on 1-Wire devices.'
SAY ''

rc = rxOWireDllVersion()
SAY "rxOWire.DLL version is: " || rc

rc = rxOWireOpen(0)  /* 0=COM1, 1=COM2... */
SAY "Port open (1=ok, 10=invalid com port, 11=no DS9097U Detected) rc = : " || rc

IF rc = 1 THEN
  DO
   
   SAY 'rxOWire find all:'
   rc = rxOWireFindAll()
   SAY 'Devices found: ' || rc

   SAY 'Time = ' || TIME('E')
   rc = rxOWireGetTemp()  
   SAY 'Elapsed time = ' || TIME('R')
   SAY 'Get Temperature: ' || rc
   SAY "Get Temp (ok = 10 byte hex string, 10=no DS1820 found)"

   IF LENGTH(rc) > 4 THEN
     DO
       RawTemp = X2D(SUBSTR(rc, 3, 2))
       CurrTemp = FORMAT(RawTemp / 2, 3, 2)
       SAY 'Temperature in degrees Celsius = ' || CurrTemp
     END

   rc = rxOWireClose()
   SAY "Port close (1=ok, 20=close err) rc = : " || rc
  END

SAY 'rxOWire test complete.'
CALL rxOWireDROPFuncs
SAY 'rxOWire.DLL dropped.'

EXIT
