/*******************************************************************
 * test.c                                                          *
 *******************************************************************
 * A test app to use the driver2 sample.                           *
 *******************************************************************
 * Warpstock Europe 1999                                           *
 * PDD workshop                                                    *
 *******************************************************************
 * Frank Meilinger                                                 *
 * Hirtesemuehle 1                                                 *
 * 65529 Waldems-Esch                                              *
 * e-mail: meilinger@wiesbaden.netsurf.de                          *
 * web: http://rover.wiesbaden.netsurf.de/~meile                   *
 *******************************************************************/

#define INCL_DOSFILEMGR
#define INCL_DOSDEVICES
#define INCL_DOSDEVIOCTL
#include <os2.h>
#include <stdio.h>

int main(int argc, char *argv[])
{
 APIRET ret;
 HFILE Hf;
 ULONG pulAction;
 UCHAR buffer[256];
 ULONG numBytes;
 ULONG dataLen;

 char *p;

 puts("\nWarpstock Europe 1999 !!!");
 puts("DRIVER2$ test application for driving the printer port\n");
 printf("open device: ");
 ret = DosOpen("DRIVER2$",
                &Hf,
                &pulAction,
                0,
                FILE_NORMAL,
                OPEN_ACTION_OPEN_IF_EXISTS | OPEN_ACTION_CREATE_IF_NEW,
                OPEN_SHARE_DENYNONE | OPEN_ACCESS_READWRITE | OPEN_FLAGS_FAIL_ON_ERROR,
                0);
 if(ret)
 {
  puts("error!\n");
  return 1;
 }
 else
  puts("ok\n");

 puts("commands: r    -> read byte from 0x379 in hex notation");
 puts("          b    -> blocking read, until bit5=0 at port 0x379");
 puts("          1    -> write byte 0xff to 0x378");
 puts("          0    -> write byte 0x00 to 0x378");
 puts("          q    -> quit\n");

 while(1)
 {
  printf("\ncommand: ");
  fflush(stdout);
  p = gets(buffer);

  if( (p==NULL) || (p[0]=='q') )
   break;

  if(p[0] == 'r')
  {
   ret = DosRead(Hf,buffer,1,&numBytes);
   if(ret != 0)
    puts("echo read: error!");
   else
    printf("echo read: %x\n",(USHORT)(buffer[0]));
   continue;
  }

  if(p[0] == 'b')
  {
   ret = DosDevIOCtl(Hf,0x80,0x60,NULL,0,0,buffer,1,&dataLen);
   if(ret != 0)
    printf("echo read: error %x!",ret);
   else
    printf("echo read: %x\n",(USHORT)(buffer[0]));
   continue;
  }

  if(p[0] == '1')
  {
   buffer[0] = 0xff;
   ret = DosWrite(Hf,(PVOID)buffer,1,&numBytes);
   if(ret != 0)
    puts("echo write 0xff: error!");
   else
    printf("echo write 0xff: %x\n",(USHORT)(buffer[0]));
   continue;
  }

  if(p[0] == '0')
  {
   buffer[0] = 0x00;
   ret = DosWrite(Hf,(PVOID)buffer,1,&numBytes);
   if(ret != 0)
    puts("echo write 0x00: error!");
   else
    printf("echo write 0x00: %x\n",(USHORT)(buffer[0]));
   continue;
  }
 }

 puts("echo quit!\n");

 printf("close device: ");
 ret = DosClose(Hf);
 if(ret)
 {
  puts("error!\n");
  return 1;
 }
 else
  puts("ok\n");

 return 0;
}

