/*
 * stub.c -- Sample stub file that calls the routines to load and
 *           start VX-REXX...  This mimics the PMEXE.EXE that came
 *           with VX-REXX 2.0.
 *
 *   What it does:  First it calls PMExeLoadDLL to load the VX-REXX
 *                  runtime library.  It prints an error message if
 *                  it can't find it.  Then it call PMExeVersion to
 *                  get the version number.  It asks the user if he/she
 *                  wants to continue if the version number is less
 *                  than 200 (corresponds to VX-REXX 2.0).  If so,
 *                  it then calls PMExeRun to start the program....
 */

#include <stddef.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#define INCL_DOS

#include <os2.h>
#include "pmexe.h"

#define MAX_PATH 300

static BOOL ShowMessage( char *msg, BOOL askyesno );

/*
 * main -- The C runtime entry point, as usual...
 */

int main( int argc, char *argv[] )
  {
    HMODULE module;
    ULONG   version;

    /* Load the DLL... */

    module = PMExeLoadDLL();
    if( !module ){
        ShowMessage( "Could not find VROBJ.DLL.  Please ensure it is in the LIBPATH.",
                     FALSE );
        goto done;
    }

    /* Check the version... */

    version = PMExeVersion();
    if( version < 200 ){
        if( !ShowMessage( "This program requires VX-REXX version 2.0 or "
                          "higher to run.  Do you want to try running it "
                          "anyhow?", TRUE ) ){
            goto done;
        }
    }

    /* Run it... */

    PMExeRun( argc, argv );

  done:
    return( 0 );
  }

/*
 * ShowMessage -- Create a message queue and put up a message
 *                box....
 */

static BOOL ShowMessage( char *str, BOOL askyesno )
  {
    HAB     hab;
    HMQ     hmq;
    PPIB    pib;
    PTIB    tib;
    PSZ     title;
    USHORT  retcode;
    char    path[ MAX_PATH + 1 ];

    hab = WinInitialize( 0 );
    hmq = WinCreateMsgQueue( hab, 0 );

    WinCancelShutdown( hmq, TRUE );

    DosGetInfoBlocks( &tib, &pib );
    DosQueryModuleName( pib->pib_hmte, MAX_PATH, path );

    if( strlen( path ) > 0 ){
        title = path + strlen( path );
        while( *(title-1) != '\\' ){
            --title;
        }
    } else {
        title = "VX-REXX Application";
    }

    retcode =  WinMessageBox( HWND_DESKTOP, HWND_DESKTOP, str, title, 0,
                    askyesno ? (MB_QUERY|MB_YESNO) : (MB_ERROR|MB_OK) );

    WinDestroyMsgQueue( hmq );
    WinTerminate( hab );

    return( retcode );
  }
