/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end; else do
        call VROptions 'ImplicitNames'
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    call Init
    signal on halt
    do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
        _VREEvent = VREvent()
        interpret _VREEvent
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary:
    __vrlsWait = abbrev( 'WAIT', translate(arg(2)), 1 )
    if __vrlsWait then do
        call VRFlush
    end
    __vrlsHWnd = VRLoad( VRWindow(), VRWindowPath(), arg(1) )
    if __vrlsHWnd = '' then signal __vrlsDone
    if __vrlsWait \= 1 then signal __vrlsDone
    call VRSet __vrlsHWnd, 'WindowMode', 'Modal' 
    __vrlsTmp = __vrlsWindows.0
    if( DataType(__vrlsTmp) \= 'NUM' ) then do
        __vrlsTmp = 1
    end
    else do
        __vrlsTmp = __vrlsTmp + 1
    end
    __vrlsWindows.__vrlsTmp = VRWindow( __vrlsHWnd )
    __vrlsWindows.0 = __vrlsTmp
    do while( VRIsValidObject( VRWindow() ) = 1 )
        __vrlsEvent = VREvent()
        interpret __vrlsEvent
    end
    __vrlsTmp = __vrlsWindows.0
    __vrlsWindows.0 = __vrlsTmp - 1
    call VRWindow __vrlsWindows.__vrlsTmp 
    __vrlsHWnd = ''
__vrlsDone:
return __vrlsHWnd

/*:VRX         Fini
*/
Fini:
    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0

/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    /*  Load the OS/2 utilities such as SysSleep
    */
    call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
    call SysLoadFuncs

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window
return

/*:VRX         PB_1_Click
*/
PB_1_Click: procedure
    "start" VRIniDir()"\e.exe"
return

/*:VRX         PB_2_Click
*/
PB_2_Click: procedure

    /*  SysCreateObject( Class, Name, Location, Setup, Option ) */

    

    ok = SysCreateObject( "WPProgram",,
            "E.EXE",,
            "<WP_NOWHERE>",,
            "EXENAME=" || VRIniDir()"\e.exe;"||,
            "OPEN=DEFAULT",,
            "r" )

return

/*:VRX         PB_3_Click
*/
PB_3_Click: procedure

    sHeight = VRGet( "Screen", "Height" )
    sWidth = VRGet( "Screen", "Width" )

    height = trunc( 3 * sHeight / 4  )
    width = trunc( 3 * sWidth / 4  )

    hWnd = VRMethod( "Screen", "FindWindow", "E.EXE", "Desktop" )

    if hwnd="" then do
        id = VRMessage( VRWindow(), "E.EXE Window not found!", "Not Found", "Error", , ,  )
    end; else do
        call VRSet hWnd, "Left", 0, "Top", 0,,
                     "Height", height, "Width", width
    end
return

/*:VRX         PB_4_Click
*/
PB_4_Click: procedure
    hWnd = VRMethod( "Screen", "FindWindow", "E.EXE", "Desktop" )

    if hwnd="" then do
                id = VRMessage( VRWindow(), "E.EXE Window not found!", "Not Found", "Error", , ,  )
    end
    else do
        call VRMethod hWnd, "Activate"
        ok = VRMethod( "Application", "SendKeyString", "", "Hello there" || "0d"x )
    end
return

/*:VRX         PB_5_Click
*/
PB_5_Click: procedure
    call VRMethod "DDEC_1", "Initiate", "convs.", "AmiPro", "System"

    if convs.0 = 0 then do
         id = VRMessage( VRWindow(), "AmiPro not running!", "Not Found", "Error", , ,  )
    end;else do
        call VRMethod "DDEC_1", "Accept"
        ok = VRMethod( "DDEC_1", "Execute", '[type("hello from DDE[Enter]")]' )
        call VRMethod "DDEC_1", "Terminate"
    end
return

/*:VRX         Quit
*/
Quit:
    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

