extproc sh.exe
#! sh
# makewhatis: create the whatis database
# Created: Sun Jun 14 10:49:37 1992
# Revised: Sat Jan  8 14:12:37 1994 by faith@cs.unc.edu
# Revised: Sat Mar 23 17:56:18 1996 by micheal@actrix.gen.nz
# Copyright 1992, 1993, 1994 Rickard E. Faith (faith@cs.unc.edu)
# May be freely distributed and modified as long as copyright is retained.
#
# Wed Dec 23 13:27:50 1992: Rik Faith (faith@cs.unc.edu) applied changes
# based on Mitchum DSouza (mitchum.dsouza@mrc-apu.cam.ac.uk) cat patches.
# Also, cleaned up code and make it work with NET-2 doc pages.
#
# makewhatis-1.4: aeb 940802, 941007, 950417
# Fixed so that the -c option works correctly for the cat pages
# on my machine. Fix for -u by Nan Zou (nan@ksu.ksu.edu).
# Many minor changes.
# The -s option is undocumented, and may well disappear again.
#
# Sat Mar 23 1996: Michael Hamilton (michael@actrix.gen.nz).
# I changed the script to invoke gawk only once for each directory tree.
# This speeds things up considerably (from 30 minutes down to 1.5 minutes
# on my 486DX66).
# 960401 - aeb: slight adaptation to work correctly with cat pages.
# 960510 - added fixes by brennan@raven.ca.boeing.com, author of mawk.
#
# Note for Slackware users: "makewhatis -v -w -c" will work.
#
# Sun Jan 16 200: SAWATAISHI Jun (jsawa@attglobal.net).
#  Modification for OS/2 Warp
#    - All compressed manpages are uncompressed before making database. 
#    - Empty manpages (size=0) are removed before makeing database. 
#    - You decide whether all uncompressed manpages are compressed again
#      or not. 
#    
#
#----------- Definition ----------------------------------------------------
#
# 
#      
AWK_COMMAND=gawk
#
#-- Do you compress manpages ? 
#
#   COMPRESS_CMD=bzip2: All uncompressed manpages are compressed by bzip2 
#                       after database is created. 
#   COMPRESS_CMD=gzip :                                          by gzip
#   COMPRESS_CMD=     : Uncompressed manpages are not compressed. 
#                       In this case, _DO_ _NOT_ add space (or TAB) between 
#                       '=' and the end of line (newline). 
#
COMPRESS_CMD='gzip --force --quiet'
#COMPRESS_CMD='bzip2 --force --quiet'
#COMPRESS_CMD=
#
#
#-- By which program do you change file permissions
#CHMOD_CMD='attrib -s -h -r'
CHMOD_CMD='chmod +rw'
#
#-- You may have to define TMPDIR here
#
if [ -z "$TMPDIR" ] 
then
  TMPDIR=f:/tmp
fi
#
#
#
#-- Define DEFMANPATH and /or DEFCATPATH like this
#     DEFMANPATH='g:/emx/man;l:/usr/man/ja;l:/usr/man;'
#   Don't forget starting ' and ending '. 
#
# Without "-w" option, when DEFMANPATH is emply this script do nothig.
# 
#
DEFMANPATH=
DEFCATPATH=
#----------------------------------------------------------------------------

topath=manpath

defmanpath=$DEFMANPATH
defcatpath=$DEFCATPATH

sections="1 2 3 4 5 6 7 8 9 n l 1m 1x 3x 5x"

for name in $*
do
if [ -n "$setsections" ]; then
	setsections=
	sections=$name
	continue
fi
case $name in
    -c) topath=catpath
	defmanpath=
	defcatpath=$DEFCATPATH
        continue;;
    -s) setsections=1
        continue;;
    -u) findarg="-ctime 0"
        update=1
        continue;;
    -v) verbose=1
	continue;;
    -w) manpath=`man -w`
	continue;;
    -*) echo "Usage: makewhatis [-u] [-v] [-w] [manpath] [-c [catpath]]"
	echo "       This will build the whatis database for the man pages"
	echo "       found in manpath and the cat pages found in catpath."
        echo "       -u: update database with new pages"
	echo "       -v: verbose"
	echo "       -w: use manpath obtained from \`man -w\`"
        echo "       [manpath]: man directories (default: $DEFMANPATH)"
	echo "       [catpath]: cat directories (default: the first existing"
	echo "           directory in $DEFCATPATH)"
        exit;;
     *) if [ -d $name ]
        then
            eval $topath=$name
#            eval $topath="\$$topath":$name
        else
            echo "No such directory $name"
            exit
        fi;;
esac
done


manpath=`echo ${manpath-$defmanpath} | tr ';' ' '`

#manpath=`echo ${MANPATH-$defmanpath} | tr ';' ' '`

if [ -z "$catpath" ]; then
   for d in `echo $defcatpath | tr ';' ' '`
   do
      if [ -d $d ]; then catpath=$d; break; fi
   done
fi
catpath=`echo ${catpath} | tr ';' ' '`

# first remove all the whatis files that will be created new,
# then only update - we might visit the same directory twice
if [ -z $update ]; then
   for pages in man cat
   do
      eval path="\$$pages"path
      for mandir in $path
      do
         rm -f $mandir/whatis
      done
   done
fi

for pages in man cat
do
   export pages
   eval path="\$$pages"path
   for mandir in $path
   do
     if [ x$verbose != x ]; then
        echo "about to enter $mandir" > /dev/tty

     fi
     if [ -f ${mandir}/whatis -a $pages = man ]; then
        if [ x$verbose != x ]; then
           echo skipping $mandir - we did it already > /dev/tty
        fi
     else      
       here=`pwd`
       cd $mandir
       for i in $sections
       do
         if [ -d ${pages}$i ]
         then
            cd ${pages}$i
            
			if [ '*' != "`echo *`" ]
			then
				$CHMOD_CMD  '*.*'
			  find . -empty -type f -exec rm -f {} \;
				if [ '*.bz2' != "`echo *.bz2`" ] ; then
				  bzip2 -dqf '*.bz2'
				fi
				if [ '*.BZ2' != "`echo *.BZ2`" ] ; then
				  bzip2 -dqf '*.BZ2'
				fi
				if [ '*.gz' != "`echo *.gz`" ] ; then
				  gzip -dqf '*.gz'
				fi
				if [ '*.GZ' != "`echo *.GZ`" ] ; then
				  gzip -dqf '*.GZ'
				fi
				if [ '*.Z' != "`echo *.Z`" ] ; then
				  gzip -dqf '*.Z'
				fi
				if [ '*.z' != "`echo *.z`" ] ; then
				  gzip -dqf '*.z'
				fi
#				find . -maxdepth 0 -iname '*.bz2' | xargs bzip2 -dqf
#				find . -maxdepth 0 -iname '*.gz' -o -iname '*.Z' |xargs gzip -dqf
			fi
            section=$i
            export section verbose
	    find . -name '*' $findarg -print | $AWK_COMMAND '
	    function readline() {
	      if (use_zcat || use_bzcat) {
		result = (pipe_cmd | getline);
		if (result < 0) {
		  print "Pipe error: " pipe_cmd " " ERRNO > "/dev/stderr";
		}
	      } else {
		result = (getline < filename);
		if (result < 0) {
		  print "Read file error: " filename " " ERRNO > "/dev/stderr";
		}
	      }
	      return result;
	    }
	    
	    function closeline() {
	      if (use_zcat || use_bzcat) {
		return close(pipe_cmd);
	      } else {
		return close(filename);
	      }
	    }
	    
	    function do_one() {
	      after = 0; insh = 0; thisjoin = 1; charct = 0;

	      if (verbose) {
		print "adding " filename > "/dev/tty"
	      }
	      
	      use_zcat = (filename ~ /\.Z$/ || filename ~ /\.z$/ ||
			  filename ~ /\.gz$/);
	      use_bzcat = (filename ~ /\.bz2/);

	      match(filename, "/[^/]+$");
	      progname = substr(filename, RSTART + 1, RLENGTH);
	      sub(/\..*/, "", progname);
	      if (use_zcat) {
		pipe_cmd = "gzip.exe -dc " filename;   # jsawa
	      }
	      if (use_bzcat) {
		pipe_cmd = "bzip2 -dc " filename; # jsawa
	      }
	    
	      while (readline() > 0) {
		gsub(/.\b/, "");
		if (($1 ~ /^\.[Ss][Hh]/ && $2 ~ /[Nn][Aa][Mm][Ee]/) ||
## by Linux below 5lines		  (pages == "cat" && $1 ~ /^NAME/)) {
                   ($1 ~ /^\.[Ss][Hh]/ && $2 ~ /̾/) ||
                   ($1 ~ /^\.[Ss][Hh]/ && $2 ~ /̾/) ||
                   (pages == "cat" && $1 ~ /^NAME/) ||
                   (pages == "cat" && $1 ~ /^̾/) ||
                   (pages == "cat" && $1 ~ /^̾/)) {
		    if (!insh)
		      insh = 1;
		    else {
		      printf "\n";
		      closeline();
                      return;
		    }
		} else if (insh) {
		  if ($1 ~ /^\.[Ss][HhYS]/ ||
		    (pages == "cat" &&
		    ($1 ~ /^S[yYeE]/ || $1 ~ /^DESCRIPTION/ ||
		    $1 ~ /^COMMAND/ || $1 ~ /^OVERVIEW/ ||
# by Linux below 5lines		    $1 ~ /^STRUCTURES/ || $1 ~ /^INTRODUCTION/))) {
                    $1 ~ /^STRUCTURES/ || $1 ~ /^INTRODUCTION/ ))) {

		      # end insh for Synopsis, Syntax, but also for
		      # DESCRIPTION (e.g., XFree86.1x),
		      # COMMAND (e.g., xspread.1)
		      # OVERVIEW (e.g., TclCommandWriting.3)
		      # STRUCTURES (e.g., XEvent.3x)
		      # INTRODUCTION (e.g., TclX.n)
		      printf "\n";
		      closeline();
                      return; 
		  } else { # derived from Tom Christiansen perl script
		      if (!after && $0 ~ progname"-") {  # Fix old cat pages
			  sub(progname"-", progname" - ");
		      }
		      gsub(/	/, " ");        # Translate tabs to spaces
		      gsub(/  +/, " ");         # Collapse spaces
		      gsub(/ *, */, ", ");      # Fix comma spacings
		      sub(/^ /, "");            # Kill initial spaces
		      sub(/ $/, "");            # Kill trailing spaces
		      sub(/__+/, "_");          # Collapse underscores
		      if ($0 ~ /[^ ]-$/) {
			sub(/-$/, "");          # Handle Hyphenations
			nextjoin = 1;
		      } else
			nextjoin = 0;
			sub(/^.[IB] /, "");       # Kill bold and italics
			sub(/^.Nm /, "");         # Kill bold
			sub(/^.Tn /, "");         # Kill normal
			sub(/^.Li /, "");         # Kill .Li
			sub(/^.Dq /, "");         # Kill .Dq
			sub(/^.Nd */, "- ");      # Convert .Nd to dash
			gsub(/\\f[PRIB0123]/, "");   # Kill font changes
			gsub(/\\s[-+0-9]*/, "");     # Kill size changes
			gsub(/\\&/, "");             # Kill \&
			gsub(/\\\((ru|ul)/, "_");    # Translate
			gsub(/\\\((mi|hy|em)/, "-"); # Translate
			gsub(/\\\*\(../, "");        # Kill troff strings
			sub(/^\.\\\".*/, "");        # Kill comments
			gsub(/\\/, "");              # Kill all backslashes
			if ($1 ~ /^\.../ || $1 == "") {
			  if (after && !needmore) {
			    printf "\n";
			    thisjoin = 1;
			    charct = 0;
			    after = 0;
			  }
			} else {
			  if ($0 ~ /^- /) {
			    sub("- ", " - ");
			  } else if (!thisjoin && $0 !~ /^- /) {
			    printf " ";
			    charct += 1;
			  }
			  thisjoin = nextjoin;
			  if ($0 !~ / - / && $0 !~ / -$/ && $0 !~ /^- /) {
			    printf "%s", $0;
			    charct += length();
			    needmore = 0;
			  } else {
			    after = 1
			    if ($0 ~ / - /) {
			      where = match( $0 , / - /);
			    } else if ($0 ~ / -$/) {
			      where = match( $0, / -$/);
			    } else {
			      where = 1;
			    }
			    if ((width = 20-charct) < 0) width=0
			    printf "%-*s", width, sprintf( "%s (%s)",
			    substr( $0, 1, where-1 ), section );
			    printf "%s", substr( $0, where )
			    if ($0 ~ /- *$/) {
			      needmore = 1;
			    } else {
			      needmore = 0;
			    }
			  }
			}
		      }
		   }
		}
	      closeline();
	    }

            {			# Main action - process each filename read in.
	      filename = $0;
	      do_one();
	    }
	    ' pages=$pages section=$section verbose=$verbose
		if [ -n "$COMPRESS_CMD" ] 
		then
      if [ '*.'$section'*' != "`echo *.$section*`" ] ; then
			  find . ! -iname '*.bz2' ! -iname '*.gz' \
			         ! -iname '*.z' ! -iname 'whatis'  -type f \
			             | xargs $COMPRESS_CMD 
      fi
		fi
       cd ..
    fi
	done > $TMPDIR/whatis$$

       cd $here

       # kludge for Slackware's /usr/man/preformat
       if [ $mandir = /usr/man/preformat ]
       then
         mandir1=/usr/man
       else
         mandir1=$mandir
       fi

       if [ -f ${mandir1}/whatis ]
       then
         cat ${mandir1}/whatis >> $TMPDIR/whatis$$
       fi

       sed '/^$/d' < $TMPDIR/whatis$$ | sort | uniq > ${mandir1}/whatis

       rm $TMPDIR/whatis$$
     fi
   done
done
