/*
 * texi2ipf.c - texi2ipf mainline
 *
 * texi2roff history:
 *             Release 1.0a    August 1988
 *             Release 2.0     January 1990
 *
 * Copyright 1988, 1989, 1990  Beverly A.Erlebacher
 * erlebach@cs.toronto.edu    ...uunet!utai!erlebach
 *
 * texi2ipf history:
 *             Release 1.0     February 1993
 *
 * Modified by Marcus Grber, Fido 2:2402/61.1
 *
 * Modified by Martin "Herbert" Dietze, Email herbert@wiloyee.shnet.org
 *
 */

/*
 * History:
 *
 * $Log: texi2ipf.c,v $
 * Revision 1.6  1997/02/06 12:45:17  herbert
 * - Added documentation in Texinfo format.
 * - Minor bug fixes.
 *
 * Revision 1.5  1997/02/04 13:05:43  herbert
 * Menu descriptions of more than one lines are now converted correctly if they
 * are indented by more than 25 whitespaces (1 tab == 8 spaces).
 *
 * Revision 1.4  1997/01/10 14:56:44  herbert
 * Fixed a weird error under OS/2 caused by too few stack.
 *
 * Revision 1.3  1996/12/17 15:14:22  herbert
 * Only some cosmetic changes. The code looks still rather ugly to me :-)
 *
 * Revision 1.2  1996/12/17 14:10:01  herbert
 * Added support for pseudo-Texinfo-commands: @ifhtml (ignored) and @ipfline{}
 * (my invention) for putting IPF code into the Texinfo source.
 * Added @macro command to table.h, will be ignored.
 *
 * Revision 1.1.1.1  1996/12/02 12:10:01  herbert
 * Texi2IPF 1.0
 *
 */

#include "texi2ipf.h"
#include <stdlib.h>
#include <stdio.h>
#ifndef __TURBOC__
#include <sys/types.h>
#endif
#include <sys/stat.h>
#include <string.h>
#include <setjmp.h>

static char * id =
"@(#)$Id: texi2ipf.c,v 1.6 1997/02/06 12:45:17 herbert Exp $";

/*
 * I start by version 2.0 since it is the first version touched by me...
 * (herbert)
 */
static char * version = "2.1";

char *progname;
jmp_buf cleanup_point;  /* needed to reach the end-of-file processing
                         * via longjmp() after encountering @bye */    

/*
 * main - parse arguments, handle options
 *     - initialize tables and other strings
 *     - open files and pass them to process().
 */
int main( int argc, char * argv[])
{
    int errflg = 0;
    FILE *in;
    char *inname;
    int h_optind = 1;   /* to keep structure without using getopt() */

    int process( FILE*, char*);
    void initialize( void);

    progname = argv[0];

    if ( errflg || argc < 2 ) {
        (void) fprintf( stderr,
                       "\ntexi2ipf -=- Convert GNU texinfo files to "
                       "OS/2 IPFC source code, version %s\n"
                       "Based on texi2roff by Beverly A.Erlebacher (1990)\n"
                       "Modified by Marcus Groeber (1993)\n"
                       "Modified by Martin \"Herbert\" Dietze (1997)\n\n"
                       "Usage: %s texi_file(s) [>ipfc_file]\n", 
                        version, progname);
        exit(1);
    }

    initialize();

    if ( !setjmp( cleanup_point) ) /* Store address for longjmp() after @bye
                                    * in Texinfo file... */
        if ( h_optind >= argc ) {
            errflg += process( stdin, "stdin");
        } else
            for (; h_optind < argc; h_optind++) {
                if ( STREQ(argv[h_optind], "-") ) {
                    inname = "stdin";
                    in = stdin;
                } else {
    #ifdef __IBMC__
    #  define OM_ "r"
    #else
    #  define OM_ "rt"
    #endif
                    if ( ( in = fopen(argv[h_optind], OM_)) == NULL ) {
                        (void) fprintf( stderr, "%s : can't open file %s\n",
                                        progname, argv[h_optind]);
                        continue;
                    }/* if */
                    inname = argv[h_optind];
                }/* if */
                errflg += process( in, inname);
                if ( in != stdin )
                    (void) fclose( in);
                /* endif */
            }/* for */
        /* endif */
    else
        if( !errflg )     /* we don't close files here as we exit the program anyway... */
            puts( cmds->exit);
        /* endif */
    /* endif */
    exit( errflg);
    return 0; /* keep the compiler happy... */
}

/*
 * process -  check opened files and pass them to translate().
 *        -  report on disastrous translation failures
 */
int process( FILE *fp, char *filename)
{
    struct stat statbuf;
    int translate( FILE *, char *);

    if ( fstat(fileno(fp), &statbuf) != 0 ){
        (void) fprintf( stderr, "%s : can't fstat file %s\n", progname,
                        filename);
        return 1;
    }
#ifdef __IBMC__
    if (statbuf.st_mode & S_IFDIR) {
#else
    if ((statbuf.st_mode & S_IFMT)==S_IFDIR) {
#endif
        (void) fprintf( stderr, "%s : %s is a directory\n", progname,
                        filename);
        return 1;
    }
    /* translate returns 0 (ok) or -1 (disaster). it isn't worthwhile
     * to try to recover from a disaster.
     */
    if ( translate( fp, filename) < 0 ) {
        (void) fprintf( stderr,
                        "%s: error while processing file %s,"
                        " translation aborted\n",
                        progname, filename);
        exit( 1);
    }
    return 0;
}
