#==============================================================
#
# Configuration specific to the IBM Visual Age C/C++ compilers
#
#==============================================================

# Do not define MAKE_SH if you want to use the standard command processor

.IF $(MAKE_SH) == $(NULL)

SHELL       := $(COMSPEC)
SHELLFLAGS  := /c
GROUPFLAGS  := $(SHELLFLAGS)
SHELLMETAS  := *"?<>|&
DIVFILE      = $(TMPFILE:s,/,\)

.ENDIF

# Define the C and C++ compilers

CC	= icc
CCC	= icc
LN	= icc
AS	= alp

# Override the object file suffix.  Earlier it was set to .o

O	!= .obj

OPUT	= -Fo
EPUT	= -Fe

.IF $(OPT)
LDEBUG = -Ti-
CDEBUG = -Ti- -Tm- -O+
.ELSE
LDEBUG = -Ti+
CDEBUG = -Ti+ -Tm- -O-
.ENDIF

# -Q:   Suppress banner
# -G4:  Generate 486 code (may want -G5 instead)
# -G5:  Generate code for Pentium
# -Sp1: Pack structure fields on one-byte boundaries
# -Tm+: Use debug memory
# -Ga+: Turn on implicit/transparent mode for Direct-to-SOM
# -Ss+: Allow // comments
# -Gt+: Datum must not cross 64K boundary
# -Gd+: Dynamically link to library routines
# -Gm+: Use multi-threaded libraries
# -Ge-: Generate code for DLL (-Ge+ for executable)

CFLAGS = -Q+ -Gm+ -G5 $(CDEBUG) -Ss+
CFLAGX = -Q+ -Gm+ -G5 $(CDEBUG) -Ss+
LFLAGS = -Q+ -Gm+ $(LDEBUG) -Tdp
LFLAGX = -Q+ -Gm+ -Gd- $(LDEBUG)
GENEXE = -Ge+ -Gd-
GENDLL = -Ge- -Gd-

.SILENT := $(__.SILENT)
