/* Visual Parse++ REXX function*/

SSDll = '\SSVPARSE\BIN\SSVPREXX.DLL'
call RxFuncAdd 'SSLoadRexxFunctions', SSDll, 'SSLoadRexxFunctions'
call SSLoadRexxFunctions SSDll

signal on error name SSTerminate
signal on syntax name SSTerminate
signal on failure name SSTerminate

ALexEnd         = 4
ALexPlus        = 5
ALexMinus       = 6
ALexDiv         = 7
ALexMult        = 8
ALexMod         = 9
ALexPow         = 10
ALexOr          = 11
ALexAnd         = 12
ALexNot         = 13
ALexOParen      = 14
ALexCParen      = 15
ALexDec         = 16
ALexOct         = 17
ALexHex         = 18

AYaccStart      = 1
AYaccStartList  = 2
AYaccExprSingle = 3
AYaccExprError  = 4
AYaccExprPlus   = 5
AYaccExprMinus  = 6
AYaccExprMult   = 7
AYaccExprDiv    = 8
AYaccExprMod    = 9
AYaccExprNot    = 10
AYaccExprAnd    = 11
AYaccExprOr     = 12
AYaccExprNested = 13
AYaccExprNumber = 14
AYaccNumberDec  = 15
AYaccNumberOct  = 16
AYaccNumberHex  = 17

ALexClassTable = '\ss\ycc\sscalc.dfa'
ALexClassConsumer = 'Visual Parse++ Consumer'
ALexClass = SSLexCreate( ALexClassTable, ALexClassConsumer, SSFile)
ALexClassTable = ''
AYaccClassTable = '\ss\ycc\sscalc.llr'
AYaccClass = SSYaccCreate( ALexClass, AYaccClassTable)
AYaccClassTable = ''

do forever
   SSRet = SSYaccParse( AYaccClass, SSParm)
   select
      when SSRet = SSOK then
         nop /* say 'Lexeme 'SSParm.0' at' SSParm.2','SSParm.3*/
      when SSRet = SSMORE then do
         SSRet = ALexClassProcessMore()
         if SSRet <> "" then
            SSRet = SSLexAddData( ALexClass, SSRet)
         end
      when SSRet = SSSHIFT then
         nop /* say 'Shift 'SSParm.0' at' SSParm.2','SSParm.3*/
      when SSRet = SSREDUCE then
         call AYaccClassReduce
      when SSRet = SSACCEPT then do
         leave
         end
      when SSRet = SSLEXERROR then do
         SSRet = ALexClassProcessError()
         if SSRet < 0 then leave
         end
      when SSRet = SSYACCERROR then do
         SSRet = AYaccClassProcessError()
         if SSRet < 0 then leave
         end
      when SSRet = SSPERMERROR then do
         say 'Permanent error'
         leave
         end
      otherwise do
         say 'Unprocessed parse 'SSRet
         leave
         end
   end
end

call SSCleanup
return 0



AYaccClassProcessError:
   say 'Syntax error at 'SSParm.2','SSParm.3': 'SSParm.0
   return -1

SSCleanup:
   if ALexClassTable = '' then
      call SSLexDestroy ALexClass
   if AYaccClassTable = '' then
      call SSYaccDestroy AYaccClass
   call SSUnloadRexxFunctions
   return

ALexClassProcessMore:
   return ''

ALexClassProcessError:
   say 'Invalid lexeme at 'SSParm.2','SSParm.3': 'SSParm.0
   return -1

AYaccClassReduce:
   say 'Reduce 'SSParm.0
   select
      when SSParm.0 = AYaccStart then do
      /* start -> exprStatement */
         end

      when SSParm.0 = AYaccStartList then do
      /* start -> start exprStatement */
         end

      when SSParm.0 = AYaccExprSingle then do
      /* exprStatement -> expr ; */
         end

      when SSParm.0 = AYaccExprError then do
      /* exprStatement -> %error ; */
         end

      when SSParm.0 = AYaccExprPlus then do
      /* expr -> expr + expr */
         end

      when SSParm.0 = AYaccExprMinus then do
      /* expr -> expr - expr */
         end

      when SSParm.0 = AYaccExprMult then do
      /* expr -> expr * expr */
         end

      when SSParm.0 = AYaccExprDiv then do
      /* expr -> expr / expr */
         end

      when SSParm.0 = AYaccExprMod then do
      /* expr -> expr % expr */
         end

      when SSParm.0 = AYaccExprNot then do
      /* expr -> not expr */
         end

      when SSParm.0 = AYaccExprAnd then do
      /* expr -> expr and expr */
         end

      when SSParm.0 = AYaccExprOr then do
      /* expr -> expr or expr */
         end

      when SSParm.0 = AYaccExprNested then do
      /* expr -> ( expr ) */
         end

      when SSParm.0 = AYaccExprNumber then do
      /* expr -> number */
         end

      when SSParm.0 = AYaccNumberDec then do
      /* number -> dec */
         end

      when SSParm.0 = AYaccNumberOct then do
      /* number -> oct */
         end

      when SSParm.0 = AYaccNumberHex then do
      /* number -> hex */
         end

   end
   return

SSTerminate:
   say 'Error on line 'sigl': 'SSResult
   call SSCleanup
   exit 1
