/*----------------------------------------------------------------------*
 * Bounds Checking for GCC.						*
 * Copyright (C) 1995 Richard W.M. Jones <rwmj@doc.ic.ac.uk>.		*
 *----------------------------------------------------------------------*
 * This program is free software; you can redistribute it and/or modify	*
 * it under the terms of the GNU General Public License as published by	*
 * the Free Software Foundation; either version 2 of the License, or	*
 * (at your option) any later version.					*
 *									*
 * This program is distributed in the hope that it will be useful,	*
 * but WITHOUT ANY WARRANTY; without even the implied warranty of	*
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	*
 * GNU General Public License for more details.				*
 *									*
 * You should have received a copy of the GNU General Public License	*
 * along with this program; if not, write to the Free Software		*
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		*
 *----------------------------------------------------------------------*
 * File:
 *	lib/functions.h
 * Summary:
 *	Header file describing the function stack used by "functions.c".
 * Other notes:
 *	
 * Author      	Date		Notes
 * RWMJ		6/3/95		Initial implementation.
 *----------------------------------------------------------------------*/

#ifndef _FUNCTIONS_H_
#define _FUNCTIONS_H_

/* This is the structure used to store a record of a single function
 * call.
 */
typedef struct function_context {
/*  struct function_context *next; */	/* Linked list to caller. */
  unsigned in_main : 1;			/* True if this is `main()'. */
  unsigned no_checking : 1;		/* True if we don't check this fn. */
  int nr_args;				/* Number of arguments to function. */
  int nr_args_had;			/* Number of arguments we've had. */
  char *name;				/* Pointer to function name. */
  char *filename;			/* File where declared. */
  int line;				/* Line where declared. */
  alloca_item *alloca_stack;		/* List of calls to alloca. */
  unsigned first_arg;			/* List of function arguments. */
} function_context;

/* The following structure is used to store a list of arrays of the
 * above structure (to optimize memory allocation).
 */
typedef struct function_context_list {
  struct function_context_list *next;	/* Linked list of these. */
  struct function_context_list *prev;
  struct function_context *fc_array;	/* Array of function contexts. */
  int used;				/* # of contexts used in this array. */
} function_context_list;

#endif /* _FUNCTIONS_H_ */
