/* egahline.c (emx+gcc) -- Copyright (c) 1994 by Steffen Haecker */

#include <stdlib.h>
#include <memory.h>
#include <sys/hw.h>
#include "graph2.h"
#include "ega.h"


void _ega_hline (unsigned x, unsigned y, unsigned n, int color)
{
  unsigned x1, length;
  unsigned char lmask, rmask;
  volatile unsigned char *p;

  x1 = x + n - 1;
  p = _g_mem + y * 80 + x / 8;
  length = x1 / 8 - x / 8;
  lmask = 0xff >> (x & 7);
  rmask = 0xff << (7 - (x1 & 7));
  if (length == 0)
    lmask &= rmask;
  GLOCK;
  OUT3 (color << 8, 0x0f01, (lmask << 8) | 8);
  ++(*p);
  if (length > 0)
    {
      --length; ++p;
      if (length > 0)
        {
          MASK (0xff);
          memset ((void *)p, 0, length);
          p += length;
        }
      MASK (rmask);
      ++(*p);
    }
  OUT2 (0xff08, 0x0001);
  GUNLOCK;
}
