/* gets.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include <sys/builtin.h>        /* For <sys/fmutex.h> */
#include <sys/fmutex.h>         /* For <sys/rmutex.h> */
#include <sys/rmutex.h>
#include <stdio.h>
#include <stdlib.h>
#include <emx/io.h>

char *gets (char *buffer)
{
  int c;
  char *dst;

  dst = buffer;
  STREAM_LOCK (stdin);
  for (;;)
    {
      c = _getc_inline (stdin);
      if (c == EOF)
        if (dst == buffer)
          {
            *dst = 0;
            STREAM_UNLOCK (stdin);
            return NULL;
          }
        else
          break;
      if (c == '\n')
        break;
      *dst++ = (char)c;
    }
  STREAM_UNLOCK (stdin);
  *dst = 0;
  return buffer;
}
