/* $Header: /usr/people/sam/tiff/libtiff/RCS/tiffiop.h,v 1.80 1996/04/05 17:36:53 sam Rel $ */

/*
 * Copyright (c) 1988-1996 Sam Leffler
 * Copyright (c) 1991-1996 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Sam Leffler and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Sam Leffler and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 * IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */

#ifndef _TIFFIOP_
#define _TIFFIOP_
/*
 * ``Library-private'' definitions.
 */
/*
 * UNIX systems should run the configure script to generate
 * a port.h file that reflects the system capabilities.
 * Doing this obviates all the dreck done in tiffcomp.h.
 */
#if defined(unix) || defined(__unix)
#include "port.h"
#include "tiffconf.h"
#else
#include "tiffconf.h"
#include "tiffcomp.h"
#endif
#include "tiffio.h"
#include "tif_dir.h"

#ifndef TRUE
#define TRUE    1
#define FALSE   0
#endif

/*
 * Typedefs for ``method pointers'' used internally.
 */
typedef unsigned char tidataval_t;  /* internal image data value type */
typedef tidataval_t* tidata_t;      /* reference to internal image data */

typedef void    (TIFFAPIP TIFFVoidMethod)(TIFF*);
typedef int     (TIFFAPIP TIFFBoolMethod)(TIFF*);
typedef int     (TIFFAPIP TIFFPreMethod)(TIFF*, tsample_t);
typedef int     (TIFFAPIP TIFFCodeMethod)(TIFF*, tidata_t, tsize_t, tsample_t);
typedef int     (TIFFAPIP TIFFSeekMethod)(TIFF*, uint32);
typedef void    (TIFFAPIP TIFFPostMethod)(TIFF*, tidata_t, tsize_t);
typedef int     (TIFFAPIP TIFFVSetMethod)(TIFF*, ttag_t, va_list);
typedef int     (TIFFAPIP TIFFVGetMethod)(TIFF*, ttag_t, va_list);
typedef void    (TIFFAPIP TIFFPrintMethod)(TIFF*, FILE*, long);
typedef uint32  (TIFFAPIP TIFFStripMethod)(TIFF*, uint32);
typedef void    (TIFFAPIP TIFFTileMethod)(TIFF*, uint32*, uint32*);

struct tiff {
    char*       tif_name;   /* name of open file */
    int     tif_fd;     /* open file descriptor */
    int     tif_mode;   /* open mode (O_*) */
    uint32      tif_flags;
#define TIFF_FILLORDER      0x0003  /* natural bit fill order for machine */
#define TIFF_DIRTYHEADER    0x0004  /* header must be written on close */
#define TIFF_DIRTYDIRECT    0x0008  /* current directory must be written */
#define TIFF_BUFFERSETUP    0x0010  /* data buffers setup */
#define TIFF_CODERSETUP     0x0020  /* encoder/decoder setup done */
#define TIFF_BEENWRITING    0x0040  /* written 1+ scanlines to file */
#define TIFF_SWAB       0x0080  /* byte swap file information */
#define TIFF_NOBITREV       0x0100  /* inhibit bit reversal logic */
#define TIFF_MYBUFFER       0x0200  /* my raw data buffer; free on close */
#define TIFF_ISTILED        0x0400  /* file is tile, not strip- based */
#define TIFF_MAPPED     0x0800  /* file is mapped into memory */
#define TIFF_POSTENCODE     0x1000  /* need call to postencode routine */
#define TIFF_INSUBIFD       0x2000  /* currently writing a subifd */
#define TIFF_UPSAMPLED      0x4000  /* library is doing data up-sampling */ 
#define TIFF_STRIPCHOP      0x8000  /* enable strip chopping support */
    toff_t      tif_diroff; /* file offset of current directory */
    toff_t      tif_nextdiroff; /* file offset of following directory */
    TIFFDirectory   tif_dir;    /* internal rep of current directory */
    TIFFHeader  tif_header; /* file's header block */
        tidata_t        tif_clientdir;  /* client TIFF directory */
    const int*  tif_typeshift;  /* data type shift counts */
    const long* tif_typemask;   /* data type masks */
    uint32      tif_row;    /* current scanline */
    tdir_t      tif_curdir; /* current directory (index) */
    tstrip_t    tif_curstrip;   /* current strip for read/write */
    toff_t      tif_curoff; /* current offset for read/write */
    toff_t      tif_dataoff;    /* current offset for writing dir */
#if SUBIFD_SUPPORT
    uint16      tif_nsubifd;    /* remaining subifds to write */
    toff_t      tif_subifdoff;  /* offset for patching SubIFD link */
#endif
/* tiling support */
    uint32      tif_col;    /* current column (offset by row too) */
    ttile_t     tif_curtile;    /* current tile for read/write */
    tsize_t     tif_tilesize;   /* # of bytes in a tile */
/* compression scheme hooks */
    TIFFBoolMethod  tif_setupdecode;/* called once before predecode */
    TIFFPreMethod   tif_predecode;  /* pre- row/strip/tile decoding */
    TIFFBoolMethod  tif_setupencode;/* called once before preencode */
    TIFFPreMethod   tif_preencode;  /* pre- row/strip/tile encoding */
    TIFFBoolMethod  tif_postencode; /* post- row/strip/tile encoding */
    TIFFCodeMethod  tif_decoderow;  /* scanline decoding routine */
    TIFFCodeMethod  tif_encoderow;  /* scanline encoding routine */
    TIFFCodeMethod  tif_decodestrip;/* strip decoding routine */
    TIFFCodeMethod  tif_encodestrip;/* strip encoding routine */
    TIFFCodeMethod  tif_decodetile; /* tile decoding routine */
    TIFFCodeMethod  tif_encodetile; /* tile encoding routine */
    TIFFVoidMethod  tif_close;  /* cleanup-on-close routine */
    TIFFSeekMethod  tif_seek;   /* position within a strip routine */
    TIFFVoidMethod  tif_cleanup;    /* cleanup state routine */
    TIFFStripMethod tif_defstripsize;/* calculate/constrain strip size */
    TIFFTileMethod  tif_deftilesize;/* calculate/constrain tile size */
    tidata_t    tif_data;   /* compression scheme private data */
/* input/output buffering */
    tsize_t     tif_scanlinesize;/* # of bytes in a scanline */
    tsize_t     tif_scanlineskew;/* scanline skew for reading strips */
    tidata_t    tif_rawdata;    /* raw data buffer */
    tsize_t     tif_rawdatasize;/* # of bytes in raw data buffer */
    tidata_t    tif_rawcp;  /* current spot in raw buffer */
    tsize_t     tif_rawcc;  /* bytes unread from raw buffer */
/* memory-mapped file support */
    tidata_t    tif_base;   /* base of mapped file */
#ifdef __WIN32__
    void*       pv_map_handle;  /* WIN32 file mapping handle;
                     * must be contiguous with tif_base
                     * since map & unmap only get tif_base
                     * and assume 4 byte offset to
                     * pv_map_handle. */
#endif
    toff_t      tif_size;   /* size of mapped file region (bytes) */
    TIFFMapFileProc tif_mapproc;    /* map file method */
    TIFFUnmapFileProc tif_unmapproc;/* unmap file method */
/* input/output callback methods */
    thandle_t   tif_clientdata; /* callback parameter */
    TIFFReadWriteProc tif_readproc; /* read method */
    TIFFReadWriteProc tif_writeproc;/* write method */
    TIFFSeekProc    tif_seekproc;   /* lseek method */
    TIFFCloseProc   tif_closeproc;  /* close method */
    TIFFSizeProc    tif_sizeproc;   /* filesize method */
/* post-decoding support */
    TIFFPostMethod  tif_postdecode; /* post decoding routine */
/* tag support */
    TIFFFieldInfo** tif_fieldinfo;  /* sorted table of registered tags */
    int     tif_nfields;    /* # entries in registered tag table */
    TIFFVSetMethod  tif_vsetfield;  /* tag set routine */
    TIFFVGetMethod  tif_vgetfield;  /* tag get routine */
    TIFFPrintMethod tif_printdir;   /* directory print routine */
};

#define isPseudoTag(t)  (t > 0xffff)    /* is tag value normal or pseudo */

#define isTiled(tif)    (((tif)->tif_flags & TIFF_ISTILED) != 0)
#define isMapped(tif)   (((tif)->tif_flags & TIFF_MAPPED) != 0)
#define isFillOrder(tif, o) (((tif)->tif_flags & (o)) != 0)
#define isUpSampled(tif)    (((tif)->tif_flags & TIFF_UPSAMPLED) != 0)
#define TIFFReadFile(tif, buf, size) \
    ((*(tif)->tif_readproc)((tif)->tif_clientdata,buf,size))
#define TIFFWriteFile(tif, buf, size) \
    ((*(tif)->tif_writeproc)((tif)->tif_clientdata,buf,size))
#define TIFFSeekFile(tif, off, whence) \
    ((*(tif)->tif_seekproc)((tif)->tif_clientdata,(toff_t)(off),whence))
#define TIFFCloseFile(tif) \
    ((*(tif)->tif_closeproc)((tif)->tif_clientdata))
#define TIFFGetFileSize(tif) \
    ((*(tif)->tif_sizeproc)((tif)->tif_clientdata))
#define TIFFMapFileContents(tif, paddr, psize) \
    ((*(tif)->tif_mapproc)((tif)->tif_clientdata,paddr,psize))
#ifdef __WIN32__
#define TIFFUnmapFileContents(tif, addr, dummy) \
    ((*(tif)->tif_unmapproc)((tif)->tif_clientdata,addr,\
        (toff_t)(tif)->pv_map_handle))
#else
#define TIFFUnmapFileContents(tif, addr, size) \
    ((*(tif)->tif_unmapproc)((tif)->tif_clientdata,addr,size))
#endif

/*
 * Default Read/Seek/Write definitions.
 */
#ifndef ReadOK
#define ReadOK(tif, buf, size) \
    (TIFFReadFile(tif, (tdata_t) buf, (tsize_t) size) == (tsize_t) size)
#endif
#ifndef SeekOK
#define SeekOK(tif, off) \
    (TIFFSeekFile(tif, (toff_t) off, SEEK_SET) == (toff_t) off)
#endif
#ifndef WriteOK
#define WriteOK(tif, buf, size) \
    (TIFFWriteFile(tif, (tdata_t) buf, (tsize_t) size) == (tsize_t) size)
#endif

/* NB: the uint32 casts are to silence certain ANSI-C compilers */
#define TIFFhowmany(x, y) ((((uint32)(x))+(((uint32)(y))-1))/((uint32)(y)))
#define TIFFroundup(x, y) (TIFFhowmany(x,y)*((uint32)(y)))

#if defined(__cplusplus)
extern "C" {
#endif
int     TIFFAPI _TIFFgetMode(const char*, const char*);
int     TIFFAPI _TIFFNoRowEncode(TIFF*, tidata_t, tsize_t, tsample_t);
int     TIFFAPI _TIFFNoStripEncode(TIFF*, tidata_t, tsize_t, tsample_t);
int     TIFFAPI _TIFFNoTileEncode(TIFF*, tidata_t, tsize_t, tsample_t);
int     TIFFAPI _TIFFNoRowDecode(TIFF*, tidata_t, tsize_t, tsample_t);
int     TIFFAPI _TIFFNoStripDecode(TIFF*, tidata_t, tsize_t, tsample_t);
int     TIFFAPI _TIFFNoTileDecode(TIFF*, tidata_t, tsize_t, tsample_t);
void    TIFFAPI _TIFFNoPostDecode(TIFF*, tidata_t, tsize_t);
int     TIFFAPI _TIFFNoSeek(TIFF*, uint32);
void    TIFFAPI _TIFFSwab16BitData(TIFF*, tidata_t, tsize_t);
void    TIFFAPI _TIFFSwab32BitData(TIFF*, tidata_t, tsize_t);
void    TIFFAPI _TIFFSwab64BitData(TIFF*, tidata_t, tsize_t);
int     TIFFAPI TIFFFlushData1(TIFF*);
void    TIFFAPI TIFFFreeDirectory(TIFF*);
int     TIFFAPI TIFFDefaultDirectory(TIFF*);
int     TIFFAPI TIFFSetCompressionScheme(TIFF*, int);
uint32  TIFFAPI _TIFFDefaultStripSize(TIFF*, uint32);
void    TIFFAPI _TIFFDefaultTileSize(TIFF*, uint32*, uint32*);

void    TIFFAPI _TIFFsetByteArray(void**, void*, long);
void    TIFFAPI _TIFFsetString(char**, char*);
void    TIFFAPI _TIFFsetShortArray(uint16**, uint16*, long);
void    TIFFAPI _TIFFsetLongArray(uint32**, uint32*, long);
void    TIFFAPI _TIFFsetFloatArray(float**, float*, long);
void    TIFFAPI _TIFFsetDoubleArray(double**, double*, long);

void    TIFFAPI _TIFFprintAscii(FILE*, const char*);
void    TIFFAPI _TIFFprintAsciiTag(FILE*, const char*, const char*);

GLOBALDATA(TIFFErrorHandler,_TIFFwarningHandler);
GLOBALDATA(TIFFErrorHandler,_TIFFerrorHandler);

int     TIFFAPI TIFFInitDumpMode(TIFF*, int);
#ifdef PACKBITS_SUPPORT
int     TIFFAPI TIFFInitPackBits(TIFF*, int);
#endif
#ifdef CCITT_SUPPORT
int     TIFFAPI TIFFInitCCITTRLE(TIFF*, int);
int     TIFFAPI TIFFInitCCITTRLEW(TIFF*, int);
int     TIFFAPI TIFFInitCCITTFax3(TIFF*, int);
int     TIFFAPI TIFFInitCCITTFax4(TIFF*, int);
#endif
#ifdef THUNDER_SUPPORT
int     TIFFAPI TIFFInitThunderScan(TIFF*, int);
#endif
#ifdef NEXT_SUPPORT
int     TIFFAPI TIFFInitNeXT(TIFF*, int);
#endif
#ifdef LZW_SUPPORT
int     TIFFAPI TIFFInitLZW(TIFF*, int);
#endif
#ifdef OJPEG_SUPPORT
int     TIFFAPI TIFFInitOJPEG(TIFF*, int);
#endif
#ifdef JPEG_SUPPORT
int     TIFFAPI TIFFInitJPEG(TIFF*, int);
#endif
#ifdef JBIG_SUPPORT
int     TIFFAPI TIFFInitJBIG(TIFF*, int);
#endif
#ifdef ZIP_SUPPORT
int     TIFFAPI TIFFInitZIP(TIFF*, int);
#endif
#ifdef PIXARLOG_SUPPORT
int     TIFFAPI TIFFInitPixarLog(TIFF*, int);
#endif
#ifdef VMS
extern const TIFFCodec _TIFFBuiltinCODECS[];
#else
extern  TIFFCodec _TIFFBuiltinCODECS[];
#endif

#if defined(__cplusplus)
}
#endif
#endif /* _TIFFIOP_ */
