#ifndef _AMCCLIB_H_
#define _AMCCLIB_H_

#include "../../samples/shared/pci_regs.h"
#include "../../samples/shared/bits.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef enum
{
    AMCC_MODE_BYTE   = 0,
    AMCC_MODE_WORD   = 1,
    AMCC_MODE_DWORD  = 2
} AMCC_MODE;

typedef enum
{
    AMCC_ADDR_REG      = AD_PCI_BAR0,
    AMCC_ADDR_SPACE0   = AD_PCI_BAR1,
    AMCC_ADDR_SPACE1   = AD_PCI_BAR2,
    AMCC_ADDR_SPACE2   = AD_PCI_BAR3,
    AMCC_ADDR_SPACE3   = AD_PCI_BAR4,
    AMCC_ADDR_NOT_USED = AD_PCI_BAR5
} AMCC_ADDR;

typedef struct AMCC_STRUCT *AMCCHANDLE;

typedef struct
{
    DWORD dwCounter;   // number of interrupts received
    DWORD dwLost;      // number of interrupts not yet dealt with
    BOOL fStopped;     // was interrupt disabled during wait
    DWORD dwStatusReg; // value of status register when interrupt occured
} AMCC_INT_RESULT;
typedef void (WINAPI *AMCC_INT_HANDLER)( AMCCHANDLE hAmcc, AMCC_INT_RESULT *intResult);

typedef struct
{
    WD_INTERRUPT Int;
    HANDLE hThread;
    WD_TRANSFER Trans[2];
    AMCC_INT_HANDLER funcIntHandler;
} AMCC_INTERRUPT;

typedef struct
{
    DWORD dwLocalBase;
    DWORD dwMask;
    DWORD dwBytes;
    DWORD dwAddr;
    DWORD dwAddrDirect;
    BOOL  fIsMemory;
} AMCC_ADDR_DESC;

typedef struct AMCC_STRUCT
{
    HANDLE hWD;
    WD_CARD cardLock;
    WD_PCI_SLOT pciSlot;
    WD_CARD_REGISTER cardReg;
    AMCC_ADDR_DESC addrDesc[AD_PCI_BARS];
    BOOL   fUseInt;
    AMCC_INTERRUPT Int;
} AMCC_STRUCT;

// options for AMCC_Open
enum { AMCC_OPEN_USE_INT =   0x1 };

DWORD AMCC_CountCards (DWORD dwVendorID, DWORD dwDeviceID);
BOOL AMCC_Open (AMCCHANDLE *phAmcc, DWORD dwVendorID, DWORD dwDeviceID, DWORD nCardNum, DWORD dwOptions);
void AMCC_Close (AMCCHANDLE hAmcc);

BOOL AMCC_IsAddrSpaceActive(AMCCHANDLE hAmcc, AMCC_ADDR addrSpace);

void AMCC_WriteRegDWord (AMCCHANDLE hAmcc, DWORD dwReg, DWORD data);
DWORD AMCC_ReadRegDWord (AMCCHANDLE hAmcc, DWORD dwReg);
void AMCC_WriteRegWord (AMCCHANDLE hAmcc, DWORD dwReg, WORD data);
WORD AMCC_ReadRegWord (AMCCHANDLE hAmcc, DWORD dwReg);
void AMCC_WriteRegByte (AMCCHANDLE hAmcc, DWORD dwReg, BYTE data);
BYTE AMCC_ReadRegByte (AMCCHANDLE hAmcc, DWORD dwReg);

void AMCC_WriteDWord(AMCCHANDLE hAmcc, AMCC_ADDR addrSpace, DWORD dwLocalAddr, DWORD data);
DWORD AMCC_ReadDWord(AMCCHANDLE hAmcc, AMCC_ADDR addrSpace, DWORD dwLocalAddr);
void AMCC_WriteWord(AMCCHANDLE hAmcc, AMCC_ADDR addrSpace, DWORD dwLocalAddr, WORD data);
WORD AMCC_ReadWord(AMCCHANDLE hAmcc, AMCC_ADDR addrSpace, DWORD dwLocalAddr);
void AMCC_WriteByte(AMCCHANDLE hAmcc, AMCC_ADDR addrSpace, DWORD dwLocalAddr, BYTE data);
BYTE AMCC_ReadByte(AMCCHANDLE hAmcc, AMCC_ADDR addrSpace, DWORD dwLocalAddr);

void AMCC_ReadWriteSpaceBlock (AMCCHANDLE hAmcc, DWORD dwOffset, PVOID buf, DWORD dwBytes, BOOL fIsRead, AMCC_ADDR addrSpace, AMCC_MODE mode);
void AMCC_ReadSpaceBlock (AMCCHANDLE hAmcc, DWORD dwOffset, PVOID buf, DWORD dwBytes, AMCC_ADDR addrSpace);
void AMCC_WriteSpaceBlock (AMCCHANDLE hAmcc, DWORD dwOffset, PVOID buf, DWORD dwBytes, AMCC_ADDR addrSpace);

BOOL AMCC_ReadNVByte(AMCCHANDLE hAmcc, DWORD dwAddr, BYTE *pbData);

// interrupt functions
BOOL AMCC_IntIsEnabled (AMCCHANDLE hAmcc);
BOOL AMCC_IntEnable (AMCCHANDLE hAmcc, AMCC_INT_HANDLER funcIntHandler);
void AMCC_IntDisable (AMCCHANDLE hAmcc);

// access pci configuration registers
DWORD AMCC_ReadPCIReg(AMCCHANDLE hAmcc, DWORD dwReg);
void AMCC_WritePCIReg(AMCCHANDLE hAmcc, DWORD dwReg, DWORD dwData);

// DMA functions
BOOL AMCC_DMAOpen(AMCCHANDLE hAmcc, WD_DMA *pDMA, DWORD dwBytes);
void AMCC_DMAClose(AMCCHANDLE hAmcc, WD_DMA *pDMA);
BOOL AMCC_DMAStart(AMCCHANDLE hAmcc, WD_DMA *pDMA, BOOL fRead,
    BOOL fBlocking, DWORD dwBytes, DWORD dwOffset);
BOOL AMCC_DMAIsDone(AMCCHANDLE hAmcc, BOOL fRead);

// this string is set to an error message, if one occurs
extern CHAR AMCC_ErrorString[];

// Operation register offsets
enum
{
    OMB1_ADDR   = 0x00,
    OMB2_ADDR   = 0x04,
    OMB3_ADDR   = 0x08,
    OMB4_ADDR   = 0x0c,
    IMB1_ADDR   = 0x10,
    IMB2_ADDR   = 0x14,
    IMB3_ADDR   = 0x18,
    IMB4_ADDR   = 0x1c,
    FIFO_ADDR   = 0x20,
    MWAR_ADDR   = 0x24,
    MWTC_ADDR   = 0x28,
    MRAR_ADDR   = 0x2c,
    MRTC_ADDR   = 0x30,
    MBEF_ADDR   = 0x34,
    INTCSR_ADDR = 0x38,
    BMCSR_ADDR  = 0x3c
};

enum { 
    BMCSR_NVDATA_ADDR = BMCSR_ADDR + 2,
    BMCSR_NVCMD_ADDR = BMCSR_ADDR + 3
};
enum { NVRAM_BUSY_BITS        = BIT7 };    /* Bit 31 indicates if device busy */

enum { 
    NVCMD_LOAD_LOW_BITS    = BIT7,              /* nvRAM Load Low command */
    NVCMD_LOAD_HIGH_BITS   = BIT5 | BIT7,       /* nvRAM Load High command */
    NVCMD_BEGIN_WRITE_BITS = BIT6 | BIT7,       /* nvRAM Begin Write command */
    NVCMD_BEGIN_READ_BITS  = BIT5 | BIT6 | BIT7 /* nvRAM Begin Read command */
};
enum { AMCC_NVRAM_SIZE = 0x80 }; // size in bytes of nvRAM

enum
{
    AIMB1    = 0x00,
    AIMB2    = 0x04,
    AIMB3    = 0x08,
    AIMB4    = 0x0c,
    AOMB1    = 0x10,
    AOMB2    = 0x14,
    AOMB3    = 0x18,
    AOMB4    = 0x1c,
    AFIFO    = 0x20,
    AMWAR    = 0x24,
    APTA     = 0x28,
    APTD     = 0x2c,
    AMRAR    = 0x30,
    AMBEF    = 0x34,
    AINT     = 0x38,
    AGCSTS   = 0x3c,
};

#ifdef __cplusplus
}
#endif

#endif
