/**********************************************************************
 *
 * This is Search for the Sacred Stone, by Mikel Rice.  It was CRUNCHed
 * by him, so I don't have any of the original comments.  I uncrunched
 * it and modified the source code (keeping the original style and 
 * wording of the game in tact, of course) so that it would run under
 * both OS/2 and CMS.  It was originally written for CMS.
 *
 * PORTABILITY STATMENT: This code is portable to both CMS and OS/2.
 * This portability should be seemless.  However, there due to 
 * differences in ASCII/EBCDIC converters, you may experience 
 * difficulties.  The most common are the pipe character (|, if you
 * have the right machine), and the NOT symbol.  OS/2 accepts the
 * backslash '\' as NOT, while CMS accepts '^' SHIFT-6 on most
 * terminals.
 * 
 * Feel free to port STONE to other environments, compile it, or
 * CRUNCH it, but please always give it out with the source code 
 * and these comments.  STONE is freeware, and should NOT be sold.
 *
 * MikeA - 713221.1742@CompuServe.com
 *********************************************************************/
/* STONE2 optimized via ROPT by MIKEL@UWF on 13 Sep 1987 at 18:21:22 */
BEGIN:
PARSE UPPER ARG LOAD
PARSE UPPER SOURCE env .

IF env = 'CMS' THEN
   DO
   ECHO_OFF = "*CP SET MSG OFF"
   ECHO_ON = "CP SET MSG ON"
   ECHO_OFF
   HI='1DE8'x
   LO='1D60'x
   CLEAR_SCR = "VMFCLEAR"
   END
ELSE IF env = 'OS/2' THEN
   DO
   ECHO_OFF = "@ECHO OFF"
   ECHO_ON = "ECHO ON"
   ECHO_OFF
   HI='1B'x || "[1m"
   LO='1B'x || "[0m"
   "ANSI ON"
   SAY LO
   CLEAR_SCR = "CLS"
   END
ELSE
   DO
   SAY "STONE has not been ported to" env"."
   EXIT
   END

TOT_NOUNS=62
PAUSE=3
CLEAR_SCR
CALL TITLE
IF LOAD='LOAD' THEN CALL LOAD
CLEAR_SCR
START:
DO FOREVER
   CALL QTIME
   SELECT
      WHEN R = 1 THEN CALL ROOM1
      WHEN R = 2 THEN CALL ROOM2
      WHEN R = 3 THEN CALL ROOM3
      WHEN R = 4 THEN CALL ROOM4
      WHEN R = 5 THEN CALL ROOM5
      WHEN R = 6 THEN CALL ROOM6
      WHEN R = 7 THEN CALL ROOM7
      WHEN R = 9 THEN CALL ROOM9
      WHEN R = 10 THEN CALL ROOM10
      WHEN R = 11 THEN CALL ROOM11
      WHEN R = 12 THEN CALL ROOM12
      WHEN R = 13 THEN CALL ROOM13
      WHEN R = 14 THEN CALL ROOM14
      WHEN R = 15 THEN CALL ROOM15
      WHEN R = 16 THEN CALL ROOM16
      WHEN R = 17 THEN CALL ROOM17
      WHEN R = 18 THEN CALL ROOM18
      WHEN R = 20 THEN CALL ROOM20
      WHEN R = 21 THEN CALL ROOM21
      WHEN R = 22 THEN CALL ROOM22
      WHEN R = 23 THEN CALL ROOM23
      WHEN R = 24 THEN CALL ROOM24
      WHEN R = 26 THEN CALL ROOM26
      WHEN R = 27 THEN CALL ROOM27
      WHEN R = 28 THEN CALL ROOM28
      WHEN R = 29 THEN CALL ROOM29
      WHEN R = 30 THEN CALL ROOM30
      WHEN R = 31 THEN CALL ROOM31
      WHEN R = 32 THEN CALL ROOM32
      WHEN R = 33 THEN CALL ROOM33
      WHEN R = 34 THEN CALL ROOM34
      WHEN R = 35 THEN CALL ROOM35
      WHEN R = 36 THEN CALL ROOM36
      WHEN R = 37 THEN CALL ROOM37
      WHEN R = 39 THEN CALL ROOM39
      WHEN R = 40 THEN CALL ROOM40
      WHEN R = 41 THEN CALL ROOM41
      OTHERWISE SIGNAL END_ROOM
   END
   SAY
   CALL CAN_SEE
   CALL CAN_GO
   CALL COMMAND
END
EXIT
QTIME:
CLEAR_SCR
TIMES='00:00'
IF HOUR>9 THEN TIMES=OVERLAY(HOUR,TIMES,1,2)
ELSE TIMES=OVERLAY(HOUR,TIMES,2,1)
IF MINUTES>9 THEN TIMES=OVERLAY(MINUTES,TIMES,4,2)
ELSE
IF MINUTES<10 THEN TIMES=OVERLAY(MINUTES,TIMES,5,1)
SAY LEFT(LOC.R,34) COPIES(' ',21)'Time: 'TIMES AM_PM
SAY
RETURN
CAN_SEE:
SEE=''
FLG=0
DO I = 1 to TOT_NOUNS
   IF OBJECT.I.2=R THEN SEE = SEE||OBJECT.I.1||'   '
END I
IF SEE='' THEN SEE='Nothing of Interest'
SAY 'You can see: 'SEE
SAY
RETURN
CAN_GO:
GO=''
PARSE UPPER VAR EXIT.R NOR SOU EAS WES UP DOW
IF NOR >0 THEN GO = GO||'NORTH   '
IF SOU >0 THEN GO = GO||'SOUTH   '
IF EAS >0 THEN GO = GO||'EAST   '
IF WES >0 THEN GO = GO||'WEST'
IF UP  >0 THEN GO = GO||'UP   '
IF DOW >0 THEN GO = GO||'DOWN'
IF GO='' THEN GO='???'
SAY 'Obvious exits: 'GO
SAY COPIES('=',70)
Say
RETURN
COMMAND:
N=0
V=0
FLAG=0
IF MSG=0 THEN
DO
   MSG=1
   SAY 'Welcome to 'HI'Search for the Sacred Stone'LO' (Standard Level)'
   SAY '(C)opyright 1986 / 1987 by:  Mikel F. Rice  (CMS0292 @ UWF)'
   SAY 'Ported to OS/2 by Michael J. Antonio (713221.1742@CompuServe.COM)'
   SAY 'Dedicated to: Robert P. Wharran'
   SAY
END
RND=RANDOM(1,6)
IF RND = 1 THEN COMMAND = 'What next?'
IF RND = 2 THEN COMMAND = 'What will you do?'
IF RND = 3 THEN COMMAND = 'Now what?'
IF RND = 4 THEN COMMAND = 'Your request?'
IF RND = 5 THEN COMMAND = 'What do you want to do?'
IF RND = 6 THEN COMMAND = 'What will you try now?'
SAY COMMAND
PARSE UPPER PULL INSTRUCT
SAY
IF INSTRUCT = 'I' THEN INSTRUCT = 'INV'
PARSE VAR INSTRUCT VERBIN NOUNIN
VERB = LEFT(VERBIN,3)
NOUN = LEFT(NOUNIN,3)
IF VERB = 'LOO' & NOUN = '' THEN SIGNAL START
IF (VERB ='NOR' | VERB='SOU') | (VERB ='EAS' | VERB ='WES')
THEN SIGNAL GO
ELSE
IF (VERB= 'N' | VERB= 'S') | (VERB= 'E' | VERB= 'W') THEN SIGNAL GO
ELSE
IF  (VERB='U' | VERB='UP') | (VERB='DOW' | VERB='D') THEN SIGNAL GO
SELECT
   WHEN VERB = 'QUI' THEN SIGNAL QUIT
   WHEN VERB = 'SAV' THEN CALL SAVE
   WHEN VERB = 'LOA' THEN CALL LOAD
   WHEN VERB = 'INV' THEN CALL INVENTORY
   WHEN VERB = 'HEL' THEN CALL HELP
   WHEN VERB = 'SWI' THEN CALL SWING_SWIM
   WHEN VERB = 'SAY' THEN CALL ASK
   WHEN VERB = 'JUM' THEN CALL JUMP
   WHEN VERB = 'VER' THEN CALL VERBS
   WHEN VERB = 'DIG' THEN CALL DIG
   WHEN VERB = 'PAU' THEN PAUSE = NOUN
   OTHERWISE FLAG = 1
END
IF FLAG = 0 THEN SIGNAL DELAY
IF LENGTH(INSTRUCT) < 4 THEN
DO
   SAY "WHAT??? I don't understand that."
   SIGNAL DELAY
END
IF NOUN = '' THEN
DO
   SAY 'That verb requires a NOUN.'
   SIGNAL DELAY
END
IF verb = 'ENT' THEN VERB = 'GO '
IF verb = 'TAK' THEN VERB = 'GET'
IF verb = 'EXA' THEN VERB = 'LOO'
IF verb = 'SMA' THEN VERB = 'BRE'
IF verb = 'BUI' THEN VERB = 'MAK'
IF verb = 'CAR' THEN VERB = 'CUT'
IF verb = 'CHO' THEN VERB = 'CUT'
IF verb = 'ROW' THEN VERB = 'PAD'
IF verb = 'PUS' THEN VERB = 'PRE'
IF verb = 'FIR' THEN VERB = 'SHO'
IF verb = 'LIF' THEN VERB = 'MOV'
IF verb = 'FLI' THEN VERB = 'USE'
IF verb = 'STA' THEN VERB = 'LIG'
IF verb = 'PLA' THEN VERB = 'PUT'
IF verb = 'HIT' THEN VERB = 'KIL'
IF verb = 'ATT' THEN VERB = 'KIL'
V=POS(VERB,VLIST)
N=POS(NOUN,NLIST)
IF V=0 THEN
DO
   SAY "I don't understand that VERB!"
   SIGNAL DELAY
END
ELSE
V =(V%3)+1
IF N=0 THEN
DO
   SAY "I don't understand that NOUN!"
   SIGNAL DELAY
END
ELSE
N =(N%3)+1
SELECT
   WHEN V = 1 THEN SIGNAL GO
   WHEN V = 2 THEN CALL GET
   WHEN V = 3 THEN CALL LOOK
   WHEN V = 4 THEN CALL DROP
   WHEN V = 5 THEN CALL OPEN
   WHEN V = 6 THEN CALL READ
   WHEN V = 7 THEN CALL UNLOCK
   WHEN V = 8 THEN CALL MOVE
   WHEN V = 9 THEN CALL CLIMB
   WHEN V = 10 THEN CALL BREAK
   WHEN V = 11 THEN CALL MAKE
   WHEN V = 12 THEN CALL DIG
   WHEN V = 14 THEN CALL CUT
   WHEN V = 15 THEN CALL PADDLE
   WHEN V = 16 THEN CALL KILL
   WHEN V = 18 THEN CALL RING
   WHEN V = 19 THEN CALL PRESS
   WHEN V = 20 THEN CALL ASK
   WHEN V = 21 THEN CALL GIVE
   WHEN V = 22 THEN CALL PAY
   WHEN V = 23 THEN CALL WEAR
   WHEN V = 25 THEN CALL LIGHT
   WHEN V = 26 THEN CALL USE
   WHEN V = 27 THEN CALL BURN
   WHEN V = 28 THEN CALL THROW
   WHEN V = 30 THEN CALL FEED
   WHEN V = 31 THEN CALL PUT
   WHEN V = 32 THEN CALL SHOOT
   OTHERWISE NOP
END
DELAY:
CALL TIMER
CALL WAIT PAUSE
RETURN
TIMER:
MINUTES=MINUTES+1
IF MINUTES = 60
THEN DO
   MINUTES = 0
   HOUR = HOUR + 1
END
ELSE
IF MINUTES >60 Then
DO
   OVER=MINUTES-60
   HOUR=HOUR+1
   MINUTES=OVER
END
IF HOUR >11 THEN AM_PM='PM'
ELSE AM_PM='AM'
IF MINUTES=0 THEN SAY 'BEEP...BEEP...Your wrist watch chimed!'
RETURN
INVENTORY:
ITEM =''
DO I = 1 TO TOT_NOUNS
   IF  OBJECT.I.2 = 50 THEN ITEM = ITEM||OBJECT.I.1'  '
END I
IF ITEM = '' THEN ITEM = 'NOTHING!'
SAY 'You are carrying: 'ITEM
RETURN
HELP:
IF R=1 THEN SAY 'Try things like examine, Inventory, GO, etc...'
ELSE
IF R=2 THEN SAY "I don't work here?"
ELSE
IF R=3 THEN SAY 'The comics inside are funnier!'
ELSE
IF R=5 THEN SAY 'Does anything here ring a bell?'
ELSE
IF (R=15 | R=16) | R=17 THEN SAY "What's your ticket out of here?"
ELSE
IF R=18 THEN SAY 'Geronimoooo.....'
ELSE
IF R=26 THEN SAY 'That log would MAKE a great dugout CANOE!'
ELSE
IF R=32 THEN SAY 'Technology can be frightening!'
ELSE
DO
   RND=RANDOM(1,11)
   SELECT
      WHEN RND=1 THEN SAY "Can't you do anything on your own?"
      WHEN RND=2 THEN SAY "I'm as confused as you are!"
      WHEN RND=3 THEN SAY "Try examining things..."
      WHEN RND=4 THEN SAY "SAVE OFTEN IN DANGEROUS PLACES!"
      WHEN RND=5 THEN SAY "WHO IS PLAYING THIS GAME, ME OR YOU?"
      WHEN RND=6 THEN SAY "NOT NOW I'M BUSY!"
      WHEN RND=7 THEN SAY "YOU NEED HELP HERE?!"
      WHEN RND=8 THEN SAY "USE YOUR COMMON SENSE!"
      WHEN RND=9 THEN SAY "SAVE OFTEN IN DANGEROUS PLACES!"
      OTHERWISE SAY "Type 'VERBS' for more help!"
   END
END
RETURN
GO:
FLG=0
VB = LEFT(VERB,1)
NN = LEFT(NOUN,1)
IF R>27 & R<31 THEN SAY 'You have to paddle the canoe around!'
ELSE
IF R=17 & (VB='S' | NN='S') & OBJECT.53.2=50 THEN R=44
ELSE
IF R=17 & (VB='S' | NN='S') & OBJECT.24.2\=50 THEN
DO
   SAY "You can't board the plane without a ticket!"
END
ELSE
IF R=17 & (VB='S' | NN='S') THEN
DO
   TRIP=RANDOM(1,10)
   HOUR=HOUR+1
   MINUTES=MINUTES+TRIP
   R=18
END
ELSE
IF R=1 & OBJECT.22.2=0 & NOUN="TAX" THEN 
   SAY "You don't have any money to pay for that."
ELSE
IF N=51 & R=34 & BEAR=0 THEN 
   SAY "The bear won't let you go by!"
ELSE
IF NOUN="CAN" THEN CALL IN_CANOE
ELSE
IF NOUN\="TAX" & (R=1 & TAXI=1) THEN
DO
   SAY 'THE TAXI DRIVER WAS TIRED OF WAITING AND LEFT!'
   TAXI=2
   OBJECT.14.2=0
END
ELSE
DO
   FLG=2
   SELECT
      WHEN NOUN="HOT" & R=1 THEN R=2
      WHEN NOUN="ELE" & R=2 THEN R=6
      WHEN NOUN="SHO" & R=4 THEN R=7
      WHEN NOUN="HUT" & R=22 THEN R=24
      WHEN NOUN="TAX" & R=1 & TAXI=1 THEN R=9
      WHEN NOUN="CAV" & R=32 THEN SAY 'THE NATIVES BLOCK YOUR WAY!'
      WHEN NOUN="CAV" & R=34 THEN R=31
      WHEN NOUN="CAN" THEN CALL IN_CANOE
      WHEN (R=31 & STONE=3) & (VB ='N' | NN='N') THEN R = 32
      WHEN NOR>0 & (VB ='N' | NN='N') THEN R = NOR
      WHEN SOU>0 & (VB ='S' | NN='S') THEN R = SOU
      WHEN EAS>0 & (VB ='E' | NN='E') THEN R = EAS
      WHEN WES>0 & (VB ='W' | NN='W') THEN R = WES
      WHEN (R=40 | R=41) & (VB ='U' | NN='U') THEN R = UP
      WHEN (R=40 | R=41) & (VB ='D' | NN='D') THEN R = DOW
      OTHERWISE FLG = 1
   END
END
IF R=36 & OBJECT.39.2=50 THEN SIGNAL WIN_ROOM
IF FLG=1 THEN
DO
   SAY "You can't go in that direction!"
   SIGNAL DELAY
END
ELSE
CALL TIMER
IF FLG=0 THEN CALL WAIT PAUSE 
SIGNAL START
LOOK:
IF R=13 & N=28 THEN N=60
IF R=12 & N=31 THEN N=61
IF R=13 & N=31 THEN N=62
IF R=31 & N=43 & STONE=0 THEN
DO
   SAY "Wow you see a blue stone of exquiste beauty!!"
   OBJECT.39.2=R
   STONE=1
END
ELSE
IF N=5 & R>20 THEN
DO
   SAY 'A monkey threw a coconut and it hit you hard on the head!'
   COCONUT=COCONUT+1
   IF COCONUT=3 THEN SIGNAL END_ROOM
END
ELSE
IF N>0 & N<7 THEN SAY OBJECT.N.3
ELSE
IF OBJECT.N.2 \= R & OBJECT.N.2 \= 50
THEN SAY "I don't see the "OBJECT.N.1" here now..."
ELSE SAY OBJECT.N.3
RETURN
GET:
COUNT=0
DO I = 1 TO TOT_NOUNS
   IF OBJECT.I.2 = 50 THEN COUNT = COUNT + 1
END I
IF COUNT > 5 THEN
DO
   RND = RANDOM(1,4)
   SELECT
      WHEN RND=1 THEN SAY "You can't carry anymore. Try 'INVENTORY'"
      WHEN RND=2 THEN SAY 'You are carrying too much stuff. Try "INVENTORY"'
      WHEN RND=3 THEN SAY 'You have too much. Try "INVENTORY"'
      WHEN RND=4 THEN SAY 'Your hands are already full! Try "INVENTORY"'
      OTHERWISE NOP
   END
   RETURN
END
IF R=13 & N=28 THEN N=60
IF R=12 & N=31 THEN N=61
IF R=13 & N=31 THEN N=62
IF OBJECT.N.2=50 THEN 
   SAY "You're already carrying that!"
ELSE
IF OBJECT.N.2\=R THEN 
   SAY "I don't see "OBJECT.N.1" here."
ELSE
IF N=19 THEN 
   SAY "Elmo says that isn't for sale."
ELSE
IF N=12 THEN 
   SAY 'The hotel security guard is watching you! Stick to stealing towels.'
ELSE
IF N=40 & SMOKE=0 & OBJECT.40.2=R THEN R=46
ELSE
IF N=39 & (OBJECT.39.2=R & STONE=1) THEN
DO
   SAY 'A stone wall slides closed behind you as you pick up the SACRED'
   SAY 'STONE from the pedestal! It closes off your only escape!'
   OBJECT.39.2=50
   OBJECT.41.2=31
   EXIT.31='0 0 0 0 0 0'
   STONE=2
   CALL WAIT 1
END
ELSE
IF N=34 & (OBJECT.34.2=R & STONE=3) THEN
DO
   SAY 'A stone wall slides closed behind you as you pick up the round'
   SAY 'rock from the pedestal! It closes off your only escape!'
   OBJECT.34.2=50
   OBJECT.41.2=31
   EXIT.31='0 0 0 0 0 0'
   STONE=2
   CALL WAIT 1
END
ELSE
IF CAN.N ='*' THEN
DO
   RND = RANDOM(1,8)
   SELECT
      WHEN RND=1 THEN SAY "Don't be a wiseguy!"
      WHEN RND=2 THEN SAY "Don't be stupid!"
      WHEN RND=3 THEN SAY "You just pulled every muscle in your back!"
      WHEN RND=4 THEN SAY "Ugh! You just can't lift it!"
      WHEN RND=5 THEN SAY "Don't be silly!"
      WHEN RND=6 THEN SAY "You can't carry that around."
      WHEN RND=7 THEN SAY "Only in your dreams..."
      OTHERWISE SAY "Why carry that?"
   END
END
ELSE
IF CAN.N='1' THEN
DO
   OBJECT.N.2=50
   SAY 'Okay! You now have the' OBJECT.N.1
END
RETURN
DROP:
IF OBJECT.N.2\=50 THEN SAY "You aren't holding that."
ELSE
IF N=22 THEN
DO
   SAY 'Some guy grabbed the money and ran off with it!!'
   OBJECT.22.2=0
END
ELSE
IF R=32 & (N=25 | N=39) THEN R=45
ELSE
IF R=31 & (N=39 | N=34) THEN SAY 'Try PUT' OBJECT.N.2
ELSE
DO
   SAY 'Okay! You have dropped the' OBJECT.N.1'.'
   OBJECT.N.2=R
END
RETURN
OPEN:
FLG=0
IF N=10 & OBJECT.N.2=50 & OBJECT.23.2=0 then
DO
   SAY 'Hey! Something fell out of the paper!'
   OBJECT.23.2=R
   FLG=1
END
ELSE
IF N=10 & OBJECT.N.2\=50 then
DO
   SAY "You don't have that item!"
   FLG=1
END
ELSE
IF N=10 & OBJECT.23.2>0 THEN
Do
   SAY 'It is already open!'
   FLG=1
END
IF N=28 & UNLOCKED=0 & (R=12 | R=13) THEN
DO
   SAY 'The lockers are locked!'
   FLG=1
END
ELSE
IF (R=12 & N=28) & (UNLOCKED=1 & OPENED=0) then
DO
   SAY "Something dropped out of the locker!"
   OBJECT.29.2=R
   OPENED=1
   FLG=1
END
ELSE
IF R=12 & N=28 & OPENED=1 then
DO
   SAY "The locker is already open!"
   FLG=1
END
IF N=29 & OBJECT.N.2=50 THEN
DO
   SAY "Oops! The parachute unravels onto the floor! You don't know how to"
   SAY 'repack it so you throw it away! That is some real bad news!!'
   OBJECT.29.2=0
   FLG=1
END
IF N=33 THEN SAY 'If only it was that easy!!'
ELSE
IF FLG=0 THEN SAY "I must be stupid, but I can't open that!"
RETURN
READ:
IF N=30 & (OBJECT.N.2=50 | OBJECT.N.2=R) THEN
DO
   SAY "It reads: Try playing 'The MONDAY Adventure' by Mikel Rice!"
END
ELSE
IF N=27 & (OBJECT.N.2=50 | OBJECT.N.2=R) THEN
DO
   SAY "It reads: To gates 1 through 5"
END
ELSE
IF N=43 & R=31 THEN SAY "You can't translate the markings..."
ELSE
IF OBJECT.N.2\=50 THEN SAY "You can't read it this far away!"
ELSE
IF N=7 then
DO
   SAY 'Hello there. I just want to take this time (1 min.) to wish you'
   SAY 'good luck!  For some extra help type "VERBS"....  Mikel Rice!'
   SAY "PS. By the way...Don't throw rocks!"
   CALL WAIT 3
END
ELSE
IF N=10 THEN SAY 'Headline: Second Man Killed by Muggers this Week!'
ELSE
IF N=23 THEN
DO
   SAY "Coupon reads: Elmo's Pawn shop redeemable for item #112665!"
END
ELSE
IF N=24 THEN SAY "It reads: Chad's Charter Service. Boarding at gate #4"
ELSE SAY 'How can you read that?'
RETURN
UNLOCK:
IF R=12 & UNLOCKED=1 THEN SAY 'The locker is already unlocked!'
ELSE
IF (R=12 | R=13) & OBJECT.11.2\=50 THEN SAY "You don't have the key!"
ELSE
IF R=12 & (UNLOCKED=0 & OBJECT.11.2=50) THEN
DO
   SAY 'What locker number?'
   PULL NUMBER
   IF NUMBER=26 THEN
   DO
      SAY "The key fits. You turn it and unlock the locker."
      UNLOCKED=1
   END
   ELSE
   DO
      SAY 'Oops! You put the key in the wrong locker and it broke!'
      OBJECT.11.2=0
   END
END
ELSE
IF R=13 THEN
Do
   SAY 'Oops! You put the key in the wrong locker and it broke!'
   OBJECT.11.2=0
END
ELSE SAY "I must be stupid, but I can't unlock that!"
RETURN
MOVE:
IF OBJECT.N.2\=R THEN SAY "I don't see that here."
ELSE
IF N=19 THEN SAY 'Hey look...the floor!'
ELSE
IF CAN.N='*' THEN
DO
   RND=RANDOM(1,4)
   SELECT
      WHEN RND=1 THEN SAY "You try but it just won't move"
      WHEN RND=2 THEN SAY "You struggle but it won't budge."
      WHEN RND=3 THEN SAY "Fat chance!"
      OTHERWISE SAY "Superman you're not...it didn't move!"
   END
END
ELSE SAY "OKAY...you moved it but nothing happened."
RETURN
CLIMB:
IF R=37 & N=42 THEN
DO
   SAY 'Ugh...That was hard work....'
   R=41
END
ElSE
IF R=39 & N=42 THEN
DO
   SAY 'PANT...That was a tough climb....'
   R=40
END
ELSE
IF N=45 | N=59 THEN SAY 'Why not just swing on it instead?!'
ELSE
IF (R=40 | R=41) & (VB ='U' | NN='U') THEN R = UP
ELSE
IF (R=40 | R=41) & (VB ='D' | NN='D') THEN R = DOW
ELSE SAY 'Why do you want to climb that?'
RETURN
BREAK:
IF N=25 & OBJECT.N.2=50 THEN
DO
   SAY 'You cracked it and all the fliud ran out! You throw it away!'
   OBJECT.N.2=0
END
ELSE
IF N=25 & OBJECT.N.2\=50 THEN SAY "I don't have that."
ELSE
IF N=28 THEN SAY "Oww..You hurt your hand."
ELSE
IF N=33 THEN SAY "The bamboo is stronger than you!"
ELSE SAY "Don't be so destructive!!"
RETURN
MAKE:
IF CANOE=0 & (OBJECT.35.2=50 & OBJECT.37.2=R) THEN
DO
   SAY 'Chop...Hack...carve... Whew! After working nearly 30 minutes'
   SAY 'you finally complete the dugout canoe, but the axe broke!'
   OBJECT.35.2=0
   OBJECT.38.2=R
   OBJECT.37.2=0
   TRIP=RANDOM(1,8)+21
   MINUTES=MINUTES+TRIP
   CANOE=1
END
ELSE
IF CANOE=0 & (OBJECT.35.2\=50 | OBJECT.37.2\=R)
THEN SAY "You don't have enough material to make a canoe."
ELSE
IF CANOE=1 THEN SAY 'You have already made a canoe.'
ELSE
SAY "I must be stupid, but I just don't understand you!"
RETURN
DIG:
IF R\=36 & OBJECT.36.2=50 THEN SAY "You dig a deep hole but find only dirt!"
ELSE
IF OBJECT.36.2\=50 THEN SAY "You don't have a shovel!"
ELSE
IF ROCK=0 THEN
DO
   SAY 'You dug a small hole but found nothing...'
   SAY 'Wait! Look there is something...'
   ROCK=1
   OBJECT.34.2=R
END
ELSE
IF ROCK=1 THEN
DO
   SAY "Look! More dirt!"
   ROCK=2
END
ELSE
IF ROCK=2 THEN SAY 'Trying to dig through to China??'
RETURN
CUT:
IF N=37 & OBJECT.35.2=50 & R=26 THEN 
   SAY 'THERE ARE LOTS OF WAYS TO CUT THE LOG!'
ELSE
IF OBJECT.35.2=50 THEN
DO
   SAY 'Ouch! The only thing you cut was your finger!'
   SAY "Don't be so destructive!!"
END
ELSE SAY "You don't have anything to cut with!"
RETURN
PADDLE:
IF R<28 | R>30 THEN SAY "You aren't in the canoe!"
ELSE
IF OBJECT.36.2\=50 THEN SAY "You don't have anything to paddle with!"
ELSE
IF N=38 THEN SAY 'Use a direction like PADDLE WEST!'
ELSE
DO
   SAY 'You use the shovel to paddle the canoe...'
   NN=LEFT(NOUN,1)
   SELECT
      WHEN R=30 & NN='S' THEN
      DO
         R=SOU
         OBJECT.38.2=R
      END
      WHEN R=29 & NN='N' THEN
      DO
         R=NOR
         OBJECT.38.2=R
      END
      WHEN NOR>0 & NN='N' THEN R = NOR
      WHEN SOU>0 & NN='S' THEN R = SOU
      WHEN EAS>0 & NN='E' THEN R = EAS
      WHEN WES>0 & NN='W' THEN R = WES
      OTHERWISE SAY "You can't paddle in that direction!"
   END
END
RETURN
IN_CANOE:
IF CANOE=0 THEN SAY "I haven't seen a canoe anywhere!"
ELSE
IF OBJECT.38.2\=R THEN SAY "The canoe isn't here!!!"
ELSE
IF OBJECT.36.2\=50 THEN
DO
   SAY "You have nothing to use as a paddle. If you went out into the river"
   SAY "now you would be 'Up the creek' so to speak!"
END
ELSE
IF R=26 THEN R=29
ELSE
IF R=33 THEN R=30
RETURN
KILL:
IF (N=20 | N=21) THEN SAY "Try SHOOT instead..."
ELSE
IF N=44 & OBJECT.N.2=R THEN SAY "The bear would rip you to shreds!"
ELSE
IF N=47 & R=32 THEN SAY "31 to 1! I think the odds are even! (HA HA)"
ELSE SAY 'This proves mankind is basically evil!'
RETURN
RING:
IF N\=12 THEN SAY 'I have no idea how to ring that!?'
ElSE
IF R\=5 THEN SAY "You can't do that...yet!"
ELSE
IF TAXI=0 THEN
DO
   SAY "Ding! Momentarily Mr. Brooks appears. He recognizes you and says,"
   SAY "'The taxi you called to take you to the airport is waiting outside!'"
   SAY "He wishes you a safe trip then returns to his work."
   OBJECT.14.2=1
   TAXI=1
   CALL WAIT 4
END
ELSE SAY "The taxi won't wait all day!"
RETURN
PRESS:
IF N=12 THEN SAY 'Try RINGing the bell instead!'
ELSE
IF N=15 THEN 
   SAY 'Use the numbers ONE, TWO, or THREE (in word form) to use the bell.'
ELSE
IF N=16 THEN SAY 'You are already on the first floor!'
ELSE
IF (N=17 | N=18) THEN R=43
ELSE
IF N=25 THEN SAY 'Try USE or FLICK lighter.'
ELSE SAY 'Lot of good that did!!'
RETURN
ASK:
IF R=7 THEN
DO
   RND=RANDOM(1,3)
   IF RND=1 THEN SAY "Elmo says, 'Do you have a coupon for me?'"
   ELSE
   IF RND=2 THEN SAY "Elmo says, 'I need your coupon.'"
   ELSE SAY "Elmo says, 'Give me your coupon!'"
END
ELSE
IF R=9 THEN
DO
   RND=RANDOM(1,3)
   IF RND=1 THEN 
      SAY "Fred says, 'Here you are mac. That'll be $19.38 please.'"
   ELSE
   IF RND=2 THEN 
      SAY "Fred says, 'This is the place bud. $19.62 for the ride.'"
   Else Say "Fred says, 'Yer here...there is $19.48 on the meter.'"
END
ELSE
IF R=5 & TAXI=0 THEN SAY "JUST RING THE BELL FOR SERVICE."
ElSE
IF R=5 & TAXI=1 THEN SAY 'MR. BROOKS IS BUSY AT THE MOMENT.'
ELSE
IF R=32 THEN SAY 'The natives look at each other and laugh. They mock you.'
ELSE SAY 'I see no one to talk to!'
RETURN
GIVE:
IF (N=22 | N=21) THEN SAY 'Use PAY for monetary transactions.'
ELSE
IF OBJECT.N.2\=50 THEN SAY "You don't have that to give!"
ELSE
IF R=7 & (N=23 | N=20) & LIGHTER=0 THEN
DO
   SAY 'Elmo takes the coupon and places something on the counter.'
   OBJECT.23.2=0
   OBJECT.25.2=R
   LIGHTER=1
END
ELSE
IF R=7 & LIGHTER=1 THEN SAY 'He is busy now.'
ELSE
IF (R\=32 & R\=34) & (R\=7 & R\=9) THEN 
   SAY "There is no one here to give anything."
ELSE
IF R=34 & (N=44 | N=40) THEN 
   SAY "You can't get close enough to the bear to do that"
ELSE
IF R=32 & (N\=25 | N\=39) THEN
DO
   SAY "The natives examine it then toss it on the ground!"
   SAY "I guess they didn't want it after all!"
   OBJECT.N.2=34
END
ELSE
IF R=32 THEN R=45
ELSE SAY 'Nobody wants that!'
RETURN
PAY:
IF (N=21 | N=22) & OBJECT.22.2=50 THEN
DO
   SAY "Fred says, 'Thanks. I will keep the change!' and he drives off."
   OBJECT.22.2=0
   TRIP=RANDOM(1,5)+5
   MINUTE=MINUTES+TRIP
   R=10
END
ELSE
IF N=20 THEN SAY "Elmo says, 'I want the coupon not the money!'"
ELSE SAY 'Try using GIVE!'
RETURN
WEAR:
IF N=29 & OBJECT.N.2=50 THEN
DO
   SAY 'Okay you are wearing the PARACHUTE!'
   TAXI=3
END
ELSE SAY 'You would look silly wearing that!!'
RETURN
JUMP:
IF R=40 | R=41 THEN SAY "You can't jump that far safely!!"
ELSE
IF R=18 & OBJECT.29.2=50 & TAXI=3 THEN
DO
   SAY 'You jump out of the plane and drift safely toward the ground. You'
   SAY 'lost some things as you jumped and they hurtle downward. Bonk! You'
   SAY 'hit your head on a tree branch and pass out! When you wake you are...'
   R=20
   IF OBJECT.25.2=50 THEN OBJECT.25.2=27
   DO LOOP = 1 TO 30
      IF OBJECT.LOOP.2=50 THEN OBJECT.LOOP.2=0
   END LOOP
   TRIP=RANDOM(1,5)+3
   MINUTES=MINUTES+TRIP
   CALL WAIT 6
END
ELSE
IF R=18 & (OBJECT.29.2\=50 | TAXI\=3) THEN R=47
ELSE
IF R=20 & TAXI=3 THEN
DO
   SAY 'The bamboo cage shakes violently and the thin rope holding it'
   SAY "stretches taunt but doesn't break!"
   TAXI=4
END
ELSE
IF R=20 & TAXI=4 THEN
DO
   SAY 'Snap! The thin rope breaks under your weight! The cage smashes'
   SAY 'against the ground and breaks apart. You roll away unharmed!'
   R=27
   TAXI=5
END
ELSE
DO
   RND=RANDOM(1,3)
   IF RND=1 THEN SAY 'Your advancing in leaps and bounds!'
   ELSE
   IF RND=2 THEN SAY "This isn't a Toyota commercial!"
   ELSE SAY 'Boy...what a great jump!'
END
RETURN
LIGHT:
IF N=25 THEN SAY 'Try USE or FLICK for lighting only the lighter!'
ELSE
IF (N\=48 & N\=49) THEN SAY 'You might be able to BURN it!'
ELSE
IF OBJECT.25.2\=50 THEN SAY "You don't have the lighter!"
ELSE
IF LIGHTER>5 THEN SAY "Oh darn! The lighter is empty!"
ELSE
IF OBJECT.49.2\=50 THEN SAY "You don't have the piece of wood!"
ELSE
IF R\=35 THEN
DO
   SAY "Using the lighter you get the damp piece of wood to catch fire."
   SAY "The damp wood creates a billowing cloud of smoke and burns up!"
   OBJECT.49.2=3
   LIGHTER=LIGHTER+1
   CALL WAIT 1
END
ELSE
DO
   SAY 'Using the lighter you manage to get the damp piece of wood to',
       'catch fire'
   SAY 'The damp wood creats a billowing cloud of thick white smoke.'
       'The smoke'
   SAY 'drives all the honeybees away from the hive! Good Job!!'
   LIGHTER=LIGHTER+1
   SMOKE=1
   OBJECT.49.2=0
   CALL WAIT 2
END
RETURN
USE:
IF N\=25 THEN SAY 'Use it how? Please be more specific!'
ELSE
IF OBJECT.25.2\=50 THEN SAY "You don't have the lighter!!"
ELSE
IF LIGHTER>5 THEN SAY 'Oh no! The lighter is empty!!'
ELSE
IF R=32 THEN
DO
   SAY 'The natives see you make fire and they run off in fear of such a'
   SAY 'powerful fire god! You may want to come back later to be king!'
   STONE=4
   LIGHTER=LIGHTER+1
   R=34
END
ELSE
DO
   SAY 'Flick...an orange flame burns briefly then goes out.'
   LIGHTER=LIGHTER+1
END
RETURN
BURN:
IF OBJECT.25.2\=50 THEN SAY "You don't have the lighter."
ELSE
IF (OBJECT.N.2\=50 & OBJECT.N.2\=R) THEN SAY "That isn't around here!"
ELSE
IF LIGHTER>5 THEN SAY 'Oh no! The lighter is empty!'
ELSE
IF N=49 THEN SIGNAL LIGHT
ELSE
IF (N=10 | N=22) | ( N=23 | N=24) | (N=30 | N=7) THEN
DO
   IF OBJECT.N.2=50 THEN
   DO
      SAY 'Ow..ow..ouch! You burned the' OBJECT.N.1 'while you were holding'
      SAY 'it! You burnt you hand slightly!'
      OBJECT.N.2=0
      LIGHTER=LIGHTER+1
   END
   ELSE
   DO
      SAY 'It burned up in seconds!'
      OBJECT.N.2=0
      LIGHTER=LIGHTER+1
   END
END
ELSE
IF (N=26 | N=50) | N=52 THEN SAY 'That would be arson!!'
ELSE SAY 'Are you a pyromaniac??'
RETURN
THROW:
IF OBJECT.N.2\=50 THEN SAY "You can't throw what you don't have!"
ELSE
IF N=34 & R\=31 THEN
DO
   SAY 'Wow what a great throw. The rock sails out of sight!'
   OBJECT.34.2=0
   ROCK=2
END
ELSE
IF (N=35 | N=36) | N=53 THEN SAY "No someone could get hurt!!"
ELSE
IF N=40 & R=34 & BEAR=0 THEN
DO
   SAY 'You throw the hive toward the bear. The hive hits the ground in front'
   SAY 'of the bear and it breaks open! The bear grabs the hive full of honey'
   SAY 'with his teeth and wanders off to eat it.'
   OBJECT.44.2=0
   OBJECT.40.2=0
   BEAR=1
   CALL WAIT 1
END
ELSE
IF R=32 & N=25 THEN R=45
ELSE
DO
   SAY "It didn't go very far."
   OBJECT.N.2=R
END
RETURN
SWING_SWIM:
IF (R>25 & R<30) | R=33 THEN SAY 'THE GATORS WOULD TEAR YOU TO BITS.'
ELSE
IF R=40 THEN
DO
   SAY 'UUUUUUGGGHHHHOOOOO! Tarzan eat your heart out!'
   R=41
END
ELSE
DO
   IF R=41 THEN
   DO
      SAY 'Wheeee... You swing across on the vine!'
      R=40
   END
   ELSE SAY 'Try rephrasing that or use another verb!'
END
RETURN
FEED:
IF N=44 THEN SAY "You can't get too close...Throw him something!"
ELSE
IF N=20 | N=21 THEN SAY 'You have nothing' OBJECT.N.1 'wants to eat!'
ELSE SAY "You are grasping at straws! Be reasonable."
RETURN
PUT:
IF R\=31 THEN SAY "Just DROP it...."
ELSE
IF STONE=2 & N=39 THEN
DO
   SAY 'As you put the SACRED STONE back on the pedestal the stone',
       'wall slides'
   SAY 'open leaving you a way out!'
   STONE=1
   OBJECT.39.2=R
   OBJECT.41.2=0
   EXIT.31='0 34 0 0 0 0'
   CALL WAIT 2
END
ELSE
IF R=31 & N=34 & STONE=2 THEN
DO
   SAY 'After you placed the rock on the pedestal the stone wall slide open'
   SAY 'leaving you an exit from the cave!'
   STONE=3
   OBJECT.34.2=R
   OBJECT.41.2=0
   EXIT.31='0 32 0 0 0 0'
   CALL WAIT 2
END
ELSE
DO
   SAY 'OK! Nothing seems to happen!'
   OBJECT.N.2=R
END
RETURN
SHOOT:
IF N=53 THEN SAY 'Shoot gun at who? Try SHOOT name.'
ELSE
IF OBJECT.53.2\=50 THEN SAY "You don't have the gun!"
ELSE
IF OBJECT.N.2\=R THEN SAY "I don't see" OBJECT.N.1 "around here!"
ELSE
IF (N=20 | N=21) & (OBJECT.53.2=50 & OBJECT.N.2=R) THEN R=48
ELSE R=44
RETURN
ROOM1:
SAY 'You are standing in front of the three story Royal Ritz hotel. There is'
SAY 'a red carpet rolled out from the door. Overhead is a red and',
    'white awning'
SAY 'that reaches out to the street. Several taxi cabs come and go picking up'
SAY 'and dropping off passengers. A well dressed doorman waits to let you in.'
RETURN
ROOM2:
SAY 'The lobby of the Royal Ritz hotel is elegantly furnished. Luxurious Oil'
SAY 'paintings line the walls and bronze statues flank the doors.',
    'Potted palms'
SAY 'add to the beauty of the lobby. The floor is made of white and',
    'black marble'
SAY 'arrange in a checkerboard pattern. To the north is the front desk.'
RETURN
ROOM3:
SAY 'You walk slowly away from the hotel toward the east. The quality of the'
SAY 'neighborhood has rapidly decreased. Here the sidewalk is old and cracked'
SAY 'with thick grass growing out through the cement cracks. There is garbage'
SAY 'strewn along the streets and there is graffitti sprayed on every',
    'building.'
RETURN
ROOM4:
SAY 'The sidewalk in front of the store has been swept clean and there is no'
SAY 'trash around save for that in the nearby wire garbage can. A blue neon'
SAY 'sign sits in the window flashing OPEN. You peer in the window at all the'
SAY 'various junk. (You know what they say about the eye of the beholder!)'
RETURN
ROOM5:
SAY 'You lean on the front desk as you wait for service. You notice that the'
SAY 'desk is neat and everything is organized. On the wall is a row of boxes'
SAY 'for messages and some keys hanging on a peg board. You notice that your'
SAY 'bill is laying out and stamped paid.'
RETURN
ROOM6:
SAY 'The elevator is decorated in the same fashion as the lobby. A plaque on'
SAY 'the wall warns of No Smoking allowed in the elevator. A speaker in the'
SAY 'ceiling plays the soft sounds of contemporary music and you begin',
    'to hum.'
RETURN
ROOM7:
SAY 'You stand amidst the row of shelves and bins that are cluttered',
    'with every'
SAY 'item you could think of. You rumage around vowing to come back later'
SAY 'when you have more time. You notice a man standing behind a protective'
SAY 'barred window. He asks you if you need anything specific.'
RETURN
ROOM8:
SAY 'You walked in to the really rough section of town! Some members of the'
SAY 'Red Blood gang saw you walking on their turf and they wasted you! The'
SAY 'morning edition of the newspaper read, "Third man killed by Muggers!"'
RETURN
ROOM9:
SAY 'You sit back and watch as the taxi manuvers through the busy city',
    'streets.'
SAY 'Several times you close your eyes in fear as the taxi skids to a',
    'halt just'
SAY 'scant inches from a daring pedestrian. You look out the door at',
    'all dents'
SAY 'in the taxi and begin to pray silently. You open your eyes to find that'
SAY 'you have pulled up to the airport. The driver turns and looks at you.'
RETURN
ROOM10:
SAY 'You are standing at the main entrances of the international airport. A'
SAY 'soft female voice crackles through a speaker warning that the white zone'
SAY 'is for unloading only. This is followed by a deep male voice noting that'
SAY 'the red zone is a fire lane and no parking is allowed there. A stream of'
SAY 'people flow hurriedly in and out of the airport.'
RETURN
ROOM11:
SAY 'You at the main junction in the airport. Announcement of arriving and'
SAY 'departing flights can barely be heard over the hustle and bustle.',
    'Workers'
SAY 'shuffle back and forth carrying luggage for tips. You notice the baggage'
SAY 'carousels to the east and west as well as some rent-a-lockers.'
RETURN
ROOM12:
SAY 'You are at the east end of the passenger area. A tired mom is asleep in'
SAY 'her chair and her young daughter sits playing in the makeup case. Two'
SAY 'older children are sitting quietly playing cards. Several people rush by'
SAY 'not bothering to apologize for bumping into you.'
RETURN
ROOM13:
SAY 'You are at the west end of the passenger area. A custodial worker sweeps'
SAY 'up cigarette butts of the floor. You notice the throng of businessmen'
SAY 'talking excitedly on the payphones. A speaker blares a page for some'
SAY 'Mr. Orthulon to come to the information desk. You notice there are no'
SAY 'empty chairs for you to sit in.'
RETURN
ROOM14:
SAY 'The passenger lounge is crowded with tired travelers. A long-haired',
    'hippy'
SAY 'softly plays a song on his guitar and some little children sit',
    'around him'
SAY 'smiling and laughing. You glance out the large windows toward the runway'
SAY "where a large 747 is taxiing for takeoff."
RETURN
ROOM15:
SAY 'The departure area is less crowded as most people have already',
    'boarded the'
SAY 'planes. You hear the loud whin of a turbine engine as a 747 lifts',
    'off the'
SAY 'runway. You see several departure gates. Signs show gate 1 as straight'
SAY 'ahead while gate 2 and 3 are to the east and gate 4 and 5 are to',
    'the west.'
SAY 'A late passenger goes through the metal detector and boards the plane.'
RETURN
ROOM16:
SAY 'The departure gate 2 is to the south and departure gate 3 is to',
    'the east.'
SAY 'A good-looking flight attendant walks by and disappears down the gate 3'
SAY 'corridor. A grandmother kisses a visiting grandson goodbye.'
RETURN
ROOM17:
SAY 'The departure area is quiet save for your echoing footsteps. You look'
SAY 'out the window at the baggage cart driving by. You notice the departure'
SAY 'gate 4 to the south and gate 5 to the west. You glance at your watch'
SAY 'and realize you need to hurry.'
RETURN
ROOM18:
SAY "You board Chad's small two-engine plane and then taking a seat you fall"
SAY 'asleep. When you awaken you notice you are flying over a thick green'
SAY 'jungle. You notice a river snaking through the dense jungle. Chad tells'
SAY 'you this is the place. A feeling of excitment wells up inside you.'
RETURN
ROOM19:
RND=RANDOM(1,2)
IF RND=1 THEN
DO
   SAY "You realized that you boarded the wrong plane but it's too late the"
   SAY "plane has already taken off. If that wasn't bad enough the plane was"
   SAY 'hi-jacked. They killed you to show the police they were serious!'
END
ELSE
DO
   SAY 'You boarded the wrong airplane. Before you could get off the',
       'plane, It was'
   SAY 'off the ground. You enjoyed the in-flight movie but the food made you'
   SAY 'deadly sick...and I mean deadly!!'
END
RETURN
ROOM20:
SAY 'You are in a bamboo cage suspended a few feet off the ground by a woven'
SAY 'rope. You yank and tug at the bamboo poles and they only bend sligthly'
SAY "but don't break. You look around and can see a hut, a garden, and even"
SAY 'a river but the cage is twirling in the gentle breeze and your sense'
SAY 'of direction is confused.'
RETURN
ROOM21:
SAY 'You walk cautiously around the area until you decide that no one is here'
SAY 'but you and then you relax. You notice that there is no fire in the pit'
SAY 'only black ashes and charcoaled remains of wood. There are footprints'
SAY 'all around the pit. You summize this is a nigthly meeting place and then'
SAY 'glance at the sun. You decide it might not be safe to stay here to long.'
RETURN
ROOM22:
SAY 'A small thatch hut stands among the blades of tall grass. It is',
    'made from'
SAY 'dried mud and long blades of thatch and grass. The opening is covered by'
SAY 'a tanned animal skin. The dark green jungle provides the perfect',
    'backdrop.'
SAY "There doesn't appear to be anyone home but you prepare to run just",
    "in case!"
RETURN
ROOM23:
SAY 'The garden is full of tall green plants a winding vines. The natives',
    'must'
SAY 'must spend many hours tending to it. Most of the plants have not yet',
    'began'
SAY 'to produce crops but the plants have many blooms. Honeybees buzz around'
SAY "the flowering plants gathering pollen."
RETURN
ROOM24:
SAY 'You are in the thatch hut. It is cool in here, almost comfortable. You'
SAY 'notice that the hut is mostly empty save for the woven bedmats.',
    'There are'
SAY 'some crude pottery formed containers for which you have no use.'
RETURN
ROOM25:
RND=RANDOM(1,4)
IF RND=1 THEN
DO
   SAY 'While trying to find your way around in the dense jungle you stumble'
   SAY 'on to a hidden village. Unfortunately the villagers want it to stay'
   SAY 'hidden! They insist that you stay for dinner...as the main course!'
END
ELSE
IF RND=2 THEN
DO
   SAY 'While walking around in the dense jungle you come face to face with a'
   SAY 'a group of headhunters. Your body falls to the ground minus a',
       'head, but'
   SAY 'look on the bright side! You will be the only american head in their'
   SAY 'collection!'
END
ELSE
IF RND=3 THEN
DO
   SAY 'You wander in to the dense jungle and suddenly realize that you',
       'are lost'
   SAY 'While walking around you discover that the jungle is crawling',
       'with large'
   SAY 'pythons and boa constrictors. Unfortunately they are now crawling all'
   SAY 'over you.... (squeeze)!'
END
ELSE
DO
   SAY 'Aarrggghhh!! You fell in to a deep pit used by hunters to catch',
       'dangerous'
   SAY 'animals. Just your luck! The pit is already occupied by a huge hungry'
   SAY 'Lion....well he is no longer hungry!'
END
RETURN
ROOM26:
SAY 'You are in a grassy clearing to the south of the village center. Nearby'
SAY 'a muddy brown river flows slowly along on a course for nowhere. You know'
SAY 'that it just recently rained since the water is muddy. You notice there'
SAY 'are wood chips littering the area. It must be a workarea for the',
    'natives.'
SAY 'A loud roar comes from the dense jungle that is just west of here.'
RETURN
ROOM27:
SAY 'This is the center of a small native village. Several thatch huts are'
SAY 'scattered about and most of them are farther than you care to walk at'
SAY 'the moment. There is one hut close by to the east. With a swift kick'
SAY 'you send a broken piece of the bamboo cage skidding throught the dirt.'
RETURN
ROOM28:
SAY 'The muddy water flows slowly past the dugout canoe. You look down in the'
SAY 'water beside the canoe and see a large alligator lurking just below the'
SAY 'the murky surface. You duck down to avoid a large overhanging tree',
    'branch.'
SAY 'You notice a huge python resting on the branch as you drift past the'
SAY "water seems to be quickening it's pace to the west."
RETURN
ROOM29:
SAY 'You are drifting lazily on the river. A gentle breeze ripples over the'
SAY 'sleepy waters. Overhead the hot yellow sun sends rays of light beating'
SAY 'down on to the earth. To the north you see a landing on the bank. To'
SAY 'the south you see a partial path leading up the bank into the dark rain'
SAY 'forest. You paddle a few strokes to stop from drifting into a rock.'
RETURN
ROOM30:
SAY 'You ease the canoe through the murky waters. You hear thrashing in',
    'the tall'
SAY 'grasses on the far bank and see two alligators fighting. The whole',
    'scene is'
SAY 'out of a National Geographic Magazine. You sit back soaking up the',
    'natural'
SAY 'beauty and wonder how long it will be til civilazation comes to',
    'destroy it!'
SAY 'You notice a fairly worn path leading up the south enbankment.'
RETURN
ROOM31:
SAY 'You are in a round cavern of the cave. The air is cold and damp.',
    'The cave'
SAY 'ends here and the only exit is the way you came in. A sparse amount of'
SAY 'light filters in from several little hole in the cave ceiling. The light'
SAY 'focuses upon a stone pedestal in the center of the cavern. There is some'
SAY 'some writing carved on it but you have no idea of what it says.'
RETURN
ROOM32:
SAY 'You emerge from the cave with the Sacred Stone in hand! You pause for a'
SAY 'short moment to dust off you clothes. Suddenly a big group of unfriendly'
SAY 'natives spring from the thick shrubs that grow around the cave.',
    'They weild'
SAY 'spears which they hold pointed at you. You swallow hard...'
RETURN
ROOM33:
SAY 'You stand on a dirt path on the bank of a muddy river. A dugout',
    'canoe sits'
SAY 'between the tall grasses of the shoreline. You hear loud squaking',
    'bird crys'
SAY 'coming from the rain forests to the east and west. Spots of shade cross'
SAY 'the path where large green leafy trees grow near the path. There are'
SAY 'patches of mud left from the recent heavy rains.'
RETURN
ROOM34:
SAY 'You are just outside of a partial hidden cave. Thick underbrush and',
    'shrubry'
SAY 'grow around the entrance. There are animal tracks leading in and out',
    'of the'
SAY "cave. The tracks belong to a bear. Hmm...you didn't realize that bears"
SAY "lived in the jungle! (I guess they don't but in this game they do!)"
RETURN
ROOM35:
SAY 'The field is growing with a variety of flowers, grass, and weeds.',
    'You walk'
SAY 'over a small thicket bush and are thankful for your hiking boots. A lone'
SAY 'knarled tree supports a few bee hives. One hive is fairly large and'
SAY 'is highest up on this relatively short, but unclimbable tree. There is'
SAY 'a smaller hive within reach. Bees fly in and out of the hive seemingly'
SAY 'not bothered by your presence.'
RETURN
ROOM36:
IF STONE=2 THEN SIGNAL WIN_ROOM
ELSE
DO
   SAY 'You stand in a beautiful field of fresh colored green grasses. A',
       'welcome'
   SAY 'breeze flows over the field making the grasses move like the',
       'ocean waves'
   SAY 'High overhead billowy white clouds float gracefully by playing',
       'cat and'
   SAY 'mouse with the fiery sun. The ground is soft here. you feel a',
       'deep peace'
   SAY 'build up inside you. You take in a big gulp of fresh clean air.'
END
RETURN
ROOM37:
SAY "You find yourself in a slightly wooded area just at the jungle's edge."
SAY 'The jungle get dense very quickly as it continues to the west. To the'
SAY 'north grows some thick shrubs. some of the shrubs are taller than you!'
SAY 'A bird sings from his lofty perch high above.'
RETURN
ROOM38:
SAY 'You stumbled into a pit of quicksand. All of the heavy rain has turned'
SAY 'the ground here to mush. Before you could understand what had happened'
SAY 'you were leg deep in the mire. You struggle in vain reaching out for a'
SAY 'low branch causing yourself to sink deeper. You should have been more'
SAY 'careful! The muck closes over you and all is still...'
RETURN
ROOM39:
Say "You are in a natural clearing. It isn't actually a clearing but",
    "more like"
SAY 'the plains. Trees and shrubs are scattered here and there. A lizard',
    'darts'
SAY 'off in search of a cool place to rest. The dirt grinds under your heavy'
SAY 'boots. You wipe the sweat from your forehead with your hand.'
RETURN
ROOM40:
SAY 'Like a monkey you scampered up the tree. Memories of climbing',
    'Pecan trees'
SAY 'as a boy come flooding back to your mind. You smile thinking back,',
    'but all'
SAY 'too quickly snap to as you slip and almost fall from the tree. A cluster'
SAY 'of vines climb up the tree. You see monkeys playing in some trees off'
SAY 'closer to the jungle. You hold the tree close and catch your breath.'
RETURN
ROOM41:
SAY 'You balance yourself on a sturdy branch. A bird takes flight alarmed by'
SAY 'your intrusion. You grip the nearest branch tigthly as a sligth breeze'
SAY 'cause the tree to sway. A number of vines snake off in many different'
SAY 'directions. You peer through the green foilage at a tree across the way.'
RETURN
ROOM42:
RND=RANDOM(1,3)
IF RND=1 THEN
DO
   SAY 'While you were watching a jaguar stalk along the shore of the river'
   SAY 'you let the dugout canoe drift over a 100 foot waterfall with you',
       'still'
   SAY 'in it! You were smashed against the rocks below! Tsk...Tsk!'
END
ELSE
IF RND=2 THEN
DO
   SAY 'You leaned back in the canoe and let it drift along as you',
       'watched the'
   SAY 'clouds form into weird shapes. The canoe soon drifted down into some'
   SAY 'white water rapids. Striking some rocks the canoe rolled over',
       'throwing'
   SAY 'you out. The river dragged you along underwater and you drown!'
END
ELSE
DO
   SAY 'You paddled the canoe into a overhanging branch. You stood up to',
       'push off'
   SAY 'of the limb, but unfortunately you fell out of the canoe and it',
       'floated'
   SAY 'out of reach before you could get to it. Too bad the alligators',
       'got you'
   SAY 'before you could get out of the river! (Burp)'
END
RETURN
ROOM43:
SAY 'After you pushed the button the elevator engine began to whine and you'
SAY 'were thrown to the floor as the elevator tilted to one side. The cable'
SAY 'snapped and the elevator crashed down into the basement. You were killed'
SAY 'in the impact. You should have LOOKed at the elevator and you would have'
SAY 'seen that the elevator was out of order!'
RETURN
ROOM44:
IF V=32 THEN
DO
   SAY "Bang! You fire of a shot from your gun! Luckily you didn't injure",
       "or kill"
   SAY "anyone! The police came and arrested you for using a firearm in",
       "a public"
   SAY 'place. You spend the night in a dirty jail cell.'
END
ELSE
DO
   SAY 'The metal detector went off and the guards had to frisk you. They',
       'found'
   SAY 'the hand gun and placed you under arrest. You spent the night in jail!'
END
LOST=3
RETURN
ROOM45:
SAY "The natives got tired of watching you squirm around. You violated the"
Say "sacred religious shrine. You are quickly riddled with several spears."
SAY "needless to say, you didn't get your degree!!"
RETURN
ROOM46:
SAY 'A large swarm of angry honeybees emerge from the hive. Dropping the hive'
SAY 'you run like crazy all the way to the river where you jumped in.',
    'You leap'
SAY 'right in fron of an alligator...(burp)! Next time look before you leap!'
RETURN
ROOM47:
SAY 'SPPLLAATTT! You wind up a bloody smear on the ground! Next time wear the'
SAY 'parachute! I guess you will know better in your next life!'
RETURN
ROOM48:
SAY 'Bang! Bang! Bang! You put three holes into' OBJECT.N.1 'before you',
    'drop the'
SAY 'smoking gun.' OBJECT.N.1 'staggers back hitting the wall. His body',
    'falls'
SAY 'to the floor leaving a red smear down the wall. Blood drips out of his'
SAY 'mouth and puddles on the floor. A pair of police officers rush in and'
SAY 'place you under arrest!!! You spend many years in the slammer!!'
SAY
LOST=3
RETURN
END_ROOM:
CLEAR_SCR
SAY LEFT(LOC.R,34) COPIES(' ',18)'Time: Too late!'
SAY
SELECT
   WHEN R=8 THEN CALL ROOM8
   WHEN R=19 THEN CALL ROOM19
   WHEN R=25 THEN CALL ROOM25
   WHEN R=38 THEN CALL ROOM38
   WHEN R=42 THEN CALL ROOM42
   WHEN R=43 THEN CALL ROOM43
   WHEN R=44 THEN CALL ROOM44
   WHEN R=45 THEN CALL ROOM45
   WHEN R=46 THEN CALL ROOM46
   WHEN R=47 THEN CALL ROOM47
   WHEN R=48 THEN CALL ROOM48
   OTHERWISE
   IF COCNUT=3 THEN
   DO
      SAY 'Bonk!!  The last coconut thrown by that good-for-nothing',
          'monkey hit'
      SAY 'you so hard that it split open your skull. You were knocked',
          'unconscious'
      SAY 'Before you could come to you bleed to death! What a',
          'terrible shame!'
   END
END
IF LOST\=3 then
DO
   SAY
   SAY CENTER(HI'Sorry you have lost his adventure...'LO,70)
   SAY
   SAY '                                                         |       '
   SAY '                            +----------+              ---+---    '
   SAY '         +---+              |          |                 |       '
   SAY '         |   |              | R. I. P. |              (.;|)./    '
   SAY '        )|.;.|/   ;.)|(.    |          |                         '
   SAY '                            |          |                         '
   SAY '                            |          |         ..))/(.;        '
   SAY '                           )|..,.((/..))/                        '
   SAY
END
ELSE
DO
   SAY 'While you were wasting time messing around, your across',
       'town rival was'
   SAY 'able to recover the Sacred Stone! By now you are the laughing stock'
   SAY 'of your town. You have brought shame to your family and school name!!'
   SAY 'You will be lucky if you ever get your degree now!'
END
SIGNAL QUIT
WIN_ROOM:
CLEAR_SCR
R=49
CALL QTIME
SAY 'As you get to the field you see a helicopter and wave madly!',
   'The helicopter'
SAY 'lands in the field and you run over to it! Your friend the professor',
    'is in'
SAY 'the chopper. You get in and are taken back to the university! You',
    'get your'
Say 'degree and the SACRED STONE is put in a museum! You become very famous!!'
SAY
SAY CENTER(HI'CONGRATULATIONS!!! You have solved this adventure!'LO,72)
SAY
SIGNAL QUIT
TITLE:
CLEAR_SCR
SAY CENTER(HI'MIKEL RICE PROUDLY PRESENTS',71)
SAY
SAY '   SSSSSSS  EEEEE   AAAA   RRRR   CCCCC  H   H     FFFFF OOOOO  RRRR  '
SAY '  S         E      A    A  R   R  C      H   H     F     O   O  R   R '
SAY '   SSSSSS   EEE    AAAAAA  RRRR   C      HHHHH     FFF   O   O  RRRR  '
SAY '         S  E      A    A  R R    C      H   H     F     O   O  R R   '
SAY '  SSSSSSS   EEEEE  A    A  R  R   CCCCC  H   H     F     OOOOO  R  R  '
SAY '                                                                      '
SAY '  TTTTTTT H   H EEEEE     SSSSSSS   AAAA   CCCCC  RRRR   EEEEE  DDDD  '
SAY '     T    H   H E        S         A    A  C      R   R  E   E  D   D '
SAY '     T    HHHHH EEE       SSSSSS   AAAAAA  C      RRRR   EEEEE  D   D '
SAY '     T    H   H E               S  A    A  C      R R    E      D   D '
SAY '     T    H   H EEEEE    SSSSSSS   A    A  CCCCC  R  R   EEEEE  DDDD  '
SAY
SAY '     *   *      SSSSSSS  TTTTTTT  OOOOOO  NN    N  EEEEEE    *   *  '
SAY '      * *      S            T     O    O  N N   N  E          * *   '
SAY '    ** * **     SSSSSS      T     O    O  N  N  N  EEEE     ** * ** '
SAY '      * *             S     T     O    O  N   N N  E          * *   '
SAY '     *   *     SSSSSSS      T     OOOOOO  N    NN  EEEEEE    *   *  '
SAY
R=1
HOUR=8
MINUTES=30
LOST=0
MSG=0
AM_PM='AM'
UNLOCKED=0
OPENED=0
TAXI=0
CANOE=0
SMOKE=0
COCONUT=0
STONE=0
LIGHTER=0
ROCK=0
BEAR=0
VLIST='GO GETLOODROOPEREAUNLMOVCLIBREMAKDIGHELCUTPADKILQUIRINPREASK'
VLIST=VLIST||'GIVPAYWEAJUMLIGUSEBURTHRSWIFEEPUTSHO'
NLIST='NORSOUEASWESUP DOWNOTELEDESNEWKEYBELREGTAXBUTONETWOTHRRUGELM'
NLIST=NLIST||'FREMONCOUTICLIGHOTSIGLOCPARFLYCHAGATCAGROCAXESHOLOGCAN'
NLIST=NLIST||'STOHIVWALTREPEDBEAVINRIVNATFIRWOOHUTCAVSHOGUN'
LOC.1 = 'Outside a fancy hotel'
EXIT.1 = '0 0 3 4 0 0'
LOC.2 = 'Hotel Lobby'
EXIT.2 = '5 1 0 0 0 0'
LOC.3 = 'Bad part of town'
EXIT.3 = '0 0 8 1 0 0'
LOC.4 = 'Outside a small shop'
EXIT.4 = '0 0 1 0 0 0'
LOC.5 = 'Front desk of the Royal Ritz'
EXIT.5 = '0 2 0 0 0 0'
LOC.6 = 'In an elevator'
EXIT.6 = '0 0 0 2 0 0'
LOC.7 = "In Elmo's pawn shop"
EXIT.7 = '0 4 0 0 0 0'
LOC.8 = 'In deep trouble'
LOC.9 = "In a Fred's taxi"
EXIT.9 = '0 0 0 0 0 0'
LOC.10= 'Outside an International Airport'
EXIT.10='0 11 0 0 0 0'
LOC.11 = 'Airport hallway'
EXIT.11 = '10 14 12 13 0 0'
LOC.12 = 'Passenger area'
EXIT.12 = '0 0 0 11 0 0'
LOC.13 = 'Passenger area'
EXIT.13 = '0 0 11 0 0 0'
LOC.14 = 'Passenger lounge'
EXIT.14 = '11 15 0 0 0 0'
LOC.15 = 'Departure area'
EXIT.15 = '14 19 16 17 0 0'
LOC.16 = 'Departure area east'
EXIT.16 = '0 19 19 15 0 0'
LOC.17 = 'Departure area west'
EXIT.17 = '0 18 15 19 0 0'
LOC.18 = 'In a two-engine plane'
EXIT.18 = '0 0 0 0 0 0'
LOC.19 = 'Knocking at the pearly gates'
EXIT.19 = '0 0 0 0 0 0'
LOC.20 = 'Trapped in a bamboo cage'
EXIT.20='0 0 0 0 0 0'
LOC.21 = 'By the village fire pit'
EXIT.21 = '0 27 0 0 0 0'
LOC.22 = 'Near a thatch hut'
EXIT.22 = '0 0 0 27 0 0'
LOC.23 = 'In the small village garden'
EXIT.23 = '0 25 27 0 0 0'
LOC.24 = 'In a thatch hut'
EXIT.24 = '0 0 0 22 0 0'
LOC.25 = 'In the dense jungle'
EXIT.25 = '0 0 0 0 0 0'
LOC.26 = 'In a clearing'
EXIT.26 = '27 0 25 25 0 0'
LOC.27 = 'Center of a native village'
EXIT.27 = '21 26 22 23 0 0'
LOC.28 = 'In a dugout canoe'
EXIT.28='25 0 29 42 0 0'
LOC.29 = 'In a dugout canoe'
EXIT.29 = '26 25 30 28 0 0'
LOC.30 = 'In a dugout canoe'
EXIT.30 = '0 33 42 29 0 0'
LOC.31 = 'In a dimly lit cave'
EXIT.31 = '0 34 0 0 0 0'
LOC.32 = 'Outside of a small cave'
EXIT.32 = '0 0 0 0 0 0'
LOC.33 = 'On a worn dirt path'
EXIT.33 = '0 36 25 25 0 0'
LOC.34 = 'Outside of a small cave'
EXIT.34 = '0 37 0 25 0 0'
LOC.35 = 'West end of a big green field'
EXIT.35 = '25 0 36 0 0 0'
LOC.36 = 'East end of a big green field'
EXIT.36 = '33 39 0 35 0 0'
LOC.37 = 'In a slightly wooded area'
EXIT.37 = '34 0 38 25 0 0'
LOC.38 = 'In a deep pit of quicksand'
LOC.39 = 'In a slightly wooded area'
EXIT.39 = '36 0 38 0 0 0'
LOC.40 = 'Perched high in a tree'
EXIT.40 = '0 0 0 0 40 39'
LOC.41 = 'Perched high in a tree'
EXIT.41 = '0 0 0 0 41 37'
LOC.42 = 'Bellyup underwater'
LOC.43 = 'Crushed under a steel beam'
LOC.44 = 'In a musty jail cell'
LOC.45 = 'In the great beyond'
LOC.46 = 'In the belly of a gator'
LOC.47 = 'All over the ground!'
LOC.48 = 'In a musty jail cell'
LOC.49 = "Getting a hero's welcome"
OBJECT.1.1 = 'NORTH'
OBJECT.1.2 = 0
CAN.1='*'
OBJECT.1.3 = "You see something, maybe you should go there!"
OBJECT.2.1 = 'SOUTH'
OBJECT.2.2 = 0
CAN.2='*'
OBJECT.2.3 = "You see something, maybe you should go there!"
OBJECT.3.1 = 'EAST'
OBJECT.3.2 = 0
CAN.3='*'
OBJECT.3.3 = "You see something, maybe you should go there!"
OBJECT.4.1 = 'WEST'
OBJECT.4.2 = 0
CAN.4='*'
OBJECT.4.3 = "You see something, Maybe you should go there!"
OBJECT.5.1 = 'UP '
OBJECT.5.2 = 0
CAN.5='*'
OBJECT.5.3 = "My neck is starting to hurt!"
OBJECT.6.1 = 'DOWN'
OBJECT.6.2 = 0
CAN.6='*'
OBJECT.6.3 = "You see something...Your feet!"
OBJECT.7.1 = 'NOTE'
OBJECT.7.2 = 1
CAN.7='1'
OBJECT.7.3 = 'There is something written on it.'
OBJECT.8.1 = 'ELEVATOR'
OBJECT.8.2 = 2
CAN.8='*'
OBJECT.8.3 = "A sign on the door says 'Out of Order'"
OBJECT.9.1 = 'Front DESK'
OBJECT.9.2 = 5
CAN.9='*'
OBJECT.9.3 = 'It is kept very tidy.'
OBJECT.10.1 = 'NEWSPAPER'
OBJECT.10.2 = 3
CAN.10='1'
OBJECT.10.3 = "It is a crumpled copy of today's newspaper."
OBJECT.11.1 = 'small KEY'
OBJECT.11.2 = 6
CAN.11='1'
OBJECT.11.3 = 'It has the number 26 scratched on it!'
OBJECT.12.1 = 'shiny BELL'
OBJECT.12.2 = 5
CAN.12='*'
OBJECT.12.3 = "It's one of those bells you ring for service."
OBJECT.13.1 = 'cash REGISTER'
OBJECT.13.2 = 5
CAN.13='*'
OBJECT.13.3 = "It isn't locked."
OBJECT.14.1 = 'TAXI'
OBJECT.14.2 = 0
CAN.14='*'
OBJECT.14.3 = "It has Fast Fred's Cab Co painted on the side."
OBJECT.15.1 = 'BUTTON'
OBJECT.15.2 = 6
CAN.15='*'
OBJECT.15.3 = "The buttons are labeled one to three."
OBJECT.16.1 = 'ONE'
OBJECT.16.2 = 0
CAN.16='*'
OBJECT.16.3 = "Try pressing it!"
OBJECT.17.1 = 'TWO'
OBJECT.17.2 = 0
CAN.17='*'
OBJECT.17.3 = 'Try pressing it!'
OBJECT.18.1 = 'THREE'
OBJECT.18.2 = 0
CAN.18='*'
OBJECT.18.3 = "Try pressing it!"
OBJECT.19.1 = 'pretty throw RUG'
OBJECT.19.2 = 7
CAN.19='*'
OBJECT.19.3 = "It is a valuable persian rug."
OBJECT.20.1 = 'ELMO'
OBJECT.20.2 = 7
CAN.20='*'
OBJECT.20.3 = "He looks like a real nice guy!"
OBJECT.21.1 = 'FRED'
OBJECT.21.2 = 9
CAN.21='*'
OBJECT.21.3 = "He is wearing a dirty cap and he needs to shave."
OBJECT.22.1 = 'MONEY'
OBJECT.22.2 = 50
CAN.22='1'
OBJECT.22.3 = "It's looks like a 20 dollar bill to me."
OBJECT.23.1 = 'redeemable COUPON'
OBJECT.23.2 = 0
CAN.23='1'
OBJECT.23.3 = "Why don't you read the writting on it!"
OBJECT.24.1 = 'plane TICKET'
OBJECT.24.2 = 50
CAN.24='1'
OBJECT.24.3 = "If I were you I would try to read it!"
OBJECT.25.1 = 'LIGHTER'
OBJECT.25.2 = 0
CAN.25='1'
OBJECT.25.3 ="It's the plastic kind and it's almost out of fluid!"
OBJECT.26.1 = 'Royal Ritz HOTEL'
OBJECT.26.2 = 1
CAN.26='*'
OBJECT.26.3 = "It is a very high class hotel."
OBJECT.27.1 = 'SIGN'
OBJECT.27.2 = 11
CAN.27='*'
OBJECT.27.3 = 'It read: To gates 1 - 5'
OBJECT.28.1 = 'LOCKERS'
OBJECT.28.2 = 12
CAN.28='*'
OBJECT.28.3 = 'They are numbered from 21 to 40'
OBJECT.29.1 = 'PARACHUTE'
OBJECT.29.2 = 0
CAN.29='1'
OBJECT.29.3 = 'It is just a parachute.'
OBJECT.30.1 = 'FLYER'
OBJECT.30.2 = 14
CAN.30='1'
OBJECT.30.3 = 'It is taped up on the wall.'
OBJECT.31.1 = 'CHAIRS'
OBJECT.31.2 = 14
CAN.31='*'
OBJECT.31.3 = 'They are very colorful kind with the thin padding.'
OBJECT.32.1 = 'GATES'
OBJECT.32.2 = 0
CAN.32='*'
OBJECT.32.3 = 'They are boarding gates.'
OBJECT.33.1 = 'bamboo CAGE'
OBJECT.33.2 = 20
CAN.33='*'
OBJECT.33.3 = 'The cage is built fairly sturdy.'
OBJECT.34.1 = 'round ROCK'
OBJECT.34.2 = 0
CAN.34='1'
OBJECT.34.3 = 'It is a fist sized rock.'
OBJECT.35.1 = 'hand AXE'
OBJECT.35.2 = 24
CAN.35='1'
OBJECT.35.3 = 'It is old but still useable'
OBJECT.36.1 = 'SHOVEL'
OBJECT.36.2 = 23
CAN.36='1'
OBJECT.36.3 = "It's a shovel, but it reminds you of something else!"
OBJECT.37.1 = 'big LOG'
OBJECT.37.2 = 26
CAN.37='*'
OBJECT.37.3 = 'The bark has been striped and it has been cut at some'
OBJECT.38.1 = 'dugout CANOE'
OBJECT.38.2 = 0
CAN.38='*'
OBJECT.38.3 = 'You did a good job...it should float.'
OBJECT.39.1 = '* Sacred STONE *'
OBJECT.39.2 = 0
CAN.39='1'
OBJECT.39.3 = 'It is a beautiful sparkling blue QUARTZ-DIAMOND!!'
OBJECT.40.1 = 'bee HIVE'
OBJECT.40.2 = 35
CAN.40='1'
OBJECT.40.3 = 'It is the hive of some honeybees.'
OBJECT.41.1 = 'stone WALL'
OBJECT.41.2 = 0
CAN.41='*'
OBJECT.41.3 = 'It is blocking the only exit.'
OBJECT.42.1 = 'big TREE'
OBJECT.42.2 = 39
CAN.42='*'
OBJECT.42.3 = 'It has some low easy to reach branches.'
OBJECT.43.1 = 'PEDESTAL'
OBJECT.43.2 = 31
CAN.43='*'
OBJECT.43.3 = 'It it exquisitly carved and made to display something.'
OBJECT.44.1 = 'mean BEAR'
OBJECT.44.2 = 34
CAN.44='*'
OBJECT.44.3 = 'The bear is big and looks hungry.'
OBJECT.45.1 = 'thick VINE'
OBJECT.45.2 = 40
CAN.45='*'
OBJECT.45.3 = 'It looks very sturdy.'
OBJECT.46.1 = 'wide RIVER'
OBJECT.46.2 = 26
CAN.46='*'
OBJECT.46.3 = 'The river is wide but the muddy water flows slowly.'
OBJECT.47.1 = 'unfriendly NATIVES'
OBJECT.47.2 = 32
CAN.47='*'
OBJECT.47.3 = 'They surround you holding spears pointed at you!'
OBJECT.48.1 = 'FIRE'
OBJECT.48.2 = 0
CAN.48='*'
OBJECT.48.3 = 'It is burning with flickering orange flames!'
OBJECT.49.1 = 'piece of WOOD'
OBJECT.49.2 = 21
CAN.49='1'
OBJECT.49.3 = 'THE WOOD IS SLIGHTLY DAMP BUT SHOULD STILL BURN.'
OBJECT.50.1 = 'thatch HUT'
OBJECT.50.2 = 22
CAN.50='*'
OBJECT.50.3 = 'The hut is made of dried mud and long blades of thatch.'
OBJECT.51.1 ='big CAVE'
OBJECT.51.2 = 34
CAN.51='*'
OBJECT.51.3 ="It isn't very dark inside but I can't see in too far."
OBJECT.52.1 ='pawn SHOP'
OBJECT.52.2=4
CAN.52='*'
OBJECT.52.3 ='The pawn shop is opened and you see someone inside.'
OBJECT.53.1 ='hand GUN'
OBJECT.53.2=50
CAN.53='1'
OBJECT.53.3 ="It's a regular hand gun. You lost the registration though."
OBJECT.54.1 = 'tall TREE'
OBJECT.54.2 = 37
CAN.54='*'
OBJECT.54.3 = 'It looks easy to climb up.'
OBJECT.55.1 = 'wide RIVER'
OBJECT.55.2 = 28
CAN.55='*'
OBJECT.55.3 = 'The river is wide but the muddy water flows slowly.'
OBJECT.56.1 = 'wide RIVER'
OBJECT.56.2 = 29
CAN.56='*'
OBJECT.56.3 = 'The river is wide but the muddy water flows slowly.'
OBJECT.57.1 = 'wide RIVER'
OBJECT.57.2 = 30
CAN.57='*'
OBJECT.57.3 = 'The river is wide but the muddy water flows slowly.'
OBJECT.58.1 = 'wide RIVER'
OBJECT.58.2 = 33
CAN.58='*'
OBJECT.58.3 = 'The river is wide but the muddy water flows slowly.'
OBJECT.59.1 = 'thick VINE'
OBJECT.59.2 = 41
CAN.59='*'
OBJECT.59.3 = 'It winds upward into the tree foliage.'
OBJECT.60.1 = 'LOCKERS'
OBJECT.60.2 = 13
CAN.60='*'
OBJECT.60.3 = 'They are numbered from 1 to 20.'
OBJECT.61.1 = 'CHAIRS'
OBJECT.61.2 = 12
CAN.61='*'
OBJECT.61.3 = 'They are very colorful kind with the thin padding.'
OBJECT.62.1 = 'CHAIRS'
OBJECT.62.2 = 13
CAN.62='*'
OBJECT.62.3 = 'They are very colorful kind with the thin padding.'
SAY CENTER('DO YOU NEED INSTRUCTIONS? (Y/N)?'LO,74)
PULL ANSWER
IF  ANSWER \= 'Y' THEN RETURN
CLEAR_SCR
say CENTER(HI'Search for the Sacred Stone'LO,76)
SAY
SAY '     HAVING COMPLETED MOST OF YOUR GRADUATE STUDIES AT THE NEARBY',
    'UNIVERSITY'
SAY 'you need only a few more credit hours to obtain your doctorate degree in'
SAY 'Archaeology. Yesterday one of your favorite professors pulled you',
    'aside to'
SAY "make an offer you couldn't refuse...."
SAY
SAY "     It seems that just recently your professor learned that a long lost"
SAY 'archaeological treasure had been uncovered. He tells you of a valuable'
SAY 'blue quartz-diamond hidden deep in the jungles by a group of very',
    'hostile'
SAY "natives. The natives hold the stone as being sacred and don't take",
    "kindly"
SAY 'to people trying to take the stone. The professor offers to let you gain'
SAY 'some valuable experience and your degree if you can bring back',
    'the SACRED'
SAY 'STONE. A sparkle appears in your eyes as you accept the challenge! The'
SAY 'professor smiles as he tells you that the rival university across town'
SAY 'will also have someone looking for the stone so you must hurry!'
SAY
SAY CENTER('Press 'HI'<ENTER>'LO' to continue',76)
PULL DUMMY
CLEAR_SCR
SAY CENTER(HI'Search for the Sacred Stone'LO,76)
SAY
SAY 'OBJECTIVE : To get to the SACRED STONE before the across town rivals get'
SAY '            it and then get back safely.'
Say
Say "GAME RULES: You manipulate your character and the surroundings by",
    "using a"
Say "            VERB NOUN pair. For example to pick up an object that",
    "you can"
Say "            see, such as a book, just type 'GET BOOK'. To drop an",
    "item you"
SAY "            no longer need type 'DROP object'. 'LOOK object' is",
    "very useful"
SAY "            as it often supplies a clue as to the object use in",
    "the game."
SAY "            Some VERBS can be used without a NOUN. Some examples",
    "of these"
Say "            are: 'INVENTORY' (I), 'HELP', 'DIG', 'JUMP', 'SWING'",
    "or 'QUIT'."
Say
SAY "            To move about in your surroundings you can use the normal"
SAY "            compass directions: NORTH, SOUTH, EAST, WEST, UP and",
    "DOWN. To"
SAY "            move in a directions, say north, just type 'GO NORTH'",
    "or simply"
SAY "            type 'NORTH' or 'N' for short. In some place it may be",
    "neccessary"
SAY "            to 'GO', 'ENTER', or 'CLIMB' to get to where you want to go."
SAY
SAY CENTER('Press 'HI'<ENTER>'LO' to continue',77)
PULL DUMMY
CLEAR_SCR
SAY CENTER(HI'Search for the Sacred Stone'LO,76)
SAY
SAY "GAME RULES: SEARCH FOR THE SACRED STONE ALLOWS YOU TO SAVE YOUR CURRENT"
SAY "            POSITION. THIS IS USEFUL WHEN ENTERING UNKNOWN AREAS OF THE"
SAY "            GAME. YOU MAY WANT TO USE SAVE OFTEN AS YOU PLAY. TO RESTORE"
SAY "            YOUR POSTION AT ANYTIME TYPE LOAD OR WHEN YOU START THE GAME"
SAY "            TYPE STONE LOAD AND YOU WILL AUTOMATICALLY BE PLACED AT THE"
SAY "            POSTION WERE YOU SAVED FROM."
Say
SAY "            IF YOU ARE A SLOW READER OR YOU ARE PLAYING THIS",
    "ADVENTURE FOR"
SAY "            THE FIRST TIME YOU MAY WANT TO DECREASE THE SPEED AT",
    "WHICH THE"
SAY "            RESPONSE MESSAGES ARE DISPLAYED UPON THE SCREEN. TO",
    "ACCOMPLISH"
SAY "            THIS SIMPLY TYPE 'PAUSE #'. THE GREATER THE NUMBER THE",
    "LONGER"
SAY "            THE MESSAGE WILL BE DISPLAYED. THE PAUSE IS SET TO 4 AT THE"
SAY "            START OF THE GAME. LIKEWISE A LOWER NUMBER WILL SHORTEN THE"
SAY "            TIME THAT THE RESPONSE IS DISPLAYED UPON THE SCREEN."
SAY
SAY CENTER('Press 'HI'<ENTER>'LO' to continue',77)
PULL DUMMY
RETURN
VERBS:
CLEAR_SCR
SAY
SAY CENTER(HI'VERB LIST'LO,60)
SAY
SAY '     GO             ENTER            GET             TAKE'
SAY '     LOOK           EXAMINE          DROP            OPEN'
SAY '     READ           UNLOCK           MOVE            PUSH'
SAY '     PRESS          KILL             HIT             ATTACK'
SAY '     CLIMB          RING             BREAK           SMASH'
SAY '     MAKE           BUILD            CUT             PLACE'
SAY '     PUT            PAY              PADDLE          ROW '
SAY '     ASK            WEAR             LIGHT           GIVE'
SAY '     START          BURN             THROW           FEED'
SAY '     USE            FLICK            SHOOT           FIRE'
SAY '     SAY            LIFT             CHOP            SAVE *'
SAY '     LOAD *         SWING *          JUMP *          SWIM *'
SAY '     INVENTORY *    HELP *           DIG *           QUIT *'
SAY
say '               * - These verbs require no noun!'
SAY
SAY
SAY '                Press <enter> to continue game'
PULL DUMMY
MINUTES=MINUTES-1
RETURN
LOAD:
IF env = "CMS" THEN
   MAKEBUF

CALL PUSHLINE 1
IF result = 0 THEN
   DO
   SAY "No SAVE file"
   PULL .
   RETURN
   END
PULL OUTPUT
PARSE VAR OUTPUT R HOUR MINUTES UNLOCKED OPENED TAXI CANOE SMOKE,
    COCONUT ROCK BEAR
ITEM=7
DO TIMES=1 TO 4
   CALL PUSHLINE
   PULL OUTPUT
   DO NOUNS= 1 TO 11
      PARSE VAR OUTPUT NUM LEFTOVER
      OBJECT.ITEM.2=VALUE(NUM)
      ITEM=ITEM+1
      OUTPUT=LEFTOVER
   END
END
CALL PUSHLINE
PULL OUTPUT
PARSE VAR OUTPUT OBJECT.52.2 OBJECT.53.2 PAUSE
CALL PUSHLINE
PULL EXIT.31
IF env = "CMS" THEN
   DO
   DROPBUF
   "FINIS STONE SAVE A0"
   END
MINUTES=MINUTES-1
RETURN
SAVE:
IF env = "CMS" THEN
   DO
   'SET CMSTYPE HT'
   'LIST ERASE EXEC A'
   IF RC=0 THEN
      DO
      'RENAME ERASE EXEC A TEMP EXEC A'
      'ERASE STONE SAVE A0'
      'RENAME TEMP EXEC A ERASE EXEC A'
      END
   'ERASE STONE SAVE A0'
   'SET CMSTYPE RT'
   END
ELSE IF env = "OS/2" THEN
   DO
   /* There should be a better way! */
   fileIdent = STREAM('STONE.SAV', 'C', 'query exists')
   IF fileIdent <> "" THEN
      DO
      rt = STREAM('STONE.SAV', 'C', 'close')
      "ERASE STONE.SAV"
      END
   END
ELSE
   DO
   SAY "Saving in" env "not fully supported"
   END

OUTPUT=R||' '||HOUR||' '||MINUTES||' '||UNLOCKED||' '||OPENED||' '||TAXI
OUTPUT=OUTPUT||' '||CANOE||' '||SMOKE||' '||COCONUT||' '||ROCK||' '||BEAR
CALL WRITELN OUTPUT
ITEM=7
DO TIMES=1 TO 4
   OUTPUT=''
   DO NOUNS= 1 TO 11
      OUTPUT=OUTPUT||OBJECT.ITEM.2||' '
      ITEM=ITEM+1
   END
   CALL WRITELN OUTPUT
END
CALL WRITELN OBJECT.52.2 OBJECT.53.2 PAUSE
CALL WRITELN EXIT.31
IF env = "CMS" THEN
   'FINIS STONE SAVE A0'
SAY
SAY
SAY CENTER('GAME HAS BEEN SAVED. USE LOAD TO RESTORE THE GAME!',70)
QUIT:
SAY
SAY CENTER(HI'Do you wish to play again? (Y/N)?'LO,70)
PULL DUMMY
IF  DUMMY = 'Y' THEN SIGNAL BEGIN
CLEAR_SCR
ECHO_ON
EXIT

PUSHLINE:
   PARSE ARG first
   IF env = "CMS" THEN
      'EXECIO 1 DISKR STONE SAVE A0'
   ELSE IF env = "OS/2" THEN
      IF first = '1' THEN
         PUSH LINEIN("STONE.SAV",1)
      ELSE
         PUSH LINEIN("STONE.SAV")
         
RETURN queued()

WRITELN:
   PARSE ARG outstr
   
   IF env = "CMS" THEN
      "EXECIO 1 DISKW STONE SAVE A0 (STRING" outstr
   ELSE IF env = "OS/2" THEN
      rt=LINEOUT("STONE.SAV", outstr)
      
RETURN

/*************************************************************************
 *
 *  Wait:  Pauses for (delay) seconds.
 *
 ************************************************************************/
Wait: PROCEDURE
   PARSE ARG delay
   
   IF \datatype(delay, "N") THEN
      delay = 1
   CALL Time("R")
   DO WHILE Time("E") < delay
      NOP
   END
RETURN

/* END */
