/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.gui.SimpleDialogs;
import net.sf.gogui.utils.ErrorMessage;
import net.sf.gogui.utils.StringUtils;

public class AnalyzeCommand {
    public static final int BWBOARD = 0;
    public static final int CBOARD = 1;
    public static final int DBOARD = 2;
    public static final int EPLIST = 3;
    public static final int GFX = 4;
    public static final int HSTRING = 5;
    public static final int HPSTRING = 6;
    public static final int NONE = 7;
    public static final int PARAM = 8;
    public static final int PLIST = 9;
    public static final int PSTRING = 10;
    public static final int PSPAIRS = 11;
    public static final int STRING = 12;
    public static final int SBOARD = 13;
    public static final int VAR = 14;
    public static final int VARB = 15;
    public static final int VARC = 16;
    public static final int VARP = 17;
    public static final int VARPO = 18;
    public static final int VARW = 19;
    private final int m_type;
    private GoColor m_colorArg;
    private File m_fileArg;
    private final String m_label;
    private String m_optStringArg;
    private final String m_command;
    private String m_stringArg;
    private GoPoint m_pointArg;
    private ArrayList m_pointListArg = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public AnalyzeCommand(String string) {
        String[] stringArray = string.split("/");
        String string2 = stringArray[0];
        this.m_type = string2.equals("bwboard") ? 0 : (string2.equals("cboard") ? 1 : (string2.equals("dboard") ? 2 : (string2.equals("eplist") ? 3 : (string2.equals("gfx") ? 4 : (string2.equals("hstring") ? 5 : (string2.equals("hpstring") ? 6 : (string2.equals("param") ? 8 : (string2.equals("plist") ? 9 : (string2.equals("pspairs") ? 11 : (string2.equals("pstring") ? 10 : (string2.equals("string") ? 12 : (string2.equals("sboard") ? 13 : (string2.equals("var") ? 14 : (string2.equals("varb") ? 15 : (string2.equals("varc") ? 16 : (string2.equals("varp") ? 17 : (string2.equals("varpo") ? 18 : (string2.equals("varw") ? 19 : 7))))))))))))))))));
        this.m_label = stringArray[1];
        this.m_command = stringArray[2];
    }

    public AnalyzeCommand(int n, String string, String string2) {
        this.m_type = n;
        this.m_label = string;
        this.m_command = string2;
    }

    public AnalyzeCommand cloneCommand() {
        AnalyzeCommand analyzeCommand = new AnalyzeCommand(this.m_type, this.m_label, this.m_command);
        analyzeCommand.m_colorArg = this.m_colorArg;
        analyzeCommand.m_fileArg = this.m_fileArg;
        analyzeCommand.m_optStringArg = this.m_optStringArg;
        analyzeCommand.m_stringArg = this.m_stringArg;
        analyzeCommand.m_pointArg = this.m_pointArg;
        analyzeCommand.m_pointListArg = this.m_pointListArg;
        return analyzeCommand;
    }

    public static AnalyzeCommand get(Frame frame, String string) {
        ArrayList arrayList = new ArrayList(128);
        ArrayList arrayList2 = new ArrayList(128);
        try {
            AnalyzeCommand.read(arrayList, arrayList2, null, null);
        }
        catch (Exception exception) {
            SimpleDialogs.showError(frame, exception.getMessage());
        }
        int n = arrayList2.indexOf(string);
        if (n < 0) {
            return null;
        }
        return new AnalyzeCommand((String)arrayList.get(n));
    }

    public String getLabel() {
        return this.m_label;
    }

    public GoColor getColorArg() {
        return this.m_colorArg;
    }

    public GoPoint getPointArg() {
        return this.m_pointArg;
    }

    public ArrayList getPointListArg() {
        return this.m_pointListArg;
    }

    public int getType() {
        return this.m_type;
    }

    public String getResultTitle() {
        StringBuffer stringBuffer = new StringBuffer(this.m_label);
        if (this.needsColorArg() && this.m_colorArg != null) {
            if (this.m_colorArg == GoColor.BLACK) {
                stringBuffer.append(" Black");
            } else {
                if (!$assertionsDisabled && this.m_colorArg != GoColor.WHITE) {
                    throw new AssertionError();
                }
                stringBuffer.append(" White");
            }
        }
        if (this.needsPointArg() && this.m_pointArg != null) {
            stringBuffer.append(' ');
            stringBuffer.append(this.m_pointArg.toString());
        } else if (this.needsPointListArg()) {
            for (int i = 0; i < this.m_pointListArg.size(); ++i) {
                stringBuffer.append(' ');
                stringBuffer.append(((GoPoint)this.m_pointListArg.get(i)).toString());
            }
        }
        if (this.needsStringArg() && this.m_stringArg != null) {
            stringBuffer.append(' ');
            stringBuffer.append(this.m_stringArg);
        }
        return stringBuffer.toString();
    }

    public boolean isPointArgMissing() {
        if (this.needsPointArg()) {
            return this.m_pointArg == null;
        }
        if (this.needsPointListArg()) {
            return this.m_pointListArg.isEmpty();
        }
        return false;
    }

    public static boolean isTextType(int n) {
        return n == 12 || n == 5 || n == 6 || n == 10 || n == 14 || n == 16 || n == 19 || n == 15 || n == 17 || n == 18;
    }

    public boolean needsColorArg() {
        return AnalyzeCommand.needsColorArg(this.m_command);
    }

    public static boolean needsColorArg(String string) {
        return string.indexOf("%c") >= 0;
    }

    public boolean needsFileArg() {
        return this.m_command.indexOf("%f") >= 0;
    }

    public boolean needsOnlyPointArg() {
        return this.needsPointArg() && !this.needsColorArg() && !this.needsFileArg() && !this.needsPointListArg() && !this.needsStringArg() && !this.needsOptStringArg();
    }

    public boolean needsOnlyPointAndColorArg() {
        return this.needsPointArg() && this.needsColorArg() && !this.needsFileArg() && !this.needsPointListArg() && !this.needsStringArg() && !this.needsOptStringArg();
    }

    public boolean needsPointArg() {
        return this.m_command.indexOf("%p") >= 0;
    }

    public boolean needsPointListArg() {
        return this.m_command.indexOf("%P") >= 0 || this.m_type == 3;
    }

    public boolean needsStringArg() {
        return this.m_command.indexOf("%s") >= 0;
    }

    public boolean needsOptStringArg() {
        return this.m_command.indexOf("%o") >= 0;
    }

    public static void read(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, String string) throws ErrorMessage {
        Object object;
        arrayList.clear();
        arrayList2.clear();
        ArrayList arrayList4 = AnalyzeCommand.getFiles();
        File file = new File(AnalyzeCommand.getDir(), "analyze-commands");
        if (!arrayList4.contains(file)) {
            AnalyzeCommand.copyDefaults(file);
            arrayList4 = AnalyzeCommand.getFiles();
        }
        for (int i = 0; i < arrayList4.size(); ++i) {
            object = (File)arrayList4.get(i);
            try {
                FileReader fileReader = new FileReader((File)object);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                AnalyzeCommand.readConfig(bufferedReader, ((File)object).getName(), arrayList, arrayList2, arrayList3);
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new ErrorMessage("File " + object + " not found");
            }
        }
        if (string != null) {
            StringReader stringReader = new StringReader(string);
            object = new BufferedReader(stringReader);
            AnalyzeCommand.readConfig((BufferedReader)object, "program response to gogui_analyze_commands", arrayList, arrayList2, arrayList3);
        }
    }

    public String replaceWildCards(GoColor goColor) {
        String string;
        String string2 = this.m_command.replaceAll("%m", goColor.toString());
        if (this.needsPointArg() && this.m_pointArg != null) {
            string2 = string2.replaceAll("%p", this.m_pointArg.toString());
        }
        if (this.needsPointListArg()) {
            string = GoPoint.toString(this.m_pointListArg);
            string2 = this.m_type == 3 && this.m_pointListArg.size() > 0 ? string2 + ' ' + string : string2.replaceAll("%P", string);
        }
        if (this.needsFileArg()) {
            string = this.m_fileArg.toString();
            if (string.indexOf(32) >= 0) {
                string = "\"" + string + "\"";
            }
            string2 = string2.replaceAll("%f", string);
        }
        if (this.needsStringArg()) {
            if (!$assertionsDisabled && this.m_stringArg == null) {
                throw new AssertionError();
            }
            string2 = string2.replaceAll("%s", this.m_stringArg);
        }
        if (this.needsOptStringArg()) {
            if (!$assertionsDisabled && this.m_optStringArg == null) {
                throw new AssertionError();
            }
            string2 = string2.replaceAll("%o", this.m_optStringArg);
        }
        if (this.needsColorArg()) {
            string = "empty";
            if (this.m_colorArg == GoColor.BLACK) {
                string = "b";
            } else if (this.m_colorArg == GoColor.WHITE) {
                string = "w";
            }
            string2 = string2.replaceAll("%c", string);
        }
        return string2;
    }

    public void setColorArg(GoColor goColor) {
        if (!$assertionsDisabled && !this.needsColorArg()) {
            throw new AssertionError();
        }
        this.m_colorArg = goColor;
    }

    public void setFileArg(File file) {
        if (!$assertionsDisabled && !this.needsFileArg()) {
            throw new AssertionError();
        }
        this.m_fileArg = file;
    }

    public void setPointArg(GoPoint goPoint) {
        this.m_pointArg = goPoint;
    }

    public void setPointListArg(ArrayList arrayList) {
        this.m_pointListArg = arrayList;
    }

    public void setStringArg(String string) {
        if (!$assertionsDisabled && !this.needsStringArg()) {
            throw new AssertionError();
        }
        this.m_stringArg = string;
    }

    public void setOptStringArg(String string) {
        if (!$assertionsDisabled && !this.needsOptStringArg()) {
            throw new AssertionError();
        }
        this.m_optStringArg = string;
    }

    private static void copyDefaults(File file) {
        String string = "net/sf/gogui/config/analyze-commands";
        URL uRL = ClassLoader.getSystemClassLoader().getResource(string);
        if (uRL == null) {
            return;
        }
        try {
            int n;
            InputStream inputStream = uRL.openStream();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) >= 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static File getDir() {
        String string = System.getProperty("user.home");
        return new File(string, ".gogui");
    }

    private static ArrayList getFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = AnalyzeCommand.getDir().listFiles();
        if (fileArray == null) {
            return arrayList;
        }
        String string = new File(AnalyzeCommand.getDir(), "analyze-commands").toString();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            if (!file.toString().startsWith(string) || file.toString().endsWith("~")) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    private static void readConfig(BufferedReader bufferedReader, String string, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) throws ErrorMessage {
        try {
            String string2;
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray;
                ++n;
                if ((string2 = string2.trim()).length() <= 0 || string2.charAt(0) == '#') continue;
                String[] stringArray2 = string2.split("/");
                if (stringArray2.length < 3 || stringArray2.length > 5) {
                    throw new ErrorMessage("Error in " + string + " line " + n);
                }
                if (arrayList3 != null && ((stringArray = StringUtils.splitArguments(stringArray2[2].trim())).length == 0 || !arrayList3.contains(stringArray[0])) || arrayList2.contains(stringArray = stringArray2[1])) continue;
                arrayList2.add(stringArray);
                arrayList.add(string2);
            }
        }
        catch (IOException iOException) {
            throw new ErrorMessage("Error reading " + string);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                throw new ErrorMessage("Error reading " + string);
            }
        }
    }

    static {
        $assertionsDisabled = !AnalyzeCommand.class.desiredAssertionStatus();
    }
}

