/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.twogtp;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import net.sf.gogui.game.GameInformation;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.Node;
import net.sf.gogui.game.NodeUtils;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.BoardUtils;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.go.MoveUtils;
import net.sf.gogui.sgf.SgfReader;

public final class Compare {
    public static String checkDuplicate(Board board, ArrayList arrayList, ArrayList arrayList2, boolean bl, boolean bl2) {
        String string = "-";
        for (int i = 0; i < arrayList2.size(); ++i) {
            if (bl && i % 2 != 0 != bl2) continue;
            ArrayList arrayList3 = (ArrayList)arrayList2.get(i);
            for (int j = 0; j < 8; ++j) {
                int n = 0;
                int n2 = arrayList.size();
                int n3 = n2 / 5;
                if (arrayList3.size() != n2) {
                    n = Math.abs(arrayList3.size() - n2);
                    n2 = Math.min(arrayList3.size(), n2);
                }
                for (int k = 0; n <= n3 && k < n2; ++k) {
                    Move move = (Move)arrayList.get(k);
                    GoPoint goPoint = move.getPoint();
                    GoColor goColor = move.getColor();
                    Move move2 = (Move)arrayList3.get(k);
                    GoPoint goPoint2 = BoardUtils.rotate(j, move2.getPoint(), board.getSize());
                    GoColor goColor2 = move2.getColor();
                    if (goColor.equals(goColor2) && goPoint == goPoint2) continue;
                    ++n;
                }
                if (n == 0) {
                    return Integer.toString(i);
                }
                if (n >= n3) continue;
                string = Integer.toString(i) + "?";
            }
        }
        return string;
    }

    public static void compare(ArrayList arrayList) throws Exception {
        Board board = null;
        ArrayList<ArrayList> arrayList2 = new ArrayList<ArrayList>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            SgfReader sgfReader = new SgfReader(fileInputStream, file.toString(), null, 0L);
            GameTree gameTree = sgfReader.getGameTree();
            GameInformation gameInformation = gameTree.getGameInformation();
            int n = gameInformation.m_boardSize;
            if (board == null) {
                board = new Board(n);
            } else if (n != board.getSize()) {
                throw new Exception("Board size in " + string + " does not match other games");
            }
            ArrayList arrayList3 = Compare.getAllAsMoves(gameTree.getRoot());
            String string2 = Compare.checkDuplicate(board, arrayList3, arrayList2, false, false);
            System.out.println(Integer.toString(i) + " " + string + " " + string2);
            arrayList2.add(arrayList3);
        }
    }

    public static ArrayList getAllAsMoves(Node node) {
        ArrayList arrayList = new ArrayList(128);
        while (node != null) {
            arrayList.addAll(NodeUtils.getAllAsMoves(node));
            node = node.getChild();
        }
        arrayList = MoveUtils.fillPasses(arrayList, GoColor.BLACK);
        return arrayList;
    }

    private Compare() {
    }
}

