/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public final class Preferences {
    private boolean m_changed;
    private final Properties m_properties = new Properties();

    public Preferences() {
        this.load();
    }

    public boolean contains(String string) {
        return this.m_properties.getProperty(string) != null;
    }

    public boolean getBool(String string) {
        return this.getInt(string) != 0;
    }

    public int getInt(String string) {
        try {
            return Integer.parseInt(this.getString(string));
        }
        catch (NumberFormatException numberFormatException) {
            this.throwFormatError(string);
            return 0;
        }
    }

    public double getDouble(String string) {
        try {
            return Double.parseDouble(this.getString(string));
        }
        catch (NumberFormatException numberFormatException) {
            this.throwFormatError(string);
            return 0.0;
        }
    }

    public String getString(String string) {
        return this.m_properties.getProperty(string);
    }

    public void load() {
        this.m_changed = true;
        File file = this.getFilename();
        if (!file.exists()) {
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.m_properties.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
        this.m_changed = false;
    }

    public void save() {
        if (!this.m_changed) {
            return;
        }
        File file = this.getFilename();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.m_properties.store(fileOutputStream, "GoGui preferences");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Could not save " + file.toString());
        }
        catch (IOException iOException) {
            System.err.println("Could not save " + file.toString());
        }
        this.m_changed = false;
    }

    public void setBool(String string, boolean bl) {
        this.setString(string, bl ? "1" : "0");
    }

    public void setBoolDefault(String string, boolean bl) {
        this.setStringDefault(string, bl ? "1" : "0");
    }

    public void setDouble(String string, double d) {
        this.setString(string, Double.toString(d));
    }

    public void setDoubleDefault(String string, double d) {
        this.setStringDefault(string, Double.toString(d));
    }

    public void setInt(String string, int n) {
        this.setString(string, Integer.toString(n));
    }

    public void setIntDefault(String string, int n) {
        this.setStringDefault(string, Integer.toString(n));
    }

    public void setString(String string, String string2) {
        if (this.contains(string) && this.getString(string).equals(string2)) {
            return;
        }
        this.m_properties.setProperty(string, string2);
        this.m_changed = true;
    }

    public void setStringDefault(String string, String string2) {
        if (this.contains(string)) {
            return;
        }
        this.m_properties.setProperty(string, string2);
        this.m_changed = true;
    }

    private File getFilename() {
        String string = System.getProperty("user.home");
        File file = new File(string, ".gogui");
        if (!file.exists()) {
            file.mkdir();
        }
        return new File(file, "config");
    }

    private void throwFormatError(String string) {
        throw new Error("Invalid value in " + this.getFilename() + " for " + string);
    }
}

