/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtpstatistics;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import net.sf.gogui.gtpstatistics.Analyze;
import net.sf.gogui.gtpstatistics.GtpStatistics;
import net.sf.gogui.utils.ErrorMessage;
import net.sf.gogui.utils.Options;
import net.sf.gogui.utils.StringUtils;
import net.sf.gogui.version.Version;

public final class Main {
    public static void main(String[] stringArray) {
        try {
            String[] stringArray2 = new String[]{"analyze:", "backward", "begin:", "commands:", "config:", "final:", "force", "help", "max:", "min:", "output:", "precision:", "program:", "setup", "size:", "verbose", "version"};
            Options options = Options.parse(stringArray, stringArray2);
            if (options.isSet("help")) {
                Main.printUsage(System.out);
                return;
            }
            if (options.isSet("version")) {
                System.out.println("GtpStatistics " + Version.get());
                return;
            }
            boolean bl = options.isSet("analyze");
            boolean bl2 = options.isSet("setup");
            boolean bl3 = options.isSet("backward");
            String string = "";
            if (!bl) {
                if (!options.isSet("program")) {
                    System.out.println("Need option -program");
                    System.exit(-1);
                }
                string = options.getString("program");
            }
            boolean bl4 = options.isSet("verbose");
            boolean bl5 = options.isSet("force");
            int n = options.getInteger("min", 0, 0);
            int n2 = options.getInteger("max", Integer.MAX_VALUE, 0);
            int n3 = options.getInteger("precision", 3, 0);
            int n4 = options.getInteger("size", 19, 1, 25);
            ArrayList arrayList = Main.parseCommands(options, "commands");
            ArrayList arrayList2 = Main.parseCommands(options, "final");
            ArrayList arrayList3 = Main.parseCommands(options, "begin");
            ArrayList arrayList4 = options.getArguments();
            int n5 = arrayList4.size();
            if (bl) {
                if (n5 > 0) {
                    Main.printUsage(System.err);
                    System.exit(-1);
                }
                String string2 = options.getString("analyze");
                String string3 = options.getString("output");
                new Analyze(string2, string3, n3);
            } else {
                if (n5 < 1) {
                    Main.printUsage(System.err);
                    System.exit(-1);
                }
                File file = options.isSet("output") ? new File(options.getString("output")) : new File("gtpstatistics.dat");
                GtpStatistics gtpStatistics = new GtpStatistics(string, arrayList4, file, n4, arrayList, arrayList3, arrayList2, bl4, bl5, bl2, n, n2, bl3);
                System.exit(gtpStatistics.getResult() ? 0 : -1);
            }
        }
        catch (Throwable throwable) {
            StringUtils.printException(throwable);
            System.exit(-1);
        }
    }

    private Main() {
    }

    private static ArrayList parseCommands(Options options, String string) throws ErrorMessage {
        ArrayList<String> arrayList = null;
        if (options.isSet(string)) {
            String string2 = options.getString(string);
            String[] stringArray = StringUtils.split(string2, ',');
            arrayList = new ArrayList<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i].trim());
            }
        }
        return arrayList;
    }

    private static void printUsage(PrintStream printStream) {
        printStream.print("Usage: java -jar gtpstatistics.jar -program program [options] file.sgf|dir [...]\n\n-analyze      Create HTML file from result file\n-begin        GTP commands to run on begin positions\n-backward     Iterate backward from end position\n-commands     GTP commands to run (comma separated)\n-config       Config file\n-final        GTP commands to run on final positions\n-force        Overwrite existing file\n-help         Display this help and exit\n-max          Only positions with maximum move number\n-min          Only positions with minimum move number\n-output       Filename prefix for output files\n-precision    Floating point precision for -analyze\n-setup        Allow setup stones in root position\n-size         Board size of games\n-verbose      Log GTP stream to stderr\n-version      Display this help and exit\n");
    }
}

