/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtpstatistics;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;
import net.sf.gogui.gui.GuiUtils;
import net.sf.gogui.utils.Table;
import net.sf.gogui.utils.TableUtils;

public class Plot {
    private boolean m_autoXMax = true;
    private boolean m_autoXMin = true;
    private boolean m_autoXTics = true;
    private boolean m_autoYMin = true;
    private boolean m_autoYMax = true;
    private boolean m_autoYTics = true;
    private boolean m_noLines = false;
    private boolean m_onlyBoolValues;
    private boolean m_onlyIntValuesX;
    private boolean m_onlyIntValuesY;
    private boolean m_plotYZero = true;
    private boolean m_useSolidLineInterval = false;
    private boolean m_withBars;
    private boolean m_xLabelsBool;
    private int m_fontHeight;
    private int m_bottom;
    private int m_height;
    private final int m_imgHeight;
    private final int m_imgWidth;
    private int m_left;
    private final int m_precision;
    private int m_right;
    private int m_top;
    private int m_width;
    private int m_xLabelPerTic = 1;
    private double m_barWidth;
    private double m_minX;
    private double m_maxX;
    private double m_minY;
    private double m_maxY;
    private double m_solidLineInterval;
    private double m_xRange;
    private double m_xTics;
    private double m_xTicsMin;
    private double m_yRange;
    private double m_yTics;
    private double m_yTicsMin;
    private final Color m_color;
    private DecimalFormat m_formatX;
    private DecimalFormat m_formatY;
    private FontMetrics m_metrics;
    private Graphics2D m_graphics2D;
    private String m_title;

    public Plot(int n, int n2, Color color, int n3) {
        this.m_precision = n3;
        this.m_color = color;
        this.m_imgWidth = n;
        this.m_imgHeight = n2;
    }

    public void plot(File file, Table table, String string, String string2, String string3) throws IOException {
        int n = 1;
        BufferedImage bufferedImage = new BufferedImage(this.m_imgWidth, this.m_imgHeight, n);
        this.m_graphics2D = bufferedImage.createGraphics();
        GuiUtils.setAntiAlias(this.m_graphics2D);
        Font font = this.m_graphics2D.getFont();
        if (font != null) {
            font = font.deriveFont((float)((double)font.getSize() * 0.8));
            this.m_graphics2D.setFont(font);
        }
        this.m_metrics = this.m_graphics2D.getFontMetrics();
        this.m_fontHeight = this.m_metrics.getHeight();
        this.m_left = 4 * this.m_fontHeight;
        this.m_top = this.m_title != null ? (int)((double)this.m_fontHeight * 1.7) : (int)((double)this.m_fontHeight * 0.5);
        this.m_right = this.m_imgWidth - (int)((double)this.m_fontHeight * 0.5);
        this.m_bottom = this.m_imgHeight - (int)((double)this.m_fontHeight * 1.5);
        this.m_width = this.m_right - this.m_left;
        this.m_height = this.m_bottom - this.m_top;
        this.initScale(table, string, string2);
        this.drawBackground();
        this.drawGrid();
        this.drawData(table, string, string2, string3, this.m_withBars);
        this.m_graphics2D.dispose();
        ImageIO.write((RenderedImage)bufferedImage, "png", file);
    }

    public void setFormatX(DecimalFormat decimalFormat) {
        this.m_formatX = decimalFormat;
    }

    public void setFormatY(DecimalFormat decimalFormat) {
        this.m_formatY = decimalFormat;
    }

    public void setPlotStyleBars(double d) {
        this.m_withBars = true;
        this.m_barWidth = d;
    }

    public void setPlotStyleNoLines() {
        this.m_noLines = true;
    }

    public void setNoPlotYZero() {
        this.m_plotYZero = false;
    }

    public void setSolidLineInterval(double d) {
        this.m_solidLineInterval = d;
        this.m_useSolidLineInterval = true;
    }

    public void setXLabelPerTic(int n) {
        this.m_xLabelPerTic = n;
    }

    public void setXLabelsBool() {
        this.m_xLabelsBool = true;
        this.setXMin(-5.0);
        this.setXMax(5.0);
        this.setXTics(1.0);
    }

    public void setXMax(double d) {
        this.m_maxX = d;
        this.m_autoXMax = false;
    }

    public void setXMin(double d) {
        this.m_minX = d;
        this.m_autoXMin = false;
    }

    public void setXTics(double d) {
        this.m_xTics = d;
        this.m_autoXTics = false;
    }

    public void setYMax(double d) {
        this.m_maxY = d;
        this.m_autoYMax = false;
    }

    public void setYMin(double d) {
        this.m_minY = d;
        this.m_autoYMin = false;
    }

    public void setYTics(double d) {
        this.m_yTics = d;
        this.m_autoYTics = false;
    }

    public void setTitle(String string) {
        this.m_title = string;
    }

    private void drawBackground() {
        this.m_graphics2D.setColor(Color.decode("#e0e0e0"));
        this.m_graphics2D.fillRect(0, 0, this.m_imgWidth, this.m_imgHeight);
        this.m_graphics2D.setColor(Color.WHITE);
        this.m_graphics2D.fillRect(this.m_left, this.m_top, this.m_width, this.m_height);
        this.m_graphics2D.setColor(Color.BLACK);
        if (this.m_title != null) {
            int n = this.m_metrics.stringWidth(this.m_title) + 10;
            int n2 = (int)((double)this.m_fontHeight * 1.4);
            int n3 = this.m_left + (this.m_width - n) / 2;
            int n4 = (this.m_top - n2) / 2;
            this.m_graphics2D.setColor(Color.decode("#ffffe1"));
            this.m_graphics2D.fillRect(n3, n4, n, n2);
            this.m_graphics2D.setColor(Color.DARK_GRAY);
            this.m_graphics2D.drawRect(n3, n4, n, n2);
            this.drawString(this.m_title, this.m_left + this.m_width / 2, this.m_top / 2);
        }
    }

    private void drawData(Table table, String string, String string2, String string3, boolean bl) {
        this.m_graphics2D.setColor(this.m_color);
        Point point = null;
        int n = this.getPoint((double)this.m_barWidth, (double)0.0).x - this.getPoint((double)0.0, (double)0.0).x - 2;
        for (int i = 0; i < table.getNumberRows(); ++i) {
            try {
                String string4 = table.get(string, i);
                String string5 = table.get(string2, i);
                if (string4 == null || string5 == null) {
                    point = null;
                    continue;
                }
                double d = Double.parseDouble(string4);
                double d2 = Double.parseDouble(string5);
                Point point2 = this.getPoint(d, d2);
                if (bl) {
                    Point point3 = this.getPoint(d, 0.0);
                    this.m_graphics2D.fillRect(point2.x - n / 2 + 1, point2.y, n, point3.y - point2.y);
                } else if (point != null && !this.m_noLines) {
                    this.m_graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
                }
                if (string3 != null) {
                    double d3 = Double.parseDouble(table.get(string3, i));
                    Point point4 = this.getPoint(d, d2 + d3);
                    Point point5 = this.getPoint(d, d2 - d3);
                    this.m_graphics2D.drawLine(point4.x, point4.y, point5.x, point5.y);
                }
                if (!bl) {
                    this.m_graphics2D.fillRect(point2.x - 1, point2.y - 1, 3, 3);
                }
                point = point2;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                point = null;
            }
        }
    }

    private void drawGrid() {
        double d;
        Point point;
        double d2;
        Stroke stroke = this.m_graphics2D.getStroke();
        BasicStroke basicStroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f}, 0.0f);
        if (this.m_useSolidLineInterval) {
            d2 = (double)((int)(this.m_xTicsMin / this.m_solidLineInterval)) * this.m_solidLineInterval;
            int n = 0;
            double d3 = d2;
            while (d3 < this.m_maxX) {
                Point point2 = this.getPoint(d3, this.m_minY);
                Point point3 = this.getPoint(d3, this.m_maxY);
                if (n % 2 == 0) {
                    this.m_graphics2D.setColor(Color.decode("#f0f0f0"));
                    Point point4 = this.getPoint(d3 + this.m_solidLineInterval, this.m_maxY);
                    this.m_graphics2D.fillRect(point3.x, point3.y, Math.min(point4.x - point3.x, this.m_right - point3.x), point2.y - point3.y);
                }
                d3 += this.m_solidLineInterval;
                ++n;
            }
        }
        this.m_graphics2D.setStroke(basicStroke);
        for (d2 = this.m_xTicsMin; d2 < this.m_maxX; d2 += this.m_xTics) {
            Point point5 = this.getPoint(d2, this.m_minY);
            Point point6 = this.getPoint(d2, this.m_maxY);
            this.m_graphics2D.setColor(Color.LIGHT_GRAY);
            this.m_graphics2D.drawLine(point6.x, point6.y, point5.x, point5.y);
        }
        this.m_graphics2D.setStroke(stroke);
        this.m_graphics2D.setStroke(basicStroke);
        for (d2 = this.m_yTicsMin; d2 < this.m_maxY; d2 += this.m_yTics) {
            Point point7 = this.getPoint(this.m_minX, d2);
            Point point8 = this.getPoint(this.m_maxX, d2);
            this.m_graphics2D.setColor(Color.LIGHT_GRAY);
            this.m_graphics2D.drawLine(point7.x, point7.y, point8.x, point8.y);
        }
        this.m_graphics2D.setStroke(stroke);
        this.m_graphics2D.setColor(Color.GRAY);
        if (this.m_minX <= 0.0 && this.m_maxX >= 0.0) {
            Point point9 = this.getPoint(0.0, this.m_minY);
            point = this.getPoint(0.0, this.m_maxY);
            this.m_graphics2D.drawLine(point9.x, point9.y, point.x, point.y);
        }
        if (this.m_minY <= 0.0 && this.m_maxY >= 0.0) {
            Point point10 = this.getPoint(this.m_minX, 0.0);
            point = this.getPoint(this.m_maxX, 0.0);
            this.m_graphics2D.drawLine(point10.x, point10.y, point.x, point.y);
        }
        if (this.m_formatX == null) {
            this.m_formatX = this.getFormat(this.m_onlyIntValuesX);
        }
        if (this.m_formatY == null) {
            this.m_formatY = this.getFormat(this.m_onlyIntValuesY);
        }
        for (d = this.m_xTicsMin; d < this.m_maxX; d += (double)this.m_xLabelPerTic * this.m_xTics) {
            if (this.m_xLabelsBool && Math.round(d) != 0L && Math.round(d) != 1L) continue;
            Point point11 = this.getPoint(d, this.m_minY);
            String string = this.m_formatX.format(d);
            this.m_graphics2D.setColor(Color.GRAY);
            this.m_graphics2D.drawLine(point11.x, point11.y, point11.x, point11.y + 3);
            this.m_graphics2D.setColor(Color.BLACK);
            this.drawString(string, point11.x, this.m_bottom + (this.m_imgHeight - this.m_bottom) / 2);
        }
        for (d = this.m_yTicsMin; d < this.m_maxY; d += this.m_yTics) {
            if (!this.m_plotYZero && Math.round(d) == 0L) continue;
            Point point12 = this.getPoint(this.m_minX, d);
            String string = this.m_formatY.format(d);
            this.m_graphics2D.setColor(Color.GRAY);
            this.m_graphics2D.drawLine(point12.x, point12.y, point12.x - 3, point12.y);
            this.m_graphics2D.setColor(Color.BLACK);
            this.drawStringRightAlign(string, this.m_left - 5, point12.y);
        }
        this.m_graphics2D.setColor(Color.LIGHT_GRAY);
        this.m_graphics2D.drawRect(this.m_left, this.m_top, this.m_width, this.m_height);
        this.m_graphics2D.setColor(Color.GRAY);
        this.m_graphics2D.drawLine(this.m_left, this.m_top, this.m_left, this.m_bottom);
        this.m_graphics2D.drawLine(this.m_left, this.m_bottom, this.m_right, this.m_bottom);
        this.m_graphics2D.setStroke(stroke);
    }

    private void drawString(String string, int n, int n2) {
        FontMetrics fontMetrics = this.m_graphics2D.getFontMetrics();
        int n3 = fontMetrics.stringWidth(string);
        int n4 = this.m_fontHeight;
        this.m_graphics2D.drawString(string, n - n3 / 2, n2 + n4 / 2);
    }

    private void drawStringRightAlign(String string, int n, int n2) {
        FontMetrics fontMetrics = this.m_graphics2D.getFontMetrics();
        int n3 = fontMetrics.stringWidth(string);
        int n4 = this.m_fontHeight;
        this.m_graphics2D.drawString(string, n - n3, n2 + n4 / 2);
    }

    private DecimalFormat getFormat(boolean bl) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setGroupingUsed(false);
        if (bl) {
            decimalFormat.setMaximumFractionDigits(0);
        } else {
            decimalFormat.setMaximumFractionDigits(this.m_precision);
        }
        return decimalFormat;
    }

    private Point getPoint(double d, double d2) {
        int n = (int)((double)this.m_left + (d - this.m_minX) / this.m_xRange * (double)this.m_width);
        int n2 = (int)((double)this.m_bottom - (d2 - this.m_minY) / this.m_yRange * (double)this.m_height);
        return new Point(n, n2);
    }

    private double getTics(double d, int n) {
        n = Math.max(n, 2);
        double d2 = d / 2.1;
        double d3 = 1.0;
        if (d / (double)n < 1.0) {
            while (!(!(d / (d3 / 2.0) < (double)n) && !(d3 > d2) || d / ((d3 /= 2.0) / 2.0) > (double)n && d3 < d2 || d / ((d3 /= 2.0) / 2.5) > (double)n && d3 < d2)) {
                d3 /= 2.5;
            }
        } else {
            while (d / d3 > (double)n && d3 * 2.0 < d2 && !(d / (d3 *= 2.0) <= (double)n) && !(d3 * 2.5 > d2) && !(d / (d3 *= 2.5) <= (double)n) && !(d3 * 2.0 > d2)) {
                d3 *= 2.0;
            }
        }
        return d3;
    }

    private double getTicsMin(double d, double d2) {
        double d3 = (double)((int)(d2 / d)) * d;
        if (d3 < d2) {
            d3 += d;
        }
        return d3;
    }

    private void initScale(Table table, String string, String string2) {
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        this.m_onlyBoolValues = true;
        this.m_onlyIntValuesX = true;
        this.m_onlyIntValuesY = true;
        for (int i = 0; i < table.getNumberRows(); ++i) {
            String string3 = table.get(string, i);
            String string4 = table.get(string2, i);
            if (string3 == null || string4 == null || !TableUtils.isNumberValue(string4)) continue;
            if (!TableUtils.isBoolValue(string4)) {
                this.m_onlyBoolValues = false;
            }
            if (!TableUtils.isIntValue(string3)) {
                this.m_onlyIntValuesX = false;
            }
            if (!TableUtils.isIntValue(string4)) {
                this.m_onlyIntValuesY = false;
            }
            try {
                double d5 = Double.parseDouble(string3);
                double d6 = Double.parseDouble(string4);
                d = Math.min(d, d5);
                d2 = Math.max(d2, d5);
                d3 = Math.min(d3, d6);
                d4 = Math.max(d4, d6);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.initScaleX(d, d2);
        this.initScaleY(d3, d4);
    }

    private void initScaleX(double d, double d2) {
        if (this.m_autoXMin) {
            this.m_minX = d - 0.05 * (d2 - d);
        }
        if (this.m_autoXMax) {
            this.m_maxX = d2 + 0.05 * (d2 - this.m_minX);
        }
        if (this.m_minX > 0.0 && this.m_minX < 0.3 * this.m_maxX) {
            this.m_minX = 0.0;
        }
        if (this.m_minX == this.m_maxX) {
            this.m_minX -= 1.1;
            this.m_maxX += 1.1;
        }
        this.m_xRange = this.m_maxX - this.m_minX;
        if (this.m_autoXTics) {
            double d3 = Math.max(Math.abs(this.m_minX), Math.abs(this.m_maxX));
            double d4 = Math.log(10.0);
            int n = (int)(Math.log(d3) / d4) + this.m_precision + 3;
            int n2 = (int)((double)n * (0.7 * (double)this.m_fontHeight));
            int n3 = this.m_width / n2;
            this.m_xTics = this.getTics(this.m_xRange, n3);
        }
        if (this.m_onlyIntValuesX) {
            this.m_xTics = Math.max(1.0, this.m_xTics);
        }
        this.m_xTicsMin = this.getTicsMin(this.m_xTics, this.m_minX);
    }

    private void initScaleY(double d, double d2) {
        if (this.m_autoYMin) {
            this.m_minY = this.m_onlyBoolValues ? 0.0 : d;
        }
        if (this.m_autoYMax) {
            this.m_maxY = this.m_onlyBoolValues ? 1.1 : d2 + 0.05 * (d2 - this.m_minY);
        }
        if (this.m_autoYMin && this.m_minY > 0.0 && this.m_minY < 0.3 * this.m_maxY) {
            this.m_minY = 0.0;
        }
        if (this.m_minY == this.m_maxY) {
            this.m_minY -= 1.1;
            this.m_maxY += 1.1;
        }
        this.m_yRange = this.m_maxY - this.m_minY;
        if (this.m_autoYTics) {
            if (this.m_onlyBoolValues) {
                this.m_yTics = 1.0;
                this.m_yTicsMin = 0.0;
            } else {
                int n = (int)((double)this.m_height / (1.5 * (double)this.m_fontHeight));
                this.m_yTics = this.getTics(this.m_yRange, n);
                if (this.m_onlyIntValuesY) {
                    this.m_yTics = Math.max(1.0, this.m_yTics);
                }
            }
        }
        if (!this.m_onlyBoolValues) {
            this.m_yTicsMin = this.getTicsMin(this.m_yTics, this.m_minY);
        }
    }
}

