/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gogui;

import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import net.sf.gogui.game.GameTree;
import net.sf.gogui.game.Node;
import net.sf.gogui.game.NodeUtils;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.gogui.JMenuChecked;
import net.sf.gogui.gui.Bookmark;
import net.sf.gogui.gui.Clock;
import net.sf.gogui.gui.RecentFileMenu;
import net.sf.gogui.utils.Platform;

public class GoGuiMenuBar {
    private boolean m_findNextEnabled;
    private boolean m_isComputerDisabled;
    private static int[] s_possibleBoardSizes;
    private static int[] s_possibleHandicaps;
    private static final int SHORTCUT;
    private final ActionListener m_listener;
    private JCheckBoxMenuItem m_itemAutoNumber;
    private JCheckBoxMenuItem m_itemBeepAfterMove;
    private JCheckBoxMenuItem m_itemCleanup;
    private JCheckBoxMenuItem m_itemCommandCompletion;
    private JCheckBoxMenuItem m_itemShowAnalyze;
    private JCheckBoxMenuItem m_itemShowCursor;
    private JCheckBoxMenuItem m_itemShowGrid;
    private JCheckBoxMenuItem m_itemShowLastMove;
    private JCheckBoxMenuItem m_itemShowShell;
    private JCheckBoxMenuItem m_itemShowSubtreeSizes;
    private JCheckBoxMenuItem m_itemShowTree;
    private JCheckBoxMenuItem m_itemShowVariations;
    private JCheckBoxMenuItem m_itemSetup;
    private JCheckBoxMenuItem m_itemTimeStamp;
    private JMenuChecked m_menuComputerColor;
    private final JMenuChecked m_menuBookmarks;
    private final JMenuChecked m_menuFile;
    private final JMenuChecked m_menuHelp;
    private final JMenuChecked m_menuShell;
    private final JMenuChecked m_menuSettings;
    private final JMenuBar m_menuBar;
    private JMenuItem m_itemAbout;
    private JMenuItem m_itemAnalyzeOnlySupported;
    private JMenuItem m_itemAnalyzeSort;
    private JMenuItem m_itemBackToMainVar;
    private JMenuItem m_itemBackward;
    private JMenuItem m_itemBackward10;
    private JMenuItem m_itemBeginning;
    private JMenuItem[] m_itemBoardSize;
    private JMenuItem m_itemBoardSizeOther;
    private JMenuItem m_itemClockHalt;
    private JMenuItem m_itemClockRestore;
    private JMenuItem m_itemClockResume;
    private JMenuItem m_itemCommentFontFixed;
    private JMenuItem m_itemComputerBlack;
    private JMenuItem m_itemComputerBoth;
    private JMenuItem m_itemComputerNone;
    private JMenuItem m_itemComputerPlay;
    private JMenuItem m_itemComputerPlaySingle;
    private JMenuItem m_itemComputerWhite;
    private JMenuItem m_itemDetachProgram;
    private JMenuItem m_itemEnd;
    private JMenuItem m_itemFindNext;
    private JMenuItem m_itemForward;
    private JMenuItem m_itemForward10;
    private JMenuItem m_itemGameTreeLarge;
    private JMenuItem m_itemGameTreeMove;
    private JMenuItem m_itemGameTreeNormal;
    private JMenuItem m_itemGameTreeNone;
    private JMenuItem m_itemGameTreeNumber;
    private JMenuItem m_itemGameTreeSmall;
    private JMenuItem m_itemGameTreeTiny;
    private JMenuItem m_itemGoto;
    private JMenuItem m_itemGotoVar;
    private JMenuItem m_itemHelp;
    private JMenuItem m_itemInterrupt;
    private JMenuItem m_itemKeepOnlyMainVar;
    private JMenuItem m_itemKeepOnlyPosition;
    private JMenuItem m_itemMakeMainVar;
    private JMenuItem m_itemNextVariation;
    private JMenuItem m_itemNextEarlierVariation;
    private JMenuItem m_itemPreviousVariation;
    private JMenuItem m_itemPreviousEarlierBackward;
    private JMenuItem m_itemQuit;
    private JMenuItem m_itemSetupBlack;
    private JMenuItem m_itemSetupWhite;
    private JMenuItem m_itemShowInfoPanel;
    private JMenuItem m_itemShowToolbar;
    private JMenuItem m_itemSaveCommands;
    private JMenuItem m_itemSaveLog;
    private JMenuItem m_itemTruncate;
    private JMenuItem m_itemTruncateChildren;
    private JSeparator m_bookmarksSeparator;
    private RecentFileMenu m_recent;
    private RecentFileMenu m_recentGtp;
    private final ArrayList m_bookmarkItems = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;

    public GoGuiMenuBar(ActionListener actionListener, RecentFileMenu.Callback callback, RecentFileMenu.Callback callback2) {
        this.m_listener = actionListener;
        this.m_menuBar = new JMenuBar();
        this.m_menuFile = this.createMenuFile(callback);
        this.m_menuBar.add(this.m_menuFile);
        this.m_menuBar.add(this.createMenuGame());
        this.m_menuBar.add(this.createMenuEdit());
        this.m_menuBar.add(this.createMenuGo());
        this.m_menuShell = this.createMenuShell(callback2);
        this.m_menuBar.add(this.m_menuShell);
        this.m_menuBookmarks = this.createMenuBookMarks();
        this.m_menuBar.add(this.m_menuBookmarks);
        this.m_menuSettings = this.createMenuSettings();
        this.m_menuBar.add(this.m_menuSettings);
        this.m_menuHelp = this.createMenuHelp();
        this.m_menuBar.add(this.m_menuHelp);
        this.setHeaderStyleSingle(true);
    }

    public void addRecent(File file) {
        try {
            File file2 = file.getCanonicalFile();
            if (file2.exists()) {
                file = file2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_recent.add(file);
    }

    public void addRecentGtp(File file) {
        try {
            File file2 = file.getCanonicalFile();
            if (file2.exists()) {
                file = file2;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_recentGtp.add(file);
    }

    public void enableCleanup(boolean bl) {
        this.m_itemCleanup.setEnabled(bl);
    }

    public void enableFindNext(boolean bl) {
        this.m_findNextEnabled = bl;
        this.m_itemFindNext.setEnabled(bl);
    }

    public boolean getAnalyzeOnlySupported() {
        return this.m_itemAnalyzeOnlySupported.isSelected();
    }

    public boolean getAnalyzeSort() {
        return this.m_itemAnalyzeSort.isSelected();
    }

    public boolean getAutoNumber() {
        return this.m_itemAutoNumber.isSelected();
    }

    public boolean getTimeStamp() {
        return this.m_itemTimeStamp.isSelected();
    }

    public boolean getCleanup() {
        return this.m_itemCleanup.isSelected();
    }

    public boolean getCommandCompletion() {
        return this.m_itemCommandCompletion.isSelected();
    }

    public boolean getCommentFontFixed() {
        return this.m_itemCommentFontFixed.isSelected();
    }

    public boolean getBeepAfterMove() {
        return this.m_itemBeepAfterMove.isSelected();
    }

    public int getGameTreeLabels() {
        if (this.m_itemGameTreeNumber.isSelected()) {
            return 0;
        }
        if (this.m_itemGameTreeMove.isSelected()) {
            return 1;
        }
        return 2;
    }

    public int getGameTreeSize() {
        if (this.m_itemGameTreeLarge.isSelected()) {
            return 0;
        }
        if (this.m_itemGameTreeSmall.isSelected()) {
            return 2;
        }
        if (this.m_itemGameTreeTiny.isSelected()) {
            return 3;
        }
        return 1;
    }

    public JMenuBar getMenuBar() {
        return this.m_menuBar;
    }

    public boolean getShowAnalyze() {
        return this.m_itemShowAnalyze.isSelected();
    }

    public boolean getShowCursor() {
        return this.m_itemShowCursor.isSelected();
    }

    public boolean getShowGrid() {
        return this.m_itemShowGrid.isSelected();
    }

    public boolean getShowInfoPanel() {
        return this.m_itemShowInfoPanel.isSelected();
    }

    public boolean getShowLastMove() {
        return this.m_itemShowLastMove.isSelected();
    }

    public boolean getShowShell() {
        return this.m_itemShowShell.isSelected();
    }

    public boolean getShowSubtreeSizes() {
        return this.m_itemShowSubtreeSizes.isSelected();
    }

    public boolean getShowToolbar() {
        return this.m_itemShowToolbar.isSelected();
    }

    public boolean getShowTree() {
        return this.m_itemShowTree.isSelected();
    }

    public boolean getShowVariations() {
        return this.m_itemShowVariations.isSelected();
    }

    public void setAnalyzeOnlySupported(boolean bl) {
        this.m_itemAnalyzeOnlySupported.setSelected(bl);
    }

    public void setAnalyzeSort(boolean bl) {
        this.m_itemAnalyzeSort.setSelected(bl);
    }

    public void setAutoNumber(boolean bl) {
        this.m_itemAutoNumber.setSelected(bl);
    }

    public void setBookmarks(ArrayList arrayList) {
        int n;
        for (n = 0; n < this.m_bookmarkItems.size(); ++n) {
            this.m_menuBookmarks.remove((JMenuItem)this.m_bookmarkItems.get(n));
        }
        if (this.m_bookmarksSeparator != null) {
            this.m_menuBookmarks.remove(this.m_bookmarksSeparator);
            this.m_bookmarksSeparator = null;
        }
        if (arrayList.size() == 0) {
            return;
        }
        this.m_bookmarksSeparator = new JSeparator();
        this.m_menuBookmarks.add(this.m_bookmarksSeparator);
        for (n = 0; n < arrayList.size(); ++n) {
            Bookmark bookmark = (Bookmark)arrayList.get(n);
            JMenuItem jMenuItem = new JMenuItem(bookmark.m_name);
            this.m_menuBookmarks.addItem(jMenuItem, "bookmark-" + n);
            this.m_bookmarkItems.add(jMenuItem);
        }
    }

    public void setComputerBlack() {
        this.m_itemComputerBlack.setSelected(true);
    }

    public void setComputerBoth() {
        this.m_itemComputerBoth.setSelected(true);
    }

    public void setComputerEnabled(boolean bl) {
        this.m_isComputerDisabled = !bl;
        this.m_menuComputerColor.setEnabled(bl);
        this.m_itemComputerPlay.setEnabled(bl);
        this.m_itemComputerPlaySingle.setEnabled(bl);
        this.m_itemBeepAfterMove.setEnabled(bl);
        this.m_itemDetachProgram.setEnabled(bl);
        this.enableAll(this.m_menuShell, bl);
        this.m_itemShowAnalyze.setEnabled(bl);
        this.m_itemShowShell.setEnabled(bl);
        if (!bl) {
            this.enableCleanup(false);
        }
    }

    public void setComputerNone() {
        this.m_itemComputerNone.setSelected(true);
    }

    public void setComputerWhite() {
        this.m_itemComputerWhite.setSelected(true);
    }

    public void selectBoardSizeItem(int n) {
        for (int i = 0; i < s_possibleBoardSizes.length; ++i) {
            if (s_possibleBoardSizes[i] != n) continue;
            this.m_itemBoardSize[i].setSelected(true);
            return;
        }
        this.m_itemBoardSizeOther.setSelected(true);
    }

    public void setBeepAfterMove(boolean bl) {
        this.m_itemBeepAfterMove.setSelected(bl);
    }

    public void setCleanup(boolean bl) {
        this.m_itemCleanup.setSelected(bl);
    }

    public void setCommandInProgress() {
        if (!$assertionsDisabled && this.m_isComputerDisabled) {
            throw new AssertionError();
        }
        this.disableAll();
        this.m_menuFile.setEnabled(true);
        this.m_itemDetachProgram.setEnabled(true);
        this.m_itemQuit.setEnabled(true);
        this.m_itemInterrupt.setEnabled(true);
        this.m_menuComputerColor.setEnabled(true);
        this.m_menuHelp.setEnabled(true);
        this.m_itemAbout.setEnabled(true);
        this.m_itemHelp.setEnabled(true);
        this.m_menuSettings.setEnabled(true);
        this.m_itemBeepAfterMove.setEnabled(true);
        this.m_itemShowCursor.setEnabled(true);
        this.m_itemShowGrid.setEnabled(true);
        this.m_itemShowInfoPanel.setEnabled(true);
        this.m_itemShowLastMove.setEnabled(true);
        this.m_itemShowToolbar.setEnabled(true);
        this.m_itemShowVariations.setEnabled(true);
        this.m_itemShowAnalyze.setEnabled(true);
        this.m_itemShowShell.setEnabled(true);
        this.m_itemShowTree.setEnabled(true);
        this.m_itemSaveLog.setEnabled(true);
        this.m_itemSaveCommands.setEnabled(true);
        this.m_itemCommandCompletion.setEnabled(true);
        this.m_itemAutoNumber.setEnabled(true);
        this.m_itemTimeStamp.setEnabled(true);
    }

    public void setCommandCompletion(boolean bl) {
        this.m_itemCommandCompletion.setSelected(bl);
    }

    public void setCommentFontFixed(boolean bl) {
        this.m_itemCommentFontFixed.setSelected(bl);
    }

    public void setGameTreeLabels(int n) {
        switch (n) {
            case 0: {
                this.m_itemGameTreeNumber.setSelected(true);
                break;
            }
            case 1: {
                this.m_itemGameTreeMove.setSelected(true);
                break;
            }
            case 2: {
                this.m_itemGameTreeNone.setSelected(true);
                break;
            }
        }
    }

    public void setGameTreeSize(int n) {
        switch (n) {
            case 0: {
                this.m_itemGameTreeLarge.setSelected(true);
                break;
            }
            case 1: {
                this.m_itemGameTreeNormal.setSelected(true);
                break;
            }
            case 2: {
                this.m_itemGameTreeSmall.setSelected(true);
                break;
            }
            case 3: {
                this.m_itemGameTreeTiny.setSelected(true);
                break;
            }
        }
    }

    public void setHeaderStyleSingle(boolean bl) {
        this.getMenuBar().putClientProperty("jgoodies.headerStyle", bl ? "Single" : "Both");
    }

    public void setTimeStamp(boolean bl) {
        this.m_itemTimeStamp.setSelected(bl);
    }

    public void setNormalMode() {
        this.enableAll();
        this.m_itemInterrupt.setEnabled(false);
        this.m_itemSetup.setSelected(false);
        this.m_itemSetupBlack.setEnabled(false);
        this.m_itemSetupWhite.setEnabled(false);
        this.m_itemFindNext.setEnabled(this.m_findNextEnabled);
        this.setComputerEnabled(!this.m_isComputerDisabled);
    }

    public void setSetupMode() {
        this.disableAll();
        this.m_itemSetup.setEnabled(true);
        this.m_itemSetupBlack.setEnabled(true);
        this.m_itemSetupWhite.setEnabled(true);
        this.m_itemSetupBlack.setSelected(true);
        this.m_itemAbout.setEnabled(true);
        this.m_itemQuit.setEnabled(true);
        this.m_itemHelp.setEnabled(true);
    }

    public void setScoreMode() {
        this.disableAll();
        this.m_itemHelp.setEnabled(true);
        this.m_itemAbout.setEnabled(true);
        this.m_itemQuit.setEnabled(true);
    }

    public void setShowAnalyze(boolean bl) {
        this.m_itemShowAnalyze.setSelected(bl);
    }

    public void setShowCursor(boolean bl) {
        this.m_itemShowCursor.setSelected(bl);
    }

    public void setShowGrid(boolean bl) {
        this.m_itemShowGrid.setSelected(bl);
    }

    public void setShowInfoPanel(boolean bl) {
        this.m_itemShowInfoPanel.setSelected(bl);
    }

    public void setShowLastMove(boolean bl) {
        this.m_itemShowLastMove.setSelected(bl);
    }

    public void setShowShell(boolean bl) {
        this.m_itemShowShell.setSelected(bl);
    }

    public void setShowSubtreeSizes(boolean bl) {
        this.m_itemShowSubtreeSizes.setSelected(bl);
    }

    public void setShowToolbar(boolean bl) {
        this.m_itemShowToolbar.setSelected(bl);
    }

    public void setShowTree(boolean bl) {
        this.m_itemShowTree.setSelected(bl);
    }

    public void setShowVariations(boolean bl) {
        this.m_itemShowVariations.setSelected(bl);
    }

    public void update(GameTree gameTree, Node node, Clock clock) {
        Node node2 = node.getFather();
        boolean bl = node2 != null;
        boolean bl2 = node.getNumberChildren() > 0;
        boolean bl3 = NodeUtils.getNextVariation(node) != null;
        boolean bl4 = NodeUtils.getNextEarlierVariation(node) != null;
        boolean bl5 = NodeUtils.getPreviousEarlierVariation(node) != null;
        boolean bl6 = NodeUtils.getPreviousVariation(node) != null;
        boolean bl7 = NodeUtils.isInMainVariation(node);
        boolean bl8 = gameTree.hasVariations();
        this.m_itemBeginning.setEnabled(bl);
        this.m_itemBackward.setEnabled(bl);
        this.m_itemBackward10.setEnabled(bl);
        this.m_itemForward.setEnabled(bl2);
        this.m_itemForward10.setEnabled(bl2);
        this.m_itemEnd.setEnabled(bl2);
        this.m_itemGoto.setEnabled(bl || bl2);
        this.m_itemGotoVar.setEnabled(bl || bl2);
        this.m_itemNextVariation.setEnabled(bl3);
        this.m_itemPreviousVariation.setEnabled(bl6);
        this.m_itemNextEarlierVariation.setEnabled(bl4);
        this.m_itemPreviousEarlierBackward.setEnabled(bl5);
        this.m_itemBackToMainVar.setEnabled(!bl7);
        this.m_itemTruncate.setEnabled(bl);
        this.m_itemTruncateChildren.setEnabled(bl2);
        this.m_itemMakeMainVar.setEnabled(!bl7);
        this.m_itemKeepOnlyMainVar.setEnabled(bl7 && bl8);
        this.m_itemKeepOnlyPosition.setEnabled(bl || bl2);
        this.m_itemClockHalt.setEnabled(clock.isRunning());
        this.m_itemClockResume.setEnabled(!clock.isRunning());
        boolean bl9 = clock.isInitialized() && (this.canRestoreTime(node) || node2 != null && this.canRestoreTime(node2));
        this.m_itemClockRestore.setEnabled(bl9);
        if (!NodeUtils.isInCleanup(node)) {
            this.setCleanup(false);
        }
    }

    private boolean canRestoreTime(Node node) {
        return !Double.isNaN(node.getTimeLeft(GoColor.BLACK)) || !Double.isNaN(node.getTimeLeft(GoColor.WHITE)) || node.getFather() == null;
    }

    private JMenuChecked createBoardSizeMenu() {
        JMenuItem jMenuItem;
        JMenuChecked jMenuChecked = this.createMenu("Board Size", 83);
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = s_possibleBoardSizes.length;
        this.m_itemBoardSize = new JMenuItem[n];
        for (int i = 0; i < n; ++i) {
            JMenuItem jMenuItem2;
            String string = Integer.toString(s_possibleBoardSizes[i]);
            this.m_itemBoardSize[i] = jMenuItem2 = jMenuChecked.addRadioItem(buttonGroup, string, "board-size-" + string);
        }
        jMenuChecked.addSeparator();
        this.m_itemBoardSizeOther = jMenuItem = jMenuChecked.addRadioItem(buttonGroup, "Other", "board-size-other");
        return jMenuChecked;
    }

    private JMenuChecked createClockMenu() {
        JMenuChecked jMenuChecked = this.createMenu("Clock", 75);
        this.m_itemClockHalt = jMenuChecked.addItem("Halt", 72, "clock-halt");
        this.m_itemClockResume = jMenuChecked.addItem("Resume", 82, "clock-resume");
        this.m_itemClockRestore = jMenuChecked.addItem("Restore", 83, "clock-restore");
        return jMenuChecked;
    }

    private JMenuChecked createComputerColorMenu() {
        ButtonGroup buttonGroup = new ButtonGroup();
        JMenuChecked jMenuChecked = this.createMenu("Computer Color", 67);
        this.m_itemComputerBlack = jMenuChecked.addRadioItem(buttonGroup, "Black", 66, "computer-black");
        this.m_itemComputerWhite = jMenuChecked.addRadioItem(buttonGroup, "White", 87, "computer-white");
        this.m_itemComputerBoth = jMenuChecked.addRadioItem(buttonGroup, "Both", 84, "computer-both");
        this.m_itemComputerNone = jMenuChecked.addRadioItem(buttonGroup, "None", 78, "computer-none");
        return jMenuChecked;
    }

    private JMenuChecked createHandicapMenu() {
        JMenuChecked jMenuChecked = this.createMenu("Handicap", 72);
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < s_possibleHandicaps.length; ++i) {
            String string = Integer.toString(s_possibleHandicaps[i]);
            JMenuItem jMenuItem = jMenuChecked.addRadioItem(buttonGroup, string, "handicap-" + string);
            if (s_possibleHandicaps[i] != 0) continue;
            jMenuItem.setSelected(true);
        }
        return jMenuChecked;
    }

    private JMenuChecked createMenu(String string, int n) {
        JMenuChecked jMenuChecked = new JMenuChecked(string, this.m_listener);
        jMenuChecked.setMnemonic(n);
        return jMenuChecked;
    }

    private JMenuChecked createMenuBookMarks() {
        JMenuChecked jMenuChecked = this.createMenu("Bookmarks", 66);
        jMenuChecked.addItem("Add Bookmark", 65, 66, SHORTCUT, "add-bookmark");
        jMenuChecked.addItem("Edit Bookmarks...", 69, "edit-bookmarks");
        return jMenuChecked;
    }

    private JMenuChecked createMenuConfigureAnalyze() {
        JMenuChecked jMenuChecked = new JMenuChecked("Configure Analyze", this.m_listener);
        jMenuChecked.setMnemonic(78);
        this.m_itemAnalyzeOnlySupported = new JCheckBoxMenuItem("Only Supported Commands");
        jMenuChecked.addItem(this.m_itemAnalyzeOnlySupported, 79, "analyze-only-supported");
        this.m_itemAnalyzeSort = new JCheckBoxMenuItem("Sort Alphabetically");
        jMenuChecked.addItem(this.m_itemAnalyzeSort, 83, "analyze-sort");
        jMenuChecked.addSeparator();
        jMenuChecked.addItem("Reload Configuration", 82, "analyze-reload");
        return jMenuChecked;
    }

    private JMenuChecked createMenuConfigureBoard() {
        JMenuChecked jMenuChecked = new JMenuChecked("Configure Board", this.m_listener);
        jMenuChecked.setMnemonic(66);
        this.m_itemShowCursor = new JCheckBoxMenuItem("Show Cursor");
        this.m_itemShowCursor.setSelected(true);
        jMenuChecked.addItem(this.m_itemShowCursor, 67, "show-cursor");
        this.m_itemShowGrid = new JCheckBoxMenuItem("Show Grid");
        this.m_itemShowGrid.setSelected(true);
        jMenuChecked.addItem(this.m_itemShowGrid, 71, "show-grid");
        this.m_itemShowLastMove = new JCheckBoxMenuItem("Show Last Move");
        this.m_itemShowLastMove.setSelected(true);
        jMenuChecked.addItem(this.m_itemShowLastMove, 76, "show-last-move");
        this.m_itemShowVariations = new JCheckBoxMenuItem("Show Variations");
        this.m_itemShowVariations.setSelected(true);
        jMenuChecked.addItem(this.m_itemShowVariations, 86, "show-variations");
        this.m_itemBeepAfterMove = new JCheckBoxMenuItem("Beep After Move");
        jMenuChecked.addItem(this.m_itemBeepAfterMove, 66, "beep-after-move");
        this.m_itemCommentFontFixed = new JCheckBoxMenuItem("Fixed Size Comment Font");
        jMenuChecked.addItem(this.m_itemCommentFontFixed, 70, "comment-font-fixed");
        return jMenuChecked;
    }

    private JMenuChecked createMenuConfigureShell() {
        JMenuChecked jMenuChecked = new JMenuChecked("Configure Shell", this.m_listener);
        jMenuChecked.setMnemonic(72);
        this.m_itemCommandCompletion = new JCheckBoxMenuItem("Popup Completions");
        jMenuChecked.addItem(this.m_itemCommandCompletion, 80, "command-completion");
        this.m_itemAutoNumber = new JCheckBoxMenuItem("Auto Number");
        jMenuChecked.addItem(this.m_itemAutoNumber, 65, "auto-number");
        this.m_itemTimeStamp = new JCheckBoxMenuItem("Timestamp");
        jMenuChecked.addItem(this.m_itemTimeStamp, 84, "timestamp");
        return jMenuChecked;
    }

    private JMenuChecked createMenuConfigureTree() {
        JMenuChecked jMenuChecked = new JMenuChecked("Configure Tree", this.m_listener);
        jMenuChecked.setMnemonic(69);
        JMenuChecked jMenuChecked2 = this.createMenu("Labels", 76);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.m_itemGameTreeNumber = jMenuChecked2.addRadioItem(buttonGroup, "Move Number", 78, "gametree-number");
        this.m_itemGameTreeMove = jMenuChecked2.addRadioItem(buttonGroup, "Move", 77, "gametree-move");
        this.m_itemGameTreeNone = jMenuChecked2.addRadioItem(buttonGroup, "None", 79, "gametree-none");
        jMenuChecked.add(jMenuChecked2);
        JMenuChecked jMenuChecked3 = this.createMenu("Size", 83);
        buttonGroup = new ButtonGroup();
        this.m_itemGameTreeLarge = jMenuChecked3.addRadioItem(buttonGroup, "Large", 76, "gametree-large");
        this.m_itemGameTreeNormal = jMenuChecked3.addRadioItem(buttonGroup, "Normal", 78, "gametree-normal");
        this.m_itemGameTreeSmall = jMenuChecked3.addRadioItem(buttonGroup, "Small", 83, "gametree-small");
        this.m_itemGameTreeTiny = jMenuChecked3.addRadioItem(buttonGroup, "Tiny", 84, "gametree-tiny");
        jMenuChecked.add(jMenuChecked3);
        this.m_itemShowSubtreeSizes = new JCheckBoxMenuItem("Show Subtree Sizes");
        jMenuChecked.addItem(this.m_itemShowSubtreeSizes, 83, "gametree-show-subtree-sizes");
        return jMenuChecked;
    }

    private JMenuChecked createMenuEdit() {
        JMenuChecked jMenuChecked = this.createMenu("Edit", 69);
        jMenuChecked.addItem("Find in Comments...", 70, 70, SHORTCUT, "find-in-comments");
        this.m_itemFindNext = jMenuChecked.addItem("Find Next", 78, 114, GoGuiMenuBar.getFunctionKeyShortcut(), "find-next");
        this.m_itemFindNext.setEnabled(false);
        jMenuChecked.addSeparator();
        jMenuChecked.addItem("Game Info", 71, 73, SHORTCUT, "game-info");
        jMenuChecked.add(this.createBoardSizeMenu());
        jMenuChecked.add(this.createHandicapMenu());
        jMenuChecked.addSeparator();
        this.m_itemMakeMainVar = jMenuChecked.addItem("Make Main Variation", 77, "make-main-variation");
        this.m_itemKeepOnlyMainVar = jMenuChecked.addItem("Delete Side Variations", 68, "keep-only-main-variation");
        this.m_itemKeepOnlyPosition = jMenuChecked.addItem("Keep Only Position", 75, "keep-only-position");
        this.m_itemTruncate = jMenuChecked.addItem("Truncate", 84, "truncate");
        this.m_itemTruncateChildren = jMenuChecked.addItem("Truncate Children", 67, "truncate-children");
        jMenuChecked.addSeparator();
        this.m_itemSetup = new JCheckBoxMenuItem("Setup Mode");
        jMenuChecked.addItem(this.m_itemSetup, 83, "setup");
        ButtonGroup buttonGroup = new ButtonGroup();
        this.m_itemSetupBlack = jMenuChecked.addRadioItem(buttonGroup, "Setup Black", 66, "setup-black");
        this.m_itemSetupBlack.setSelected(true);
        this.m_itemSetupWhite = jMenuChecked.addRadioItem(buttonGroup, "Setup White", 87, "setup-white");
        return jMenuChecked;
    }

    private JMenuChecked createMenuExport() {
        JMenuChecked jMenuChecked = new JMenuChecked("Export", this.m_listener);
        jMenuChecked.setMnemonic(69);
        jMenuChecked.addItem("SGF Position...", 83, "export-sgf-position");
        jMenuChecked.addItem("LaTeX Main Variation...", 76, "export-latex");
        jMenuChecked.addItem("LaTeX Position...", 80, "export-latex-position");
        jMenuChecked.addItem("Text Position...", 84, "export-ascii");
        return jMenuChecked;
    }

    private JMenuChecked createMenuFile(RecentFileMenu.Callback callback) {
        JMenuChecked jMenuChecked = this.createMenu("File", 70);
        jMenuChecked.addItem("Open...", 79, 79, SHORTCUT, "open");
        jMenuChecked.add(this.createRecentMenu(callback));
        jMenuChecked.addItem("Save", 83, 83, SHORTCUT, "save");
        jMenuChecked.addItem("Save As...", 65, "save-as");
        jMenuChecked.addSeparator();
        jMenuChecked.add(this.createMenuExport());
        jMenuChecked.addSeparator();
        jMenuChecked.addItem("Print...", 80, 80, SHORTCUT, "print");
        jMenuChecked.addSeparator();
        jMenuChecked.addItem("Attach Program...", 84, 65, SHORTCUT, "attach-program");
        this.m_itemDetachProgram = jMenuChecked.addItem("Detach Program", 68, "detach-program");
        jMenuChecked.addSeparator();
        this.m_itemQuit = jMenuChecked.addItem("Quit", 81, 81, SHORTCUT, "exit");
        return jMenuChecked;
    }

    private JMenuChecked createMenuGame() {
        JMenuChecked jMenuChecked = this.createMenu("Game", 65);
        jMenuChecked.addItem("New Game", 78, "new-game");
        jMenuChecked.addSeparator();
        this.m_menuComputerColor = this.createComputerColorMenu();
        jMenuChecked.add(this.m_menuComputerColor);
        this.m_itemComputerPlay = jMenuChecked.addItem("Play", 76, 116, GoGuiMenuBar.getFunctionKeyShortcut(), "play");
        this.m_itemComputerPlaySingle = jMenuChecked.addItem("Play Single Move", 83, 116, GoGuiMenuBar.getFunctionKeyShortcut() | 1, "play-single");
        jMenuChecked.addItem("Pass", 80, 113, GoGuiMenuBar.getFunctionKeyShortcut(), "pass");
        this.m_itemInterrupt = jMenuChecked.addItem("Interrupt", 84, 27, 0, "interrupt");
        jMenuChecked.add(this.createClockMenu());
        jMenuChecked.addSeparator();
        this.m_itemCleanup = new JCheckBoxMenuItem("Cleanup");
        this.m_itemCleanup.setMnemonic(69);
        jMenuChecked.add(this.m_itemCleanup);
        jMenuChecked.addItem("Score", 79, "score");
        return jMenuChecked;
    }

    private JMenuChecked createMenuGo() {
        int n = 1;
        JMenuChecked jMenuChecked = this.createMenu("Go", 71);
        this.m_itemBeginning = jMenuChecked.addItem("Beginning", 66, 36, SHORTCUT, "beginning");
        this.m_itemBackward10 = jMenuChecked.addItem("Backward 10", 87, 37, SHORTCUT | 1, "backward-10");
        this.m_itemBackward = jMenuChecked.addItem("Backward", 75, 37, SHORTCUT, "backward");
        this.m_itemForward = jMenuChecked.addItem("Forward", 70, 39, SHORTCUT, "forward");
        this.m_itemForward10 = jMenuChecked.addItem("Forward 10", 82, 39, SHORTCUT | 1, "forward-10");
        this.m_itemEnd = jMenuChecked.addItem("End", 69, 35, SHORTCUT, "end");
        this.m_itemGoto = jMenuChecked.addItem("Go to Move...", 79, 71, SHORTCUT, "goto");
        jMenuChecked.addSeparator();
        this.m_itemNextVariation = jMenuChecked.addItem("Next Variation", 78, 40, SHORTCUT, "next-variation");
        this.m_itemPreviousVariation = jMenuChecked.addItem("Previous Variation", 80, 38, SHORTCUT, "previous-variation");
        this.m_itemNextEarlierVariation = jMenuChecked.addItem("Next Earlier Variation", 88, 40, SHORTCUT | n, "next-earlier-variation");
        this.m_itemPreviousEarlierBackward = jMenuChecked.addItem("Previous Earlier Variation", 76, 38, SHORTCUT | n, "previous-earlier-variation");
        this.m_itemBackToMainVar = jMenuChecked.addItem("Back to Main Variation", 77, 77, SHORTCUT, "back-to-main-variation");
        this.m_itemGotoVar = jMenuChecked.addItem("Go to Variation...", 86, "goto-variation");
        return jMenuChecked;
    }

    private JMenuChecked createMenuHelp() {
        JMenuChecked jMenuChecked = this.createMenu("Help", 72);
        JMenuItem jMenuItem = jMenuChecked.addItem("GoGui Documentation", 71, 112, GoGuiMenuBar.getFunctionKeyShortcut(), "help");
        JMenuItem jMenuItem2 = jMenuChecked.addItem("About", 65, "about");
        this.m_itemHelp = jMenuItem;
        this.m_itemAbout = jMenuItem2;
        return jMenuChecked;
    }

    private JMenuChecked createMenuShell(RecentFileMenu.Callback callback) {
        JMenuChecked jMenuChecked = this.createMenu("Shell", 76);
        this.m_itemSaveLog = jMenuChecked.addItem("Save Log...", 76, "gtpshell-save");
        this.m_itemSaveCommands = jMenuChecked.addItem("Save Commands...", 67, "gtpshell-save-commands");
        jMenuChecked.addItem("Send File...", 70, "gtpshell-send-file");
        String string = System.getProperty("user.home");
        File file = new File(new File(string, ".gogui"), "recent-gtpfiles");
        this.m_recentGtp = new RecentFileMenu("Send Recent", file, callback);
        this.m_recentGtp.getMenu().setMnemonic(82);
        jMenuChecked.add(this.m_recentGtp.getMenu());
        return jMenuChecked;
    }

    private JMenuChecked createMenuSettings() {
        JMenuChecked jMenuChecked = this.createMenu("Settings", 83);
        this.m_itemShowToolbar = new JCheckBoxMenuItem("Show Toolbar");
        jMenuChecked.addItem(this.m_itemShowToolbar, 84, "show-toolbar");
        this.m_itemShowInfoPanel = new JCheckBoxMenuItem("Show Info Panel");
        jMenuChecked.addItem(this.m_itemShowInfoPanel, 73, "show-info-panel");
        jMenuChecked.addSeparator();
        this.m_itemShowTree = new JCheckBoxMenuItem("Show Tree");
        jMenuChecked.addItem(this.m_itemShowTree, 82, 118, GoGuiMenuBar.getFunctionKeyShortcut(), "show-tree");
        this.m_itemShowShell = new JCheckBoxMenuItem("Show Shell");
        jMenuChecked.addItem(this.m_itemShowShell, 83, 119, GoGuiMenuBar.getFunctionKeyShortcut(), "show-shell");
        this.m_itemShowAnalyze = new JCheckBoxMenuItem("Show Analyze");
        jMenuChecked.addItem(this.m_itemShowAnalyze, 65, 120, GoGuiMenuBar.getFunctionKeyShortcut(), "analyze");
        jMenuChecked.addSeparator();
        jMenuChecked.add(this.createMenuConfigureBoard());
        jMenuChecked.add(this.createMenuConfigureTree());
        jMenuChecked.add(this.createMenuConfigureShell());
        jMenuChecked.add(this.createMenuConfigureAnalyze());
        return jMenuChecked;
    }

    private JMenu createRecentMenu(RecentFileMenu.Callback callback) {
        String string = System.getProperty("user.home");
        File file = new File(new File(string, ".gogui"), "recent-files");
        this.m_recent = new RecentFileMenu("Open Recent", file, callback);
        JMenu jMenu = this.m_recent.getMenu();
        jMenu.setMnemonic(82);
        return jMenu;
    }

    private void disableAll() {
        for (int i = 0; i < this.m_menuBar.getMenuCount(); ++i) {
            JMenu jMenu = this.m_menuBar.getMenu(i);
            if (jMenu == null) continue;
            this.enableAll(jMenu, false);
        }
    }

    private void enableAll() {
        for (int i = 0; i < this.m_menuBar.getMenuCount(); ++i) {
            JMenu jMenu = this.m_menuBar.getMenu(i);
            if (jMenu == null) continue;
            jMenu.setEnabled(true);
            for (int j = 0; j < jMenu.getItemCount(); ++j) {
                if (jMenu.getItem(j) == null) continue;
                jMenu.getItem(j).setEnabled(true);
            }
        }
    }

    private void enableAll(JMenu jMenu, boolean bl) {
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            if (jMenu.getItem(i) == null) continue;
            jMenu.getItem(i).setEnabled(bl);
        }
    }

    private static int getFunctionKeyShortcut() {
        if (Platform.isMac()) {
            return SHORTCUT;
        }
        return 0;
    }

    static {
        $assertionsDisabled = !GoGuiMenuBar.class.desiredAssertionStatus();
        s_possibleBoardSizes = new int[]{9, 11, 13, 15, 17, 19};
        s_possibleHandicaps = new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9};
        SHORTCUT = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    }
}

