:userdoc.
:h1 res=9110.Bingo/2
:i1.General Description
:p.Bingo/2 is a 32-bit, multi-threaded, multimedia
OS/2 2.x Presentation Manager software program
which allows you to play many different types of
:link reftype=hd res=3.bingo games:elink. on your
computer. Features include:
:ul compact.
:li.Automated or manual play
:li.Other players in the bingo hall, you may also hear some
:link reftype=hd res=9396.chatter:elink.
:li.Play up to 10 cards at the same time
:li.Highly customizable (bingo chip color, sound, draw time interval, etc.)
:li.:link reftype=hd res=9510.Bingo scores:elink.
showing number of bingos, number of games and cards played
:li.:link reftype=hd res=1.Bingo Board:elink.
containing status of numbers, game time, graphical bitmap of
game type and current number drawn shown
:li.:link reftype=hd res=9321.Print bingo cards:elink. to your local printer
:li.Digitized voices throughout.
:eul.
:p.:link reftype=hd res=5.Playing Bingo/2:elink. is fun and easy. You start
with $100 but may win a lot more with your luck and skill.

:h1 res=5.Playing Bingo/2
:i1 id=play.Playing Bingo/2
:p.When you first invoke the program, the
:link reftype=hd res=9210.Games Option dialog box:elink. is displayed
to allow you to select the type of
:link reftype=hd res=3.bingo game:elink. to play and the number of
:link reftype=hd res=9346.bingo cards:elink.
you want to play at the same time. You may also select
one or more other players to play along (just like in your friendly
neighborhood bingo hall).
Click on Ok to continue.
:p.Once the bingo cards are displayed, select New under File or press F2
to start a new game. Numbers are drawn at regular intervals (according to the
draw time which may be customized using the
:link reftype=hd res=9410.Settings dialog box:elink.). The
:link reftype=hd res=1.Bingo Board:elink.
will display the drawn number in reversed video.
Numbers previously drawn are removed from the Bingo Board. Also, you may
pause the game at any time by pressing F4 (or Pause from File) and
you may draw the next number immediately without waiting for the regular
draw time interval by pressing F5 (or Next number from File).
:p.Mark your bingo card(s) by moving your mouse pointer over a bingo card and
clicking on a square. A bingo chip will then appear, just like marking
your bingo card in a bingo hall! But even better, you can let the computer
mark your bingo cards for you (in case you are a little lazy or a novice
player), just select Auto Play under the Options menu and sit back and relax.
:p.If a bingo has been found, a
:link reftype=hd res=4.Bingo! dialog box:elink. will appear containing a
list of winning bingo card(s). The winner collects the prize money
shown in the title bar of the Bingo board. The prize money for each game
is dependent upon the number of players and bingo cards being played.
:p.To see how you are doing and how much money you have left, select
Scores under File to display the
:link reftype=hd res=9510.Scores dialog window:elink..
:p.Select New under File again to start a new game.

.****************************************************************************
.* :h1 res=9000.How to Register
.* :i1 id=Registr.How to Register
.* :p.To register, please complete and send the ORDER.FRM below.
.* :xmp.
.* .im ORDER.FRM
.* :exmp.
.****************************************************************************

:h1 res=1.Bingo Board
:i1 id=board.Bingo Board
:artwork name='HLPBOARD.BMP' runin align=center.
:p.The Bingo/2 bingo board looks like a real bingo board you would see in
any bingo hall.
:p.On the top, the title bar contains the game type, the prize money and
game status (ie. In progress, Game over, etc.).
:p.The bingo board also displays:
:ul compact.
:li.The running time of the game.
:li.A graphical picture of the game type is depicted.
:li.The current number drawn (in a large font for easy identification).
:eul.
:p.The current number drawn is also shown in reverse video, while all numbers
previously drawn are removed from the Bingo board.

:h1 res=9346.Bingo Card
:i1 id=Card.Bingo Card
:artwork name='HLPCARD.BMP'.
:p.The Bingo/2 bingo card looks like a real bingo card you would use in
any bingo hall.
:p.You may see three types of chips (the color is all the same as you have
specified in the
:link reftype=hd res=9410.Settings dialog box:elink.).
:ul compact.
:li.Normal chip is solid.
:li.The winning bingo squares are marked with a semi-transparent chip so you
can see the numbers behind them.
:li.An empty chip indicates bingo squares which you forgot to mark! Hopefully,
you don't see to many of these.
:eul.
:p.To mark the card, simply move your mouse pointer over the desired square
and click either mouse button. If you have the Auto Play option turned on,
then you don't have to do anything as the computer will automatically play or
mark the card for you.

:h1 res=3.Bingo Games
:i1 id=gametyp.Bingo Games
:p.You may select one of the many types of bingo games available in
Bingo/2.
:dl tsize=7 compact.
:dthd.GAME
:ddhd.DESCRIPTION
:dt.:artwork runin name='CLASSIC.BMP'.
:dd.Classic game. One horizontal, vertical or diagonal line filled.
:dt.:artwork runin name='ALLNO.BMP'.
:dd.All numbers. The entire bingo card must be completely filled.
:dt.:artwork runin name='X.BMP'.
:dd.X. Form the letter X or two diagonal lines.
:dt.:artwork runin name='DIAMOND.BMP'.
:dd.Diamond. Form a diamond.
:dt.:artwork runin name='4CORNERS.BMP'.
:dd.Four corners. Fill the four corners of the card.
:dt.:artwork runin name='CENTER.BMP'.
:dd.Center. Form a cross.
:dt.:artwork runin name='OUTSQUAR.BMP'.
:dd.Outside square. Form a large square or all squares away from the Free
square.
:dt.:artwork runin name='INSQUARE.BMP'.
:dd.Inside square. Form a small square or all squares adjacent to the Free
square.
:dt.:artwork runin name='T.BMP'.
:dd.T. Form the letter T.
:dt.:artwork runin name='Y.BMP'.
:dd.Y. Form the letter Y.
:dt.:artwork runin name='Z.BMP'.
:dd.Z. Form the letter Z.
:dt.:artwork runin name='N.BMP'.
:dd.N. Form the letter N.
:dt.:artwork runin name='H.BMP'.
:dd.H. Form the letter H.
:dt.:artwork runin name='M.BMP'.
:dd.M. Form the letter M.
:dt.:artwork runin name='LUCKY7.BMP'.
:dd.Lucky 7. Form the number 7.
:dt.:artwork runin name='HARDAWAY.BMP'.
:dd.Hardaway. Like the classic game without using the Free square.
:edl.

:h1 res=4.Bingo!
:i1 id=bingo.Bingo!
:artwork name='HLPBINGO.BMP'.
:p.The Bingo! dialog box is displayed when a winning bingo card has been
found. Multiple winning bingo cards are shown in the scrollable list. Click
the Close push button to remove this window.

:h1 res=9120.Help for File
:i1 id=File.File
:p.Use this choice to get File menu options for Bingo which includes:
:ul.
:li.Start a new game
:li.Quit current game
:li.Pause
:li.Draw next number without draw time delay
:li.:link reftype=hd res=9321.Print bingo cards:elink.
:li.:link reftype=hd res=9510.Scores:elink.
:li.:link reftype=hd res=9550.High scores:elink.
:li.Exit
:eul.

:h1 res=9130.Help for Options
:i1 id=Options.Options
:p.Use this choice to get Options menu options for Bingo which includes:
:ul.
:li.Select between automated or manual play
:li.Mark all or not
:li.Sound off or on
:li.Select :link reftype=hd res=9396.Chatter Box:elink. display
:li.:link reftype=hd res=9210.Game options:elink.
:li.:link reftype=hd res=9410.Customizable settings:elink.
:li.:link reftype=hd res=9326.Customize font:elink.
:eul.

:h1 res=9121.Help for New
:i2 refid=File.New
:p.This choice allows you to start a new game. If a game is in progress, you
will be prompted to confirm.

:h1 res=9129.Help for Quit
:i2 refid=File.Quit Game
:p.This choice allows you to stop a game in progress. You will be asked to
confirm to quit the game.

:h1 res=9122.Help for Pause
:i2 refid=File.Pause
:p.Pause allows you to stop the bingo game temporarily. Click on OK to
resume the game.

:h1 res=9127.Help for Next number
:i2 refid=File.Next number
:p.Next number allows you to draw the next bingo number immediately
without waiting for the normal draw time delay.

:h1 res=9131.Help for Mark All
:i2 refid=Options.Mark All
:p.You may toggle between marking all the squares or not.

:h1 res=9132.Help for Sound
:i2 refid=Options.Sound
:p.You may turn the sound on or off.

:h1 res=9123.Help for Auto play
:i2 refid=Options.Auto play
:p.You may toggle between automatic play or manual play.

:h1 res=9135.Help for Other Cards
:i2 refid=Options.Other Cards...
:p.If you specified other players, you may select to see their cards being
played.

:h1 res=9136.Help for Chatter
:i2 refid=Options.Chatter
:p.You may toggle between displaying or hiding the
:link reftype=hd res=9396.Chatter Box:elink..

:h1 res=9124.Help for Games
:i2 refid=Options.Games...
:p.Game options allows you to change:
:ul.
:li.Player's name (shown in the Scores)
:li.Type of bingo game (ie. Classic, All numbers, Four corners, etc.)
:li.Select number of cards to be played
:li.Select the number of other players
:eul.

:h1 res=9125.Help for Settings
:i2 refid=Options.Settings...
:p.Settings allows you to customize the following features:
:ul.
:li.Bingo chip color
:li.Bingo card mouse pointer
:li.Draw time
:li.Sound
:li.Mark all
:li.Prompt for a new set of cards before each game
:li.Prompt for a new game after each game
:li.Show Game options window at start
:li.Select automatic or manual play
:li.Bingo board orientation (vertical or horizontal)
:li.Display of Chatter Box
:eul.

:h1 res=9134.Help for Fonts
:i2 refid=Options.Fonts...
:p.Fonts allow you to change the font of the Bingo board and bingo card.
Note some fonts :hp2.may not:ehp2. be properly suited.

:h1 res=9128.Help for Scores
:i2 refid=File.Scores...
:p.Scores allows you to see the number of games played, number of cards
played and number of bingos for both you and the other players.

:h1 res=9137.Help for High Scores
:i2 refid=File.High Scores...
:p.High scores allows you to see the highest scores (top 5) ever recorded
in Bingo/2.

:h1 res=9133.Help for Print
:i2 refid=File.Print...
:p.This option allows you to print the current set of bingo cards to your
attached local printer. Note that this option is not available if a bingo
game is in progress.

:h1 res=9126.Help for Exit
:i2 refid=File.Exit
:p.Select this choice to leave the program. If a game is in progress, you
will be prompted to confirm.

:h1 res=9210.Games Options Dialog Help
:i1 id=Games.Games Options Dialog
:artwork name='HLPGAME.BMP'.
:p.You may customize several options from the Games Options dialog
window:
:ul compact.
:li.Player's name
:li.Game type
:li.Number of cards
:li.Number of other players
:eul.
:p.After changing the options, select OK to continue. Select Defaults to
restore the options settings to the original system defaults.

:h1 res=9216.Your Name Help
:i2 refid=Games.Your Name
:p.Type your name (maximum of 20 characters) which will be shown in the
scores.

:h1 res=9211.Game Type Help
:i2 refid=Games.Game Type
:p.You may select which bingo games to play. Only the
:link reftype=hd res=3.available bingo games:elink.
are shown in the combination list box.

:h1 res=9212.Number of Cards Help
:i2 refid=Games.Number of Cards
:p.You may select how many :link reftype=hd res=9346.bingo cards:elink.
you want to play at the same time.
Valid choices are between 1 and 10.

:h1 res=9217.Number of Players Help
:i2 refid=Games.Number of Players
:p.You may select how many other players (in the bingo hall) will play
in the game. Each player will play only one bingo card.

:h1 res=9215.Defaults
:i2 refid=Games.Defaults
:p.Select this push button to restore the Options settings to the
original system default values.

:h1 res=9310.Start Dialog Help
:i1 id=Start.Start Message
:p.You have chosen to start a new game while the current game is still in
progress. Click OK if you really want to start a new game. The current game
will be lost and a new game may be started.

:h1 res=9380.Quit Dialog Help
:i1 id=Stop.Quit Message
:p.You have chosen to quit while the current game is still in
progress. Click Yes if you really want to quit the current game.
The current game will be lost.

:h1 res=9360.Let's Play Bingo Dialog Help
:i1 id=Timer.Let's Play Bingo Message
:p.The computer has detected that you have not yet started a new game. Click
on Yes to start a new game immediately. If you click on No, you must start
the game manually but selecting New which is found under File.

:h1 res=9340.New Cards Help
:i1 id=Newcards.New Cards Message
:p.You are about to start a new bingo game. You have the option of using
the same cards you have played with in the previous game or to use a new set.
Click on Yes to play with a new set of bingo cards.

:h1 res=9410.Settings Dialog Help
:i1 id=Settings.Settings Dialog
:artwork name='HLPSET.BMP'.
:p.You may customize several games settings from the Settings dialog
window:
:ul compact.
:li.Color of bingo chips
:li.Draw time (in seconds)
:li.Mouse pointer
:li.Sound (on or off)
:li.Mark all (on or off)
:li.Chatter (on or off)
:li.Auto play (on or off)
:li.Bingo board orientation (vertical or horizontal)
:li.Use new or existing cards or prompt after every game
:eul.
:p.After changing the settings, select OK to continue. Select Default to
restore the game settings to the original system defaults.

:h1 res=9411.Chip Color Help
:i2 refid=Settings.Chip Color
:p.You may select the color of the bingo chips. Only the available colors
are shown in the value set control.

:h1 res=9421.Pointer Help
:i2 refid=Settings.Pointer
:p.You may select the mouse pointer for your bingo cards.

:h1 res=9412.Draw Time Help
:i2 refid=Settings.Draw Time
:p.Move the slider bar to the desired time between bingo number
drawings in seconds.
Suggested number is 2 seconds multiplied by the
the number of bingo cards with a minimum of 5 seconds.

:h1 res=9413.Mark All Help
:i2 refid=Settings.Mark All
:p.If you select off, only those squares relevant to the current bingo game
being played may be marked. If you select on, all squares on the bingo card
may be marked.

:h1 res=9422.Chatter Help
:i2 refid=Settings.Chatter
:p.If you select on, the
:link reftype=hd res=9396.Chatter Box:elink.
will be displayed. Otherwise, it will
be hidden. You also can toggle under the Options menu.

:h1 res=9423.Auto Play Help
:i2 refid=Settings.Auto Play
:p.Select On for automatic marking of numbers. Select Off for manual play.

:h1 res=9424.Board Type Help
:i2 refid=Settings.Board Type
:p.Select a horizontal or vertical Bingo Board orientation.

:h1 res=9425.3D Effects Help
:i2 refid=Settings.3D Effects
:p.Select for 3D Bingo board and bingo cards (which have a gray background,
normal is white).

:h1 res=9414.Sound Help
:i2 refid=Settings.Sound
:p.You may turn the sound effects on or off.

:h1 res=9416.New Cards Help
:i2 refid=Settings.New Cards
:p.Select Prompt if you wish to be asked
if you want a new set of cards everytime a new game begins. If you wish to
keep playing with the same set of cards all the time, then select No. If
you wish to playing with a new set of cards after each game automatically,
select Yes.

:h1 res=9417.Show Initially Help
:i2 refid=Settings.Show Initially
:p.If you select off, the Games Options window dialog will not be shown
when you first start the Bingo/2.

:h1 res=9420.Prompt for New Game Help
:i2 refid=Settings.New Game Prompt
:p.If you select on, you will be prompted for a new game after the completion
of the last bingo game. Otherwise, a new game is automatically started after
every game.

:h1 res=9415.Defaults
:i2 refid=Settings.Defaults
:p.Select this push button to restore the game settings to the
original system default values.

:h1 res=9418.PC Speaker Help
:i2 refid=Settings.PC Speaker
:p.Select this option if you want sounds to come from your computer's
internal PC speaker.

:h1 res=9419.Audio Card Help
:i2 refid=Settings.Audio Card Help
:p.If you have MMPM/2 installed and have a supported sound card, select
this option.

:h1 res=9510.Scores Dialog Help
:i1 id=Score.Scores Dialog
:artwork name='HLPSCORE.BMP'.
:p.In the Bingo Scores dialog box, the number of games played, number of cards
played, number of bingos and money won
for both you and the other players are displayed in tabular form. As well,
the amount of money you have left is shown.
:p.Just click on OK when you are done. You may
reset the scores back to 0 by clicking on the Reset push button.

:h1 res=9511.Reset
:i2 refid=Score.Reset
:p.Select this push button to reset the bingo scores back to 0.

:h1 res=9550.High Scores Dialog Help
:i1 id=HiScore.High Scores Dialog
:artwork name='HLPHISCR.BMP'.
:p.In the High Scores dialog box, the highest scores (top 5) are shown along
with the corresponding player's name.
:p.Just click on Close when you are done. You may
reset the high scores back to 0 by clicking on the Reset push button.

:h1 res=9551.Reset
:i2 refid=HiScore.Reset
:p.Select this push button to reset the high scores back to 0.

:h1 res=9391.Other Cards Help
:i1 id=Other.Other Cards Dialog
:artwork name='HLPOTHER.BMP'.
:p.In the List of Other Cards dialog box, you are presented with a list of
all other bingo cards being played during the game. Click to select one or
more bingo cards and press the Select push button. Click the All or None
push buttons to select all or none of the other bingo cards.
The selected bingo cards
will be shown.
:p.When the game ends, all other bingo cards shown are removed. You will
have to reselect in the next game again.

:h1 res=9396.Chatter Help
:i1 id=Chat.Chatter Box
:artwork name='HLPCHAT.BMP'.
:p.The Chatter Box contains some interesting
bingo hall chatter as the game progresses. Also, another listbox contains
the bingo number draw history for the current game.

:h1 res=9336.No Money Help
:i1 id=NoMoney.No Money
:p.Darn, you don't have any more money to continue to play Bingo/2.
:p.Click Yes to reset all the scores to their starting or original values.
Otherwise, click No to quit the game.

:h1 res=9321.Select Print Dialog Help
:i1 id=Print.Select Print Dialog
:artwork name='HLPPRINT.BMP'.
:p.Select one of the available printer queues. Then you may optionally select
to chance the job properties by clicking on the Job Properties push button.
:p.By default, one bingo card will be printed on one page. You may print
up to 4 bingo cards per page by clicking on the 4 cards per page check box.
:p.When you are ready to print (make sure your printer is turned on!), click
on the Print push button to start printing.
:p.Note that during the printing process, you will not be able to play or
start a new bingo game.

:h1 res=9329.Stop Print Help
:i1 id=StopPrt.Stop Print
:p.Click on Yes if you really want to stop printing the set of bingo cards.
Otherwise, click No to continue.

:h1 res=9326.Select Font Dialog Help
:i1 id=Font.Select Font Dialog
:artwork name='HLPFONT.BMP'.
:p.Select one of the available fonts found in your system. Then click on
the Ok push button.

:h1 res=9316.No Bingo Help
:i1 id=NoBingo.No Bingo
:p.All bingo cards have been checked and no bingo was found. All numbers have
been drawn so the game is over. You may have missed marking some numbers,
please check all your bingo cards.

:h1 res=9180.Help for Help
:i1 id=Help.Help Menu
:p.Use this choice to get help for the application. You may
request an index of help choices, general help for the application,
help for the supported function keys, or a brief description about the
application.

:h1 res=9182.Help for Help Index
:i2 refid=Help.Help Index
:p.Use this choice to get an index of available help topics.

:h1 res=9183.Help for General Help
:i2 refid=Help.General Help
:p.Use this choice to get general help for the whole application.

:h1 res=9184.Help for Using Help
:i2 refid=Help.Using Help
:p.Use this choice to get help in using the help subsystem itself.

:h1 res=9185.Help for Keys Help
:i2 refid=Help.Keys Help
:p.Use this choice to get help for the supported function keys.

:h1 res=9186.Help for Product Information
:i2 refid=Help.Product Information
:p.Use this choice to get a brief description of this program.

:h1 res=9187.Keys Help
:i1 id=keys.Keys
:p.The following keystrokes are valid in this application:
:table cols='8 20' rules=both frame=box.
:row.
:c.Key
:c.Description
:row.
:c.F1
:c.Help
:row.
:c.F2
:c.New
:row.
:c.F3
:c.Exit
:row.
:c.F4
:c.Pause game
:row.
:c.F5
:c.Next number
:row.
:c.Ctrl+A
:c.Toggle autoplay
:row.
:c.Ctrl+C
:c.Other cards
:row.
:c.Ctrl+F
:c.Fonts
:row.
:c.Ctrl+G
:c.Game options
:row.
:c.Ctrl+H
:c.High scores
:row.
:c.Ctrl+M
:c.Mark All
:row.
:c.Ctrl+P
:c.Print bingo cards
:row.
:c.Ctrl+Q
:c.Quit game
:row.
:c.Ctrl+R
:c.Scores
:row.
:c.Ctrl+S
:c.Settings
:row.
:c.Ctrl+T
:c.Chatter box
:row.
:c.Ctrl+U
:c.Sound
:etable.
:euserdoc.
