/* REXX */
Call RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"
Call SysLoadFuncs
Call SysCls
Say "Welcome to WarpTris 1.01 installation script!"
Say
Say "If you have an old version of WarpTris installed you can specify the"
Say "directory where that version is installed. Doing that will replace the"
Say "old version and preserve the old high scores."
Say
Say "**Warning!**"
Say "Whatever directory you specify the WarpTris desktop folder will be"
Say "erased if present, and replaced by the new one!"
Say
Say "Do you wish to continue ? (Y/N)"
pull response
if(response <> "Y") then
do 
 exit
end
Say
Say "On what directory do you want me to install WarpTris's files ?"
Say "(If you just press Enter, I will assume the current directory.)"
Parse Pull fullpath

if(fullpath \= "") then
do
 Call SysFileTree fullpath, FileDirectory, 'D'	
 If(FileDirectory.0='0') Then
 do 
  Say "The path you specified does not exist."
  Say "I will try to create it."
  Say
  rc = SysMkDir(fullpath)
  if(rc <> 0) then
  do
   Say "There was an error creating de directory you specified."
   Say "The path may be invalid, exiting..."
   exit
  end
  Say "The directory was created successfully."
  Say
  Say "I will now copy the necessary files to the specified directory."
  "copy *.* "||fullpath
 end
 else
 do
  Say "The directory allready exist."
  Say
  Say "I will now copy the necessary files to the specified directory."
  "copy *.* "||fullpath
 end
end

if(fullpath = "") then fullpath = Directory()

Say
Say "I wil now create on you Desktop a folder with a program object in it,"
Say "that references WarpTris."

rc = SysCreateObject("WPFOLDER", "WarpTris 1.01", "<WP_DESKTOP>", "OBJECTID=<WARPTRIS>;", "replace")
if(rc <> 1) then
do 
 Say "There was an error creating the desktop folder, exiting..."
 exit
end

rc = SysCreateObject("WPPROGRAM", "WarpTris 1.01", "<WARPTRIS>", "STARTUPDIR="||fullpath||"\;EXENAME="||fullpath||"\WARPTRIS.EXE;PROGTYPE=PM", "replace")
if(rc <> 1) then
do 
 Say "There was an error creating the program object, exiting..."
 exit
end

rc = SysCreateObject("WPPROGRAM", "WarpTris Information", "<WARPTRIS>", "STARTUPDIR="||fullpath||"\;EXENAME=VIEW.EXE;PROGTYPE=PM;PARAMETERS=WarpTris.INF", "replace")
if(rc <> 1) then
do 
 Say "There was an error creating the program object, exiting..."
 exit
end

rc = SysCreateShadow(fullpath||"\README", "<WARPTRIS>")
if(rc <> 1) then
do
 Say "There was an error creating the README file shadow..."
end

rc = SysCreateShadow(fullpath||"\WhatsNew", "<WARPTRIS>")
if(rc <> 1) then
do
 Say "There was an error creating the WhatsNew file shadow..."
end

Say
Say "WarpTris was installed successfully!"
Say
Call SysDropFuncs
exit			


