//=======================================================================
//@V@:Note: This file generated by vgen V1.02 (03:43:54 PM 09 Jul 1997).
//	wDemmdlg.cpp:	Source for wDemModalDialog class
//=======================================================================

////////////////////////////////////////////////////////////////////////////
// This file is a module in the program Zero Point, a video game program  //
// for Linux X11 and Windows.                                             //
//                                                                        //
// Copyright (C) 1996, 1997, 1998 by Enumerate Inc.                       //
//                                                                        //
// Enumerate Inc. can be contacted at enumerate@rocketmail.com            //
//                                                                        //
// This file is licensed within the terms of the GNU General Public       //
// License version 2 or later. This source code may freely redistributed  //
// or modified within the terms of that license, as described in the file //
// 'COPYING' which should be included with any redistribution of this     //
// file. If the file COPYING is not available, a copy of the General      //
// Public License can be obtained from the Free Software Foundation, Inc. //
// 675 Mass Ave., Cambridge, MA 02139.                                    //
//                                                                        //
// THIS PROGRAM IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER  //
// EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED       //
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.    //
// THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS    //
// WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF  //
// ALL NECESSARY SERVICING, REPAIR OR CORRECTION.                         //
//////////////////////////////////////////////////////////////////////////// 


#include "wDemmdlg.h"
#include <v/vnotice.h>
#include <v/vicon.h>
#include <v/vkeys.h>
#include "wlnapp.h"   //wlnApp
#include "wlndefs.h"
#include "genArray.h"
//#include "wDemText.h"  //wdtxtArr, an array of text entries for the demo

// #include "../icons/up.vbm"
// static vIcon iconUp(&up_bits[0], up_height, up_width);
// #include "../icons/right.vbm"
// static vIcon iconRight(&right_bits[0], right_height, right_width);
// #include "../icons/down.vbm"
// static vIcon iconDown(&down_bits[0], down_height, down_width);
// #include "../icons/left.vbm"
// static vIcon iconLeft(&left_bits[0], left_height, left_width);



//@V@:BeginIDs
enum {
  lblMainMsg = 2500,
  btnTestMDlg		// add your id's here
};
//@V@:EndIds

//@V@:BeginDialogCmd DefaultCmds
static DialogCmd DefaultCmds[] =
{
  {C_Label, lblMainMsg, 0,"ZeroPoint Demo Dialog",NoList,CA_MainMsg,isSens,NoFrame, 0, 0},

  {C_Text, demoText, 0, "WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW\nW\nW\nW\nW\nW\nW\nW", NoList, CA_None, isSens, NoFrame, 0,lblMainMsg},
  //frame for icons
  //   {C_Frame, arrowFrame, 0, "",NoList,CA_None,isSens,NoFrame,\
  //    0,demoText},
  //   //Icons in the frame
  //   {C_IconButton, blankIcon1, 0, "", &iconUp, CA_Hidden, notSens, \
  //    arrowFrame, 0, 0},
  //   {C_IconButton, arrowUp, 0, "Up", &iconUp, CA_None, notSens, \
  //    arrowFrame, blankIcon1, 0},
  //   {C_IconButton, blankIcon2, 0, "", &iconUp, CA_Hidden, notSens, \
  //    arrowFrame, arrowUp, 0},
  //   {C_IconButton, arrowLeft, 0, "Left", &iconLeft, CA_None, notSens, \
  //    arrowFrame, 0, blankIcon1},
  //   {C_IconButton, arrowDown, 0, "Down", &iconDown, CA_None, notSens, \
  //    arrowFrame, arrowLeft, blankIcon1},
  //   {C_IconButton, arrowRight, 0, "Right", &iconRight, CA_None, notSens, \
  //    arrowFrame, arrowDown, blankIcon1},

  {C_Button, btnTestMDlg, 0, "          ", NoList, CA_Hidden, notSens,
   NoFrame, demoText, 0},
  {C_Button, btnDemoPrev, 0, "   Prev   ", NoList, CA_None, notSens,
   NoFrame, demoText, btnTestMDlg},
  {C_Button, btnDemoNext, 0, "   Next   ", NoList, CA_None,
   isSens, NoFrame, demoText, btnDemoPrev},

  {C_Button, btnPlay, 0, "   Play   ",NoList,CA_None,
   isSens,NoFrame,demoText,btnDemoNext},
  {C_Button, btnPractice, 0, " Practice ", NoList, CA_None,
   isSens, NoFrame, demoText, btnPlay},
  {C_Button, M_Cancel, 0, "  Cancel  ", NoList, CA_None,
   isSens, NoFrame, demoText, btnPractice},
  //{C_Button, demoClrKeys, 1, "", NoList, CA_Hidden, 
  //notSens, NoFrame, btnPractice, demoText},
  //{C_Button, demoKeyPress, 0, "", NoList, CA_Hidden,
  //notSens, NoFrame, btnPractice, demoClrKeys},

  {C_EndOfList,0,0,0,0,CA_None,0,0,0}
};
//@V@:EndDialogCmd


//======================>>> wDemModalDialog::wDemModalDialog <<<==================
wDemModalDialog::wDemModalDialog(vBaseWindow* bw, char* title) :
  vModalDialog(bw, title)
{
  UserDebug(Constructor,"wDemModalDialog::wDemModalDialog()\n");
    //wdtxtArr = genArray<char*>;
    //these strings are written in a 46 char 
    //XEmacs screen
  wdtxtArr[intro1] = 
"Welcome to the demonstration of ZeroPoint. \nThis dialog box may be covering part of    \nthe game window. If you have room enough   \non your screen, you may want to move it    \nso you can better see the window during    \nthe demo.";
  wdtxtArr[intro2] = 
"ZeroPoint presents a moving line or polygon\non the screen. The motions are random      \n(almost), and your job is to make the line \nor polygon stop. (Those of you who know    \nmatrix algebra will see that if the motions\nare truly random, stopping the line will be\nimpossible about half the time.)";
  wdtxtArr[intro3] =
"Of course, the motion of the line is an    \nillusion. The end points of each new line  \nor polygon are a given number of pixels    \naway from the previous ones. Pressing an   \narrow key changes how many pixels all of   \nthe endpoints skip in that direction.";
  wdtxtArr[descrip1] =  
"The objective of ZeroPoint is to stop the  \nmoving line, and later the moving polygon. \nThe only way to do this is to gradually    \nslow the line using the arrow keys on the  \nkeyboard. (The corner keys on the numeric  \nkeypad make diagonal changes.)" ;
  wdtxtArr[descrip2] = 
"Each time you press an arrow key, it       \nchanges the motion of the endpoints of the \nline one unit that direction. If the line  \nis moving left five units a step, and you  \npress the right arrow key once, then the   \nline will be moving left 4 units a step.";
  wdtxtArr[descrip3] = 
"A problem that usually arises is that the  \nendpoints go in opposite directions. When  \nthat happens, you need to wait until one of\nthe endpoints bounces, then make changes   \nthat will slow the line down.";
  wdtxtArr[action1] = 
"I am now going to start the demo, using a  \nsimple-minded approach to stopping the     \nmoving line in the screen window. Each time\nI send a keypress to myself, I'll print a  \nmessage at the bottom of the window. Press \nthe \"Next\" button to start me up";
  wdtxtArr[action2] = 
"The key I'm pressing is listed on the      \nstatus bar of the main window. (at the     \nbottom) When nothing is listed, I'm        \nwaiting for the line to bounce. Each time a\nkey is listed, that means I only pressed it\nonce. (At times, I get tired of waiting,   \nand just bump the line up and to the right \nfor no reason.)";
  wdtxtArr[extra1] = 
"This demo is very simple-minded. On higher \nlevels with many-sided polygons, it can be \nhelpful to get one vertex stopped and slow \nothers by making complementary changes just\nbefore and after they bounce, leaving the  \nstationary one still.";
  wdtxtArr[scoring1] = 
"The scoring is based on how quickly you    \nstop the walking line. You start each level\nwith a certain number of points. Each step \nthe line takes, you lose a point. If your  \nscore for the level reaches 0, you lose a  \nlife.";
  wdtxtArr[scoring2] = 
"If you start Zero Point at a level above   \none, and successfully complete that level  \nyou get a starting bonus equal to 1000     \npoints for each level you skipped over.";
  DefaultCmds[1].title = wdtxtArr[intro1];
  AddDialogCmds(DefaultCmds);		// add the predefined commands
  currPage = intro1;
}

//===================>>> wDemModalDialog::~wDemModalDialog <<<====================
wDemModalDialog::~wDemModalDialog()
{
  UserDebug(Destructor,"wDemModalDialog::~wDemModalDialog() destructor\n")
    }

//====================>>> wDemModalDialog::wDemAction <<<====================
int wDemModalDialog::wDemAction(char* msg, int index)
{
  ItemVal ans,rval;
  if(index >= 0 && index < endlist){
    SetString(demoText, wdtxtArr[index]);
    currPage = index;
  }
  if(!((wlnApp*)theApp)->practicing()){
    //    ((wlnApp*)theApp)->highScrQ();
    ((wlnApp*)theApp)->practiceMode(true);
    ((wlnApp*)theApp)->SetValueAll(mnuPractice, true, Checked);
  }
  ((wlnApp*)theApp)->startAtLevel(1);
  ((wlnApp*)theApp)->demodiag(true);
  ans = ShowModalDialog(msg,rval);
  ((wlnApp*)theApp)->demodiag(false);
  ((wlnApp*)theApp)->runDemo(false);
  if (ans == M_Cancel)
    return 0;

  // *** Add code to process dialog values here

  return ans == btnPractice;
}

void wDemModalDialog::showKeyPress(int theKey){
#ifdef __WINDOWS__ //use sensitive because it shows
  SetValue(arrowUp, true, Sensitive);    //reset all the arrows
  SetValue(arrowDown, true, Sensitive);
  SetValue(arrowLeft, true, Sensitive);
  SetValue(arrowRight, true, Sensitive);
  switch(theKey){
  case Left:
    SetValue(arrowLeft, false, Sensitive);
    break;
  case Right:
    SetValue(arrowRight, false, Sensitive);
    break;
  case Down:
    SetValue(arrowDown, false, Sensitive);
    break;
  case Up:
    SetValue(arrowUp, false, Sensitive);
    break;
  }//switch(theKey)
#else //ifdef __WINDOWS__
  //not windows, i.e. linux: use hidden because sensitive doesn't show
  //cerr << "Made it to ShowKeyPress, key value == " << theKey << endl;
  SetValue(arrowUp, false, Hidden);    //reset all the arrows
  SetValue(arrowDown, false, Hidden);
  SetValue(arrowLeft, false, Hidden);
  SetValue(arrowRight, false, Hidden);
  switch(theKey){
  case Left:
    SetValue(arrowLeft, true, Hidden);
    break;
  case Right:
    SetValue(arrowRight, true, Hidden);
    break;
  case Down:
    SetValue(arrowDown, true, Hidden);
    break;
  case Up:
    SetValue(arrowUp, true, Hidden);
    break;
  }//switch(theKey)
#endif //else //ifdef __WINDOWS__
}//showKeyPress
  



//====================>>> wDemModalDialog::DialogCommand <<<====================
void wDemModalDialog::DialogCommand(ItemVal id, ItemVal retval, CmdType ctype)
{
  UserDebug2(CmdEvents,"wDemModalDialog::DialogCommand(id:%d, val:%d)\n",id, retval)

  //static int demoKey = 0;
  int firsty;
  switch (id)		// We will do some things depending on value
    {
      //@V@:Case: btnTestMDlg
    case btnPlay:
      //((wlnApp*)theApp)->practiceMode(false);
      //((wlnApp*)theApp)->SetValueAll(mnuPractice, false, Checked);
      CloseDialog();
      ((wlnApp*)theApp)->runDemo(false);
      ((wlnApp*)theApp)->SendWindowCommandAll(M_New, 1, C_Blank);
      break;
    case btnPractice:
      CloseDialog();
      ((wlnApp*)theApp)->runDemo(false);
      ((wlnApp*)theApp)->practiceMode(true);
      ((wlnApp*)theApp)->startAtLevel(1);
      break;
    case btnDemoNext:
      if(currPage < endlist - 1){
	currPage++;
	SetString(demoText, wdtxtArr[currPage]);
      }
      if(currPage == action2){
	((wlnApp*)theApp)->runDemo(true);
      } else {
	((wlnApp*)theApp)->runDemo(false);
      }
      if(currPage == endlist - 1){
	SetValue(btnDemoNext, false, Sensitive);
      }
      if(currPage > 0){
	SetValue(btnDemoPrev, true, Sensitive);
      }
      break;
    case btnDemoPrev:
      if(currPage > 0){
	currPage--;
	SetString(demoText, wdtxtArr[currPage]);
      }
      if(currPage == action2){
	((wlnApp*)theApp)->runDemo(true);
      } else {
	((wlnApp*)theApp)->runDemo(false);
      }
      if(currPage == 0){
	SetValue(btnDemoPrev, false, Sensitive);
      }
      if(currPage < endlist - 1){
	SetValue(btnDemoNext, true, Sensitive);
      }
      break;
    case btnTestMDlg:
      {
	vNoticeDialog note(this);
	note.Notice("Test Dialog");
	break;
      }	//@V@:EndCase
    case arrowLeft:
      showKeyPress(Left);
      break;
    case arrowRight:
      showKeyPress(Right);
      break;
    case arrowUp:
      showKeyPress(Up);
      break;
    case arrowDown:
      showKeyPress(Down);
      break;
    case demoClrKeys:
      showKeyPress(0);
      break;
//     case demoKeyPress:
//       cerr << "Made it to demoKeyPress. retval == " << retval << endl;
//       if(currPage == action2){
// 	firsty = ffs(retval);
// 	switch(firsty){
// 	case 1:
// 	  showKeyPress(Left);
// 	  ((wlnApp*)theApp)->KeyFake(vk_Left, 0);
// 	  break;
// 	case 2:
// 	  showKeyPress(Right);
// 	  ((wlnApp*)theApp)->KeyFake(vk_Right, 0);
// 	  break;
// 	case 3:
// 	  showKeyPress(Up);
// 	  ((wlnApp*)theApp)->KeyFake(vk_Up, 0);
// 	  break;
// 	case 4:
// 	  showKeyPress(Down);
// 	  ((wlnApp*)theApp)->KeyFake(vk_Down, 0);
// 	  break;
//	}//switch(firsty)
    }//end switch(id)

  vModalDialog::DialogCommand(id,retval,ctype);
}//DialogCommand

