/***
 This file belongs to the Xened distribution.
 Copyright (C) 1995-2001 Thorsten Thielen <thth@gmx.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***/

//#define _TEST_
//#define _VERBOSE_

#ifdef _GIFLOAD_
#undef _VERBOSE_
#undef _TEST_
#endif

#ifdef __EMX__
#include <graph.h>
#include <os2.h>
#endif

#ifdef __LINUX__
#include "xened.h"
#endif

#include <stdio.h>
#include <stdlib.h>

/*************************************************************************/

#ifdef _TEST_
#define  GFX_INIT(m)              g_mode (m)
#define  GFX_CLOSE()              g_mode (G_MODE_OFF)
#define  GFX_SET(x,y,c)           g_set (x, y, c)
#define  GFX_GET(x,y,c)           g_get (x, y)
#define  GFX_LINE(x1,y1,x2,y2,c)  g_line (x1, y1, x2, y2, c)
#define  GFX_BOX(x,y,xs,ys,c)     g_box (x, y, x+xs-1, y+ys-1, c, G_FILL)
#define  GFX_RECT(x,y,xs,ys,c)    g_box (x, y, x+xs-1, y+ys-1, c, G_OUTLINE)
#define  GFX_LOCK()               g_lock ()
#define  GFX_UNLOCK()             g_unlock ()
#endif

#ifndef GFX_SET
#define  GFX_SET(x,y,c)           g_set (x, y, c)
#endif

#ifndef GFX_LOCK
#define  GFX_LOCK()               g_lock ()
#endif

#ifndef GFX_UNLOCK
#define  GFX_UNLOCK()             g_unlock ()
#endif

#define GIF_ID_STR "GIF87a"
#define MAX_BITPLANES 8
#define IMAGE_DESC_CHAR ','

enum { IFO_SEQUENTIAL, IFO_INTERLACED };

struct GIFScreenDescr
{
    USHORT   xs, ys;
    BOOL     fGCM;
    USHORT   cBitplanes, cPixel;
    USHORT   colidxBack;
};

struct GIFImageDescr
{
    USHORT   x, y, xs, ys;
    BOOL     fLCM;
    USHORT   ifo;
    USHORT   cBitplanes;
};

/*************************************/

#include "decoder.c"

BOOL load_gif (PSZ pszFilename, USHORT x, USHORT y);

/*************************************/

FILE *g_pfile;
INT  g_ypos = 0, g_xpos = 0;
INT  bad_code_count;

#ifndef _LOADGIF_
LONG g_lPos;
#endif

/*************************************/

#ifdef _TEST_

VOID main (INT argc, PCHAR argv[])
{
    GFX_INIT (G_MODE_VGA_L);

    if (argc > 1)
        load_gif (argv[1], 0, 0);

    getchar ();
    
    GFX_CLOSE ();
    exit (0);
}
#endif

/*************************************************************************/

INT get_byte (void)
{
    return (getc (g_pfile));
}

INT out_line (BYTE pixels[], INT linelen)
{
    USHORT   i;

    for (i = 0; i < linelen; i++)
        GFX_SET (g_xpos+i, g_ypos, pixels[i]);
    g_ypos ++;

    return (1);
}
/*************************************************************************/

BOOL load_gif (PSZ pszFilename, USHORT x, USHORT y)
{
#ifdef _LOADGIF_
    CHAR   rgch[11];
    BYTE   b;
    USHORT check;
    LONG   l;
    FILE   *pfile;

    struct GIFScreenDescr   gscrdsc;
    struct GIFImageDescr    gimgdsc;

    // Open GIF-file
    if (! (pfile = fopen (pszFilename, "rb")))
    {
        fprintf (stderr, "ERROR: Could not open file \"%s\".\n", pszFilename);
        return (FALSE);
    }

    g_pfile = pfile;

    // Check ID-string at start of file
    fread (rgch, 1, strlen (GIF_ID_STR), pfile);
    rgch[strlen (GIF_ID_STR)] = '\0';
    if (strcmp (rgch, GIF_ID_STR) != 0)
    {
        fprintf (stderr, "ERROR: Not a (valid) GIF-file: \"%s\".\n",
                 pszFilename);
        fclose (pfile);
        return (FALSE);
    }

    // Read GIF-ScreenDescriptor
    fread (&(gscrdsc.xs), 1, 2, pfile);
    fread (&(gscrdsc.ys), 1, 2, pfile);
    b = getc (pfile);
    gscrdsc.fGCM = (b & 0x80) ? TRUE : FALSE;
    if ((gscrdsc.cBitplanes = (b & 0x07)) > MAX_BITPLANES)
    {
        fprintf (stderr, "WARNING: More than %d bitplanes?! (global)\n",
                 MAX_BITPLANES);
        gscrdsc.cBitplanes = MAX_BITPLANES;
    }
    gscrdsc.colidxBack = getc (pfile);
    b = getc (pfile);

#ifdef _VERBOSE_
    printf ("ScreenDescriptor:\n"
            "\txsScreen = %d\n"
            "\tysScreen = %d\n"
            "\tGlobalColorMap? %s\n"
            "\t#Bitplanes = %d\n"
            "\tColIndex Background = %d\n",
            gscrdsc.xs, gscrdsc.ys,
            gscrdsc.fGCM ? "yes" : "no",
            gscrdsc.cBitplanes,
            gscrdsc.colidxBack);
#endif
    
    // Read GlobalColorMap if exists
    if (gscrdsc.fGCM)
    {
        // FIXME do sth with this values!
        l = (1 << gscrdsc.cBitplanes) * 3L;
        fseek (pfile, l, SEEK_CUR);
    }

    // Look for ImageDescriptor
    while (getc (pfile) != IMAGE_DESC_CHAR)
        ;

    // Read GIF-ImageDescriptor
    fread (&(gimgdsc.x), 1, 2, pfile);
    fread (&(gimgdsc.y), 1, 2, pfile);
    fread (&(gimgdsc.xs), 1, 2, pfile);
    fread (&(gimgdsc.ys), 1, 2, pfile);
    b = getc (pfile);
    gimgdsc.fLCM = (b & 0x80) ? TRUE : FALSE;
    gimgdsc.ifo = (b & 0x40) ? IFO_SEQUENTIAL : IFO_INTERLACED;
    if ((gimgdsc.cBitplanes = (b & 0x07)) > MAX_BITPLANES)
    {
        fprintf (stderr, "WARNING: More than %d bitplanes?! (for image)\n",
                 MAX_BITPLANES);
        gimgdsc.cBitplanes = MAX_BITPLANES;
    }

#ifdef _VERBOSE_
    printf ("ImageDescriptor:\n"
            "\txsImage = %d\n"
            "\tysImage = %d\n"
            "\txImage = %d\n"
            "\tyImage = %d\n"
            "\tLocalColorMap? %s\n"
            "\tImageOrder = %s\n"
            "\t#Bitplanes = %d\n",
            gimgdsc.xs, gimgdsc.ys,
            gimgdsc.x, gimgdsc.y,
            gimgdsc.fLCM ? "yes" : "no",
            (gimgdsc.ifo = IFO_SEQUENTIAL) ? "Sequential" : "Interlaced",
            gimgdsc.cBitplanes);
#endif

    // Read LocalColorMap if exists
    if (gimgdsc.fLCM)
    {
        // FIXME do sth with this values!
        l = (1 << gscrdsc.cBitplanes) * 3L;
        fseek (pfile, l, SEEK_CUR);
    }

#ifdef _VERBOSE_
    getchar ();
#endif
#endif /* #ifdef _LOADGIF_ */
    
    g_xpos = x;
    g_ypos = y;
    GFX_LOCK ();
#ifdef _LOADGIF_
    if ((check = decoder (gimgdsc.xs)))
    {
        fprintf (stderr, "ERROR: Could not decode (ErrCode = %d)\n", check);
        fclose (pfile);
        return (FALSE);
    }
#else
    fseek (g_pfile, g_lPos, SEEK_SET);
    decoder (189);
#endif
    GFX_UNLOCK ();

#ifdef _LOADGIF_
    fclose (pfile);
#endif
    return (TRUE);
}
/*************************************************************************/
