/***
 This file belongs to the Xened distribution.
 Copyright (C) 1995-2001 Thorsten Thielen <thth@gmx.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***/
/*
 * mainmenu.c - Xened
 */

#include "xened.h"

/*************************************************************************/

extern SHORT       rgsValues[MAX_SECTORS][7];
extern PSZ         *rgpsz;
extern GADGET      rggad[];
extern PTILEBOX    ptbox, ptboxFont, ptboxWeaps;
extern CHAR        g_pszErr[];

/*************************************************************************/

#define WIN_MM_XS       167
#define WIN_MM_YS       121
#define XS_MENU         WIN_MM_XS-16

PSZ *pszEntries;

/*************************************************************************/

SHORT MainMenu (USHORT xo, USHORT yo)
{
    BOOL           f = TRUE;
    SHORT          kcode, action;
    static SHORT   entry = 0, old_entry;
    USHORT         i;

    pszEntries = &rgpsz[TXT_MENU_0];
    
#ifdef _TESTSTAR_
    SHORT     x = 0;
    clock_t   cClock = 0;
#endif

    draw_stone (0+xo, 0+yo, WIN_MM_XS-1+xo, WIN_MM_YS-1+yo, LIGHTGRAY,
                WHITE, DARKGRAY);
    draw_stone (4+xo, 4+yo, WIN_MM_XS-5+xo, WIN_MM_YS-5+yo, CYAN, DARKGRAY,
                WHITE);
    draw_stone (8+xo, 8+yo, WIN_MM_XS-8+xo, WIN_MM_YS-20+yo, BLACK, WHITE,
                DARKGRAY);
    draw_stone (8+xo, WIN_MM_YS-17+yo, WIN_MM_XS-8+xo, WIN_MM_YS-9+yo, BLACK,
                WHITE, DARKGRAY);

    /*** Display menu-entries ***/
    for (i = 0; i < MAX_ENTRIES; i++)
        show_string (ptboxFont, pszEntries[i],
                     9+xo+(XS_MENU-strlen (pszEntries[i])*(ptboxFont->xs+1))/2,
                     14+yo+i*(ptboxFont->ys+1), XS_MENU);

    /*** Draw cursor ***/
    GFX_RECT (13+xo, 14+yo+entry*(ptboxFont->ys+1)-1,
              154+xo, 14+yo+(entry+1)*(ptboxFont->ys+1)-1, RED);

    do
    {
        if (entry != old_entry)
        {
            GFX_RECT (13+xo, 14+yo+old_entry*(ptboxFont->ys+1)-1,
                      154+xo, 14+yo+(old_entry+1)*(ptboxFont->ys+1)-1, BLACK);
            GFX_RECT (13+xo, 14+yo+entry*(ptboxFont->ys+1)-1,
                      154+xo, 14+yo+(entry+1)*(ptboxFont->ys+1)-1, RED);
            old_entry = entry;
        }

        kcode = -1;
        do
        {
#ifdef _TESTSTAR_
            if (cClock < clock ())
            {
                cClock = clock ();
                
                g_set (x, 100, 0);
                x ++;
                if (x >= 320)
                    x = 0;
                g_set (x, 100, 15);
            }
#else
            /*** Check for any user activities (keyboard,mouse) ***/
            kcode = _read_kbd (0, 0, 0);
            if (kcode == 0)
                kcode = _read_kbd (0, 0, 0);

            do_stars (xo+0, yo+0, xo+WIN_MM_XS-1, yo+WIN_MM_YS-1);
            if (f)
                do_msg_line (xo, yo);
#endif
        }
        while (kcode == -1);
        action = -1;

        /*** Check what action user wants ***/
        if (kcode != -1)
        {
            switch (kcode)
                {
                case C_UP:       action = ACT_MENU_UP;         break;
                case C_DOWN:     action = ACT_MENU_DOWN;       break;
                case PAGE_UP:    action = ACT_MENU_HOME;       break;
                case PAGE_DOWN:  action = ACT_MENU_END;        break;
                case C_HOME:     action = ACT_MENU_HOME;       break;
                case C_END:      action = ACT_MENU_END;        break;
                case 9:          action = ACT_MENU_DOWN;       break;
                case K_BACKTAB:  action = ACT_MENU_UP;         break;
                case 13:         action = ACT_MENU_SHOOT;      break;

                case ' ':
                    if (f)
                        f = FALSE;
                    else
                        f = TRUE;
                    break;
                }
        }

        /*** Make action ***/
        switch (action)
        {
        case ACT_MENU_UP:
            if (entry > 0)
                entry --;
            break;

        case ACT_MENU_DOWN:
            if (entry < MAX_ENTRIES-1)
                entry ++;
            break;

        case ACT_MENU_HOME:
            entry = 0;
            break;

        case ACT_MENU_END:
            entry = MAX_ENTRIES-1;
            break;

        case ACT_MENU_SHOOT:
            action = ACT_QUIT;
            break;
        }
    }
    while (action != ACT_QUIT);

    GFX_BOX (0+xo, 0+yo, WIN_MM_XS-1+xo, WIN_MM_YS-1+yo, BLACK);

    return (entry);
}
/*************************************************************************/

#define A_STARS 50
#define STAR_SPEED 96

USHORT starcols[4] = { DARKGRAY, LIGHTGRAY, WHITE };

VOID do_stars (USHORT x1, USHORT y1, USHORT x2, USHORT y2)
{
    static BOOL      f = FALSE;
    SHORT            i, x, y;
    static SHORT     stars[A_STARS][5];
#ifdef _USE_CLOCK_
#ifdef __TURBOC__
    static ULONG     cClock = 0L, cDummy;
#else
    static clock_t   cClock = 0;
#endif
#endif

#ifdef _USE_CLOCK_
#ifdef __TURBOC__
/*    sprintf (g_pszErr, "readtimer ():\n%ld\n %lu", cDummy, cDummy);
    message (g_pszErr, MAGENTA, MSG_X, MSG_Y);*/
    
    if (cClock > (cDummy = (ULONG) readtimer ()))
        return;

    cClock = cDummy + 10000L;
/*    if (readtimer () % 10 != 0)
        return;*/
#else
    if (cClock == clock ())
         return;
    
    cClock = clock ();
#endif
#endif

    if (! f)
    {
        for (i = 0; i < A_STARS; i++)
        {
            stars[i][2] = RANDOM (STAR_SPEED);
            stars[i][0] = RANDOM (320);
            stars[i][1] = RANDOM (200);
            if (GFX_GET (stars[i][0], stars[i][1]))
                stars[i][3] = 0;
            else
                stars[i][3] = 1;
            stars[i][4] = RANDOM (STAR_SPEED)+1;
        }
        f = TRUE;
    }

    for (i = 0; i < A_STARS; i++)
    {
        x = stars[i][0];
        y = stars[i][1];

        if (x <= 320)
        {
            // Move star
            stars[i][4] += stars[i][2];
            if (stars[i][4] >= STAR_SPEED)
            {
                stars[i][4] -= STAR_SPEED-1;

                if (stars[i][3])
                    if (! ((x >= x1) && (x <= x2) &&
                           (y >= y1) && (y <= y2)))
                    {
                        // Clear star from "sky"
                        GFX_SET (x, y, BLACK);
                    }

#ifdef __TURBOC__
                stars[i][0] += 1;
#else
                stars[i][0] += 2;
#endif
                x = stars[i][0];

                // New place "on sky"?
                if (GFX_GET (x, y) ||
                    ((x >= x1) && (x <= x2) &&
                     (y >= y1) && (y <= y2)))
                {
                    stars[i][3] = 0;
                }
                else
                {
                    stars[i][3] = 1;
                    if ((x >= 0) && (x < 320))
                    {
                        if (stars[i][2] <= STAR_SPEED/5*2)
                            GFX_SET (x, y, starcols[0]);
                        else if (stars[i][2] <= STAR_SPEED/5*3)
                            GFX_SET (x, y, starcols[1]);
                        else
                            GFX_SET (x, y, starcols[2]);
                    }
                }
            }
        }
        else
        {
            stars[i][2] = RANDOM (STAR_SPEED>>1)+RANDOM (STAR_SPEED>>1)+1;
            stars[i][0] = -RANDOM (50)-stars[i][2];
            stars[i][1] = RANDOM (200);
            stars[i][3] = 0;
            stars[i][4] = 0;
        }
    }
}
/*************************************************************************/

#ifdef _MSG_SCROLL_
VOID shift_left (USHORT x1, USHORT y1, USHORT x2, USHORT y2, USHORT dx)
{
    USHORT   x, y;
    
    for (x = x1; x <= x2; x++)
        for (y = y1; y <= y2; y++)
            GFX_SET (x-dx, y, GFX_GET (x, y));
}
#endif

PSZ *pszMessages;

VOID do_msg_line (USHORT xo, USHORT yo)
{
#ifdef _MSG_SCROLL_
    static BOOL     f = FALSE;
    static USHORT   usBig = 0, usSmall = 0;

#ifdef _USE_CLOCK_
#ifdef __TURBOC__
    static ULONG     cClock = 0L, cDummy;
#else
    static clock_t   cClock = 0;
#endif
#endif

#ifdef _USE_CLOCK_
#ifdef __TURBOC__
/*    sprintf (g_pszErr, "readtimer ():\n%ld\n %lu", cDummy, cDummy);
    message (g_pszErr, MAGENTA, MSG_X, MSG_Y);*/
    
    if (cClock > (cDummy = (ULONG) readtimer ()))
        return;

    cClock = cDummy + 15000L;
/*    if (readtimer () % 10 != 0)
        return;*/
#else
    if (cClock >= clock ())
         return;
    
    cClock = clock ()+5;
#endif
#endif
    
    if (! f)
    {
        pszMessages = &rgpsz[TXT_MESSAGES_0];
        f = TRUE;
    }

    GFX_LOCK ();
    shift_left (9+xo+1, WIN_MM_YS-15+yo, 9+xo+XS_MENU-2, WIN_MM_YS-15+yo+8, 1);
    GFX_UNLOCK ();
    
    usSmall ++;
    if (usSmall == ptboxFont->xs+1)
    {
        usSmall = 0;
        usBig ++;
        if (usBig >= strlen (pszMessages[0]))
            usBig = 0;
    }

    if (usSmall == 0)
        show_char (ptboxFont, pszMessages[0][usBig],
                   9+xo+XS_MENU-(ptboxFont->xs+1)-1, WIN_MM_YS-15+yo);
#else
    static USHORT   cMessage = 0;
    static time_t   cTime = 0;

    if (cTime+2 <= time (NULL))
    {
        pszMessages = &rgpsz[TXT_MESSAGES_0];
        cTime = time (NULL);
        
        draw_stone (8+xo, WIN_MM_YS-17+yo, WIN_MM_XS-8+xo, WIN_MM_YS-9+yo,
                    BLACK, WHITE, DARKGRAY);
        show_string (ptboxFont, pszMessages[cMessage], 9+xo+
                     (XS_MENU-strlen (pszMessages[cMessage])*(ptboxFont->xs+1))
                     /2, WIN_MM_YS-15+yo, XS_MENU);

        cMessage = (cMessage+1) % MAX_MESSAGES;
    }
#endif
}
/*************************************************************************/
