/***
 This file belongs to the Xened distribution.
 Copyright (C) 1995-2001 Thorsten Thielen <thth@gmx.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***/
/*
 * ed_weaps.c - Xened
 */

#include "xened.h"

/*************************************************************************/

extern PSZ         *rgpsz;
extern GADGET      rggad[];
extern PTILEBOX    ptbox, ptboxFont, ptboxWeaps;
extern CHAR        g_pszErr[];

/*************************************************************************/

#define MAX_WEAPONS 24
#define MAX_PRICE 9999

PSZ *pszWeapons;
PSZ *pszComments;

USHORT usPrices[MAX_WEAPONS] =
{
    200, 400, 400, 400, 600, 1000, 1000, 1000, 1000, 1200, 2000, 2000,
    3000, 4000, 4000, 4000, 4000, 4000, 4000, 5000, 5000, 6000, 6000,
    6000,
};

/*************************************************************************/

VOID EditWeapons (PGADGETLIST pgadlist, PSZ pszPath, USHORT xo, USHORT yo)
{
    CHAR    dstring[21];
    SHORT   kcode, action, weapon = 0, old_weapon = weapon+1;
    USHORT  usSetTo[MAX_WEAPONS];

    if (! LoadWeaponPrices (pszPath, usSetTo))
        return;
    
    pgadlist->xo = xo;
    pgadlist->yo = yo;

    pszWeapons = &rgpsz[TXT_ADVICE];
    pszComments = &rgpsz[TXT_WEAPON_COMMENT_0];

    draw_stone (0+xo, 0+yo, 216+xo, 78+yo, LIGHTGRAY, WHITE, DARKGRAY);
    draw_stone (4+xo, 4+yo, 212+xo, 74+yo, CYAN, DARKGRAY, WHITE);
    draw_stone (8+xo, 8+yo, 43+xo, 42+yo, BLACK, WHITE, DARKGRAY);
    draw_stone (8+xo, 48+yo, 208+xo, 70+yo, BLACK, WHITE, DARKGRAY);
    draw_stone (72+xo, 8+yo, 106+xo, 24+yo, BLACK, WHITE, DARKGRAY);
    draw_stone (72+xo, 27+yo, 106+xo, 42+yo, BLACK, WHITE, DARKGRAY);

    draw_stone (rggad[18].x1+xo, rggad[18].y1+yo,
                rggad[18].x2+xo, rggad[18].y2+yo, LIGHTGRAY, WHITE, DARKGRAY);
    draw_stone (rggad[19].x1+xo, rggad[19].y1+yo,
                rggad[19].x2+xo, rggad[19].y2+yo, LIGHTGRAY, WHITE, DARKGRAY);
    
    gadlist_draw (pgadlist);

    show_string (ptboxFont, rgpsz[TXT_PRICE], 75+xo, 11+yo, 30);
    show_string (ptboxFont, rgpsz[TXT_SET_TO], 75+xo, 29+yo, 30);
    
    do
    {
        if (weapon != old_weapon)
        {
            show_tile (ptboxWeaps, weapon, 18+xo, 18+yo);
            
            draw_stone (8+xo, 48+yo, 208+xo, 70+yo, BLACK, WHITE, DARKGRAY);
            show_string (ptboxFont, pszWeapons[weapon], 11+xo, 50+yo, 200);
            show_string (ptboxFont, pszComments[weapon], 11+xo, 58+yo, 200);

            sprintf (dstring, "%4d", usPrices[weapon]);
            show_string (ptboxFont, dstring, 85+xo, 18+yo, 30);
            
            old_weapon = weapon;
        }

        sprintf (dstring, "%4d", usSetTo[weapon]);
        show_string (ptboxFont, dstring, 85+xo, 36+yo, 30);
        
        kcode = -1;
        do
        {
            /*** Check for any user activities (keyboard,mouse) ***/
            kcode = _read_kbd (0, 0, 0);
            if (kcode == 0)
                kcode = _read_kbd (0, 0, 0);

            do_stars (xo+0, yo+0, xo+216, yo+78);
        }
        while (kcode == -1);
        action = -1;

        /*** Check what action user wants ***/
        if (kcode != -1)
        {
            switch (kcode)
                {
                case C_UP:       action = ACT_WEAPON_10_MORE;  break;
                case C_DOWN:     action = ACT_WEAPON_10_LESS;  break;
                case PAGE_UP:    action = ACT_WEAPON_100_MORE; break;
                case PAGE_DOWN:  action = ACT_WEAPON_100_LESS; break;
                case '+':        action = ACT_WEAPON_NEXT;     break;
                case '-':        action = ACT_WEAPON_PREV;     break;
                case 27:         action = ACT_WEAPONS_OK;      break;
                case 's':        action = ACT_WEAPONS_SAVE;    break;
                
                case 9:          action = ACT_GADGET_NEXT;     break;
                case K_BACKTAB:  action = ACT_GADGET_PREV;     break;
                case 13:         action = ACT_GADGET_SHOOT;    break;
            }
        }

        /*** Anything to do with the gadgets? ***/
        switch (action)
        {
        case ACT_GADGET_NEXT:
            gadlist_next (pgadlist);
            break;
 
        case ACT_GADGET_PREV:
            gadlist_prev (pgadlist);
            break;

        case ACT_GADGET_SHOOT:
            action = gadlist_shoot (pgadlist);
            break;
        }

        /*** Make action ***/
        switch (action)
        {
        case ACT_WEAPON_PREV:
            if (weapon == 0)
                weapon = 23;
            else
                weapon --;
            break;

        case ACT_WEAPON_NEXT:
            if (weapon >= 23)
                weapon = 0;
            else
                weapon ++;
            break;

        case ACT_WEAPON_10_MORE:
            if (usSetTo[weapon] <= 9989)
                usSetTo[weapon] += 10;
            break;

        case ACT_WEAPON_100_MORE:
            if (usSetTo[weapon] <= 9899)
                usSetTo[weapon] += 100;
            break;

        case ACT_WEAPON_10_LESS:
            if (usSetTo[weapon] > 10)
                usSetTo[weapon] -= 10;
            break;

        case ACT_WEAPON_100_LESS:
            if (usSetTo[weapon] > 100)
                usSetTo[weapon] -= 100;
            break;

        case ACT_WEAPONS_SAVE:
            if (SaveWeaponPrices (pszPath, usSetTo))
                message (rgpsz[TXT_WROTE_NEW_PRICES_TO_FILE_XENON2_EXE], GREEN,
                         MSG_X, MSG_Y);
            break;                 
        }
    }
    while (action != ACT_WEAPONS_OK);

    GFX_BOX (0+xo, 0+yo, 216+xo, 78+yo, BLACK);
}
/*************************************************************************/

BOOL LoadWeaponPrices (PSZ pszPath, USHORT rgus[])
{
    CHAR    pszFilename[256];
    SHORT   i;
    FILE    *pfile;

    sprintf (pszFilename, "%s%c%s", pszPath, DIR_SEPERATOR_CHAR, EXEFILE_N);
    if (! (pfile = fopen (pszFilename, "rb")))
    {
        sprintf (g_pszErr, rgpsz[TXT_COULD_NOT_OPEN_FILE_X], pszFilename);
        message (g_pszErr, RED, MSG_X, MSG_Y);
        return (FALSE);
    }
  
    fseek (pfile, 227L*512L+2L, SEEK_SET);
  
    for (i = 0; i < MAX_WEAPONS; i++)
        fread (&rgus[i], 1, 2, pfile);
  
    fclose (pfile);
    return (TRUE);
}
/*************************************************************************/

BOOL SaveWeaponPrices (PSZ pszPath, USHORT rgus[])
{
    CHAR    pszFilename[256];
    SHORT   i;
    FILE    *pfile;

    sprintf (pszFilename, "%s%c%s", pszPath, DIR_SEPERATOR_CHAR, EXEFILE_N);
    if (! (pfile = fopen (pszFilename, "rb+")))
    {
        sprintf (g_pszErr, rgpsz[TXT_COULD_NOT_OPEN_FILE_X], pszFilename);
        message (g_pszErr, RED, MSG_X, MSG_Y);
        return (FALSE);
    }
  
    fseek (pfile, 227L*512L+2L, SEEK_SET);
  
    for (i = 0; i < MAX_WEAPONS; i++)
        fwrite (&rgus[i], 1, 2, pfile);
  
    fclose (pfile);
    return (TRUE);
}
/*************************************************************************/
