/***
 This file belongs to the Xened distribution.
 Copyright (C) 1995-2001 Thorsten Thielen <thth@gmx.net>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***/
/*
 * xen_map.c - Xened
 */

#include "xened.h"

/*************************************************************************/

extern PSZ    *rgpsz;
extern CHAR   g_pszErr[];

/*************************************************************************/

#ifdef _PRELOAD_TILES_
PTILEBOX ptboxMap;
#endif

/*************************************************************************/

BOOL load_xenon_map (STRPTR map_file_n, USHORT map[YS_MAP][XS_MAP])
{
    SHORT   i, line, col, mode, anz;
    FILE    *map_file;

    if ((map_file = fopen (map_file_n,"rb")) == NULL)
    {
        sprintf (g_pszErr, rgpsz[TXT_COULD_NOT_OPEN_FILE_X], map_file_n);
        message (g_pszErr, RED, MSG_X, MSG_Y);
        return (FALSE);
    }

    line = 0;
    col = -1;
    mode = 1;

    while (line < YS_MAP)
    {
        anz = (SHORT) getc (map_file);
        if (feof (map_file) || ferror (map_file))
        {
#ifdef _DEBUG_
            sprintf (g_pszErr, "MAP-ERROR: line=%d, col=%d, pos=%ld, anz=%d\n",
                     line, col, ftell (map_file), anz);
            message (g_pszErr, MAGENTA, MSG_X, MSG_Y);
#endif
            break;
        }

        if (anz == 0)
        {
            anz = getc (map_file);
            for (i = 0; i < anz; i++)
            {
                col++;
                if (col >= XS_MAP)
                {
                    line++;
                    col = 0;
                }
                map[line][col] = 0;
            }
            mode = 1;
        }
        else
        {
            for (i = 0; i < anz; i++)
            {
                col++;
                if (col >= XS_MAP)
                {
                    line++;
                    col = 0;
                }

                if ((line < 0) || (line >= YS_MAP) || (col < 0) || (col >= XS_MAP))
                {
#ifdef _DEBUG_
                    sprintf (g_pszErr, "MAP-ERROR: line=%d, col=%d, pos=%ld\n",
                             line, col, ftell (map_file));
                    message (g_pszErr, MAGENTA, MSG_X, MSG_Y);
#endif
                    break;
                }

                map[line][col] = 0;
                if (mode == 1)
                    fread (&map[line][col], 1, 2, map_file);
            }
            
            if (mode == 0)
                mode = 1;
            else
                mode = 0;
        }
    }

    fclose (map_file);
    return (TRUE);
}
/*************************************************************************/

BOOL save_xenon_map (STRPTR map_file_n, USHORT map[YS_MAP][XS_MAP])
{
    SHORT  line, col, anz;
    LONG   pos[2];
    FILE   *map_file;

    if ((map_file = fopen (map_file_n,"wb")) == NULL)
    {
        sprintf (g_pszErr, rgpsz[TXT_COULD_NOT_OPEN_FILE_X], map_file_n);
        message (g_pszErr, RED, MSG_X, MSG_Y);
        return (FALSE);
    }

    line = 0;
    col = 0;

    while (line < YS_MAP)
    {
        if (map[line][col] != 0x0000)
        {
            anz = 0;
            pos[0] = ftell (map_file);
            fputc (anz,map_file);
    
            while (map[line][col] != 0x0000)
            {
                fwrite (&map[line][col], 1, 2, map_file);
                anz++;
                col++;
                if (col >= XS_MAP)
                {
                    col = 0;
                    line++;
                    if (line >= YS_MAP)
                        goto EndIt;
                }
            }
    
            pos[1] = ftell (map_file);
            fseek (map_file,pos[0],SEEK_SET);
            fputc (anz,map_file);
            fseek (map_file,pos[1],SEEK_SET);
        }
        
        anz = 0;
        while (map[line][col] == 0x0000)
        {
            anz++;
            col++;
            if (col >= XS_MAP)
            {
                col = 0;
                line++;
                if (line >= YS_MAP)
                {
                    write_anz (anz, map_file);
                    goto EndIt;
                }
            }
        }

        write_anz (anz, map_file);
    }

EndIt:

    fclose (map_file);
    return (TRUE);
}
/*************************************************************************/

BOOL display_xenon_map (USHORT map[YS_MAP][XS_MAP], USHORT mx, USHORT my,
                        USHORT ox, USHORT oy, USHORT xs, USHORT ys,
                        FILE *pfile, USHORT cx, USHORT cy, BOOL do_cursor)
{
    USHORT   x, y, usTile;
    BYTE     rgb[YS_TILE*XS_TILE];

    if (! pfile)
        return FALSE;
    
    GFX_LOCK ();
    
    for (y = 0; y < ys; y++)
        for (x = 0; x < xs; x++)
        {
            usTile = map[my+y][mx+x]/64;
            
#ifdef _PRELOAD_TILES_
            if (ptboxMap)
                show_tile (ptboxMap, usTile, ox+x*XS_TILE, oy+y*YS_TILE);
            else
#endif
            {
                fseek (pfile, usTile*SIZEOF_MAPTILE, SEEK_SET);
                read_xenon_tile (pfile, rgb);
                show_tile_raw (rgb, XS_TILE, YS_TILE, ox+x*XS_TILE,
                               oy+y*YS_TILE);
            }
/*            {
                lPos = map[my+y][mx+x]/2L*4L;
                fseek (pfile, lPos, SEEK_SET);
                read_xenon_tile (pfile, rgb);
                show_xenon_tile_gfx (&tile,ox+x*XS_TILE,oy+y*YS_TILE);
            } */
        }

    // Draw 'cursor' FIXME if visible
    if (do_cursor)
        GFX_RECT (ox+(cx-mx)*XS_TILE+2, oy+(cy-my)*YS_TILE+2,
                  ox+(cx-mx)*XS_TILE+2+11, oy+(cy-my)*YS_TILE+2+11,
                  LIGHTGREEN);

    GFX_UNLOCK ();
    return (TRUE);
}
/*************************************************************************/
