/*
    Ŀ
    Ĵ
    Ĵ   PROJECT      : SP2 (South Park Speaks/2)                  Ĵ
    Ĵ   FILE         : SP2.Cpp - Main File                        Ĵ
    Ĵ   Last modified: 03 Apr 99                                  Ĵ
    Ĵ
    

    SP2 - South Park Speaks/2
*/

#define         SP2

/* ------------------------------------------------------------------------ */
/* History                                                                  */
/* ------------------------------------------------------------------------ */
/*
    1.00    03/04/99    Initial Version
*/

/* ------------------------------------------------------------------------ */
/* Include files                                                            */
/* ------------------------------------------------------------------------ */

#define         INCL_PM
#define         INCL_MACHDR
#define         INCL_MCIOS2
#include        <os2.h>
#include        <os2me.h>

#include        "stdlib.h"
#include        "time.h"

#include        "SP2.H"

/* ------------------------------------------------------------------------ */
/* Definitions                                                              */
/* ------------------------------------------------------------------------ */

#define Version         "[SP2, V1.00 - 03/04/99 - (C) Chris Graham - WarpSpeed Computers]"

/* ------------------------------------------------------------------------ */
/* Foreward references                                                      */
/* ------------------------------------------------------------------------ */

extern "C" {
int                 PMprintf( const char *f, ... ) ;

MRESULT APIENTRY    SouthParkDlgProc( HWND hwndDlg, ULONG ulMessage, MPARAM mp1, MPARAM mp2 ) ;
MRESULT APIENTRY    AboutDlgProc( HWND hwndDlg, ULONG ulMessage, MPARAM mp1, MPARAM mp2 ) ;
void                CentreWindow( HWND hWnd ) ;
}

/* ------------------------------------------------------------------------ */
/* Constant Local Data                                                      */
/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Global Data                                                              */
/* ------------------------------------------------------------------------ */

HBITMAP             hbmBGAL ;
HBITMAP             hbmCARTMAN ;
HBITMAP             hbmCHEF ;
HBITMAP             hbmGARRISON ;
HBITMAP             hbmHANKY ;
HBITMAP             hbmIKE ;
HBITMAP             hbmJESUS ;
HBITMAP             hbmKENNY ;
HBITMAP             hbmKYLE ;
HBITMAP             hbmPOLICE ;
HBITMAP             hbmSTAN ;

LONG                cxDlgFrame, cyDlgFrame, cyTitleBar ;

HWND                hwndPopupMenu ;

/* ------------------------------------------------------------------------ */
/* PM Code                                                                  */
/* ------------------------------------------------------------------------ */

void                main( int argc, char *argv[] )
{
HAB                 hab ;                   /* handle to the anchor block   */
HMQ                 hmq ;                   /* handle to the message queue  */
QMSG                qmsg ;
ULONG               flCreate ;
HPS                 hps ;

    hab = WinInitialize( 0 ) ;
    hmq = WinCreateMsgQueue( hab, 100 ) ;

    cxDlgFrame = WinQuerySysValue( HWND_DESKTOP, SV_CXDLGFRAME ) ;
    cyDlgFrame = WinQuerySysValue( HWND_DESKTOP, SV_CYDLGFRAME ) ;
    cyTitleBar = WinQuerySysValue( HWND_DESKTOP, SV_CYTITLEBAR ) ;

    /* Load our Bitmaps */
    hps = WinGetPS( HWND_DESKTOP ) ;
    hbmBGAL     = GpiLoadBitmap( hps, NULLHANDLE, IDB_BGAL    , 0, 0 ) ;
    hbmCARTMAN  = GpiLoadBitmap( hps, NULLHANDLE, IDB_CARTMAN , 0, 0 ) ;
    hbmCHEF     = GpiLoadBitmap( hps, NULLHANDLE, IDB_CHEF    , 0, 0 ) ;
    hbmGARRISON = GpiLoadBitmap( hps, NULLHANDLE, IDB_GARRISON, 0, 0 ) ;
    hbmHANKY    = GpiLoadBitmap( hps, NULLHANDLE, IDB_HANKY   , 0, 0 ) ;
    hbmIKE      = GpiLoadBitmap( hps, NULLHANDLE, IDB_IKE     , 0, 0 ) ;
    hbmJESUS    = GpiLoadBitmap( hps, NULLHANDLE, IDB_JESUS   , 0, 0 ) ;
    hbmKENNY    = GpiLoadBitmap( hps, NULLHANDLE, IDB_KENNY   , 0, 0 ) ;
    hbmKYLE     = GpiLoadBitmap( hps, NULLHANDLE, IDB_KYLE    , 0, 0 ) ;
    hbmPOLICE   = GpiLoadBitmap( hps, NULLHANDLE, IDB_POLICE  , 0, 0 ) ;
    hbmSTAN     = GpiLoadBitmap( hps, NULLHANDLE, IDB_STAN    , 0, 0 ) ;
    WinReleasePS( hps ) ;

    /* Load our popup menu  */
    hwndPopupMenu = WinLoadMenu( HWND_DESKTOP, NULLHANDLE, IDM_POPUP ) ;

    WinDlgBox(  HWND_DESKTOP,           /*  Parent-window handle of the created dialog window.          */
                HWND_DESKTOP,           /*  Requested owner-window handle of the created dialog window. */
                SouthParkDlgProc,       /*  Dialog procedure for the created dialog window.             */
                NULLHANDLE,             /*  Resource identity containing the dialog template.           */
                DLG_SOUTHPARKSPEAKS,    /*  Dialog-template identity within the resource file.          */
                NULL ) ;                /*  Pointer to application-defined data area.                   */

    mciPlayResource( HWND_DESKTOP,      /*  Window handle.          */
                     NULLHANDLE,        /*  Module handle.          */
                     RT_WAVE,           /*  Resource type.          */
                     IDWAV_END,         /*  Resource identifier.    */
                     0,                 /*  Flags.                  */
                     NULL,              /*  Window title.           */
                     NULLHANDLE ) ;     /*  Window handle.          */

    /* Finish and clean up */
    WinDestroyMsgQueue( hmq ) ;
    WinTerminate( hab ) ;

    DosExit( EXIT_PROCESS, 0 ) ;
}

/* ------------------------------------------------------------------------ */
/* Window Procedure for the main dialog box                                 */
/* ------------------------------------------------------------------------ */
MRESULT APIENTRY    SouthParkDlgProc( HWND hwndDlg, ULONG ulMessage, MPARAM mp1, MPARAM mp2 )
{
static HBITMAP      hbmDisplayed ;
HPS                 hps ;
POINTL              pt ;
HBITMAP             hbm ;

    switch ( ulMessage )
        {
        case WM_INITDLG:
            /* 165, 129 */
            WinSetWindowPos( hwndDlg, NULLHANDLE, 0, 0, 165 + 2 * cxDlgFrame + 1, 129 + cyDlgFrame + cyTitleBar + 1, SWP_SIZE ) ;

            CentreWindow( hwndDlg ) ;

            srand( time( NULL ) ) ;

            WinSendMsg( hwndDlg, WM_COMMAND, MPFROMLONG( IDWAV_BGAL1 + ( ( NO_WAVES * rand() ) / RAND_MAX ) ), NULL ) ;
            break ;

        case WM_PAINT:
            /* Call our old default proc to paint frame sides   */
            WinDefDlgProc( hwndDlg, ulMessage, mp1, mp2 ) ;
            /* Now get a PS to our dialog                       */
            hps = WinGetPS( hwndDlg ) ;
            /* Offset the drawing of the bitmap by frame sizes  */
            pt.x = cxDlgFrame ;
            pt.y = cyDlgFrame ;
            WinDrawBitmap( hps, hbmDisplayed, NULL, &pt, 0, 0, DBM_NORMAL ) ;
            WinReleasePS( hps ) ;
            break ;

        case WM_COMMAND:
            hbm = NULLHANDLE ;
            switch ( SHORT1FROMMP(mp1) )
                {
                case IDWAV_BGAL1:
                case IDWAV_BGAL2:
                    hbm = hbmBGAL ;
                    break ;

                case IDWAV_CARTMAN1:
                case IDWAV_CARTMAN2:
                case IDWAV_CARTMAN3:
                case IDWAV_CARTMAN4:
                case IDWAV_CARTMAN5:
                case IDWAV_CARTMAN6:
                case IDWAV_CARTMAN7:
                case IDWAV_CARTMAN8:
                case IDWAV_CARTMAN9:
                case IDWAV_CARTMAN10:
                case IDWAV_CARTMAN11:
                case IDWAV_CARTMAN12:
                case IDWAV_CARTMAN13:
                case IDWAV_CARTMAN14:
                case IDWAV_CARTMAN15:
                    hbm = hbmCARTMAN ;
                    break ;

                case IDWAV_CHEF1:
                case IDWAV_CHEF2:
                case IDWAV_CHEF3:
                case IDWAV_CHEF4:
                case IDWAV_CHEF5:
                    hbm = hbmCHEF ;
                    break ;

                case IDWAV_GARRISON1:
                case IDWAV_GARRISON2:
                case IDWAV_GARRISON3:
                case IDWAV_GARRISON4:
                    hbm = hbmGARRISON ;
                    break ;

                case IDWAV_HANKY1:
                    hbm = hbmHANKY ;
                    break ;

                case IDWAV_IKE1:
                case IDWAV_IKE2:
                case IDWAV_IKE3:
                    hbm = hbmIKE ;
                    break ;

                case IDWAV_JESUS1:
                case IDWAV_JESUS2:
                case IDWAV_JESUS3:
                    hbm = hbmJESUS ;
                    break ;

                case IDWAV_KENNY1:
                case IDWAV_KENNY2:
                    hbm = hbmKENNY ;
                    break ;

                case IDWAV_KYLE1:
                case IDWAV_KYLE2:
                case IDWAV_KYLE3:
                case IDWAV_KYLE4:
                    hbm = hbmKYLE ;
                    break ;

                case IDWAV_POLICE1:
                case IDWAV_POLICE2:
                    hbm = hbmPOLICE ;
                    break ;

                case IDWAV_STAN1:
                case IDWAV_STAN2:
                case IDWAV_STAN3:
                case IDWAV_STAN4:
                    hbm = hbmSTAN ;
                    break ;

                case IDWAV_END:
                case DID_OK:
                case DID_CANCEL:                    /* Catches the ESC key      */
                    WinDismissDlg( hwndDlg, TRUE ) ;
                    break ;

                case IDM_ABOUT:
                    WinDlgBox(  HWND_DESKTOP,       /*  Parent-window handle of the created dialog window.          */
                                hwndDlg,            /*  Requested owner-window handle of the created dialog window. */
                                AboutDlgProc,       /*  Dialog procedure for the created dialog window.             */
                                NULLHANDLE,         /*  Resource identity containing the dialog template.           */
                                DLG_ABOUT,          /*  Dialog-template identity within the resource file.          */
                                NULL ) ;            /*  Pointer to application-defined data area.                   */
                    break ;

                default:
                    break ;
                }
            if ( hbm )
                {
                if ( hbmDisplayed != hbm )
                    {
                    hbmDisplayed = hbm ;
                    WinInvalidateRect( hwndDlg, NULL, TRUE ) ;
                    }
                mciPlayResource( hwndDlg,           /*  Window handle.          */
                                 NULLHANDLE,        /*  Module handle.          */
                                 RT_WAVE,           /*  Resource type.          */
                                 SHORT1FROMMP(mp1), /*  Resource identifier.    */
                                 MCI_ASYNC,         /*  Flags.                  */
                                 NULL,              /*  Window title.           */
                                 NULLHANDLE ) ;     /*  Window handle.          */
                }
            break ;

        case WM_BUTTON2DOWN:
            WinPopupMenu( hwndDlg,                  /*  Parent-window handle.                       */
                          hwndDlg,                  /*  Owner-window handle.                        */
                          hwndPopupMenu,            /*  Pop-up menu-window handle.                  */
                          SHORT1FROMMP(mp1),        /*  x-coordinate of the pop-up menu position.   */
                          SHORT2FROMMP(mp1),        /*  y-coordinate of the pop-up menu position.   */
                          0,                        /*  Item identity.                              */
                          PU_NONE |                 /*  Options.                                    */
                          PU_KEYBOARD | PU_MOUSEBUTTON1 ) ;
            break ;

        default:
            return( WinDefDlgProc( hwndDlg, ulMessage, mp1, mp2 ) ) ;
        }

    return( (MRESULT) 0L ) ;
}

/* ------------------------------------------------------------------------ */
/* Window Procedure for the About Box                                       */
/* ------------------------------------------------------------------------ */
MRESULT APIENTRY    AboutDlgProc( HWND hwndDlg, ULONG ulMessage, MPARAM mp1, MPARAM mp2 )
{
    switch ( ulMessage )
        {
        case WM_INITDLG:
            CentreWindow( hwndDlg ) ;
            break ;

        case WM_COMMAND:
            switch ( SHORT1FROMMP(mp1) )
                {
                case DID_OK:
                case DID_CANCEL:
                    WinDismissDlg( hwndDlg, TRUE ) ;
                    break ;
                }
            break ;

        default:
            return( WinDefDlgProc( hwndDlg, ulMessage, mp1, mp2 ) ) ;
            break ;
        }       /* End Switch ulMessage */

    return ( 0L ) ;
}

/* ------------------------------------------------------------------------ */
/* CentreWindow() centers and given window to the enter of the screen.      */
/* ------------------------------------------------------------------------ */
void                CentreWindow( HWND hWnd )
{
LONG                lScrWidth, lScrHeight ;
RECTL               rclRect ;

    lScrWidth  = WinQuerySysValue( HWND_DESKTOP, SV_CXSCREEN ) ;
    lScrHeight = WinQuerySysValue( HWND_DESKTOP, SV_CYSCREEN ) ;
    WinQueryWindowRect( hWnd, &rclRect ) ;
    WinSetWindowPos( hWnd, HWND_TOP, (lScrWidth - rclRect.xRight) / 2, (lScrHeight - rclRect.yTop) / 2, 0, 0, SWP_MOVE | SWP_ACTIVATE ) ;
}

