#define INCL_WIN

#include <os2.h>

#include <stdlib.h>

#include "bounce.h"

#define WC_BOUNCE "Bounce"
#define WW_BOUNCE 4 /* Number of bytes in window words */

MRESULT EXPENTRY wp_Bounce(HWND hwnd, ULONG Msg, MPARAM mp1, MPARAM mp2);

HAB hab;

main(int argc, char *argv[], char *envp[])
{
    HWND hwndFrame, hwndClient;
    QMSG qmsg;
    HMQ hmq;
    ULONG fcf_flags;

    hab = WinInitialize(0);
    hmq = WinCreateMsgQueue(hab, 0);

    if (!WinRegisterClass(hab,
                            WC_BOUNCE,
                            wp_Bounce,
                            CS_SIZEREDRAW,
                            WW_BOUNCE))
        DosExit(EXIT_PROCESS, 1);
    fcf_flags = FCF_TITLEBAR | FCF_SYSMENU | FCF_SIZEBORDER | FCF_MINMAX |
                FCF_SHELLPOSITION | FCF_TASKLIST;

    hwndFrame = WinCreateStdWindow(HWND_DESKTOP,
                                    WS_VISIBLE,
                                    &fcf_flags,
                                    WC_BOUNCE,
                                    "Bounce",
                                    WS_VISIBLE,
                                    (HMODULE)0,
                                    (USHORT)0,
                                    &hwndClient);

    while(WinGetMsg(hab, &qmsg, 0L, 0, 0))
        WinDispatchMsg(hab, &qmsg);

    WinDestroyWindow(hwndFrame);
    WinDestroyMsgQueue(hmq);
    WinTerminate(hab);
}

MRESULT EXPENTRY wp_Bounce(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    PBOUNCEVARS pbv;
    ERRORID rc;

    pbv = PBVFROMHWND(hwnd);

    switch(msg) {
        case WM_CREATE:
            WinDefWindowProc(hwnd, msg, mp1, mp2);
            /* Allocate memory for the bounce variables */
            pbv = malloc(sizeof(BOUNCEVARS));
            WinSetWindowPtr(hwnd, 0, pbv);
            pbv->xDir = pbv->yDir = 8;

            /* Create a memory device context */
            pbv->hdcMemory = DevOpenDC(hab, OD_MEMORY, "*", 0L, NULL, 0L);

            pbv->sizl.cx = pbv->sizl.cy = 0;

            pbv->hpsMemory = GpiCreatePS(hab, pbv->hdcMemory, &pbv->sizl,
                                PU_PELS | GPIF_DEFAULT | GPIT_MICRO | GPIA_ASSOC);

            pbv->hbm = GpiLoadBitmap(pbv->hpsMemory, (HMODULE)0, ID_RESOURCE, 32L, 32L);

            GpiDestroyPS(pbv->hpsMemory);

            /* Set initial bitmap position */
            pbv->aptl[0].x = pbv->aptl[0].y = 0;

            /* Generate timer messages as fast as possible */
            /* Got to call WinStartTimer twice: once to get a timer ID */
            /* and again to start it */
            pbv->idTimer = WinStartTimer(hab, 0, 0, 100);
            WinStartTimer(hab, hwnd, pbv->idTimer, 100);
            return (MRESULT)FALSE;
            break;

        case WM_TIMER:
            /* Update position */
            pbv->aptl[0].x += pbv->xDir;
            pbv->aptl[0].y += pbv->yDir;

            /* Check for boundaries and update direction */
            if(pbv->aptl[0].x + BM_XSIZE >= pbv->cxClient)
                pbv->xDir = -pbv->xDir;
            if(pbv->aptl[0].x <= 0)
                pbv->xDir = -pbv->xDir;
            if(pbv->aptl[0].y + BM_YSIZE >= pbv->cyClient)
                pbv->yDir = -pbv->yDir;
            if(pbv->aptl[0].y <= 0)
                pbv->yDir = -pbv->yDir;

            /* Redraw */
            WinInvalidateRect(hwnd, NULL, FALSE);
            break;

        case WM_SIZE:
            pbv->cxClient = SHORT1FROMMP(mp2);
            pbv->cyClient = SHORT2FROMMP(mp2);
            return (MRESULT) FALSE;

        case WM_PAINT:
            pbv->hps = WinBeginPaint(hwnd, 0L, &pbv->rcl);
            WinFillRect(pbv->hps, &pbv->rcl, CLR_BACKGROUND);

            WinQueryWindowRect(hwnd, &pbv->rcl);
            WinDrawBitmap(pbv->hps, pbv->hbm, 0, (PPOINTL)&pbv->aptl[0], CLR_NEUTRAL, CLR_BACKGROUND, DBM_NORMAL);

            WinEndPaint(pbv->hps);
            break;

        case WM_DESTROY:
            GpiDestroyPS(pbv->hpsMemory);
            DevCloseDC(pbv->hdcMemory);
            GpiDeleteBitmap(pbv->hbm);
            free(pbv);
            break;

        default:
            return WinDefWindowProc(hwnd, msg, mp1, mp2);
            break;
    }
}




