/* We need to include symbolic constants, function prototypes, structures and types for the system */
#define INCL_WIN
#include <os2.h>

/* A window class has a name, used in several places through the source, so we define it here */
#define WC_HELLO "Hello"

/* Forward reference for the window procedure */
MRESULT EXPENTRY HelloWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

/* We need variables for a frame window and a client window */
HWND hwndFrame, hwndClient;

int main(int argc, char *argv[], char *envp[])
{
    HAB hab;            // Handle to an anchor block
    HMQ hmq;            // Handle for a message queue
    QMSG qmsg;          // Queue message structure
    ULONG ulFrameFlags; // Frame creation flags - allow for frame components

    /* Let PM know we're here, and it can allocate resources */
    hab = WinInitialize(0);

    /* Create a message queue to receive messages for our windows */
    hmq = WinCreateMsgQueue(hab, 0);

    /* Register a window class (winproc) to process messages for the client window */
    if(!WinRegisterClass(hab,
                WC_HELLO,
                HelloWndProc,
                CS_SYNCPAINT | CS_SIZEREDRAW,
                0L))
        DosExit(EXIT_PROCESS,1);

    /* Set up frame creation flags for a standard window, only no menu, accelerator table or icon */
    ulFrameFlags = FCF_STANDARD & ~FCF_MENU & ~FCF_ACCELTABLE & ~FCF_ICON;

    /* Create a frame (and its children) and client windows */
    hwndFrame = WinCreateStdWindow(HWND_DESKTOP,    // Frame's parent
                    WS_VISIBLE,                     // Frame window style
                    &ulFrameFlags,                  // Frame creation flags
                    WC_HELLO,                       // Client window class
                    "Hello",                        // Titlebar text
                    WS_VISIBLE,                     // Client window style
                    (HMODULE)0L,                    // Resource module handle - 0 for resources in .EXE
                    0L,                             // Resource ID
                    &hwndClient);                   // Variable to receive client window handle

    if (hwndFrame == 0) {
        WinAlarm(HWND_DESKTOP, WA_ERROR);
        DosExit(EXIT_PROCESS, 1);
    }

    /* The 'event loop' reads messages and dispatches them until WinGetMsg returns FALSE after reading WM_QUIT */
    while(WinGetMsg(hab, &qmsg, 0L, 0L, 0L))
        WinDispatchMsg(hab, &qmsg);

    /* Destroying the frame automatically destroys all its children */
    WinDestroyWindow(hwndFrame);
    WinDestroyMsgQueue(hmq);
    WinTerminate(hab);
}

/* The 'guts' of the application is in the window procedure, which implements behaviour of the client window */
MRESULT EXPENTRY HelloWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    HPS hps;                                // A presentation space is where PM 'paints'
    RECTL rc;                               // A rectangle structure is good for holding window size info
    CHAR szMessage[] = "Hello World!";      // The message to be displayed

    switch(msg) {
        case WM_CREATE:                     // Return false to allow the system to
            return (MRESULT) FALSE;         // continue creating the window
            break;                          // Return TRUE if there's a problem

        case WM_ERASEBACKGROUND:
            return (MRESULT) TRUE;          // Return TRUE to allow the frame to fill the client with white
            break;

        case WM_PAINT:                      // The real 'guts' of the application are here
            hps = WinBeginPaint(hwnd, 0, &rc);  // Get a presentation space to paint in
//            WinQueryWindowRect(hwnd, &rc);      // Query the window size
            WinDrawText(hps, -1, szMessage, &rc, CLR_NEUTRAL,   // Draw the text (szMessage) in the rectangle, in colour black
                CLR_BACKGROUND, DT_CENTER| DT_VCENTER | DT_ERASERECT);  // on white background, centered and filling the rectangle
            WinEndPaint(hps);                   // Release the presentation space
            return (MRESULT) FALSE;             // Return FALSE to indicate the message has been processed
            break;

        case WM_CLOSE:                          // Post back a WM_QUIT to yourself
            WinPostMsg(hwnd, WM_QUIT, 0L, 0L);  // so that the event loop terminates
            return (MRESULT) FALSE;
            break;

        default:        // Let the system handle all other messages with default behaviour
            return WinDefWindowProc(hwnd, msg, mp1, mp2);
            break;
    }
}
