/* OS/2 Gamer's Guide installation */
SIGNAL ON SYNTAX

CALL RxFuncAdd "SysLoadFuncs","REXXUTIL","SysLoadFuncs"
CALL SysLoadFuncs

PARSE ARG destDir

IF destDir="" | destDir="/?" | TRANSLATE(destDir)="HELP" | TRANSLATE(destDir)="/H" THEN
DO
	SAY "Usage: INSTALL destDir"
	SAY ""
	SAY "       destDir     = Directory location where you want"
	SAY "                     the OS/2 Gamer's Guide installed."
	SAY "		          NOTE: Do not install over an old"
	SAY "			  version!"
	EXIT
END

SAY "Installing the OS/2 Gamer's Guide to "||destdir
SAY "Program requires approximately 3Megs of HD space."
currentDir = DIRECTORY()
CALL CheckSource currentDir
destDir = CreateDestDir(destDir)
CALL UnZipFiles destDir currentDir
CALL MakeObjects destDir
SAY "------------------------"
SAY "Program installation complete."
PAUSE
SAY "Installing the Watcom SQL RunTime"
SAY "Copyright (c) WATCOM International Corporation 1992"
"setup"
EXIT

/***** SUBROUTINES *****/

/*****************************************************************************
 * CheckSource      - makes sure that all necessary files are present
 *                    in the source directory. Terminates the install
 *                    script if an error occurs.
 *****************************************************************************/
CheckSource: PROCEDURE
	PARSE ARG currentDir

	sourceList.0 = 5
	sourceList.1 = 'gguide2.zip'
	sourceList.2 = 'wsql.zip'
	sourceList.3 = 'unzip.exe'
	sourceList.4 = 'README.TXT'
	sourceList.5 = 'vrobj.dll'

	DO n = 1 TO sourceList.0
		IF STREAM(sourceList.n,"C","QUERY EXISTS")="" THEN
		DO
			SAY "** Installation failed! **"
			SAY "Unable to find file "||sourceList.n||" in "||currentDir
			EXIT
		END
	END
	RETURN
/*****************************************************************************/

/*****************************************************************************
 * CreateDestDir    - procedure to create the destination directory.
 *                    Returns the fully qualified pathname of the
 *                    destination directory. Terminates the install script
 *                    if an error occurs.
 *****************************************************************************/
CreateDestDir: PROCEDURE
	PARSE ARG destDir

	CALL SETLOCAL
	target = DIRECTORY(destDir)			/* check whether dest dir exists		*/
	IF target="" THEN				/* dest dir doesn't exist so create it		*/
	DO
		IF 0\=SysMkDir(destDir) THEN
		DO
			SAY ""		
			SAY "Error creating directory '"||destDir||"'"
			EXIT
		END
	END
	destDir = DIRECTORY(destDir)		/* get fully qualified pathname of dest dir	*/
	CALL ENDLOCAL
	RETURN destDir
/*****************************************************************************/

/*****************************************************************************
 * CopyProgramFiles - procedure to copy the program files to the
 *                    specified directory. Terminates the install
 *                    script if an error occurs.
 *****************************************************************************/
CopyProgramFiles: PROCEDURE
	PARSE ARG destDir

	filelist.0 = 2
	filelist.1 = "UNZIP.EXE"
	filelist.2 = "GGUIDE2.ZIP"

	SAY "Copying program files to "||destDir||" ..."
	DO n=1 TO filelist.0
		'@COPY '||filelist.n||' '||destDir
		IF rc\=0 THEN
		DO
			SAY "Error copying "||filelist.n
			EXIT
		END
	END

	RETURN
/*****************************************************************************/

/*****************************************************************************
 * UnZipFiles - procedure to uncompress the program files.
 *****************************************************************************/
UnZipFiles: PROCEDURE
	PARSE ARG destDir currentDir

	SAY "Uncompressing the program files."
	zipfile = "GGUIDE2.ZIP"
	"unzip" zipfile "-d" destDir
	SAY "Uncompressing the WSQL install files."
	zipfile = "WSQL.ZIP"
	"unzip" zipfile
	RETURN
/*****************************************************************************/

/*****************************************************************************
 * MakeObjects  - procedure to create the necessary Workplace Shell objects.
 *                Terminates the install script if an error occurs.
 *****************************************************************************/
MakeObjects: PROCEDURE
	PARSE ARG destDir

	SAY "Creating/updating Games folder on the desktop."
	objectSetup = "OBJECTID=<Gamers_Guide>;"
	IF 0=SysCreateObject( "WPFolder", "Games Folder", "<WP_DESKTOP>", objectSetup, "U" ) THEN
	DO
		SAY "Unable to create program object."
		EXIT
	END

	SAY 'Creating/updating OS/2 Gamer''s Guide program object.'
	objectSetup = "EXENAME="||destDir||"\GAMERS.EXE;PROGTYPE=PM;"
	IF 0=SysCreateObject( 'WPProgram', 'Gamer''s Guide', '<Gamers_Guide>', objectSetup, 'U' ) THEN
        DO
            SAY "Unable to create shadow object."
            EXIT
        END
    RETURN
/*****************************************************************************/

/*****************************************************************************/
 * Standard REXX program error handlers
 *****************************************************************************/
SYNTAX:
	SAY 'REXX error' rc 'in line' sigl
	SAY "Instruction = "||SOURCELINE(sigl)
	EXIT
/*****************************************************************************/
