#define INCL_DOS
#define INCL_PM
#include <os2.h>
#include <iostream.h>
#include <ThreadTemp.h>

#include "TstSave.hh"



TestSaver::TestSaver():SaverModule(){
   SaverActive=0;
   TestThread=new ClassThreadwoArg<TestSaver> (this,&ThreadFnc);
   TestThread->ChangeStackSize(32*1024);
}

TestSaver::~TestSaver(){
   DeactivateSaver();
   delete TestThread;
}


void TestSaver::ThreadFnc(void){
   HAB hab  =WinInitialize(0);
   HMQ hmq  =WinCreateMsgQueue(hab,10);

   WinMessageBox(
      HWND_DESKTOP,
      HWND_DESKTOP,
      "Saver Thread is active",
      "Woo",
      144,
      MB_OK|MB_WARNING|MB_MOVEABLE);

   while(SaverActive){
      DosSleep(300);
      (cout<<'.').flush();
   }

   WinDestroyMsgQueue(hmq);
   WinTerminate(hab);
}

string TestSaver::GetSaverName(){
   return "Test Saver";
}

SaverModule::HWND TestSaver::GetPageHandle(){
return 0;
}

void TestSaver::ActivateSaver(){
   SaverActive=1;
   TestThread->Start();
}

void TestSaver::DeactivateSaver(){
   if(TestThread->IsRunning()){
      TID tid=TestThread->GetThreadID();
      SaverActive=0;
      DosWaitThread(&tid,0);
   }
}

