#define INCL_DOSFILEMGR
#include <os2.h>
#include <iostream.h>

void listEAs(const char* name)
{
   const unsigned size = 2000; // Incidently, if you make size > 65364
                               // bytes, and the file does not exist,
                               // a *LARGE* portion of your memory,
                               // starting at the buffer pointer,
                               // will be zeroed, destroying a lot
                               // of your data. Try it!!!
   void* pBuffer = (void*)(new char[size]);

   ULONG count = -1; // means, fill as many names as there is room for

   APIRET rc = DosEnumAttribute(ENUMEA_REFTYPE_PATH,
                                PVOID(name), // Yuk, I hate this API!
                                1, // ordinal index of first EA to read,
                                pBuffer,
                                size,
                                &count,
                                ENUMEA_LEVEL_NO_VALUE); // only legal value!!
  if (rc) {
     cerr << "DosEnumAttribute => " << rc << endl;
     return;
  } /* endif */
  PDENA2 pDena = (PDENA2)pBuffer;
  ULONG offset = 0;
  if (count != 0) {
    do {
       pDena = PDENA2((CHAR*)(pDena) + offset);
       cout << "oNextEntryOffset:\t" << pDena->oNextEntryOffset << endl;
       cout << "fEA:\t\t" << int(pDena->fEA) << endl;
       cout << "cbName:\t\t" << int(pDena->cbName) << endl;
       cout << "cbValue:\t\t" << pDena->cbValue << endl;
       cout << "szName:\t\t" << pDena->szName << endl;
       cout << endl;
       offset = pDena->oNextEntryOffset;
    } while ( pDena->oNextEntryOffset != 0 ); /* enddo */
  } /* endif */
}

int main(int argc, char* argv[])
{
   if (argc != 2) {
      cerr << "Usage: namelist filename" << endl;
      return -1;
   } /* endif */
   listEAs(argv[1]);
   return 0;
}
