#ifndef _EDITFILE_HPP_
#define _EDITFILE_HPP_

#define INCL_WINMESSAGEMGR
#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#include <os2.h>

#include "afile.hpp"

class AEditFile : public AFile

{
  public:
    AEditFile (void);                                               // constructor
    ~AEditFile (void);                                              // destructor
    Boolean allocateDataBuffer (void);                              // allocate the data buffer
    char * getPointerToData (void) { return (m_pFileContents); };   // returns the pointer to the data buffer
    APIRET read (HWND hwndStatusLine);                              // read the data
    APIRET write (HWND hwndStatusLine);                             // write the data
    void stopProcess (void) { m_bStopProcess = true; };             // stop the process (reading / writing)

    enum { eBytesToRead = 102400 };                                 // default number of bytes to read / write

  private:
    char * m_pFileContents;                                         // pointer to data buffer
    ULONG m_ulFileSize;                                             // the size of the file
    Boolean m_bStopProcess;                                         // stops the process if true
};

#endif //_EDITFILE_HPP_
