#ifndef __MEMOBJ_H__
#define __MEMOBJ_H__

#ifndef _exp_
   #ifdef __DLL__
      #define _exp_ _Export
   #else
      #define _exp_
   #endif
#endif



class MemoryObj{
protected:
typedef unsigned long int ULONG;


public:
   _exp_ MemoryObj(ULONG Len);
   virtual _exp_ ~MemoryObj();

   virtual int IsShared()=0;

   int _exp_ InitializeForSubAlloc(int IsServ=0, ULONG SubAllocPoolLen=0);
   int _exp_ UnInitializeForSubAlloc();

   void* _exp_ SubAlloc(ULONG Lenght);
   int _exp_ SubFree(void *Ptr, ULONG Lenght);

   int _exp_ FreeBaseMem();

protected:

   void *BaseAddr;
   ULONG BaseLen, 
         SubAllocPoolLen;
   char  fIsSubInitialized;
};



class SharedMemoryObj:public MemoryObj{

public:
   _exp_ SharedMemoryObj(ULONG Len,char InitForSubAlloc=1,char *Name=0);
   _exp_ SharedMemoryObj(char *Name,ULONG Len,char InitForSubAlloc=1);
   _exp_ ~SharedMemoryObj();

   virtual int IsShared(){return 1;}


   void* _exp_ AllocBaseMem(ULONG Len, int IsServ=0);
   int _exp_ OpenShareMem();



protected:
   void CreateName(char *Name);

   char * MemoryName;
};


/*****************  

add in latter

class PrivateMemoryObj:public MemoryObj{

public:
   _exp_ PrivateMemoryObj(ULONG Len);

   virtual int IsShared(){return 0;}


   void* _exp_ AllocBaseMem(ULONG Len);
};
*/

#endif
