// styleswitcher.js -
//  Offer selection of preferred display size
//  Choice gets stored in cookie upon leaving page, is loaded from cookie
//  Depending on choice, different style sheets are loaded
//
//  Auswahl bevorzugter Darstellungsgre
//  Auswahl wird beim Verlassen der Seite als Cookie gespeichert und wieder aus Cookie geladen
//  Abhngig von Auswahl werden verschiedene style sheets geladen
//
// function changeHeaderImages (c) 2005 Christian Hennecke
 
function setActiveStyleSheet(title) {
  var i, a, main;
  for(i=0; (a = document.getElementsByTagName("link")[i]); i++) {
    if(a.getAttribute("rel").indexOf("style") != -1 && a.getAttribute("title")) {
      a.disabled = true;
      if(a.getAttribute("title") == title) {
        a.disabled = false;
        changeHeaderImages(title);
      }
    }
  }
}
 
function getActiveStyleSheet() {
  var i, a;
  for(i=0; (a = document.getElementsByTagName("link")[i]); i++) {
    if(a.getAttribute("rel").indexOf("style") != -1 && a.getAttribute("title") && !a.disabled) return a.getAttribute("title");
  }
  return null;
}
 
function getPreferredStyleSheet() {
  var i, a;
  for(i=0; (a = document.getElementsByTagName("link")[i]); i++) {
    if(a.getAttribute("rel").indexOf("style") != -1
       && a.getAttribute("rel").indexOf("alt") == -1
       && a.getAttribute("title")
       ) return a.getAttribute("title");
  }
  return null;
}
 
function createCookie(name,value,days) {
  if (days) {
    var date = new Date();
    date.setTime(date.getTime()+(days*24*60*60*1000));
    var expires = "; expires="+date.toGMTString();
  }
  else expires = "";
  document.cookie = name+"="+value+expires+"; path=/";
}
 
function readCookie(name) {
  var nameEQ = name + "=";
  var ca = document.cookie.split(';');
  for(var i=0;i < ca.length;i++) {
    var c = ca[i];
    while (c.charAt(0)==' ') c = c.substring(1,c.length);
    if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
  }
  return null;
}
 
function changeHeaderImages(title) {
  var size = "0";
  switch (title) {
    case "small":
      size = "14";
      break;
    case "medium":
      size = "16";
      break;
    case "large":
      size = "18";
      break;
  }
  logo = new Image();
  logo.src = "img/voicebg-" + size + ".png";
  flag = new Image();
  flag.src = "img/flag-" + size + ".png";
  down = new Image();
  down.src = "img/down-" + size + ".png";
  previous = new Image();
  previous.src = "img/previous-" + size + ".png";
  content = new Image();
  content.src = "img/content-" + size + ".png";
  next = new Image();
  next.src = "img/next-" + size + ".png";
  document.getElementById('logo').src = logo.src;
  document.getElementById('flag').src = flag.src;
  document.getElementById('down').src = down.src;
  if(document.getElementById('previousTop')) {
    document.getElementById('previousTop').src = previous.src;
  }
  document.getElementById('contentTop').src = content.src;
  if(document.getElementById('nextTop')) {
    document.getElementById('nextTop').src = next.src;
  }
  if(document.getElementById('previousBottom')) {
    document.getElementById('previousBottom').src = previous.src;
  }
  document.getElementById('contentBottom').src = content.src;
  if(document.getElementById('nextBottom')) {
    document.getElementById('nextBottom').src = next.src;
  }
  return null;
}
 
window.onload = function(e) {
  var cookie = readCookie("style");
  var title = cookie ? cookie : getPreferredStyleSheet();
  setActiveStyleSheet(title);
}
 
window.onunload = function(e) {
  var title = getActiveStyleSheet();
  createCookie("style", title, 365);
}
 
var cookie = readCookie("style");
var title = cookie ? cookie : getPreferredStyleSheet();
setActiveStyleSheet(title);
