rem 
rem $Header: dbmsofln.sql 7020200.1 95/02/15 18:31:44 cli Generic<base> $ 
rem 
Rem
Rem    NAME
Rem
Rem      dbmsofln.sql - replication offline instantiation package spec
Rem
Rem    NOTES
Rem
Rem      The procedural option is needed to use this facility.
Rem
Rem      This package is installed by sys (connect internal).
Rem
Rem      The repcat tables are defined in catrep.sql and owned by system.
Rem
Rem    DEPENDENCIES
Rem      The snapshot packages rely on the dbms_snaphot package and all it
Rem      relies upon (e.g., dbms_defer)
Rem
Rem      The object generator (dbmsobjg) and the replication procedure/trigger
Rem      generator (dbmsgen) must be previously loaded.
Rem
Rem      Uses dynamic SQL (dbmssql.sql) heavily.
Rem
Rem    USAGE
Rem
Rem	BETA RELEASE DISCLAIMER
Rem	This is a beta release of dbmsofln.sql and, as such, is 
Rem	subject to change. DO NOT use this package in a production environment
Rem	without thorough testing.
Rem
Rem	Use the procedures in this package to instantiate a new master site
Rem	for a replicated schema. The replicated schema does not need to
Rem	remain quiesced while the new site is instantiated, however, DO NOT
Rem	call any DBMS_REPCAT procedures until after completing step 9 below.
Rem
Rem	To perform this method of instantiation, complete the following steps:
Rem
Rem	1.	Create the necessary database links from the new site to each
Rem		existing site, and from each existing site to the new site.
Rem
Rem	2.	At the master definition site, call 
Rem		DBMS_REPCAT.SUSPEND_MASTER_ACTIVITY(SchemaName).
Rem		
Rem	3.	At the master definition site, call
Rem		DMBS_OFFLINE_SCHEMA.BEGIN_INSTANTIATION(SchemaName, NewSite).
Rem
Rem		This ensures that any updates at the existing master sites
Rem		are queued for the new master site.
Rem
Rem	4.	At any site, export the user-defined tables for the replicated 
Rem		schema.
Rem
Rem	5.	At the master definition site, call
Rem		DBMS_OFFLINE_SCHEMA.RESUME_MASTERS(SchemaName, NewSite).
Rem
Rem		This allows non-administrative replication activity to resume 
Rem		at the existing master sites.
Rem
Rem	6.	At the new master site, call
Rem		DBMS_OFFLINE_SCHEMA.BEGIN_LOAD(SchemaName, NewSite).
Rem
Rem		This disables the triggers at the new master site so that your
Rem		changes are not added to the queue when you begin importing
Rem		data at the new site.
Rem
Rem	7.	At the new site, import the tables exported in step 4.
Rem
Rem	8.	At the new site, call
Rem		DBMS_OFFLINE_SCHEMA.END_LOAD(SchemaName, NewSite).
Rem
Rem		This re-enables the triggers that were disabled in step 6.
Rem
Rem	9.	At the master definition site, call
Rem		DBMS_OFFLINE_SCHEMA.END_INSTANTIATION(SchemaName, NewSite).
Rem
Rem		This resumes normal replication activity at the new site.
Rem
Rem	10.	Schedule execution of queues between new master site and 
Rem		existing sites. DO NOT push queues to the new master until you 
Rem		have completed step 9. If the new site is already a part of 
Rem		another replicated environment, you must unschedule
Rem             the execution of the queues to the new site between steps 5 and 9.
Rem
Rem    MESSAGES
Rem
Rem	This section describes the probable cause and suggested action for
Rem	messages that you may encounter when using dbmsofln.sql.
Rem
Rem
Rem	ORA-23430 the replicated schema %s does not exist
Rem	Cause:    The caller has provided the name of a replicated schema that
Rem	          is not known at the master site as an argument to a routine
Rem	          in offline instantiation of a schema.
Rem     Action:   Check that the replicated schema exists at the master site
Rem               where the user is executing the procedure, and retry the call.
Rem
Rem     ORA-23431 site %s is not the master definition site
Rem     Cause:    The master site where the routine was executing is not the
Rem               master definition site.
Rem     Action:   Find out the master definition site for the replicated schema
Rem               in question, and re-run the routine.
Rem
Rem     ORA-23432 wrong state: %s"
Rem     Cause:    Routine is executing against a replicated schema whose state
Rem               is in the wrong state.
Rem     Action:   Make sure that the replicated schema is in the state given in
Rem               the error message.
Rem
Rem     ORA-23433 master site %s already exists
Rem     Cause:    Trying to instantiate a replicated schema at a master site
Rem               that is already a part of the schema.
Rem     Action:   If you were trying to add this site, do nothing because it
Rem               already exists; otherwise, pick the name of another site,
Rem               and re-run the routine.
Rem
Rem     ORA-23434 executing against wrong master site %s
Rem     Cause:    Caller provides an argument indicating the site against which
Rem               the routine should be executing; trying to execute the 
Rem               routine at a site that is different from that argument.
Rem     Action:   Execute against the correct master site.
Rem
Rem     ORA-23435 malformed master site name %s
Rem     Cause:    Site name as argument to routine is not formed correctly.
Rem     Action:   Please consult the Oracle manuals on how to construct site 
Rem               names.
Rem
Rem     ORA-23436 site %s is not master site
Rem     Cause:    The new site given as an argument to a routine is not a
Rem               master site for the given replicated schema.
Rem     Action:   Execute dbms_offline_schema.begin_instantiation() routine to
Rem               add a new site to the replicated schema.
Rem
Rem     ORA-23437 master site %s not known for replicated schema
Rem     Cause:    The site name given as an argument to a routine is not already
Rem               known to the replicated schema.
Rem     Action: Execute dbms_offline_schema.begin_instantiation() routine to
Rem             add a new site to the replicated schema.
Rem
Rem
Rem    SECURITY
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem     boki       01/09/95 -  merge changes from branch 1.1.710.3
Rem     boki       12/21/94 -  merge changes from branch 1.1.710.1
Rem     boki       01/06/95 -  Tech writer to add explanatory comments on use
Rem     boki       01/06/95 -  Tech writer to add more self-explanatory info
Rem     boki       12/02/94 -  Branch_for_patch
Rem     boki       12/02/94 -  Creation
Rem     boki       12/02/94 -  Creation
Rem     boki       10/28/94  -- Substantial modification of Sandeep's original
Rem                             specification.
Rem
 
---------------------------------------------------------------------------
CREATE OR REPLACE PACKAGE dbms_offline_schema AS

  -------------
  -- TYPE DEFINITIONS
  --
  TYPE SetOfSiteType IS TABLE OF VARCHAR2(256)
     INDEX BY BINARY_INTEGER;

  -------------
  -- EXCEPTIONS
  --

  nosuchschema EXCEPTION;
    PRAGMA exception_init(nosuchschema, -23430);
    nosuchschema_num NUMBER := -23430;
    nosuchschema_msg VARCHAR2(76) := 'the replicated schema %s does not exist';

  notmasterdef EXCEPTION;
    PRAGMA exception_init(notmasterdef, -23431);
    notmasterdef_num NUMBER := -23431;
    notmasterdef_msg VARCHAR2(76) := 'site %s is not the master definition site';

  wrongstate EXCEPTION;
    PRAGMA exception_init(wrongstate, -23432);
    wrongstate_num NUMBER := -23432;
    wrongstate_msg VARCHAR(76) := 'wrong state: %s';    

  sitealreadyexists EXCEPTION;
    PRAGMA exception_init(sitealreadyexists, -23433);
    sitealreadyexists_num NUMBER := -23433;
    sitealreadyexists_msg VARCHAR2(76) := 'master site %s already exists';

  wrongsite EXCEPTION;
    PRAGMA exception_init (wrongsite, -23434);
    wrongsite_num NUMBER := -23434;
    wrongsite_msg VARCHAR2(76) := 'executing against wrong master site %s';

  badsitename EXCEPTION;
    PRAGMA exception_init (badsitename, -23435);
    badsitename_num NUMBER := -23435;
    badsitename_msg VARCHAR2(76) := 'malformed master site name %s';

  notmastersite EXCEPTION;
    PRAGMA exception_init (notmastersite, -23436);
    notmastersite_num NUMBER := -23436;
    notmastersite_msg VARCHAR2(76) := 'site %s is not master site';

  unknownsite EXCEPTION;
    PRAGMA exception_init (unknownsite, -23437);
    unknownsite_num NUMBER := -23437;
    unknownsite_msg VARCHAR2(76) := 'master site %s not known for replicated schema';

  -------------
  -- PROCEDURES
  --

  -- Effects: Each master site, including the "new_site," knows about all
  --   the other sites for schema "schema_name."  This routine must be run
  --   at the master definition site.
  --   Raises the following exceptions:
  --      nosuchschema:   if "schema_name" does not name a schema known at
  --                      this site
  --      notmasterdef:   if the site this routine is executing at is not the
  --                      master def. site.
  --      sitealreadyexists:  if "new_site" is already part of the schema
  --			  "schema_name"
  --      wrongstate:     if master def site is not in Quiesced state
  --      badsitename:    if "new_site" is a malformed site name
  PROCEDURE begin_instantiation (schema_name VARCHAR2,
                                 new_site VARCHAR2);

  -- Effects: For "schema_name" resume normal activity for all master sites 
  --   excluding "new_site."  This routine must be executed at the
  --   master definition site.
  --   Raises the following exceptions:
  --      nosuchschema:   if "schema_name" does not name a schema known at
  --                      this site
  --      notmasterdef:   if the site this routine is executing at is not the
  --                      master def. site.
  --      badsitename:    new_site is a malformed name
  --      wrongstate:     if master def site is not in Quiesced state
  --      unknownsite:    "new_site" is unknown to "schema_name"
  PROCEDURE resume_masters (schema_name VARCHAR2,
          	            new_site VARCHAR2);

  -- Effects: For schema "schema_name" this routine integrates each site in
  --   "new_sites" into the set of existing sites.  When the routine returns
  --   normally, all sites can communicate with each other.  This routine 
  --   must be executed at the master definition site.
  --   Raises the following exceptions:
  --      nosuchschema:   if "schema_name" does not name a schema known at
  --                      this site
  --      notmasterdef:   if the site this routine is executing at is not the
  --                      master def. site.
  --      badsitename:    site name is malformed
  --      unknownsite:    site "new_site" is not known to schema "schema_name".
  --      wrongstate:     if master def site is not in Quiesced state
  PROCEDURE end_instantiation (schema_name VARCHAR2,
		               new_site VARCHAR2);

  -- Effects: Starts the instantiation of "schema_name" at site "new_site." 
  --    This new site is readied for loading of user-defined tables when routine
  --    returns normally.  
  --    Raises the following exceptions:
  --      nosuchschema:   if "schema_name" does not name a schema known at
  --                      this site
  --      badsitename:    "new_site" is a malformed name of a site.
  --      wrongsite:      routine is not executing against site "new_site"
  --      unknownsite:    "new_site" not a master for given schema
  --      wrongstate:     if master def site is not in Normal state
  PROCEDURE begin_load (schema_name VARCHAR2,
  	                new_site VARCHAR2);

  --  Effects: Ends the instantiation of schema "schema_name" at site "new_site"
  --    and resumes normal activity.
  --   Raises the following exceptions:
  --      nosuchschema:   if "schema_name" does not name a schema known at
  --                      this site.
  --      badsitename:    "new_site" is a malformed name of a site.
  --      wrongsite:      routine is not executing against site "new_site"
  --      unknownsite:    "new_site" not a master for given schema
  --      wrongstate:     if master def site is not in Normal state
  PROCEDURE end_load (schema_name VARCHAR2,
                      new_site VARCHAR2);

end;
/
